/*************************************************
*    The PMW Music Typesetter - 3rd incarnation  *
*************************************************/

/* Copyright (c) Philip Hazel, 2005 */

/* This file contains one function, which sets up the current
version string and the version in binary for comparison. It
includes the date of compilation. It is a fiddly bit of code,
but we want the string in a particular format. We also want
the copyright string to appear in the binary, and have to make
some use of it to stop the compiler optimizing it away. */

#include "pmwhdr.h"

#define version 4120      /* In fixed-point format */

#ifdef Debug
#define hasdebug "D"
#else
#define hasdebug ""
#endif

void version_init(void)
{
int i = 0;
uschar *copyright = US"Copyright (c) Philip Hazel 2005";
uschar today[20];
Ustrcpy(version_string, copyright);
Ustrcpy(today, __DATE__);
if (today[4] == ' ') i = 1;
today[3] = today[6] = '-';
version_fixed  = version;
format_sprintf(version_string, "%f%s%s (", version,
  (version%1000 == 0)? ".00" : (version%100 == 0)? "0" : "", hasdebug);
Ustrncat(version_string, today+4+i, 3-i);
Ustrncat(version_string, today, 4);
Ustrncat(version_string, today+7, 4);
Ustrcat(version_string, ")");
}

/* End of version.c */
