/*************************************************
*    The PMW Music Typesetter - 3rd incarnation  *
*************************************************/

/* Copyright (c) Philip Hazel, 1991 - 2005 */

/* Written by Philip Hazel, starting November 1991 */
/* This file last modified: August 2005 */


/* This file contains all the major tables used by the program;
a few that are used in one module only are kept with that module. */

#include "pmwhdr.h"
#include "readhdr.h"
#include "outhdr.h"




/*************************************************
*           Tables for UTF-8 support             *
*************************************************/

/* These are the breakpoints for different numbers of bytes in a UTF-8
character. */

const int utf8_table1[] =
  { 0x7f, 0x7ff, 0xffff, 0x1fffff, 0x3ffffff, 0x7fffffff};

/* These are the indicator bits and the mask for the data bits to set in the
first byte of a character, indexed by the number of additional bytes. */

const int utf8_table2[] = { 0,    0xc0, 0xe0, 0xf0, 0xf8, 0xfc};
const int utf8_table3[] = { 0xff, 0x1f, 0x0f, 0x07, 0x03, 0x01};

/* Table of the number of extra characters, indexed by the first character
masked with 0x3f. The highest number for a valid UTF-8 character is in fact
0x3d. */

const uschar utf8_table4[] = {
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
  3,3,3,3,3,3,3,3,4,4,4,4,5,5,5,5 };
  


/*************************************************
*               Miscellaneous                    *
*************************************************/

int main_bit[] = {
 0x00000001, 0x00000002, 0x00000004, 0x00000008,
 0x00000010, 0x00000020, 0x00000040, 0x00000080,
 0x00000100, 0x00000200, 0x00000400, 0x00000800,
 0x00001000, 0x00002000, 0x00004000, 0x00008000,
 0x00010000, 0x00020000, 0x00040000, 0x00080000,
 0x00100000, 0x00200000, 0x00400000, 0x00800000,
 0x01000000, 0x02000000, 0x04000000, 0x08000000,
 0x10000000, 0x20000000, 0x40000000, 0x80000000};


/* Font identification strings. This table must be lengthened if more than 12
extra faces are allowed. */

uschar *font_IdStrings[] = {
  US"rm",  US"it",  US"bf",  US"bi",  US"sy",  US"mf",  US"mf",
  US"xf1", US"xf2", US"xf3", US"xf4", US"xf5", US"xf6", US"xf7", US"xf8",
  US"xf9", US"xf10", US"xf11", US"xf12" };


/* Key signatures table giving number of sharps or flats */

int main_keysigtable[] = {
  /* a     b     c     d     e     f     g    */
     3,    5,    0,    2,    4,   -1,    1,  /* major keys */
  -100, -100,    7, -100, -100,    6, -100,  /* sharpened  */
    -4,   -2,   -7,   -5,   -3, -100,   -6,  /* flattened  */
     0,    2,   -3,   -1,    1,   -4,   -2,  /* minor keys */
     7, -100,    4,    6, -100,    3,    5,  /* sharpened  */
    -7,   -5, -100, -100,   -6, -100, -100   /* flattened  */
};


/* Table giving the order of sharps and flats in key signatures,
for different clefs (real clefs only). */

int main_sharporder[] = {
  L_5L,L_3S,L_5S,L_4L,L_2S,L_4S,L_3L,   /* treble clef */
  L_2S,L_1L,L_3L,L_1S,L_3S,L_2L,L_4L,   /* soprano clef */
  L_3S,L_2L,L_4L,L_2S,L_4S,L_3L,L_5L,   /* mezzo clef */
  L_4S,L_3L,L_5L,L_3S,L_2L,L_4L,L_2S,   /* alto clef */
  L_2L,L_4L,L_2S,L_4S,L_3L,L_5L,L_3S,   /* tenor clef */
  L_3L,L_1S,L_3S,L_2L,L_0S,L_2S,L_4S,   /* Cbaritone clef */
  L_3L,L_1S,L_3S,L_2L,L_0S,L_2S,L_4S,   /* (F)baritone clef */
  L_4L,L_2S,L_4S,L_3L,L_1S,L_3S,L_2L,   /* bass clef */
  L_5L,L_3S,L_5S,L_4L,L_2S,L_4S,L_3L};  /* deepbass clef */

int main_flatorder[] = {
  L_3L,L_4S,L_2S,L_4L,L_2L,L_3S,L_1S,   /* treble clef */
  L_4L,L_2L,L_3S,L_1S,L_3L,L_1L,L_2S,   /* soprano clef */
  L_1S,L_3L,L_1L,L_2S,L_4L,L_2L,L_3S,   /* mezzo clef */
  L_2S,L_4L,L_2L,L_3S,L_1S,L_3L,L_1L,   /* alto clef */
  L_3S,L_5L,L_3L,L_4S,L_2S,L_4L,L_2L,   /* tenor clef */
  L_4S,L_2S,L_4L,L_2L,L_3S,L_1S,L_3L,   /* Cbaritone clef */
  L_4S,L_2S,L_4L,L_2L,L_3S,L_1S,L_3L,   /* (F)baritone clef */
  L_2L,L_3S,L_1S,L_3L,L_1L,L_2S,L_0S,   /* bass clef */
  L_3L,L_4S,L_2S,L_4L,L_2L,L_3S,L_1S};  /* deepbass clef */


/* Table giving offsets into above for all the clefs */

int main_clefoffset[] = { 
   0,     /* treble */ 
   7,     /* soprano */
  14,     /* mezzo */
  21,     /* alto */
  28,     /* tenor */
  35,     /* Cbaritone */ 
  42,     /* (F)baritone */ 
  49,     /* bass */
  56,     /* deepbass */ 
   0,     /* hclef */
   0,     /* none */
   0,     /* trebledescant */
   0,     /* trebletenor */
   0,     /* trebletenorB */
  49,     /* soprabass */
  49 };   /* contrabass */


/* Table of clef types. This is used by the clefwidth directive for 
altering the table of widths in the movement structure. It indicates
which entries in the table are for which kinds of clef shape. */

int main_cleftypes[] = { clef_treble, 
  clef_alto, clef_alto, clef_alto, clef_alto, clef_alto, 
  clef_bass, clef_bass, clef_bass, 
  clef_h, clef_none,
  clef_treble, clef_treble, clef_treble,
  clef_bass, clef_bass };   
  

/* Table of pitch values for the seven note names */

uschar read_basicpitch[] = { 9, 11, 0, 2, 4, 5, 7 };

/* Table giving pitch increments/decrements indexed by accidental
number. The values are kept with 2 added so that they will fit
into the baraccs tables as bytes. The first value shouldn't be
used (it represents "no accidental"), but set it as a natural
just in case. */
                      /* - ##  $ $$  %  # */
uschar read_accpitch[] = { 2, 4, 1, 0, 2, 3 };


/* Table giving musical characters for accidental numbers */

int out_acctable[] = {
  0, mc_dsharp,  mc_flat,  mc_dflat,  mc_natural,  mc_sharp,
  0, mc_rdsharp, mc_rflat, mc_rdflat, mc_rnatural, mc_rsharp,
  0, mc_sdsharp, mc_sflat, mc_sdflat, mc_snatural, mc_ssharp };



/* Default point sizes of heading texts */

int read_headingsizes[] = { 17000, 12000, 10000, 8000 };


/* Tables for accent decoding. Arrange to get standard accent
numbers, with ! at the end. */

uschar *accent_singlechars = US" .->vVduo\'!";

int accent_list[] = {
  0, af_staccato, af_bar, af_gt, af_wedge, af_tp, af_down, af_up, af_ring,
  af_vline, af_opposite};

/* Movement values for music-font chars that just do movement, given
at a 1-point font size */

int music_xmovement[] = {    0,    0,   0, -100, 100, -330,    0, 550,   0 };
int music_ymovement[] = { -100, -400, 400,    0,   0,    0, -200,   0, 200 };


/* Caesura strings */

uschar *main_caesurastrings[] = { US"V", US"\\\\" };


/* Characters for printing staves with different numbers of lines */

uschar out_stavechar10[] = { 0, 'G', 247, 248, 249, 'F', 250 };
uschar out_stavechar1[] =  { 0, 'D', 169, 170, 171, 'C', 172 };


/* Top and bottom lines of staves */

int stave_tops[] =    { 8000, 8000, 12000, 16000, 12000, 16000, 20000 };
int stave_bottoms[] = { 8000, 8000,  4000,     0,     0,     0,     0 };



/*************************************************
*      Structure for printing music chars        *
*************************************************/

/* This structure converts from an idealized (virtual) "music font" into actual
characters and positions in the real music font. */

static mfstr cbaritone= { NULL, 0,  8000, '#' };
static mfstr tenor    = { NULL, 0,  4000, '#' };
static mfstr alto     = { NULL, 0,     0, '#' };
static mfstr mezzo    = { NULL, 0, -4000, '#' };
static mfstr soprano  = { NULL, 0, -8000, '#' };

static mfstr oldcbaritone= { NULL, 0,  8000, 175 };
static mfstr oldtenor    = { NULL, 0,  4000, 175 };
static mfstr oldalto     = { NULL, 0,     0, 175 };
static mfstr oldmezzo    = { NULL, 0, -4000, 175 };
static mfstr oldsoprano  = { NULL, 0, -8000, 175 };

static mfstr df1      = { NULL, 3900,  0, '\'' };
static mfstr dflat    = { &df1, 0,     0, '\'' };

static mfstr rnatural = { NULL,  0,  0, (142<<16)+('('<<8)+141 };
static mfstr rsharp   = { NULL,  0,  0, (142<<16)+('%'<<8)+141 };
static mfstr rdsharp  = { NULL,  0,  0, (142<<16)+('&'<<8)+141 };

static mfstr rf2      = { NULL,  8000,2000,  142 };
static mfstr rf1      = { &rf2,  3500,   0, '\'' };
static mfstr rflat    = { &rf1,     0,2000,  141 };

static mfstr rdf3     = { NULL, 11900,2000,  142 };
static mfstr rdf2     = { &rdf3, 7400,   0, '\'' };
static mfstr rdf1     = { &rdf2, 3500,   0, '\'' };
static mfstr rdflat   = { &rdf1,    0,2000,  141 };

static mfstr snatural = { NULL,  0,  0, (140<<16)+('('<<8)+139 };
static mfstr ssharp   = { NULL,  0,  0, (140<<16)+('%'<<8)+139 };
static mfstr sdsharp  = { NULL,  0,  0, (140<<16)+('&'<<8)+139 };

static mfstr sf2      = { NULL,  8000,2000,  140 };
static mfstr sf1      = { &sf2,  3500,   0, '\'' };
static mfstr sflat    = { &sf1,     0,2000,  139 };

static mfstr sdf3     = { NULL, 11900,2000,  140 };
static mfstr sdf2     = { &sdf3, 7400,   0, '\'' };
static mfstr sdf1     = { &sdf2, 3500,   0, '\'' };
static mfstr sdflat   = { &sdf1,    0,2000,  139 };

static mfstr ttp1 = { NULL, 4000, -12000, ']' };
static mfstr trebletenor = { &ttp1, 0, 0, '!' };

static mfstr ttp4 = { NULL,  9300, -12000, 158 };
static mfstr ttp3 = { &ttp4, 1000, -12000, 157 };
static mfstr ttp2 = { &ttp3, 4300, -12000, ']' };
static mfstr trebletenorB = { &ttp2, 0, 0, '!' };

static mfstr tdp1 = { NULL, 6000, 23000, ']' };
static mfstr trebledescant = { &tdp1, 0, 0, '!' };

static mfstr cbp1 = { NULL, 2500, -6000, ']' };
static mfstr contrabass = { &cbp1, 0, 0, '\"' };
static mfstr oldcontrabass = { &cbp1, 0, 0, 174 };

static mfstr sbp1 = { NULL, 3500, 16500, ']' };
static mfstr soprabass = { &sbp1, 0, 0, '\"' };
static mfstr oldsoprabass = { &sbp1, 0, 0, 174 };

static mfstr baritone = { NULL, 0, -4000, '\"' };
static mfstr deepbass = { NULL, 0,  4000, '\"' };

static mfstr oldbaritone = { NULL, 0, -4000, 174 };
static mfstr olddeepbass = { NULL, 0,  4000, 174 };

/* Small integers in these tables indicate a one-to-one correspondence
between the musical character and a character in the music font. */

mfstr *out_mftable_ps[] =
  {
  (mfstr *)33, &trebletenor, &trebledescant,
  (mfstr *)34, &contrabass,  &soprabass,
  &cbaritone,  &tenor,       &alto, 
  &mezzo,      &soprano,

  (mfstr *)40, (mfstr *)37,    (mfstr *)38, (mfstr *)39, &dflat,
  &rnatural,   &rsharp,        &rdsharp,    &rflat,      &rdflat,
  &snatural,   &ssharp,        &sdsharp,    &sflat,      &sdflat,

  (mfstr *)94, (mfstr *)95,                            /* common & cut */
  (mfstr *)48, &trebletenorB, (mfstr *)173,            /* long rest & clefs */
  &baritone,   &deepbass,     (mfstr *)174, &oldcontrabass,
  &oldsoprabass, &oldcbaritone, &oldtenor,  &oldalto,  &oldmezzo,   &oldsoprano,
  &oldbaritone, &olddeepbass   
  };



/*************************************************
*              Movement initialization           *
*************************************************/


/* Accidental adjustments are initialized to zero */

static int init_accadjusts[8];


/* Accspacing is effectively the width of each accidental
character, in order of height. The first entry in the table
is unused; the offset relates to inverted notes. */

                            /*  inv  ##    $     $$    %     # */
static int init_accspacing[] = { 0, 5250, 4500, 8000, 4250, 5000 };


/* Stemswap level defaults to the third line. This table must be kept in
stem with stave_bitvec_size. */

static int init_stemswaplevel[] = {
  P_3L, P_3L, P_3L, P_3L, P_3L, P_3L, P_3L, P_3L,
  P_3L, P_3L, P_3L, P_3L, P_3L, P_3L, P_3L, P_3L,
  P_3L, P_3L, P_3L, P_3L, P_3L, P_3L, P_3L, P_3L,
  P_3L, P_3L, P_3L, P_3L, P_3L, P_3L, P_3L, P_3L,
  P_3L, P_3L, P_3L, P_3L, P_3L, P_3L, P_3L, P_3L,
  P_3L, P_3L, P_3L, P_3L, P_3L, P_3L, P_3L, P_3L,
  P_3L, P_3L, P_3L, P_3L, P_3L, P_3L, P_3L, P_3L,
  P_3L, P_3L, P_3L, P_3L, P_3L, P_3L, P_3L, P_3L};


/* Default note spacing */

int init_notespacing[] = {
  30000, 30000, 22000, 16000, 12000, 10000, 10000, 10000 };


/* Default startline spacing */

static startlinestr init_startline = { 0, 0, 0, 0 };


/* Default font sizes at normal magnification; null pointers to
stretch/shear matrices. */

static fontsizestr init_fontsizes = {
  10000,     /* music */
   7000,     /* grace */
   7000,     /* cue */
   5000,     /* cuegrace */
  10000,     /* clefs */
  10000,     /* barno */
   9000,     /* footnote */
  12000,     /* rehearse */
  10000,     /* triplet */
  10000,     /* repno */
  10000,     /* restct */
  10000,     /* trill */
  10000,     /* vertacc */

  /* It doesn't seem possible in ANSI C to parameterize this
  initialization using MaxTextFont, so we must keep this in
  step with its value. */

  { 10000,     /* user font size 1 */
    10000,     /* user font size 2 */
    10000,     /* user font size 3 */
    10000,     /* user font size 4 */
    10000,     /* user font size 5 */
    10000,     /* user font size 6 */
    10000,     /* user font size 7 */
    10000,     /* user font size 8 */
    10000,     /* user font size 9 */
    10000,     /* user font size 10 */
    10000,     /* user font size 11 */
    10000,     /* user font size 12 */
  },

  11800,     /* tsfont */
  10000,     /* ulay */
  10000,     /* olay */
  10000,     /* fbass */
  10000,     /* init */

  /* Matrix pointers */

  NULL,     /* music */
  NULL,     /* grace */
  NULL,     /* cue */
  NULL,     /* cuegrace */
  NULL,     /* clefs */
  NULL,     /* footnote */
  NULL,     /* barno */
  NULL,     /* rehearse */
  NULL,     /* triplet */
  NULL,     /* repno */
  NULL,     /* restct */
  NULL,     /* trill */
  NULL,     /* vertacc */

  /* It doesn't seem possible in ANSI C to parameterize this
  initialization using MaxTextFont, so we must keep this in
  step with its value. */

  { NULL,     /* user font size 1 */
    NULL,     /* user font size 2 */
    NULL,     /* user font size 3 */
    NULL,     /* user font size 4 */
    NULL,     /* user font size 5 */
    NULL,     /* user font size 6 */
    NULL,     /* user font size 7 */
    NULL,     /* user font size 8 */
    NULL,     /* user font size 9 */
    NULL,     /* user font size 10 */
    NULL,     /* user font size 11 */
    NULL,     /* user font size 12 */
  },

  NULL,     /* tsfont */
  NULL,     /* ulay */
  NULL,     /* olay */
  NULL,     /* fbass */
  NULL,     /* init */
};


/* Default relative stave sizes, must keep in step with stave_bitvec_size */

int init_stavesizes[] =
  {
  1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000,
  1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000,
  1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000,
  1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000,
  1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000,
  1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000,
  1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000,
  1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000 };

/* Default relative stave volumes; must keep in step with stave_bitvec_size */

uschar init_play_volume[] =
  { 0, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
   15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
   15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
   15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15 };
   
/* Default midi channels; must keep in step with stave_bitvec_size */ 

uschar init_midi_channel[] =
  { 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 };

/* Default midi forced pitch; must keep in step with stave_bitvec_size. 
Zero means use pitch of note (i.e. don't force). */ 

uschar init_midi_note[] =
  { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };

/* Default midi voice allocation to midi channels; 128 => don't set */

uschar init_midi_voice[] = 
  { 128, 128, 128, 128, 128, 128, 128, 128, 
    128, 128, 128, 128, 128, 128, 128, 128 }; 
    
/* Default midi channel volumes */

uschar init_midi_volume[] =
  { 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15 }; 
   

/* Default stave zero copy block */

zcopystr init_zcopy = { NULL, NULL, 0, 0, 0, 1 };


/* Default values for the movement structure */

movtstr init_movtstr = {
  NULL,               /* stavetable */

  &init_fontsizes,    /* fontsizes */
  NULL,               /* posvector */
  &init_startline,    /* startline */
  &init_zcopy,        /* zcopy */ 

  NULL,               /* bracelist */
  (stave_list *)(-1), /* bracketlist */
  (stave_list *)(-1), /* joinlist */
  NULL,               /* joindottedlist */
  NULL,               /* thinbracketlist */ 

  NULL,               /* footing */
  NULL,               /* heading */
  NULL,               /* lastfooting */
  NULL,               /* pagefooting */
  NULL,               /* pageheading */

  NULL,               /* play_changes */
  NULL,               /* barnovector */
  US"-",                /* hyphenstring */
  US"\\mf\\\\136\\",    /* trill string */
  init_play_volume,   /* play volumes */
  
  init_midi_channel,  /* midi channel for each stave */
  init_midi_note,     /* midi note forced for each stave */
  init_midi_voice,    /* voices for each MIDI channel */ 
  init_midi_volume,   /* volumes for each MIDI channel */ 

  init_accadjusts,    /* accadjusts */
  init_accspacing,    /* accspacing */
  init_notespacing,   /* notespacing */
  NULL,               /* layout */ 
  NULL,               /* midi_start */ 
  NULL,               /* play_tempo_changes */
  init_stavesizes,    /* stavesizes */
  NULL,               /* stave_ensure */
  NULL,               /* stave_spacing */
  init_stemswaplevel, /* stemswaplevel */

  0,                  /* barcount */
  0,                  /* barlinesize */ 
  0x80000000,         /* barlinespace */
  0,                  /* barlinestyle */
  0,                  /* barno_interval */
  0,                  /* barno_level */ 
  0,                  /* barno_textflags */
  0,                  /* baroffset */
  1800,               /* beamdepth */
  5000,               /* beamflaglength */ 
  0,                  /* botmargin */
  0,                  /* bracestyle */ 
  2300,               /* breveledgerextra */
  0,                  /* caesurastyle */
  1000,               /* clefsize */
  0,                  /* clefstyle */ 
  1200,               /* dotspacefactor */
  0,                  /* endlinesluradjust */
  0,                  /* endlineslurstyle */ 
  0,                  /* endlinetieadjust */
  0,                  /* endlinetiestyle */    
  0,                  /* extenderlevel */
  font_rm,            /* bar number font */
  font_bf,            /* long rest font */
  font_rm,            /* rehearsal marks font */
  font_rm,            /* repeat bar numbers font */
  font_bf,            /* time signature font */
  font_rm,            /* triplet font */
  4000,               /* footnotesep */ 
  { 6000,6000 },      /* gracespacing */
  0,                  /* gracestyle */
  200,                /* hairpinlinewidth */
  7000,               /* hairpinwidth */
  50000,              /* hyphenthreshold */
  just_all,           /* justify */
  2,                  /* key default = C major */
  0,                  /* keyspacing */ 
  0,                  /* laststave */
  -1,                 /* leftmargin */
  -1,                 /* linelength */
  500,                /* maxbarcount */
  310,                /* maxbeamslope1 */ 
  330,                /* maxbeamslope2 */ 
  movt_default,       /* movt_opt */
  11000,              /* overlaydepth */
  120,                /* play_tempo */
  text_box,           /* rehearsalstyle */
  0,                  /* repeatstyle */
  0,                  /* shorten (stems) */ 
  700,                /* smallcapsize */ 
  0,                  /* startbracketbar */
  stemswap_default,   /* stemswaptype */
  44000,              /* systemgap */
  0x00010404,         /* time default = 1*4/4 */
  0,                  /* timespacing */ 
  10000,              /* topmargin */
  0,                  /* totalnocount */
  0,                  /* transpose */
  300,                /* tripletlinewidth */
  480000,             /* truelinelength */
  11000,              /* underlaydepth */
  0,                  /* underlaystyle */ 

  { 0, 0 },           /* breakbarlines */   /*** must be kept in ***/
  { -1, -1 },         /* staves */          /*** step with ***/
  { 0, 0 },           /* suspend */         /*** stave_bitvec_size ***/
  
  { 13, 15, 15, 15, 15, 15, 16, 16, 16, 15, 0, 13, 13, 13, 16, 16 },  /* clefwidths */
  { 0, 0, 0, 0, 0, 0, 2000, 4000 },         /* tailadjusts */ 

  FALSE,              /* beamendrests */
  FALSE,              /* breverests */
  TRUE,               /* check */
  TRUE,               /* checkdoublebars */
  TRUE,               /* fullbarend */
  FALSE,              /* incipitjoin */
  TRUE,               /* keydoublebar */
  TRUE,               /* keywarn */
  TRUE,               /* showtime */
  TRUE,               /* showtimebase */
  FALSE,              /* tiesoverwarnings */ 
  TRUE,               /* timewarn */
  FALSE,              /* startnotime */
  TRUE,               /* spreadunderlay */
  TRUE,               /* underlayextenders */ 
  FALSE,              /* unfinished */

  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,   /* playtranspose; must keep in */
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,   /* step with stave_bitvec_size */
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 }
};



/*************************************************
*             Bar item lengths table             *
*************************************************/

/* The length table is used for advancing the pointer through the
packed list of structures. The lengths are rounded up to whole words. On the
Acorn, this was done by by the sizeof() operator, but it seems not to be the
case with gcc. */

#define ROUND(x) ((((x) + sizeof(int) - 1)/sizeof(int)) * sizeof(int))

uschar length_table [] = {
  ROUND(sizeof(b_Endstr)),
  ROUND(sizeof(b_Jumpstr)),
  ROUND(sizeof(b_allstr)),
  ROUND(sizeof(b_barnumstr)),
  ROUND(sizeof(b_beamaccstr)),
  ROUND(sizeof(b_beambreakstr)),
  ROUND(sizeof(b_beambreak2str)),
  ROUND(sizeof(b_beamritstr)),
  ROUND(sizeof(b_bowingstr)),
  ROUND(sizeof(b_breakbarlinestr)),
  ROUND(sizeof(b_caesurastr)),
  ROUND(sizeof(b_chordstr)),
  ROUND(sizeof(b_clefstr)),
  ROUND(sizeof(b_commastr)),
  ROUND(sizeof(b_dbarstr)),
  ROUND(sizeof(b_dotbarstr)),
  ROUND(sizeof(b_dotrightstr)),
  ROUND(sizeof(b_drawstr)),
  ROUND(sizeof(b_dynmovestr)),
  ROUND(sizeof(b_endpletstr)),
  ROUND(sizeof(b_endslurstr)),
  ROUND(sizeof(b_ensstr)),
  ROUND(sizeof(b_ensurestr)), 
  ROUND(sizeof(b_footnotestr)), 
  ROUND(sizeof(b_hairpinstr)),
  ROUND(sizeof(b_ibarstr)),
  ROUND(sizeof(b_justifystr)),
  ROUND(sizeof(b_keystr)),
  ROUND(sizeof(b_linegapstr)),
  ROUND(sizeof(b_lrepeatstr)),
  ROUND(sizeof(b_masqstr)),
  ROUND(sizeof(b_movestr)),
  ROUND(sizeof(b_namestr)),
  ROUND(sizeof(b_nbarstr)),
  ROUND(sizeof(b_newlinestr)),
  ROUND(sizeof(b_newpagestr)),
  ROUND(sizeof(b_nopackstr)),
  ROUND(sizeof(b_notestr)),
  ROUND(sizeof(b_noteheadsstr)),
  ROUND(sizeof(b_notesstr)),
  ROUND(sizeof(b_nsstr)),
  ROUND(sizeof(b_nsmstr)),
  ROUND(sizeof(b_offsetstr)),
  ROUND(sizeof(b_olevelstr)),
  ROUND(sizeof(b_olherestr)),
  ROUND(sizeof(b_ornamentstr)),
  ROUND(sizeof(b_pagestr)), 
  ROUND(sizeof(b_pagebotsstr)),
  ROUND(sizeof(b_pagetopsstr)),
  ROUND(sizeof(b_playchangestr)), 
  ROUND(sizeof(b_pletstr)),
  ROUND(sizeof(b_prevbarstr)), 
  ROUND(sizeof(b_resetstr)),
  ROUND(sizeof(b_resumestr)),
  ROUND(sizeof(b_rrepeatstr)),
  ROUND(sizeof(b_setclef)),
  ROUND(sizeof(b_setkey)),
  ROUND(sizeof(b_settime)),
  ROUND(sizeof(b_sgstr)),
  ROUND(sizeof(b_sgstr)),
  ROUND(sizeof(b_slopestr)),
  ROUND(sizeof(b_slurstr)),
  ROUND(sizeof(b_linegapstr)), 
  ROUND(sizeof(b_slurmodstr)),
  ROUND(sizeof(b_spacestr)),
  ROUND(sizeof(b_ssstr)),
  ROUND(sizeof(b_ssstr)),
  ROUND(sizeof(b_suspendstr)),
  ROUND(sizeof(b_textstr)),
  ROUND(sizeof(b_textXstr)),
  ROUND(sizeof(b_tickstr)),
  ROUND(sizeof(b_tiestr)),
  ROUND(sizeof(b_timestr)),
  ROUND(sizeof(b_tremolostr)),
  ROUND(sizeof(b_tripswstr)),
  ROUND(sizeof(b_ulevelstr)),
  ROUND(sizeof(b_ulherestr)),
  ROUND(sizeof(b_unbreakbarlinestr)),
  ROUND(sizeof(b_zcopystr)) 
};

/* End of tables.c */
