/*************************************************
*    The PMW Music Typesetter - 3rd incarnation  *
*************************************************/

/* Copyright (c) Philip Hazel, 1991 - 2002 */

/* Written by Philip Hazel, starting November 1991 */
/* This file last modified: September 2002 */


/* This file contains code for outputting nth time bar markings */

#include "pmwhdr.h"
#include "outhdr.h"
#include "pagehdr.h"




/*************************************************
*          Deal with start of nth time bar       *
*************************************************/

void out_setstartnbar(b_nbarstr *nb, int x, int miny)
{
nbarstr *nbb = store_Xget(sizeof(nbarstr));
nbb->next = NULL;
nbb->nbar = nb;
nbb->x = x;
nbb->maxy = -BIGNUMBER;
nbb->miny = miny;
bar_cont->nbar = nbb;
}





/*************************************************
*         Free store for an nth time marking     *
*************************************************/

void out_freenbar(void)
{
nbarstr *nb = bar_cont->nbar;
while (nb != NULL)
  {
  nbarstr *next = nb->next;
  store_free(nb);
  nb = next;
  }
bar_cont->nbar = NULL;
}



/*************************************************
*               Draw an nth time marking         *
*************************************************/

/* The yield is the unmagnified y level, which is set as a minimum
for a subsequent marking. We don't free the data here, as sometimes
nothing is drawn (e.g. when bar lines descend), so the freeing
happens elsewhere. */

int out_drawnbar(BOOL rightjog, int x1)
{
int x[4], y[4];
int n = 0;
nbarstr *nb = bar_cont->nbar;
b_nbarstr *b = nb->nbar;

int yield;
int x0 = nb->x;
int yy = (nb->maxy > 18000)? nb->maxy + 11000 : 29000;

/* Minimum y keeps it aligned with previous */

if (yy < nb->miny) yy = nb->miny;

/* Add in manual adjustment and scale to stave */

yield = yy + b->y;
yy = (yield * main_stavemagn)/1000;


/* Sort out the left hand end; a continuation prints nothing,
and can set the y value lower because of this. */

/* No it can't - messes up alignment with next */

if (x0 == 0)
  {
  x0 = out_sysblock->firstnoteposition - 2000 + out_sysblock->xjustify;
  /* yy -= 4*main_stavemagn; */
  }


/* Start of a new iteration; set up for a jog and output the text(s) */

else
  {
  uschar buff[80];
  uschar *p = buff;
  uschar *comma = US"";

  x0 += 1500 + b->x;
  x[n] = x0;
  y[n++] = yy - 10*main_stavemagn;

  while (nb != NULL)
    {
    b = nb->nbar;
    if (b->s == NULL) 
      p += sprintf(CS p, "%s%d", comma, b->n);
    else   
      p += sprintf(CS p, "%s%s", comma, b->s);
    comma = US", ";
    nb = nb->next;
    }

  out_string(buff, curmovt->font_repeat,
    mac_muldiv((curmovt->fontsizes)->fontsize_repno, main_stavemagn, 1000),
      x0 + 4000, out_ystave - yy + 9*main_stavemagn, 0);
  }


/* Draw the lines and return the basic level */

x[n] = x0;
y[n++] = yy;

x[n] = x1;
y[n++] = yy;

if (rightjog)
  {
  x[n] = x1;
  y[n++] = yy - 10*main_stavemagn;
  }

dev_lines(x, y, n, 400);
return yield;
}


/* End of setnbar.c */
