/*************************************************
*    The PMW Music Typesetter - 3rd incarnation  *
*************************************************/

/* Copyright (c) Philip Hazel, 1991 - 2002 */

/* Written by Philip Hazel, starting November 1991 */
/* This file last modified: August 2002 */


/* This is the header file for the pagination routines.
It contains mostly definitions of shared variables. Many of the
structures used are more global, and are therefore in pmwhdr. */


/* Backward offsets for non-note items in a bar. */

#define posx_acc         (-1)    /* accidental */
#define posx_gracelast   (-2)    /* grace notes use 2 to 15, in reverse order */
#define posx_gracefirst  (-15)
#define posx_RLright     (-16)   /* left repeat when printed on the right */
#define posx_timelast    (-17)   /* time signatures use 17 to 20, in reverse */
#define posx_timefirst   (-20)
#define posx_keylast     (-21)   /* key signatures use 21 to 24, in reverse */
#define posx_keyfirst    (-24)
#define posx_RLleft      (-25)   /* left repeat when printed on the left */
#define posx_RR          (-26)
#define posx_dotbar      (-27)
#define posx_clef        (-28)
#define posx_tick        (-29)
#define posx_comma       (-30)
#define posx_caesura     (-31)
#define posx_max         (-31)

#define posx_maxgrace    (posx_gracelast - posx_gracefirst + 1)
#define posx_maxtime     (posx_timelast - posx_timefirst + 1)
#define posx_maxkey      (posx_keylast - posx_keyfirst + 1)


extern pagedatastr *page_accepteddata;  /* pointers to the data structures */
extern pagedatastr *page_nextdata;      /* used while measuring */
extern pagedatastr *page_previousdata;


extern int  page_barcount;            /* bars processed so far */
extern int  page_barlinewidth;        /* bar line width */
extern int  page_barnumber;           /* next to be processed */
extern int  page_botmargin;           /* value for this page */
extern contstr *page_cont;            /* continuation structure */
extern int  page_countsystems;        /* count of systems on a page */
extern int  page_done;                /* finish flag */
extern BOOL page_firstsystem;         /* first system of movt */
extern headstr *page_footing;         /* pending footing */
extern int  page_footnotedepth;       /* depth of footnotes for a system */
extern headstr *page_footnotes;       /* pending footnotes */
extern int  page_footnotespacing;     /* current spacing off value */
extern int  page_justify;             /* bits for this page */
extern int  page_justifyLR;           /* bits for this system */
extern int  page_lastbarcountbump;    /* for backing off */
extern BOOL page_lastendwide;         /* flag for repeat */
extern BOOL page_lastenddouble;       /* flag for double bar */
extern headstr *page_lastfootnote;
extern headstr *page_lastnewfootnote;
extern sysblock *page_lastsystem;     /* previous system */
extern int  page_lastulevel;          /* bottommost underlay level */
extern int  page_lastwanted;          /* highest wanted stave number */
extern int  page_layout_stretchn;     /* used for re-spacing */
extern int  page_layout_stretchd;     /* ditto */
extern int  page_manyrest;            /* multi-rest count */
extern startlinestr *page_midline;    /* current mid line data */
extern int  page_movtnumber;          /* current movement */
extern BOOL page_movtpending;         /* new movement pending */
extern int  page_newfootnotedepth;    /* depth of footnotes for a system */
extern headstr *page_newfootnotes;    /* footnotes for a system */
extern BOOL page_newpagewanted;       /* set to force newpage */
extern int  page_olaysize;            /* overlay size for this movement */
extern int *page_olevel;              /* forced olevels */
extern int *page_olhere;              /* local forcings */
extern workposstr *page_posptr;       /* pointer to end of following */
extern workposstr *page_postable;     /* working position table */
extern BOOL page_savehadmovt;         /* temp save */
extern int  page_sgnext;              /* system gap for next system */
extern unsigned int page_showtimes[stave_bitvec_size]; /* which staves require time sigs */
extern int *page_ssnext;              /* spacing table for next system */
extern int *page_ssehere;             /* ensure table for this system */
extern int *page_ssenext;             /* ensure table for next system */
extern BOOL page_startchangetime;     /* flags change of ts at start line */
extern startlinestr *page_startline;  /* current start line data */
extern BOOL page_startlinebar;        /* flags start of line */
extern int  page_stave;               /* current stave */
extern unsigned int page_stavemap[stave_bitvec_size]; /* copy of movement stave bits */
extern sysblock *page_sysblock;       /* current block */
extern sysblock **page_sysprevptr;    /* points to where to hang the next on */
extern int  page_sys_botmargin;       /* value set by this system */
extern int  page_sys_justify;         /* ditto */
extern int  page_sys_topmargin;       /* ditto */
extern int  page_topmargin;           /* value for this page */
extern int  page_ulaysize;            /* underlay size for this movement */
extern int *page_ulevel;              /* forced ulevels */
extern int *page_ulhere;              /* local forcings */
extern BOOL page_warnkeytime;         /* warning key/time wanted */
extern int  page_xxwidth;             /* width of signatures only bar */


extern void *page_copy(void *);
extern void page_dopageheading(headstr *);
extern void page_endpage(BOOL);
extern void page_justifyheading(headstr *);
extern void page_newpage(headstr *, headstr *);
extern int  page_makepostable(BOOL);
extern int  page_namestringwidth(uschar *, int, int);
extern void page_setcont(void);
extern void page_setsignatures(void);
extern int  page_startwidth(pagedatastr *, unsigned int *, unsigned int *);

/* End of pagehdr.h */
