/* Copyright 1995, 1996, 1997, 1998 by Arkkra Enterprises */

#include <stdio.h>
#include "globals.h"

char *prolog_text[] = {
	"% Mup prolog Copyright (c) 1995, 1996, 1997, 1998, 1999, 2000, 2003, 2004,",
	"% 2008, 2009 by Arkkra Enterprises",
	"% All rights reserved",
	"",
	"% Mup PostScript Prolog 5.8 for use with Mup 5.8",
	"",
	"% lwid is used as the width of a standard (thin) line in the music",
	"% character definitions.",
	"/lwid 70 def",
	"/halflwid lwid 2 div def",
	"",
	"% Define the following for use in do_upshortnote, do_dnshortnote, and",
	"% do_shortrest; it has to be done outside of the music font definition.",
	"/utildict 10 dict def",
	"utildict begin",
	"	/setnumflags	{	/numflags	exch def } def",
	"	/sethooksm1	{	/hooksm1	exch def } def",
	"	/setoffsets	{	/offsets	exch def } def",
	"	/setx		{	/x		exch def } def",
	"	/sety		{	/y		exch def } def",
	"end",
	"",
	"% Define a music character font.  Each music character is defined as if it",
	"% were a normal ASCII character in a strange font where \"A\" looks like a",
	"% treble clef, \"B\" looks like a bass clef, etc.",
	"",
	"/mfont0 100 dict def",
	"mfont0 begin",
	"	/FontType 3 def",
	"	/FontMatrix [ .001 0 0 0.001 0 0 ] def",
	"	/FontBBox [ -2000 -4030 2000 4030 ] def",
	"	/FontName (Mfont0) def",
	"",
	"	% set up Encoding vector with standard names",
	"	/Encoding 256 array def",
	"	StandardEncoding Encoding copy",
	"	pop",
	"",
	"	% the following definitions are used for quarter rests",
	"	/topx -170 def /topy 950 def",
	"	/cor1x 250 def /cor1y 450 def",
	"	/cor2x -300 def /cor2y 200 def",
	"	/cor3x 250 def /cor3y -400 def",
	"",
	"	% the following definitions are used for double sharps",
	"	/limit 300 halflwid add def",
	"	/off 70 def",
	"	/inbendsmall limit 200 sub def",
	"	/inbendbig limit 20 sub def",
	"	/outbendsmall 100 def",
	"	/outbendbig outbendsmall off add def",
	"",
	"	%%%%% define routines that will be used by multiple characters %%%%%",
	"	/do_1n {",
	"		gsave",
	"		newpath -10 rotate 1.6 1 scale",
	"		0 0 325 0 360 arc		%outer ellipse",
	"		1 1.6 div 1 scale 10 rotate	%back to original",
	"		35 rotate 0.85 1.1 scale",
	"		0 0 275 0 360 arc		%inner ellipse",
	"		eofill",
	"		grestore",
	"	} def",
	"	/do_upflag {",
	"		-315 0 moveto",
	"		-300 100 -100 480 0 600 curveto",
	"		300 960 350 1500 200 1700 curveto",
	"		130 1700 lineto",
	"		350 1200 50 650 -315 600 curveto",
	"		fill",
	"	} def",
	"	/do_flat {",
	"		-250 -400 moveto	%outer edge of loop",
	"		500 0 350 650 -250 160 curveto",
	"		-250 160 lwid sub lineto %inner edge of loop",
	"		100 400 300 0 -250 -400 lwid add curveto",
	"		fill",
	"",
	"		lwid setlinewidth	%stem",
	"		-250 1100 moveto -250 -400 lineto stroke",
	"	} def",
	"	/do_diamond {",
	"		newpath",
	"		420 0 moveto 0 300 lineto -420 0 lineto",
	"		0 -300 lineto closepath",
	"		259 -29 moveto -41 185 lineto -259 29 lineto",
	"		41 -185 lineto closepath",
	"		eofill",
	"	} def",
	"	/do_2n {",
	"		gsave",
	"		newpath 25 rotate 1.4 1 scale",
	"		0 0 315 0 360 arc		%outer ellipse",
	"		1 1.4 div 1 scale		%back to original",
	"		1.3 0.5 scale",
	"		0 0 310 0 360 arc		%inner ellipse",
	"		eofill",
	"		grestore",
	"	} def",
	"	/do_4n {",
	"		gsave",
	"		newpath 25 rotate 1.35 1 scale",
	"		0 0 310 0 360 arc fill",
	"		grestore",
	"	} def",
	"	/do_com {",
	"		newpath",
	"		330 250 150 0 360 arc fill	%knob at upper right",
	"		465 300 moveto			%outer boundary",
	"		410 500 200 635 0 635 curveto",
	"		-750 635 -750 -635 0 -635 curveto",
	"		350 -635 480 -300 500 -100 curveto",
	"		430 -100 lineto			%inner boundary",
	"		380 -300 250 -565 0 -565 curveto",
	"		-450 -565 -450 565 0 565 curveto",
	"		200 565 370 350 395 300 curveto",
	"		fill",
	"	} def",
	"	/do_ferm {",
	"		0 0 800 lwid sub 0 180 arc	%inner arc",
	"		-800 0 lineto",
	"		0 270 lwid sub 800 180 0 arcn	%outer arc",
	"		800 0 lineto fill",
	"		0 120 120 0 360 arc fill	%the dot",
	"	} def",
	"	/do_mor {",
	"		gsave",
	"		0.7 1 scale	%scrunch the following horizontally",
	"		45 rotate	%to pretend all lines horz or vertical",
	"		0 1 1 {",
	"			pop	%we don't need the loop variable",
	"			%one half of the mordent",
	"			0 40 moveto 350 40 lineto 350 -460 lineto",
	"			750 -460 lineto 750 -540 lineto",
	"			150 -540 lineto 150 -40 lineto",
	"			0 -40 lineto fill",
	"			180 rotate	%to do the other half",
	"		} for",
	"		grestore",
	"	} def",
	"	/do_turn {",
	"		gsave",
	"		0 1 1 {",
	"			pop	%we don't need the loop variable",
	"			0 -100 moveto	%outer boundary",
	"			200 -400 625 -400 625 0 curveto",
	"			625 200 500 325 300 325 curveto",
	"			300 185 lineto	%inner boundary",
	"			450 255 555 150 555 0 curveto",
	"			555 -350 250 -250 0 100 curveto",
	"			fill",
	"			300 255 70 0 360 arc fill %knob on end",
	"			180 rotate	%to do the other half",
	"		} for",
	"		grestore",
	"	} def",
	"",
	"	/do_upshortnote {",
	"		utildict begin",
	"		setnumflags		%set numflags from the stack",
	"		gsave",
	"		-330 0 translate	%half a flag width",
	"		do_4n			%do a quarter note head",
	"		lwid setlinewidth",
	"		370 0 moveto",
	"		370 2100 numflags 2 sub flagsep mul add lineto stroke",
	"		670 2100 numflags 2 sub flagsep mul add translate",
	"		1 -1 scale		%reflect across X axis",
	"		0 1 numflags 1 sub {",
	"			do_upflag	%do an upflag",
	"			pop		%we don't need the loop variable",
	"			0 flagsep translate",
	"		} for",
	"		grestore",
	"		end",
	"	} def",
	"",
	"	/do_dnshortnote {",
	"		utildict begin",
	"		setnumflags		%set numflags from the stack",
	"		do_4n			%do a quarter note head",
	"		lwid setlinewidth",
	"		-370 0 moveto",
	"		-370 -2100 numflags 2 sub flagsep mul sub lineto stroke",
	"		gsave",
	"		-70 -2100 numflags 2 sub flagsep mul sub translate",
	"		0 1 numflags 1 sub {",
	"			do_upflag	%do an upflag",
	"			pop		%we don't need the loop variable",
	"			0 flagsep translate",
	"		} for",
	"		grestore",
	"		end",
	"	} def",
	"",
	"	/do_shortrest {",
	"		utildict begin",
	"		sety setx setoffsets sethooksm1	%set variable from the stack",
	"		gsave",
	"		-105.8 offsets mul -600 offsets mul translate",
	"		0 1 hooksm1 {		%loop once per hook",
	"			newpath",
	"			1 setlinewidth",
	"			gsave",
	"			1 1.2 scale",
	"			-150 300 1.2 div 140 0 360 arc fill 	%the dot",
	"			grestore",
	"			lwid setlinewidth",
	"			-50 700 550 255 315 arc		%rest of the hook",
	"			hooksm1 lt { stroke 105.8 600 translate } if",
	"		} for",
	"		x y lineto stroke",
	"		grestore",
	"		end",
	"	} def",
	"",
	"",
	"	% subsidiary dictionary of character definitions",
	"	/CharStrings 128 dict def",
	"	CharStrings begin",
	"",
	"		/.notdef {} def",
	"",
	"		% Here are the definitions of the characters.  A stepsize here",
	"		% is 300 units (assuming the character is drawn at its default",
	"		% size).",
	"",
	"		% gclef",
	"		/A {",
	"			newpath",
	"			%start with inner curl, inside boundary",
	"			-50 -300 moveto",
	"			-450 600 700 700 750 0 curveto",
	"			750 -800 -700 -800 -700 200 curveto",
	"			-700 900 500 1400 520 2250 curveto",
	"			520 2900 300 3000 200 3000 curveto",
	"			100 3000 -400 2500 -200 1800 curveto",
	"			350 -600 lineto",
	"			720 -1600 0 -1650 -400 -1400 curveto",
	"",
	"			%go back to start, drawing the other boundary",
	"			-400 -1480 lineto",
	"			0 -1700 800 -1700 430 -600 curveto",
	"			-120 1800 lineto",
	"			-300 2400 200 2800 250 2800 curveto",
	"			400 2800 430 2700 430 2450 curveto",
	"			430 1800 -900 1200 -900 300 curveto",
	"			-750 -900 800 -900 850 0 curveto",
	"			900 1100 -750 900 -120 -300 curveto fill",
	"",
	"			%circle at the bottom",
	"			-300 -1250 250 0 360 arc fill",
	"		} def",
	"",
	"		% fclef",
	"		/B {",
	"			newpath",
	"			%start with outside boundary, at bottom",
	"			-1000 -1700 moveto",
	"			100 -1100 500 -600 450 0 curveto",
	"			450 850 -1100 850 -950 0 curveto",
	"",
	"			%go back to start, drawing the other boundary",
	"			-880 0 lineto",
	"			-920 400 -600 560 -300 560 curveto",
	"			0 560 150 400 150 0 curveto",
	"			150 -400 100 -900 -1000 -1620 curveto fill",
	"",
	"			%circle at the left",
	"			newpath",
	"			-700 0 250 0 360 arc fill",
	"",
	"			%do the two dots after the main curve",
	"			700 -300 100 0 360 arc fill",
	"			700 300 100 0 360 arc fill",
	"		} def",
	"",
	"		% cclef",
	"		/C {",
	"			gsave",
	"			%do upper curved part, then scale to do mirror image",
	"			0 1 1 {",
	"				pop	%we don't need the loop variable",
	"				%outer boundary of curve",
	"				-170 0 moveto 100 300 lineto",
	"				400 -200 750 300 750 650 curveto",
	"				750 1100 450 1235 250 1235 curveto",
	"				0 1235 -143 1100 -143 950 curveto",
	"",
	"				%inner boundary of curve",
	"				0 950 lineto",
	"				0 1100 30 1165 250 1165 curveto",
	"				300 1165 450 1100 450 650 curveto",
	"				450 400 400 -100 100 400 curveto",
	"				-270 0 lineto fill",
	"				%stroke",
	"				%-270 0 moveto 100 400 lineto",
	"				%400 -100 450 400 450 650 curveto",
	"				%450 1100 300 1165 250 1165 curveto",
	"				%30 1165 0 1100 0 950 curveto",
	"				%stroke",
	"",
	"				%elliptical ball at end of curve",
	"				gsave",
	"				1.3 1 scale",
	"				10 950 120 0 360 arc fill",
	"				grestore",
	"				1 -1 scale	%reflect across X axis",
	"			} for",
	"			grestore",
	"",
	"			% two vertical lines on the left",
	"			300 setlinewidth -600 -1200 halflwid sub moveto",
	"			-600 1200 halflwid add lineto stroke",
	"			lwid setlinewidth -300 -1200 halflwid sub moveto",
	"			-300 1200 halflwid add lineto stroke",
	"		} def",
	"",
	"		% dblwhole",
	"		/D {",
	"			do_1n		%do a whole note",
	"			lwid setlinewidth",
	"			-490 -600 moveto -490 600 lineto stroke",
	"			490 -600 moveto 490 600 lineto stroke",
	"		} def",
	"",
	"		% 1n",
	"		/E {",
	"			do_1n		%do a whole note",
	"		} def",
	"",
	"		% 2n",
	"		/F {",
	"			do_2n		%do a half note",
	"		} def",
	"",
	"		% 4n",
	"		/G {",
	"			do_4n		%do a quarter note head",
	"		} def",
	"",
	"		% upflag",
	"		/H {",
	"			do_upflag		%do an upflag",
	"		} def",
	"",
	"		% dnflag",
	"		/I {",
	"			gsave",
	"			1 -1 scale	%reflect across X axis",
	"			do_upflag		%do an upflag",
	"			grestore",
	"		} def",
	"",
	"		% dwhrest",
	"		/J {",
	"			300 setlinewidth",
	"			0 0 moveto 0 600 lineto stroke",
	"		} def",
	"",
	"		% 1rest",
	"		/K {",
	"			lwid setlinewidth",
	"			-750 600 moveto 750 600 lineto stroke",
	"			300 setlinewidth",
	"			-400 450 moveto 400 450 lineto stroke",
	"		} def",
	"",
	"		% 2rest",
	"		/L {",
	"			lwid setlinewidth",
	"			-750 0 moveto 750 0 lineto stroke",
	"			300 setlinewidth",
	"			-400 150 moveto 400 150 lineto stroke",
	"		} def",
	"",
	"		% 4rest",
	"		/M {",
	"			newpath",
	"			cor3x cor3y halflwid add moveto",
	"			%-400 -200 -450 -650 50 -950 lwid add curveto",
	"			-450 -50 -450 -650 50 -950 lwid add curveto",
	"			-150 -650 -100 -250 cor3x cor3y halflwid sub curveto",
	"			fill",
	"",
	"			cor1x cor1y moveto cor1x 200 sub cor1y 200 add lineto",
	"			cor2x cor2y lineto cor2x 200 add cor2y 200 sub lineto",
	"			fill",
	"",
	"			lwid setlinewidth",
	"			topx topy moveto cor1x cor1y lineto stroke",
	"			cor2x cor2y moveto cor3x cor3y lineto stroke",
	"		} def",
	"",
	"		% 8rest",
	"		/N {",
	"			0 0 0 -600 do_shortrest",
	"		} def",
	"",
	"		% 16rest",
	"		/O {",
	"			1 1 100 -1200 do_shortrest",
	"		} def",
	"",
	"		% 32rest",
	"		/P {",
	"			2 1 0 -1800 do_shortrest",
	"		} def",
	"",
	"		% 64rest",
	"		/Q {",
	"			3 2 -80 -2100 do_shortrest",
	"		} def",
	"",
	"		% 128rest",
	"		/R {",
	"			4 2 -150 -2700 do_shortrest",
	"		} def",
	"",
	"		% 256rest",
	"		/S {",
	"			5 3 -280 -3300 do_shortrest",
	"		} def",
	"",
	"		% dot",
	"		/T {",
	"			newpath",
	"			0 0 120 0 360 arc fill",
	"		} def",
	"",
	"		% nat",
	"		/U {",
	"			% fill crossbars so that we can do parallelograms",
	"			-235 -470 moveto -235 -270 lineto",
	"			235 -130 lineto 235 -330 lineto fill",
	"			-235 130 moveto -235 330 lineto",
	"			235 470 lineto 235 270 lineto fill",
	"",
	"			% vertical strokes",
	"			lwid setlinewidth",
	"			-200 -380 moveto -200 850 lineto stroke",
	"			200 -850 moveto 200 380 lineto stroke",
	"		} def",
	"",
	"		% sharp",
	"		/V {",
	"			% fill crossbars so that we can do parallelograms",
	"			-325 -480 moveto -325 -280 lineto",
	"			325 -120 lineto 325 -320 lineto fill",
	"			-325 120 moveto -325 320 lineto",
	"			325 480 lineto 325 280 lineto fill",
	"",
	"			% vertical strokes",
	"			lwid setlinewidth",
	"			-150 -930 moveto -150 880 lineto stroke",
	"			150 -880 moveto 150 930 lineto stroke",
	"		} def",
	"",
	"		% flat",
	"		/W {",
	"			do_flat		%do a flat",
	"		} def",
	"",
	"		% dblsharp",
	"		/X {",
	"			gsave",
	"			0 1 3 {		%loop once for each of 4 sticks",
	"				pop	%we don't need the loop variable",
	"				0 off neg moveto",
	"				outbendbig outbendsmall lineto",
	"				inbendbig inbendsmall lineto",
	"				limit limit lineto",
	"				inbendsmall inbendbig lineto",
	"				outbendsmall outbendbig lineto",
	"				off neg 0 lineto",
	"				fill",
	"				-90 rotate",
	"			} for",
	"			grestore",
	"		} def",
	"",
	"		% dblflat",
	"		/Y {",
	"			-290 580 290 {	%loop once for each flat",
	"",
	"				gsave",
	"				1 setlinewidth",
	"				0 translate	%translate left/right (loop var)",
	"				do_flat		%do a flat",
	"				grestore",
	"",
	"			} for",
	"		} def",
	"",
	"		% xnote",
	"		/Z {",
	"			gsave",
	"			1.15 1 scale 120 setlinewidth 1 setlinecap	%round",
	"			-300 -300 moveto 300 300 lineto stroke",
	"			-300 300 moveto 300 -300 lineto stroke",
	"			grestore",
	"		} def",
	"",
	"		% dwhdiamond",
	"		/a {",
	"			do_diamond	%do a diamond",
	"			lwid setlinewidth",
	"			-420 -600 moveto -420 600 lineto stroke",
	"			420 -600 moveto 420 600 lineto stroke",
	"		} def",
	"",
	"		% diamond",
	"		/b {",
	"			do_diamond	%do a diamond",
	"		} def",
	"",
	"		% filldiamond",
	"		/c {",
	"			420 0 moveto 0 300 lineto",
	"			-420 0 lineto 0 -300 lineto fill",
	"		} def",
	"",
	"		% up2n",
	"		/d {",
	"			lwid setlinewidth",
	"			380 0 moveto 380 2100 lineto stroke",
	"			do_2n		%do a half note",
	"		} def",
	"",
	"		% dn2n",
	"		/e {",
	"			lwid setlinewidth",
	"			-380 0 moveto -380 -2100 lineto stroke",
	"			do_2n		%do a half note",
	"		} def",
	"",
	"		% up4n",
	"		/f {",
	"			do_4n		%do a quarter note head",
	"			lwid setlinewidth",
	"			370 0 moveto 370 2100 lineto stroke",
	"		} def",
	"",
	"		% dn4n",
	"		/g {",
	"			do_4n		%do a quarter note head",
	"			lwid setlinewidth",
	"			-370 0 moveto -370 -2100 lineto stroke",
	"		} def",
	"",
	"		% up8n",
	"		/h {",
	"			gsave",
	"			-330 0 translate	% half a flag width",
	"			do_4n		%do a quarter note head",
	"			lwid setlinewidth",
	"			370 0 moveto 370 2100 lineto stroke",
	"			670 2100 translate",
	"			1 -1 scale	%reflect across X axis",
	"			do_upflag		%do an upflag",
	"			grestore",
	"		} def",
	"",
	"		% dn8n",
	"		/i {",
	"			do_4n		%do a quarter note head",
	"			lwid setlinewidth",
	"			-370 0 moveto -370 -2100 lineto stroke",
	"			gsave",
	"			-70 -2100 translate",
	"			do_upflag		%do an upflag",
	"			grestore",
	"		} def",
	"",
	"		% up16n",
	"		/j {",
	"			2 do_upshortnote",
	"		} def",
	"",
	"		% dn16n",
	"		/k {",
	"			2 do_dnshortnote",
	"		} def",
	"",
	"		% up32n",
	"		/l {",
	"			3 do_upshortnote",
	"		} def",
	"",
	"		% dn32n",
	"		/m {",
	"			3 do_dnshortnote",
	"		} def",
	"",
	"		% up64n",
	"		/n {",
	"			4 do_upshortnote",
	"		} def",
	"",
	"		% dn64n",
	"		/o {",
	"			4 do_dnshortnote",
	"		} def",
	"",
	"		% up128n",
	"		/p {",
	"			5 do_upshortnote",
	"		} def",
	"",
	"		% dn128n",
	"		/q {",
	"			5 do_dnshortnote",
	"		} def",
	"",
	"		% up256n",
	"		/r {",
	"			6 do_upshortnote",
	"		} def",
	"",
	"		% dn256n",
	"		/s {",
	"			6 do_dnshortnote",
	"		} def",
	"",
	"		% com",
	"		/t {",
	"			do_com		%do a common time symbol",
	"		} def",
	"",
	"		% cut",
	"		/u {",
	"			do_com		%do a common time symbol",
	"			lwid setlinewidth",
	"			0 -900 moveto 0 900 lineto stroke",
	"		} def",
	"",
	"		% begped",
	"		/v {",
	"			lwid setlinewidth",
	"			-200 600 moveto -200 0 lineto 200 0 lineto stroke",
	"		} def",
	"",
	"		% pedal",
	"		/w {",
	"			lwid setlinewidth",
	"			-500 0 moveto -450 0 lineto 0 600 lineto",
	"			450 0 lineto 500 0 lineto stroke",
	"		} def",
	"",
	"		% endped",
	"		/x {",
	"			lwid setlinewidth",
	"			200 600 moveto 200 0 lineto -200 0 lineto stroke",
	"		} def",
	"",
	"		% dnbow",
	"		/y {",
	"			lwid setlinewidth",
	"			-350 0 moveto -350 900 lineto stroke",
	"			350 0 moveto 350 900 lineto stroke",
	"			200 setlinewidth",
	"			-350 800 moveto 350 800 lineto stroke",
	"		} def",
	"",
	"		% upbow",
	"		/z {",
	"			lwid setlinewidth",
	"			-300 900 moveto 0 0 lineto 300 900 lineto stroke",
	"		} def",
	"",
	"		% wedge",
	"		/one {",
	"			0 0 moveto -150 500 lineto 150 500 lineto fill",
	"		} def",
	"",
	"		% uwedge",
	"		/two {",
	"			-150 0 moveto 150 0 lineto 0 500 lineto fill",
	"		} def",
	"",
	"		% ferm",
	"		/three {",
	"			newpath",
	"			do_ferm		%do a right side up fermata",
	"		} def",
	"",
	"		% uferm",
	"		/four {",
	"			newpath",
	"			gsave",
	"			0 270 lwid sub 800 add translate %baseline at bottom",
	"			180 rotate			%upside down",
	"			do_ferm		%do a right side up fermata",
	"			grestore",
	"		} def",
	"",
	"		% sign",
	"		/five {",
	"			gsave",
	"			%do upper left curved part, upper right dot;",
	"			%then rotate 180 to do other half",
	"			0 1 1 {",
	"				pop	%we don't need the loop variable",
	"				0 100 moveto		%inner boundary",
	"				-1000 300 -400 750 -200 700 curveto",
	"				-200 800 lineto		%outer boundary",
	"				-550 900 -1100 100 0 -100 curveto",
	"				fill",
	"				%dot at end of curve",
	"				-200 700 100 0 360 arc fill",
	"				%dot in upper right quadrant",
	"				500 200 70 0 360 arc fill",
	"				180 rotate",
	"			} for",
	"			grestore",
	"",
	"			%slash through middle",
	"			lwid setlinewidth",
	"			-400 -800 moveto 400 800 lineto stroke",
	"		} def",
	"",
	"		% coda",
	"		/six {",
	"			newpath",
	"			gsave",
	"			0.6 1 scale",
	"			0 0 550 0 360 arc	%outside boundary",
	"			1 0.6 div 1 scale	%back to original",
	"			0.9 1 scale",
	"			0 0 650 0 360 arc	%inside boundary",
	"			eofill",
	"			grestore",
	"			lwid setlinewidth",
	"			0 -850 moveto 0 850 lineto stroke",
	"			-800 0 moveto 800 0 lineto stroke",
	"		} def",
	"",
	"		% mor",
	"		/seven {",
	"			do_mor		%do a mordent",
	"		} def",
	"",
	"		% invmor",
	"		/eight {",
	"			do_mor		%do a mordent",
	"			lwid setlinewidth",
	"			0 -450 moveto 0 450 lineto stroke",
	"		} def",
	"",
	"		% turn",
	"		/nine {",
	"			do_turn		%do a turn",
	"		} def",
	"",
	"		% invturn",
	"		/zero {",
	"			gsave",
	"			1 -1 scale	%reflect across X axis",
	"			do_turn		%do a turn",
	"			grestore",
	"		} def",
	"",
	"		% acc_gt",
	"		/numbersign {",
	"			lwid setlinewidth",
	"			-500 300 moveto 500 0 lineto -500 -300 lineto stroke",
	"		} def",
	"",
	"		% acc_hat",
	"		/dollar {",
	"			newpath",
	"			-365 0 moveto 0 860 lineto 365 0 lineto",
	"			150 0 lineto -75 530 lineto -300 0 lineto fill",
	"		} def",
	"",
	"		% acc_uhat",
	"		/quotedbl {",
	"			newpath",
	"			365 860 moveto 0 0 lineto -365 860 lineto",
	"			-150 860 lineto 75 330 lineto 300 860 lineto fill",
	"		} def",
	"",
	"		% tr",
	"		/asterisk {",
	"			%vertical bar of t",
	"			-350 1000 moveto -550 200 lineto",
	"			-612.5 -50 -212.5 -50 -160 200 curveto",
	"			-230 200 lineto",
	"			-300 50 -420 50 -400 200 curveto",
	"			-200 1000 lineto fill",
	"",
	"			%crossbar of t and vertical bar of r",
	"			-700 600 moveto -160 600 lineto",
	"			20 600 30 520 60 440 curveto",
	"			-50 0 lineto 70 0 lineto 180 440 lineto",
	"			190 480 100 670 -150 670 curveto",
	"			-690 670 lineto fill",
	"",
	"			%horizontal curve of r",
	"			100 480 moveto",
	"			300 630 450 700 650 550 curveto",
	"			560 480 lineto",
	"			450 630 300 560 100 390 curveto",
	"			fill",
	"",
	"			%knob at end of r",
	"			600 460 100 0 360 arc fill",
	"		} def",
	"",
	"		% leg",
	"		/comma {",
	"			100 setlinewidth",
	"			-400 0 moveto 400 0 lineto stroke",
	"		} def",
	"",
	"		% rr",
	"		/hyphen {",
	"			100 setlinewidth",
	"			-400 0 moveto 0 1000 lineto stroke",
	"			0 0 moveto 400 1000 lineto stroke",
	"		} def",
	"",
	"		% measrpt",
	"		/period {",
	"			newpath -450 400 150 0 360 arc fill",
	"			newpath 450 -400 150 0 360 arc fill",
	"			200 setlinewidth",
	"			-550 -600 moveto 550 600 lineto stroke",
	"		} def",
	"",
	"		% copyright",
	"		/slash {",
	"			lwid setlinewidth",
	"			newpath 0 400 400 0 360 arc stroke",
	"			newpath 0 400 200 45 315 arc stroke",
	"		} def",
	"",
	"		% dim",
	"		/quoteleft {",
	"			50 setlinewidth",
	"			newpath 0 640 220 0 360 arc stroke",
	"		} def",
	"",
	"		% halfdim",
	"		/quoteright {",
	"			50 setlinewidth",
	"			newpath 0 640 220 0 360 arc stroke",
	"			newpath -340 300 moveto 340 980 lineto stroke",
	"		} def",
	"",
	"		% triangle",
	"		/asciicircum {",
	"			50 setlinewidth",
	"			newpath -340 -10 moveto 0 710 lineto",
	"			340 -10 lineto closepath stroke",
	"		} def",
	"",
	"		% qwhrest",
	"		/ampersand {",
	"			300 setlinewidth",
	"			0 -600 moveto 0 600 lineto stroke",
	"		} def",
	"",
	"		% ll1rest",
	"		/exclam {",
	"			310 setlinewidth",
	"			-400 455 moveto 400 450 lineto stroke",
	"		} def",
	"",
	"		% ll2rest",
	"		/at {",
	"			310 setlinewidth",
	"			-400 145 moveto 400 150 lineto stroke",
	"		} def",
	"	end",
	"",
	"	/BuildChar {",
	"",
	"		exch begin",
	"		Encoding exch get",
	"",
	"		dup",
	"		Mcbbox0 exch get",
	"		aload pop setcachedevice",
	"",
	"		CharStrings exch get",
	"		exec",
	"		end",
	"	} def",
	"end",
	"",
	"",
	"% Define another music character font, since there are too many to fit in one",
	"% font.  It works the same way as the first one.",
	"",
	"/mfont1 100 dict def",
	"mfont1 begin",
	"	/FontType 3 def",
	"	/FontMatrix [ .001 0 0 0.001 0 0 ] def",
	"	/FontBBox [ -2000 -4030 2000 4030 ] def",
	"	/FontName (Mfont1) def",
	"",
	"	% set up Encoding vector with standard names",
	"	/Encoding 256 array def",
	"	StandardEncoding Encoding copy",
	"	pop",
	"",
	"	%%%%% define routines that will be used by multiple characters %%%%%",
	"",
	"	/do_dwh_bars {",
	"		% the two bars surrounding a double whole note",
	"		lwid setlinewidth",
	"		-420 -600 moveto -420 600 lineto stroke",
	"		420 -600 moveto 420 600 lineto stroke",
	"	} def",
	"	/do_righttriangle {",
	"		newpath",
	"		420 270 moveto -420 270 lineto 350 -300 lineto 420 -300 lineto",
	"		350 150 moveto -140 150 lineto 350 -213 lineto",
	"		eofill",
	"	} def",
	"	/do_fillrighttriangle {",
	"		newpath",
	"		420 270 moveto -420 270 lineto 350 -300 lineto 420 -300 lineto",
	"		fill",
	"	} def",
	"	/do_rectangle {",
	"		newpath",
	"		420 270 moveto -420 270 lineto -420 -270 lineto 420 -270 lineto",
	"		350 150 moveto -350 150 lineto -350 -150 lineto 350 -150 lineto",
	"		eofill",
	"	} def",
	"	/do_isostriangle {",
	"		newpath",
	"		0 300 moveto -420 -270 lineto 420 -270 lineto",
	"		0 182 moveto -245 -150 lineto 245 -150 lineto",
	"		eofill",
	"	} def",
	"	/do_piewedge {",
	"		newpath",
	"		0 -300 moveto 0 -244 514 35 145 arc",
	"		0 -209 moveto 0 -244 394 43 137 arc",
	"		eofill",
	"	} def",
	"	/do_semicircle {",
	"		newpath",
	"		gsave",
	"		1 1.357 scale 420 199 moveto 0 199 420 180 360 arc",
	"		1 1.09 scale 350 111 moveto 0 199 350 194.1 345.9 arc",
	"		eofill",
	"		grestore",
	"	} def",
	"	/do_slashhead {",
	"		newpath",
	"		lwid setlinewidth",
	"		-620 -530 moveto -480 -670 lineto 620 530 lineto 480 670 lineto",
	"		closepath stroke",
	"	} def",
	"",
	"	% subsidiary dictionary of character definitions",
	"	/CharStrings 128 dict def",
	"	CharStrings begin",
	"",
	"		/.notdef {} def",
	"",
	"		% Here are the definitions of the characters.  A stepsize here",
	"		% is 300 units (assuming the character is drawn at its default",
	"		% size).",
	"",
	"		% dwhrighttriangle",
	"		/A {",
	"			do_righttriangle",
	"			do_dwh_bars",
	"		} def",
	"",
	"		% righttriangle",
	"		/B {",
	"			do_righttriangle",
	"		} def",
	"",
	"		% fillrighttriangle",
	"		/C {",
	"			newpath",
	"			420 270 moveto -420 270 lineto 350 -300 lineto",
	"			420 -300 lineto",
	"			fill",
	"		} def",
	"",
	"		% udwhrighttriangle",
	"		/D {",
	"			gsave",
	"			180 rotate",
	"			do_righttriangle",
	"			do_dwh_bars",
	"			grestore",
	"		} def",
	"",
	"		% urighttriangle",
	"		/E {",
	"			gsave",
	"			180 rotate",
	"			do_righttriangle",
	"			grestore",
	"		} def",
	"",
	"		% ufillrighttriangle",
	"		/F {",
	"			gsave",
	"			180 rotate",
	"			do_fillrighttriangle",
	"			grestore",
	"		} def",
	"",
	"		% dwhrectangle",
	"		/G {",
	"			do_rectangle",
	"			do_dwh_bars",
	"		} def",
	"",
	"		% rectangle",
	"		/H {",
	"			do_rectangle",
	"		} def",
	"",
	"		% fillrectangle",
	"		/I {",
	"			newpath",
	"			420 270 moveto -420 270 lineto -420 -270 lineto",
	"			420 -270 lineto",
	"			fill",
	"		} def",
	"",
	"		% dwhisostriangle",
	"		/J {",
	"			do_isostriangle",
	"			do_dwh_bars",
	"		} def",
	"",
	"		% isostriangle",
	"		/K {",
	"			do_isostriangle",
	"		} def",
	"",
	"		% fillisostriangle",
	"		/L {",
	"			newpath",
	"			0 300 moveto -420 -270 lineto 420 -270 lineto",
	"			fill",
	"		} def",
	"",
	"		% dwhpiewedge",
	"		/M {",
	"			do_piewedge",
	"			do_dwh_bars",
	"		} def",
	"",
	"		% piewedge",
	"		/N {",
	"			do_piewedge",
	"		} def",
	"",
	"		% fillpiewedge",
	"		/O {",
	"			newpath",
	"			0 -300 moveto 0 -244 514 35 145 arc",
	"			fill",
	"		} def",
	"",
	"		% dwhsemicircle",
	"		/P {",
	"			do_semicircle",
	"			do_dwh_bars",
	"		} def",
	"",
	"		% semicircle",
	"		/Q {",
	"			do_semicircle",
	"		} def",
	"",
	"		% fillsemicircle",
	"		/R {",
	"			newpath",
	"			gsave",
	"			1 570 420 div scale",
	"			420 199 moveto 0 199 420 180 360 arc",
	"			fill",
	"			grestore",
	"		} def",
	"",
	"		% dwhslashhead",
	"		/S {",
	"			do_slashhead",
	"			lwid setlinewidth",
	"			-650 -600 moveto -650 600 lineto stroke",
	"			650 -600 moveto 650 600 lineto stroke",
	"		} def",
	"",
	"		% slashhead",
	"		/T {",
	"			do_slashhead",
	"		} def",
	"",
	"		% fillslashhead",
	"		/U {",
	"			newpath",
	"			200 setlinewidth",
	"			-550 -600 moveto 550 600 lineto stroke",
	"		} def",
	"",
	"		% blankhead",
	"		/V {",
	"			%print nothing",
	"		} def",
	"	end",
	"",
	"	/BuildChar {",
	"",
	"		exch begin",
	"		Encoding exch get",
	"",
	"		dup",
	"		Mcbbox1 exch get",
	"		aload pop setcachedevice",
	"",
	"		CharStrings exch get",
	"		exec",
	"		end",
	"	} def",
	"end",
	"",
	"",
	"% General routines for printing any music character, invoked by each music",
	"% character's specific routine below.  The scaling factor (default 1) needs",
	"% to be multiplied by 10 to get the actual size.  These routines restore the",
	"% preexisting current font when they are done.",
	"",
	"/printmchar0 {",
	"	gsave",
	"	/musicchar exch def",
	"	/Mfont0 findfont exch 10 mul scalefont setfont moveto ",
	"	musicchar show",
	"	grestore",
	"} def",
	"/printmchar1 {",
	"	gsave",
	"	/musicchar exch def",
	"	/Mfont1 findfont exch 10 mul scalefont setfont moveto ",
	"	musicchar show",
	"	grestore",
	"} def",
	"",
	"% Define each music character name to be a routine that prints the character.",
	"% Each character is to be invoked as in this example:",
	"%	100 200 1 gclef		% at (100, 200), scale to default size & print",
	"",
	"/gclef			{ (A) printmchar0 } def",
	"/fclef			{ (B) printmchar0 } def",
	"/cclef			{ (C) printmchar0 } def",
	"/dblwhole		{ (D) printmchar0 } def",
	"/1n			{ (E) printmchar0 } def",
	"/2n			{ (F) printmchar0 } def",
	"/4n			{ (G) printmchar0 } def",
	"/upflag			{ (H) printmchar0 } def",
	"/dnflag			{ (I) printmchar0 } def",
	"/dwhrest		{ (J) printmchar0 } def",
	"/1rest			{ (K) printmchar0 } def",
	"/2rest			{ (L) printmchar0 } def",
	"/4rest			{ (M) printmchar0 } def",
	"/8rest			{ (N) printmchar0 } def",
	"/16rest			{ (O) printmchar0 } def",
	"/32rest			{ (P) printmchar0 } def",
	"/64rest			{ (Q) printmchar0 } def",
	"/128rest		{ (R) printmchar0 } def",
	"/256rest		{ (S) printmchar0 } def",
	"/dot			{ (T) printmchar0 } def",
	"/nat			{ (U) printmchar0 } def",
	"/sharp			{ (V) printmchar0 } def",
	"/flat			{ (W) printmchar0 } def",
	"/dblsharp		{ (X) printmchar0 } def",
	"/dblflat		{ (Y) printmchar0 } def",
	"/xnote			{ (Z) printmchar0 } def",
	"/dwhdiamond		{ (a) printmchar0 } def",
	"/diamond		{ (b) printmchar0 } def",
	"/filldiamond		{ (c) printmchar0 } def",
	"/up2n			{ (d) printmchar0 } def",
	"/dn2n			{ (e) printmchar0 } def",
	"/up4n			{ (f) printmchar0 } def",
	"/dn4n			{ (g) printmchar0 } def",
	"/up8n			{ (h) printmchar0 } def",
	"/dn8n			{ (i) printmchar0 } def",
	"/up16n			{ (j) printmchar0 } def",
	"/dn16n			{ (k) printmchar0 } def",
	"/up32n			{ (l) printmchar0 } def",
	"/dn32n			{ (m) printmchar0 } def",
	"/up64n			{ (n) printmchar0 } def",
	"/dn64n			{ (o) printmchar0 } def",
	"/up128n			{ (p) printmchar0 } def",
	"/dn128n			{ (q) printmchar0 } def",
	"/up256n			{ (r) printmchar0 } def",
	"/dn256n			{ (s) printmchar0 } def",
	"/com			{ (t) printmchar0 } def",
	"/cut			{ (u) printmchar0 } def",
	"/begped			{ (v) printmchar0 } def",
	"/pedal			{ (w) printmchar0 } def",
	"/endped			{ (x) printmchar0 } def",
	"/dnbow			{ (y) printmchar0 } def",
	"/upbow			{ (z) printmchar0 } def",
	"/wedge			{ (1) printmchar0 } def",
	"/uwedge			{ (2) printmchar0 } def",
	"/ferm			{ (3) printmchar0 } def",
	"/uferm			{ (4) printmchar0 } def",
	"/sign			{ (5) printmchar0 } def",
	"/coda			{ (6) printmchar0 } def",
	"/mor			{ (7) printmchar0 } def",
	"/invmor			{ (8) printmchar0 } def",
	"/turn			{ (9) printmchar0 } def",
	"/invturn		{ (0) printmchar0 } def",
	"/acc_gt			{ (#) printmchar0 } def",
	"/acc_hat		{ ($) printmchar0 } def",
	"/acc_uhat		{ (\") printmchar0 } def",
	"/tr			{ (*) printmchar0 } def",
	"/leg			{ (,) printmchar0 } def",
	"/rr			{ (-) printmchar0 } def",
	"/measrpt		{ (.) printmchar0 } def",
	"/copyright		{ (/) printmchar0 } def",
	"/dim			{ (`) printmchar0 } def",
	"/halfdim		{ (') printmchar0 } def",
	"/triangle		{ (^) printmchar0 } def",
	"/qwhrest		{ (&) printmchar0 } def",
	"/ll1rest		{ (!) printmchar0 } def",
	"/ll2rest		{ (@) printmchar0 } def",
	"/dwhrighttriangle	{ (A) printmchar1 } def",
	"/righttriangle		{ (B) printmchar1 } def",
	"/fillrighttriangle	{ (C) printmchar1 } def",
	"/udwhrighttriangle	{ (D) printmchar1 } def",
	"/urighttriangle		{ (E) printmchar1 } def",
	"/ufillrighttriangle	{ (F) printmchar1 } def",
	"/dwhrectangle		{ (G) printmchar1 } def",
	"/rectangle		{ (H) printmchar1 } def",
	"/fillrectangle		{ (I) printmchar1 } def",
	"/dwhisostriangle	{ (J) printmchar1 } def",
	"/isostriangle		{ (K) printmchar1 } def",
	"/fillisostriangle	{ (L) printmchar1 } def",
	"/dwhpiewedge		{ (M) printmchar1 } def",
	"/piewedge		{ (N) printmchar1 } def",
	"/fillpiewedge		{ (O) printmchar1 } def",
	"/dwhsemicircle		{ (P) printmchar1 } def",
	"/semicircle		{ (Q) printmchar1 } def",
	"/fillsemicircle		{ (R) printmchar1 } def",
	"/dwhslashhead		{ (S) printmchar1 } def",
	"/slashhead		{ (T) printmchar1 } def",
	"/fillslashhead		{ (U) printmchar1 } def",
	"/blankhead		{ (V) printmchar1 } def",
	"",
	"",
	"% Define routines for Mup output other than music characters.",
	"",
	"/stepsize 3 def	   % define a step size as 3 points (at default magnification)",
	"",
	"% x1 y1 x2 lines dist staffscale staff",
	"%		draw a staff starting at x1, y1 and extending to x2 with \"lines\"",
	"%		lines, 2*dist*stepsize apart, scaled by staffscale",
	"/staff {",
	"	/staffscale exch def",
	"	/dist exch def",
	"	/lines exch def",
	"	/x2 exch def",
	"	/y1 exch def",
	"	/x1 exch def",
	"	0.7 staffscale mul sb setlinewidth",
	"	1 lines sub  2  lines 1 sub {	% loop from bottom line to top line",
	"		dup stepsize mul staffscale mul dist mul y1 add x1 exch moveto",
	"		stepsize mul staffscale mul dist mul y1 add x2 exch lineto stroke",
	"	} for",
	"} def",
	"",
	"% x y1 y2 bracket	draw a bracket; y1 is the top",
	"/bracket {",
	"	/y2 exch def",
	"	/y1 exch def",
	"	/x exch def",
	"	gsave",
	"	3 setlinewidth",
	"	x 2 sub y1 1 add moveto",
	"	x 2 sub y2 1 sub lineto",
	"	stroke",
	"	x 2 sub y1 1 add moveto",
	"	x 1 sub y1 1 add   x 3 add y1 1 add   x 5 add y1 6 add   curveto",
	"	x 6 add y1 5 add lineto",
	"	x 5 add y1 2 add   x 1 add y1 2 sub   x 2 sub y1 2 sub   curveto",
	"	fill",
	"	x 2 sub y2 1 sub moveto",
	"	x 1 sub y2 1 sub   x 3 add y2 1 sub   x 5 add y2 6 sub   curveto",
	"	x 6 add y2 5 sub lineto",
	"	x 5 add y2 2 sub   x 1 add y2 2 add   x 2 sub y2 2 add   curveto",
	"	fill",
	"	grestore",
	"} def",
	"",
	"% x y1 y2 right repeatbracket	draw a bracket for a repeat; y1 is the top,",
	"%				right==1 means facing to the right",
	"/repeatbracket {",
	"	/right exch def",
	"	/y2 exch def",
	"	/y1 exch def",
	"	/x exch def",
	"	gsave",
	"	right 0 eq {",
	"		x y1 y2 add 2 div translate",
	"		180 rotate",
	"		0 x sub 0 y1 y2 add 2 div sub translate",
	"	} if",
	"	x 4.5 sub y1 1 add moveto",
	"	x 0 sub y1 1 add   x 2 add y1 1 add   x 6 add y1 5 add   curveto",
	"	x 6 add y1 4 add lineto",
	"	x 6 add y1 2 add   x 1 add y1 2 sub   x 4.5 sub y1 1.5 sub   curveto",
	"	fill",
	"	x 4.5 sub y2 1 sub moveto",
	"	x 0 sub y2 1 sub   x 2 add y2 1 sub   x 6 add y2 5 sub   curveto",
	"	x 6 add y2 4 sub lineto",
	"	x 6 add y2 2 sub   x 1 add y2 2 add   x 4.5 sub y2 1.5 add   curveto",
	"	fill",
	"	grestore",
	"} def",
	"",
	"% x y1 y2 brace		draw a brace; y1 is the top",
	"/brace {",
	"	/y2 exch def",
	"	/y1 exch def",
	"	/x exch def",
	"	gsave",
	"	x 6 sub y1 y2 add 2 div translate",
	"	/topy y1 y2 sub 2 div 1 sub def",
	"	0.667 1 scale",
	"	0 1 1 {",
	"		pop",
	"		%0 topy moveto 0 0 lineto stroke",
	"		0 0 moveto",
	"		16 topy 0.2 mul   -11 topy 0.6 mul   8 topy   curveto",
	"		8.7 topy lineto",
	"		-7 topy 0.7 mul   20 topy 0.3 mul   1 0   curveto",
	"		fill",
	"		1 -1 scale	% flip to do bottom half",
	"	} for",
	"	grestore",
	"} def",
	"",
	"% endx endy wavy staffscale	draw a wavy line from current point to here,",
	"%				scaled by staffscale",
	"/wavy {",
	"	/staffscale exch def",
	"	/endy exch def		% define the end point of the line",
	"	/endx exch def",
	"	currentpoint		% line starts at current point",
	"	/begy exch def		% define the beginning point of the line",
	"	/begx exch def",
	"	gsave",
	"	/dx endx begx sub def	% find delta x and delta y",
	"	/dy endy begy sub def",
	"	/r dx dx mul dy dy mul add sqrt def	% hypotenuse",
	"	/theta dy dx atan def			% angle with positive x axis",
	"	begx begy translate	% change axes so that we can draw the line",
	"	theta rotate		%   from (0, 0) to (r, 0)",
	"	staffscale staffscale scale	% scale everything by staffscale",
	"	/scaledr r staffscale div def	% but scale r in reverse to keep length",
	"",
	"	% Each outer loop draws one cycle of the squiggle.  It continues until",
	"	% we are at or beyond the desired end point.",
	"	0 0 moveto",
	"	0 6 scaledr {",
	"		gsave",
	"		% first loop draws left half of squiggle; second draws right",
	"		0 1 1 {",
	"			0.0 0.4 moveto",
	"			2.0 1.9 3.4 2.3 3.9 0.0 curveto",
	"			2.1 0.0 lineto",
	"			1.9 0.8 1.4 0.7 0.0 -0.4 curveto",
	"			fill",
	"			pop 180 rotate -6 0 translate",
	"		} for",
	"		grestore",
	"",
	"		pop 6 0 translate	% shift axes right one squiggle",
	"	} for",
	"",
	"	grestore",
	"} def",
	"",
	"% x y space frets fretno numvert curvel curver [ f1 f2 f3 ... ] grid",
	"%				print a guitar grid diagram",
	"/grid {",
	"	/grid_positions exch def % 0=\"o\", -1=\"x\", -2=nothing, positive=dot",
	"	/curver exch def	% right string for curve, 0 if none",
	"	/curvel exch def	% left string for curve, 0 if none",
	"	/numvert exch def	% vertical position to print fretno, 0 if none",
	"	/fretno exch def	% fret no. to print at right, 0 if none",
	"	/frets exch def		% number of fret lines",
	"	/space exch def		% points between two neighboring lines",
	"	/y exch def		% y coord of top fret line",
	"	/x exch def		% x coord of left strings",
	"",
	"	gsave",
	"	/strings grid_positions length def	% number of strings",
	"	/lmarky 0.4 space mul y add def		% lowest Y of a \"o\" or \"x\"",
	"	space 10 div setlinewidth",
	"	2 setlinecap",
	"",
	"	% draw the lines of the grid",
	"	0  1  strings 1 sub {	% loop from left string to right string",
	"		dup space mul x add y moveto",
	"		space mul x add frets 1 sub space mul y exch sub lineto stroke",
	"	} for",
	"	0  -1  1 frets sub {	% loop from top fret (nut) to bottom fret",
	"		dup space mul y add x exch moveto",
	"		space mul y add strings 1 sub space mul x add exch lineto stroke",
	"	} for",
	"",
	"	% draw the curved line if there is one",
	"	curvel 0 gt {",
	"		% within strings curvel to curver, find smallest positive fret",
	"		/minfret 1000 def",
	"		curvel 1 curver {",
	"			/strno exch def",
	"			/grid_p grid_positions strno 1 sub get def",
	"			grid_p 0 gt grid_p minfret lt and {",
	"				/minfret grid_p def",
	"			} if",
	"		} for",
	"",
	"		% if curve goes above top fret, other marks must be higher",
	"		minfret 1 eq {",
	"			/hmarky 1.2 space mul y add def",
	"		} {",
	"			/hmarky lmarky def",
	"		} ifelse",
	"",
	"		/strdiff curver curvel sub def",
	"		space 8 div setlinewidth",
	"",
	"		% set endpoint coords of curve; higher if curve is short",
	"		/curvex1 curvel 1 sub space mul x add def",
	"		/curvex2 curver 1 sub space mul x add def",
	"		/curvey 1 minfret sub space mul y add def",
	"		strdiff 3 lt {",
	"			/curvey 0.2 strdiff div space mul curvey add def",
	"		} if",
	"",
	"		% move to left end, set other points, draw curve",
	"		curvex1 curvey moveto",
	"",
	"		curvex1 curvex2 curvex1 sub 3 div add",
	"		curvey space 0.4 strdiff sqrt mul mul add",
	"",
	"		curvex2 curvex2 curvex1 sub 3 div sub",
	"		curvey space 0.4 strdiff sqrt mul mul add",
	"",
	"		curvex2 curvey curveto stroke",
	"	} if",
	"",
	"	space 10 div setlinewidth",
	"",
	"	% draw dots and x and o marks",
	"	0  1  strings 1 sub {	% loop from left string to right string",
	"		/strno exch def	% first string is 0",
	"		/grid_p grid_positions strno get def",
	"		/strx strno space mul x add def",
	"",
	"		% set Y of mark higher if curved line covers this string",
	"		strno 1 add curvel ge  strno 1 add curver le  and {",
	"			/marky hmarky def",
	"		} {",
	"			/marky lmarky def",
	"		} ifelse",
	"",
	"		grid_p -1 eq {		% draw an X above the string",
	"			/xhwid space 3 div def",
	"			strx xhwid sub marky xhwid sub moveto",
	"			strx xhwid add marky xhwid add lineto stroke",
	"			strx xhwid sub marky xhwid add moveto",
	"			strx xhwid add marky xhwid sub lineto stroke",
	"		} if",
	"		grid_p 0 eq {		% draw a circle above the string",
	"			strx marky space 0.3 mul 0 360 arc stroke",
	"		} if",
	"		grid_p 1 ge {		% draw a dot by the proper fret",
	"			strx y grid_p space mul sub space 3 div add",
	"			space 3 div 0 360 arc fill",
	"		} if",
	"	} for",
	"",
	"	% print \"X fr\" if requested",
	"	fretno 0 gt {",
	"		/Palatino-Roman findfont space 1.9 mul scalefont setfont",
	"		x strings 0.5 sub space mul add",
	"		y space numvert 0.3 add mul sub moveto",
	"		fretno 2 string cvs show ( fr) show",
	"	} if",
	"	grestore",
	"} def",
	"",
	"% x1 y1 x2 y2 whitebox		draw a white rectangle with opposite",
	"%				corners of (x1,y1) and (x2,y2)",
	"/whitebox {",
	"	/y2 exch def",
	"	/x2 exch def",
	"	/y1 exch def",
	"	/x1 exch def",
	"	1.0 setgray",
	"	newpath",
	"	x1 y1 moveto",
	"	x1 y2 lineto",
	"	x2 y2 lineto",
	"	x2 y1 lineto",
	"	closepath",
	"	fill",
	"	stroke",
	"	0.0 setgray",
	"} def",
	"",
	"",
	"/LineNum 0 def",
	"/InputFile (unknown) def",
	"",
	"% n linenum",
	"/linenum {",
	"	/LineNum exch def",
	"} def",
	"",
	"% (inputfilename) inputfile",
	"/inputfile {",
	"	/InputFile exch def",
	"} def",
	"",
	"% find size of Encoding and make a dictionary",
	"% that size for bounding box information",
	"mfont0 begin",
	"/dictsize Encoding length def",
	"mfont0 /Mcbbox0 dictsize dict put",
	"",
	"% temporarily redefine printmchar0 to get code",
	"5 dict begin",
	"/printmchar0 { {} forall } def",
	"",
	"Mcbbox0 Encoding gclef get [ 1790.0 0 -915.0 -1605.0 865.0 3015.0 ] put",
	"Mcbbox0 Encoding fclef get [ 1840.0 0 -1015.0 -1705.0 815.0 655.0 ] put",
	"Mcbbox0 Encoding cclef get [ 1540.0 0 -765.0 -1245.0 765.0 1255.0 ] put",
	"Mcbbox0 Encoding dblwhole get [ 1090.0 0 -535.0 -605.0 545.0 615.0 ] put",
	"Mcbbox0 Encoding 1n get [ 1080.0 0 -535.0 -335.0 535.0 345.0 ] put",
	"Mcbbox0 Encoding 2n get [ 880.0 0 -435.0 -345.0 435.0 355.0 ] put",
	"Mcbbox0 Encoding 4n get [ 840.0 0 -415.0 -335.0 415.0 345.0 ] put",
	"Mcbbox0 Encoding upflag get [ 640.0 0 -335.0 -5.0 295.0 1715.0 ] put",
	"Mcbbox0 Encoding dnflag get [ 640.0 0 -335.0 -1705.0 295.0 15.0 ] put",
	"Mcbbox0 Encoding qwhrest get [ 340.0 0 -165.0 -605.0 165.0 615.0 ] put",
	"Mcbbox0 Encoding dwhrest get [ 340.0 0 -165.0 -5.0 165.0 615.0 ] put",
	"Mcbbox0 Encoding 1rest get [ 1540.0 0 -765.0 -15.0 765.0 645.0 ] put",
	"Mcbbox0 Encoding 2rest get [ 1540.0 0 -765.0 -45.0 765.0 315.0 ] put",
	"Mcbbox0 Encoding 4rest get [ 650.0 0 -345.0 -885.0 295.0 995.0 ] put",
	"Mcbbox0 Encoding 8rest get [ 750.0 0 -305.0 -615.0 435.0 485.0 ] put",
	"Mcbbox0 Encoding 16rest get [ 830.0 0 -415.0 -1215.0 405.0 485.0 ] put",
	"Mcbbox0 Encoding 32rest get [ 940.0 0 -415.0 -1215.0 515.0 1085.0 ] put",
	"Mcbbox0 Encoding 64rest get [ 1040.0 0 -515.0 -1515.0 515.0 1085.0 ] put",
	"Mcbbox0 Encoding 128rest get [ 1140.0 0 -515.0 -1515.0 615.0 1685.0 ] put",
	"Mcbbox0 Encoding 256rest get [ 1250.0 0 -625.0 -2115.0 615.0 1685.0 ] put",
	"Mcbbox0 Encoding ll1rest get [ 840.0 0 -415.0 -15.0 415.0 625.0 ] put",
	"Mcbbox0 Encoding ll2rest get [ 840.0 0 -415.0 -15.0 415.0 325.0 ] put",
	"Mcbbox0 Encoding dot get [ 280.0 0 -135.0 -125.0 135.0 135.0 ] put",
	"Mcbbox0 Encoding nat get [ 520.0 0 -255.0 -855.0 255.0 865.0 ] put",
	"Mcbbox0 Encoding sharp get [ 700.0 0 -345.0 -935.0 345.0 945.0 ] put",
	"Mcbbox0 Encoding flat get [ 580.0 0 -295.0 -405.0 275.0 1115.0 ] put",
	"Mcbbox0 Encoding dblsharp get [ 720.0 0 -355.0 -345.0 355.0 355.0 ] put",
	"Mcbbox0 Encoding dblflat get [ 1160.0 0 -585.0 -405.0 565.0 1115.0 ] put",
	"Mcbbox0 Encoding xnote get [ 880.0 0 -435.0 -365.0 435.0 375.0 ] put",
	"Mcbbox0 Encoding dwhdiamond get [ 950.0 0 -465.0 -605.0 475.0 615.0 ] put",
	"Mcbbox0 Encoding diamond get [ 880.0 0 -435.0 -305.0 435.0 315.0 ] put",
	"Mcbbox0 Encoding filldiamond get [ 880.0 0 -435.0 -305.0 435.0 315.0 ] put",
	"Mcbbox0 Encoding up2n get [ 880.0 0 -435.0 -345.0 435.0 2115.0 ] put",
	"Mcbbox0 Encoding dn2n get [ 880.0 0 -435.0 -2105.0 435.0 355.0 ] put",
	"Mcbbox0 Encoding up4n get [ 850.0 0 -415.0 -335.0 425.0 2115.0 ] put",
	"Mcbbox0 Encoding dn4n get [ 840.0 0 -415.0 -2105.0 415.0 345.0 ] put",
	"Mcbbox0 Encoding com get [ 1100.0 0 -575.0 -645.0 515.0 655.0 ] put",
	"Mcbbox0 Encoding cut get [ 1100.0 0 -575.0 -905.0 515.0 915.0 ] put",
	"Mcbbox0 Encoding begped get [ 470.0 0 -245.0 -45.0 215.0 615.0 ] put",
	"Mcbbox0 Encoding pedal get [ 1040.0 0 -515.0 -45.0 515.0 675.0 ] put",
	"Mcbbox0 Encoding endped get [ 480.0 0 -215.0 -45.0 255.0 615.0 ] put",
	"Mcbbox0 Encoding dnbow get [ 810.0 0 -395.0 -5.0 405.0 915.0 ] put",
	"Mcbbox0 Encoding upbow get [ 720.0 0 -355.0 -115.0 355.0 925.0 ] put",
	"Mcbbox0 Encoding wedge get [ 340.0 0 -165.0 5.0 165.0 515.0 ] put",
	"Mcbbox0 Encoding uwedge get [ 340.0 0 -165.0 -5.0 165.0 505.0 ] put",
	"Mcbbox0 Encoding ferm get [ 1640.0 0 -815.0 -5.0 815.0 1015.0 ] put",
	"Mcbbox0 Encoding uferm get [ 1640.0 0 -815.0 -5.0 815.0 1015.0 ] put",
	"Mcbbox0 Encoding sign get [ 1340.0 0 -665.0 -825.0 665.0 835.0 ] put",
	"Mcbbox0 Encoding coda get [ 1640.0 0 -815.0 -855.0 815.0 865.0 ] put",
	"Mcbbox0 Encoding mor get [ 1320.0 0 -655.0 -285.0 655.0 295.0 ] put",
	"Mcbbox0 Encoding invmor get [ 1320.0 0 -655.0 -455.0 655.0 465.0 ] put",
	"Mcbbox0 Encoding turn get [ 1300.0 0 -645.0 -335.0 645.0 345.0 ] put",
	"Mcbbox0 Encoding invturn get [ 1300.0 0 -645.0 -335.0 645.0 345.0 ] put",
	"Mcbbox0 Encoding acc_gt get [ 1170.0 0 -525.0 -345.0 635.0 355.0 ] put",
	"Mcbbox0 Encoding acc_hat get [ 780.0 0 -385.0 -5.0 385.0 875.0 ] put",
	"Mcbbox0 Encoding acc_uhat get [ 780.0 0 -385.0 -5.0 385.0 875.0 ] put",
	"Mcbbox0 Encoding tr get [ 1440.0 0 -715.0 -5.0 715.0 1015.0 ] put",
	"Mcbbox0 Encoding leg get [ 840.0 0 -415.0 -55.0 415.0 65.0 ] put",
	"Mcbbox0 Encoding rr get [ 940.0 0 -465.0 -25.0 465.0 1035.0 ] put",
	"Mcbbox0 Encoding dim get [ 540.0 0 -265.0 -15.0 265.0 905.0 ] put",
	"Mcbbox0 Encoding halfdim get [ 760.0 0 -375.0 -15.0 375.0 1015.0 ] put",
	"Mcbbox0 Encoding triangle get [ 800.0 0 -395.0 -45.0 395.0 785.0 ] put",
	"Mcbbox0 Encoding measrpt get [ 1300.0 0 -645.0 -675.0 645.0 685.0 ] put",
	"Mcbbox0 Encoding copyright get [ 920.0 0 -455.0 -45.0 455.0 855.0 ] put",
	"Mcbbox0 Encoding up8n get [ 1390.0 0 -745.0 -335.0 635.0 2115.0 ] put",
	"Mcbbox0 Encoding dn8n get [ 840.0 0 -415.0 -2105.0 415.0 345.0 ] put",
	"Mcbbox0 Encoding up16n get [ 1390.0 0 -745.0 -335.0 635.0 2115.0 ] put",
	"Mcbbox0 Encoding dn16n get [ 840.0 0 -415.0 -2105.0 415.0 345.0 ] put",
	"Mcbbox0 Encoding up32n get [ 1390.0 0 -745.0 -335.0 635.0 2595.0 ] put",
	"Mcbbox0 Encoding dn32n get [ 840.0 0 -415.0 -2585.0 415.0 345.0 ] put",
	"Mcbbox0 Encoding up64n get [ 1390.0 0 -745.0 -335.0 635.0 3075.0 ] put",
	"Mcbbox0 Encoding dn64n get [ 840.0 0 -415.0 -3065.0 415.0 345.0 ] put",
	"Mcbbox0 Encoding up128n get [ 1390.0 0 -745.0 -335.0 635.0 3555.0 ] put",
	"Mcbbox0 Encoding dn128n get [ 840.0 0 -415.0 -3545.0 415.0 345.0 ] put",
	"Mcbbox0 Encoding up256n get [ 1390.0 0 -745.0 -335.0 635.0 3975.0 ] put",
	"Mcbbox0 Encoding dn256n get [ 840.0 0 -415.0 -3965.0 415.0 345.0 ] put",
	"",
	"end",
	"end",
	"",
	"/Mfont0 mfont0 definefont",
	"",
	"",
	"% find size of Encoding and make a dictionary",
	"% that size for bounding box information",
	"mfont1 begin",
	"/dictsize Encoding length def",
	"mfont1 /Mcbbox1 dictsize dict put",
	"",
	"% temporarily redefine printmchar1 to get code",
	"5 dict begin",
	"/printmchar1 { {} forall } def",
	"",
	"Mcbbox1 Encoding dwhrighttriangle get [ 950.0 0 -465.0 -605.0 475.0 615.0 ] put",
	"Mcbbox1 Encoding righttriangle get [ 880.0 0 -435.0 -305.0 435.0 285.0 ] put",
	"Mcbbox1 Encoding fillrighttriangle get [ 880.0 0 -435.0 -305.0 435.0 285.0 ] put",
	"Mcbbox1 Encoding udwhrighttriangle get [ 950.0 0 -465.0 -605.0 475.0 615.0 ] put",
	"Mcbbox1 Encoding urighttriangle get [ 880.0 0 -435.0 -275.0 435.0 315.0 ] put",
	"Mcbbox1 Encoding ufillrighttriangle get [ 880.0 0 -435.0 -275.0 435.0 315.0 ] put",
	"Mcbbox1 Encoding dwhrectangle get [ 950.0 0 -465.0 -605.0 475.0 615.0 ] put",
	"Mcbbox1 Encoding rectangle get [ 880.0 0 -435.0 -275.0 435.0 285.0 ] put",
	"Mcbbox1 Encoding fillrectangle get [ 880.0 0 -435.0 -275.0 435.0 285.0 ] put",
	"Mcbbox1 Encoding dwhisostriangle get [ 950.0 0 -465.0 -605.0 475.0 615.0 ] put",
	"Mcbbox1 Encoding isostriangle get [ 880.0 0 -435.0 -275.0 435.0 315.0 ] put",
	"Mcbbox1 Encoding fillisostriangle get [ 880.0 0 -435.0 -275.0 435.0 315.0 ] put",
	"Mcbbox1 Encoding dwhpiewedge get [ 950.0 0 -465.0 -605.0 475.0 615.0 ] put",
	"Mcbbox1 Encoding piewedge get [ 880.0 0 -435.0 -305.0 435.0 285.0 ] put",
	"Mcbbox1 Encoding fillpiewedge get [ 880.0 0 -435.0 -305.0 435.0 285.0 ] put",
	"Mcbbox1 Encoding dwhsemicircle get [ 950.0 0 -465.0 -605.0 475.0 615.0 ] put",
	"Mcbbox1 Encoding semicircle get [ 880.0 0 -435.0 -305.0 435.0 285.0 ] put",
	"Mcbbox1 Encoding fillsemicircle get [ 880.0 0 -435.0 -305.0 435.0 285.0 ] put",
	"Mcbbox1 Encoding dwhslashhead get [ 1410.0 0 -695.0 -725.0 705.0 735.0 ] put",
	"Mcbbox1 Encoding slashhead get [ 1380.0 0 -685.0 -725.0 685.0 735.0 ] put",
	"Mcbbox1 Encoding fillslashhead get [ 1300.0 0 -645.0 -675.0 645.0 685.0 ] put",
	"Mcbbox1 Encoding blankhead get [ 880.0 0 -435.0 -275.0 435.0 285.0 ] put",
	"",
	"end",
	"end",
	"",
	"/Mfont1 mfont1 definefont",
	"",
(char *) 0
};

/* generate the PostScript prolog */

void
ps_prolog()
{
	int line;

	for (line = 0; prolog_text[line] != (char *) 0; line++) {
		(void) printf("%s\n", prolog_text[line]);
	}
}
