/*********************************************************************/
/*                                                                   */
/* Instalation program for CDCOPY package                            */
/*                                                                   */
/* Author: Michel SUCH, Email: msuch@free.fr                         */
/*                                                                   */
/* Chris Wohlgemuth:                                                 */                                                                  */
/* Changed the EMX revision check to look for fix 3 instead fix 1    */ 
/*********************************************************************/

   call init_prog
   call update_config
exit


init_prog:

 parse source . . progname .
 x = pos( filespec('n', progname), progname) - 2
 rundir = substr(progname, 1, x)

 bootdrv = translate(value('PATH', , 'os2environment'))
 parse var bootdrv bootdrv':\OS2;'rest
 bootdrv = substr(bootdrv, length(bootdrv))
/*------------------- Init Rexxutil-----------------------------------*/
 If RXFUNCQUERY('SysLoadFuncs') Then Do
    Call rxfuncadd 'SysLoadFuncs', 'REXXUTIL', 'SYSLOADFUNCS'
    Call sysloadfuncs
 End
 configsys = bootdrv':\config.sys'
 configbak = bootdrv':\config.cdc'
 tempfile = rundir'\CDCOPY.TMP'
   say "Installation program for CDCOPY Version 1.5, 1999-12-23"
   say "Author: Michel SUCH. Email: msuch@free.fr"
   say ""
   say "This installation program will do the following things:"
   say ""
   say "1. Save file" configsys "as" configbak
   say "2. Update the path line of the config.sys to add the" rundir "directory."
   say "3. Add a device line for aspirout.sys if not already there."
   say "4. Update the /all flag for the os2aspi.dmd if not already done."
   say "5. Check if the EMX version is high enough to run CDCOPY"
   say ""
   say "Press Y to continue installation,"
   say "any other key to cancel."
   if translate(sysgetkey()) <> 'Y' then do
      say ""
      say "Installation cancelled."
      exit
   end
   say ""

 prev_cdcopy = value( "cdcopy", , "os2environment")
 call check_emx
return /* init_prog */


update_config:

   changed = 0
   driverfound = 0
   cdcfound = 0
   aspifound = 0
   i = 1
   do while lines(configsys) <> 0
      config.i = linein(configsys)
      line = translate(strip(config.i))
      select
         when substr(line, 1, 8) = "SET PATH" then do
            if prev_cdcopy <> '' then do
               x = pos( translate( prev_cdcopy)';', line)
               if x > 0,
               & translate(rundir) <> translate(prev_cdcopy) then do
                  l = length(prev_cdcopy) + 1
                  config.i = delstr( config.i, x, l);
                  line = translate( config.i)
                  changed = 1
               end
            end
            if pos( translate(rundir)';', line) = 0 then do
               changed = 1
               if substr(config.i, length(config.i)) = ';' then
                  config.i = config.i || rundir';'
               else
                  config.i = config.i || ';' || rundir';'
            end
            if changed = 1 then say "Path variable updated."
         end

         when substr(line, 1, 7) = "DEVICE=" then do
            if pos("ASPIROUT.SYS", line) <> 0 then do
               driverfound = 1
               if line <> "DEVICE=" || translate(rundir)"\ASPIROUT.SYS" then do
                  config.i = "device="rundir"\aspirout.sys"
                  say "Line:" config.i "updated in file" configsys
                  changed = 1
               end
            end
         end

         when substr( line, 1, 8) = "BASEDEV=" then do
            if pos("OS2ASPI.DMD", line) > 0 then do
               aspifound = 1
               if pos("/ALL", line) = 0 then do
                  config.i = "basedev=os2aspi.dmd /all"
                  changed = 1
                  say "OS2ASPI.DMD updated"
               end
            end
         end

         when substr( line, 1, 3) = "SET" then do
            val = word( line, 2)
            parse var val id'='val
            if id = "CDCOPY" then do
               cdcfound = 1
               if val <> translate(rundir) then do
                  config.i = "set cdcopy="rundir
                  changed = 1
                  say "cdcopy environment variable updated"
               end
            end
         end

         otherwise nop
      end
      i = i + 1
   end
   call stream configsys, 'c', 'close'
   config.0 = i-1
   if driverfound = 0 then do
      call add_config "device="rundir"\aspirout.sys"
   end
   if aspifound = 0 then do
      call add_config "basedev=os2aspi.dmd /all"
   end
   if cdcfound = 0 then do
      call add_config "set cdcopy="rundir
   end
   if changed = 1 then do
      "@COPY" configsys configbak ">nul 2>nul"
      if rc <> 0 then do
         say "Cannot backup file" configsys','
         say "program stopped."
         exit
      end
      else say "Original file" configsys "saved as" configbak
      ret = sysfiledelete(configsys)
      if ret <> 0 then do
         say "Cannot replace file" configsys","
         say "program stopped"
         exit
      end
      do i = 1 to config.0
         call lineout configsys, config.i
      end
      call stream configsys, 'c', 'close'
      say "Please reboot your system to finish installation."
   end
   else do
      say "Program CDCOPY already installed, no need to reboot."
   end
return /* update_config */


add_config:

   parse arg ln
   i = config.0 + 1
   config.i = ln
   config.0 = i
   changed = 1
   say "line:" ln "added to file CONFIG.SYS"
return /* add_config */


check_emx:

   /* Check if EMXRT is installed */
   "@call emxrev >"tempfile "2>nul"
   if rc <> 0 then do
      say "The EMXRT libraries are not installed on your system"
      say "or are not at the right level."
         call require_emx
      end

   /* check if levels are good */
   emxref = "EMX EMXIO EMXLIBC EMXLIBCM EMXLIBCS EMXWRAP"
   emxfound = ''
   do while lines(tempfile) <> 0
      emx = translate(linein(tempfile))
      dll = word(emx, 1)
      level = word(emx, words(emx))
      select
         when dll = 'EMX' then do
            if level < 61 then call require_emx
            emxfound = emxfound' 'dll
         end
         when dll = 'EMXIO' then do
            if level < 60 then call require_emx
            emxfound = emxfound' 'dll
         end
         when dll = 'EMXLIBC' then do
            if level < 63 then call require_emx
            emxfound = emxfound' 'dll
         end
         when dll = 'EMXLIBCM' then do
            if level < 63 then call require_emx
            emxfound = emxfound' 'dll
         end
         when dll = 'EMXLIBCS' then do
            if level < 63 then call require_emx
            emxfound = emxfound' 'dll
         end
         when dll = 'EMXWRAP' then do
            if level < 60 then call require_emx
            emxfound = emxfound' 'dll
         end
         otherwise nop
      end
   end
   do i = 1 to words(emxref)
      emxlib = word(emxref, i)
      if wordpos(emxlib, emxfound) = 0 then do
         say "EMXRT problem: Library" emxlib "not found."
         call require_emx
      end
   end
   call stream tempfile, 'c', 'close'
   call sysfiledelete tempfile
return /* check_emx */


require_emx:

   call stream tempfile, 'c', 'close'
   call sysfiledelete tempfile
   say "The CDCOPY package requires EMXRT Version 09D"
   say "With fixpack 3"
   say "You can get EMXRT 09D and EMXFIX03 packages"
   say "on the WEB from HOBBES: http://hobbes.nmsu.edu"
return /* require_emx */
