/* Rexx script to setup an association for C-Side */

call RxFuncAdd "SysLoadFuncs", "REXXUTIL", "SysLoadFuncs"
call SysLoadFuncs

ExeFile=Directory()
ExeFile=ExeFile || "\C-Side.exe"
Result = SysFileTree(ExeFile,Stem,"F")
IF Stem.0 <> 1 THEN
   DO
      Say ""
      Say "You must execute this program from the folder where" ||,
          " C-Side resides!"
      Say "C-Side Program Object NOT created!"
      Signal Error_occured
   END

title = "C-Side"
class = "WPProgram"
location = "<WP_DESKTOP>"

setup_string = "ExeName=" || ExeFile || ";ASSOCFILTER=*.CD;PROGTYPE=PM;"  ||,
               "OBJECTID=<CSIDE>;CCVIEW=YES"
Result= SysCreateObject(class,title,location,setup_string,"R")

IF Result <> 1 THEN
   DO
      Say ""
      Say "Unable to create" title
      Signal Error_occured
   END
ELSE
   DO
      Say ""
      Say title "program object created on" location
   END

Error_occured:
