/* This Rexx-skript puts the tracknames into the tracks listbox of an audio-folder.
 * It uses the CDDB information fetched earlier by the CDDb helper.
 */
/*
 * This file is (C) Chris Wohlgemuth 2000-2001
 *
 * It's part of the Audio/Data-CD-Creator distribution.
 *
 * Visit
 *
 * http://www.geocities.com/SiliconValley/Sector/5785/index.html
 *
 * for more information.
 */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs


parse arg fileInfo.diskid numTracks ' "'fileInfo.folder'" ' fileinfo.installdir

say ''
say ''
say 'This Rexx-skript puts the tracknames into the tracks listbox of an audio-folder.'
say 'Do not start this skript by hand. It is called by a helper with the right parameters.'
SAY ''

say 'ID: 'fileinfo.diskid
say 'Folder: 'fileinfo.folder
say 'installdir: 'fileinfo.installdir
say '# Tracks: 'numTracks

if numTracks < 1 then exit

cddbData=installdir||'\cddbdata\'||fileinfo.diskid

rc=checkCddbData()
if rc=0 then exit

SAY 'cddb data found, now processing...'


/* Seems we have all we need. Start processing the cddb data */

/* Read the cddb data into a stem */
rc=readCddbData()

DO a=0 to numTracks-1
   /* Put cddb info into stem */
   fileinfo.title=searchCddbValue("TTITLE"||a)
 
   /*  fileinfo.realdiskid=searchCddbValue("DISCID=")
       fileinfo.disktitle=searchCddbValue("DTITLE=") */

  /* Set name of listbox item */
   setupstring='SETTRACKLBTEXT='||a+1||' '||fileinfo.title
   rc=SysSetObjectData(fileinfo.folder,setupstring);
END

exit

/*******************************************************************/
/* Procedures */
/*******************************************************************/



/* Search an entry in the cddb data file */
searchCddbValue: PROCEDURE expose cddb.

parse arg keyword

found=0
DO i=1 to cddb.0 while found=0
  if POS(keyword,cddb.i)=1 then found=i
END

if found<>0 then return SUBSTR(cddb.found,POS('=',cddb.found)+1)

return ''

/* Read the cddb data into a compund var */
readCddbData:

/* Clear var */
DROP cddb.
cddb.=""
cddb.0=0

/* Read the file */
DO i=cddb.0+1 while lines(fileinfo.cddbdatafile)<>0
   cddb.i=LINEIN(fileinfo.cddbdatafile)
END
cddb.0=i-1
return 0



checkCddbData: PROCEDURE expose fileinfo.

cddbData=fileinfo.installdir||'\cddbdata\'||fileinfo.diskid

fileinfo.cddbdatafile=cddbData
rc=STREAM(cddbData ,'c','query exists')
if rc\='' then return 1

fileinfo.cddbdatafile=''
return 0

 /* ------------------------------------------------------------------ */
 /* function: Convert a hexadecimal WORD from LSB format to MSB format */
 /*           and vice versa                                           */
 /*                                                                    */
 /* call:     SwapWord hexadecimal_word                                */
 /*                                                                    */
 /* where:    hexadecimal_word - input as hexadecimal word             */
 /*                                                                    */
 /* output:   value in MSB format as hexadecimal word                  */
 /*                                                                    */
 SwapWord: PROCEDURE
   RETURN strip( translate( "12", arg(1), "21" ) )
 
 
   


