
/*
 * gpih.h:
 *      header file for gpih.h, which contains GPI helper functions
 *      that are  independent of a single application,
 *      i.e. these can be  used w/out the rest of the XFolder source in
 *      any PM program.
 *
 *      Copyright (C) 1997-99 Ulrich Mller.
 *      This file is part of the XFolder source package.
 *      XFolder is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published
 *      by the Free Software Foundation, in version 2 as it comes in the
 *      "COPYING" file of the XFolder main distribution.
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 */

#if __cplusplus
extern "C" {
#endif

#ifndef GPIH_HEADER_INCLUDED
    #define GPIH_HEADER_INCLUDED
    /*
     * gpihQueryDisplayCaps:
     *      this returns certain device capabilities of
     *      the Display device. ulIndex must be one of
     *      the indices as described in DevQueryCaps.
     *      This function will load all the device capabilities
     *      only once and reuse them afterwards.
     */

    ULONG gpihQueryDisplayCaps(ULONG ulIndex);

    /*
     * gpihQueryLineSpacing:
     *      this returns the optimal line spacing for text
     *      output with the current HPS; this is computed
     *      by evaluating those incredible FONTMETRICS
     */

    LONG gpihQueryLineSpacing(HPS hps,
                              PSZ pszText);     // in:  text to output


    /*
     * gpihDraw3DFrame:
     *      this draws a rectl in 3D style with a given line width;
     *      if (fRaised), the 3D line is given a "raised" look,
     *      "sunken" otherwise
     */

    VOID gpihDraw3DFrame(HPS hps,
                         PRECTL prcl,       // in:  rectangle
                         USHORT usWidth,    // in:  line width (>= 1)
                         BOOL fRaised);     // in:  TRUE for "raised", FALSE "sunken"

    /*
     * gpihCreateMemPS:
     *      creates a memory device context and presentation space so
     *      they are compatible with the screen device context and
     *      presentation space. These are stored in *hdcMem and *hpsMem.
     *      You must free these with GpiDestroyPS(hpsMem) and
     *      DevCloseDC(hdcMem) when you don't need these any more.
     *      Returns FALSE upon errors.
     */

    BOOL gpihCreateMemPS(HAB hab,        // in: anchor block
                        HDC *hdcMem,     // out: memory DC
                        HPS *hpsMem);    // out: memory PS

    /*
     * gpihCreateBitmap:
     *      creates a new bitmap for a given memory PS.
     *      This new bitmap has the size specified in *prcl.
     *      Note that the bitmap is _not_ selected in the mem PS.
     *      Returns the bitmap handle or NULLHANDLE upon errors.
     */

    HBITMAP gpihCreateBitmap(HPS hpsMem,        // memory DC
                             PRECTL prcl);      // size of bitmap


    /*
     * gpihCreateBmpFromPS:
     *      this creates a new bitmap, which is compatible with the
     *      device associated with hpsScreen, and then copies the
     *      rectangle prcl into it; returns the handle of the bitmap,
     *      which can then be used for WinDrawBitmap and such
     */

    HBITMAP gpihCreateBmpFromPS(HAB hab,        // in: anchor block
                                HPS hpsScreen,  // in: screen PS to copy from
                                PRECTL prcl);   // in: rectangle to copy


    HBITMAP gpihLoadBitmapFile(HPS hps,
                               PSZ pszBmpFile,
                               PULONG pulError);
#endif

#if __cplusplus
}
#endif

