
/***************************************************************/
/*                                                             */
/*  Plug-in interface definitions for T&V HappyPlayer          */
/*  Copyright (c) 2000  Vadim Rumyantsev, Tatyana Rumyantseva  */
/*                                                             */
/*  This program and its source code is a commercial software, */
/*  NOT freeware! You must be a legal T&V HappyPlayer user to  */
/*  use this software for any purpose.                         */
/*                                                             */
/***************************************************************/


#ifndef TVPLUGIN_H
#define TVPLUGIN_H

#ifdef __cplusplus
  #define TV_EXTERN extern "C"
#else
  #define TV_EXTERN extern
#endif

#include <os2.h>


typedef struct _PLCALLS {
  ULONG Total;                         /* Total number of functions below  */
  int   (*I2CR) (ULONG addr);                                 /* I2C read  */
  void  (*I2CW) (ULONG addr, ULONG b1, ULONG b2, BOOL both);  /* I2C write */
  BOOL  (*I2CT) (ULONG addr);                                 /* I2C test  */
  void  (*SwitchMute) (BOOL sw);                    /* Mute on/off         */
  void  (*SetRegister) (ULONG addr, ULONG value);   /* BT register write   */
  ULONG (*GetRegister) (ULONG addr);                /* BT register read    */
} PLCALLS;


TV_EXTERN APIRET PLINIT (PLCALLS *calls, HWND hwnd, ULONG version);  /* Init */
TV_EXTERN APIRET PLDONE ();                                          /* Done */
TV_EXTERN APIRET PLPRESS (char key, char skey);         /* Process keystroke */


#endif
