Unit Version;

// NewView - a new OS/2 Help Viewer
// Copyright 2001 Aaron Lawrence (aaronl at consultant dot com)
// This software is released under the Gnu Public License - see readme.txt

Interface

// This file contains the version number and history.

function GetAppVersion: string;

Implementation

const
  AppVersion = 'V1.27.9';

{
THe whole history thing is turned off!!
Is searching really counting the number of occurrences
in a topic?
Searching
- Searching for phrases/concatenated strings e.g.
  86( or CAKE_SAUSAGE both of which IPF handles as
  seperate words. Or "about this" which IPF also does.

  For each word,
  1. Seperate into chunks
  2. Search dictionary
    for middle chunks, search for exact matches.
      can abort search if any chunk does not have exact match.
    for starting chunk, search for exact or finishing matches.
    for end chunk, search for exact or beginning matches.
  3. Matching 'words' are all matches for first chunk,
     combined with all matches for last chunk
  4. Matched topics are where there is a match for all chunks.

  Algorithim:
  seperate
  set up topic matrix
  for middle chunks,
    search dict,
    if no matches
      end search
    search topics - exact match
    if no topics
      end search
    and results into topic matrix

  search first and last


- Cancel global search.
- All-directories global search option
  (not just HELP+BOOKSHELF)
- Make global search an option on the search panel?
Main UI
- Better handling of windows
  - close button (?)
  - problem with CPPUG toc pane
  - leaving windows smaller than screen...
- Begin/End keypresses in rtview
Misc
- Tools - Mark Start Topic
- Thread loading (?) and searching
- Print 5 days
  (NB. View has fancy features for multi windows)
- Fonts specified in file  3 days
- Replace view for context sensitive help 5 days (ha ha)
- Read and use 'parent' table so that child windows
  found in index/search/link can load parent.
Bugs
(Can't reproduce)
- Crash on CPPLIB from VAC++
- Never exits??
- copy from rtv - e.g. syntax of vprintf in C lib ref
  Locks up!

Other
- Make links from http:// ftp:// mailo:// news://
- Load env. var blobbies from the GUI.
- translate
- DBCS mode
- Runin (not) for bitmaps
- How to use NewView screen
- Colour/font drag drop
- Text colours.
- Multithread 2 days
- Remember last open and save directories 1/4 day
- Page history remember file and position on page 1/2 day
- Internationalisation ? 1 day
- Run WinHelp if format is WinHelp
- Export whole file 1 day?
- Bookmarks 2 days ?
- Lists (bullet/number) ? is there anything to do...
- Show History ?
- make navigation back and forth
  detect differences in windows and make minimum changes 1/2 day

Nice ideas that ain't gonna happen
- Syntax highlight for code.
  Infeasible because
    - how do we tell what language the code is in?
    - how do we tell what parts of the help file are code?

V1.27.10 20/1/1
Picked up improvements in richtext and outline:
standardised borders
fixed problem with initial display of RTV
better scrolling in the outline
(Smooth scrolling is available but doesn't seem to work so
well for this control - I've turned it off in NewView).

V1.27.9 18/1/1
Changed help windows significantly so I can put a (small)
title bar.

V1.27.8 17/1/1
Added popup menu for topics.

V1.27.7 14/1/1
Fixed:
- Cursor does not show if click at end of line (RTV)

V1.27.6 14/1/1
Now saves position within topic for each window.
& when the window is resized.
But something weird - goes to nearest paragraph always...?

V1.27.5 13/1/1
Fixed crashes in saving notes due to destroying files after
saving each files notes; because each time we scan all notes
and hence need all files to be present.
Correctly enable Notes controls at the same time as other
controls (e.g. at startup!)
Also added some safety code to notes operations.
If window cursor not set, add notes at the top of the topic.

V1.27.4 13/1/1
Removed CurrentFile from mainform. Instead looks up file
per topic. This fixes several crashes.

V1.27.3 13/1/1
Fixed up a couple of crashes in global search.

V1.27.2 13/1/1
Picked up various SPCC fixes.
- Listbox items.addstrings is now fast.
  My previous attempt, tcustomlistbox.addstrings, did not work!
  Did not work for loading initial items.
- Click on combo box edit, drops down
- Tasklist is correct for modal dialogs.

V1.27.1 9/12/0
Changed to put INI file in application dir.
Also, picked up a change to RTV, that margins are once
again set in terms of space widths. Didn't I do this before?
Why did I change?

V1.27.0 9/12/0
Restructured searching code:
- moved search table handling to a seperate unit.
  Now has no knowledge of topics, just knows the IPF search
  table format.
- Moved other search code to SearchUnit... uses a functional
  interface.
Changed much of the code to work with arrays of ints, since
this is nice and fast for such things as combining lists of
matching words and looking stuff up.

Search capabilities are the same as before: all seems to be
working.

V1.26.1 5/12/0
Extended searching another step. Now splits up words
as IPF does, into strings of letters / digits/ symbols.
However, this is not very effective because the searching
does not currently take proximity into account...

V1.26.0 3/12/0
Simple implementation of hyperlinked bitmaps:
only handles single overall link code, but this is
enough to handle e.g cmdref examples links.

V1.25.0 3/12/0
Fixed up +/- modifiers in searching.
Moved search query parsing to new unit TextSearchQuery.
Some changes to search page: handle cursor up/down and
pass to results listbox.

V1.24.2 29/11/0
Fixed up search. Seems to be right now for most cases.

V1.24.1 29/11/0
Updated search UI to match new searching approach.
Commented/tidied search code.

V1.24.0 26/11/0
Further changes to search. Now sorts results according
to relevance, based on title/index/topic word count and
weighting exact word matches > partial starting matches > within matches

Theres' still something fucked w.r.t within matches (?)
-

V1.23.0 26/11/0
Major revamp of search. Now supports multi-word
searching with +/- modifiers ala altavista.

V1.22.2 26/11/0
Added checks that BOOKSHELF and HELP environment vars
are defined. Give a warning if not.

V1.22.1 25/11/0
Picked up fixed RTV (v2.9.0) which pretty much works
with outline fonts.

[Grr. Stupidly, released this as NewView1_22_0.zip]

V1.21.1 28/10/0
One undocumented case of bitmap centering.

V1.21.0 28/10/0
Footnotes.
Highlights need for window title bars with (at least) close button.
NB perhaps this should only apply when there is more than one window

Also noticed bug with unknown codes like $fb; would lock up
Now supports $fb code, which does centering.

V1.20.1 27/10/0
Reworked links a little to fix:
- "VisualAge C++ Open Class Library Reference" file
  Click on the index tab.
  Search for "ordering relation".
  Double click on the entry found (this might be entirely unecessary).
  Click on the back arrow.
  This causes a "TList error exception (EListError) occurred at
  $000106EB !"
Now each link stores the helpfile it refers to.

V1.20.0 21/10/0
Back to Sibyl fixpack 3 (mainly for Smartstore, which won't
link with SPC25).
Checked the contents loading more carefully. My code for
skipping hidden entries didn't really look too safe.
Also there are some entries that are not set to hidden but
have a level of zero, which I am now skipping

V1.19.6 2/10/0
Implemented bitmap flags, except for stretch to fit.

V1.19.5 2/10/0
Catch more exceptions on helpfile load. It's a bit fake because
it could already have damaged it's memory, but at least it's more
useful feedback.

V1.19.4 2/10/0
Fixed bug with highlighted words

V1.19.3 30/9/0
Fixed file dialog some more: now changes directory when typed in.

V1.19.2 30/9/0
Yuck, I made a big mess of bitmap loading. Now fixed I hope.

V1.19.1 30/9/0
When images cannot be loaded, it doesn't throw an exception. Instead
just displays a predefined 'missing' bitmap.

V1.19.0 26/9/0
He he
Can pick the toolbar bitmap now...

V1.18.3 26/9/0
Menu hints, displayed in status bar.

V1.18.2 24/9/0
OK mostly going again. Bitmaps not tested. May have forgotten
some things.
Have fixed the os2clu inf problem! :-)

:-D PMREF loads in 1.1 sec: 0.6 sec to load the file, 0.5 to display
Search takes 17s down from 30s

V1.18.1 24/9/0
Oh fuck... rewriting topic reading. This was all triggered by the
discovery that word spacing is reset to true at slot boundaries.
So now, the whole thing is being redone: topics simply store
pointers to their slots. Slots are stored in an exactly-sized
array of records, to minimize memory allocation costs.

Do the same with images, and also for speeding up search
it should not read the whole table of contents, rather just the
entries it needs to show as found. In any case it uses a simplified
contents read until the topic must actually be displayed, when
the window details can be read.

V1.17.16 24/9/0
Fixed alignment in bullets: set margin in terms of size of space char.

V1.17.15 17/9/0
Fixed 'search for words containing' - was not case insensitive

V1.17.14 17/9/0
Fixed a bug in search method 6, 'truncated at both ends'

V1.17.13 17/9/0
Heh! :-)
Speeded up index listbox loading by 20x ! PMREF 430 ms -> 23 ms!
Added an addstrings method to customlistbox.
Note - the PM method of doing this doesn't allow setting
associated objects :-( Fortunately, in my case, I'm already
using a seperate stringlist, which now holds the objects as well.

V1.17.12 17/9/0
Translating of slot data is much faster. Now allocates
all memory up front, which saves a lot of time for some reason.

PMREF: 1.4 s

Index is becoming a problem.

V1.17.11 17/9/0
Further optimisations to index loading.

V1.17.10 17/9/0
Recoded Starts function in assembler since without optimising,
Sibyl is doing a shocking job of it.
Well.. hm. Seems that may be up to 3 x faster, but it was already
< 25 ms !

V1.17.9 17/9/0
Optimised dictionary loading. Now needs no memory allocation,
so e.g. pm4.inf takes only 32 ms to load, vs 200+ ms before.

PMREF: 2.1s

V1.17.8 17/9/0
Picked up the second version of Sibyl FP4. Fix
for changing focus off NewView.

V1.17.7 16/9/0
Heh :-)
Figured out the RLE compression. A few tricky bits...
Found a bug in the [truncated] stream of bytes search method
Found a bug in the "not included list" search method

Tentatively conclude that search table is finished.

V1.17.6 16/9/0
Added collapse all in view menu

V1.17.5
Set application font to WarpSans.9 so standard dialogs
have it...

V1.17.4
Fixed a bug with displaying links a second time!
  Reported by Steen Kleis Srensen kleis@image.dk
   and tpater@one.net.au and others...

V1.17.3
Scrapped plans to rewrite loading. Can't see how to make faster
without scrapping OO approach.

Implemented most of search table useage, except RLE compression
method, which is not explained in the IBM docs.

V1.17.2
What a shocker... saved about half a second simply by
optimising out my horrendously slow StrNPas!! Now 2.7s

NOTE: Creating and displaying the index takes a full second.
Perhaps I should just scrap it, once search is fast.

Hm. My timings have not been including things after loading the file.

V1.17.1
FIrst part of a rewrite for speed.
Files are loaded as a single block of data. This saves on lots
of temporary memory allocations which results in a speed up.
Also changed ReadSlot, which reads topic data, to use pointers
rather than indexes. This saves quite a bit of time too, since I
can't turn optimisation on.

PMREF is now down to 3.2 s load time.

V1.16.13
Added a few more keyboard shortcuts

V1.16.12
Re-enabled save as... though the confirmation dialog for an existing
file looks naff and I haven't done the file dialog completely nicely.

V1.16.11
Fixed - Autolinks at start of a topic, the link continues into the text
  e.g. cpplng.inf
Fixed - copy to clipboard (in RTV)

V1.16.10
- Double click opens topic from global search
- Doesn't have problem if you just viewtopic while on
  a file (forgot to handle this case in TNainForm.OnViewGlobalSearchTopic)

V1.16.9
Turned optimisation off again. Was causing problems with assertions
reading bitmaps. This slows loading (pmref) by almost a whole second ;-(
Fixed reading contents slot numbers, was anding with 255

V1.16.8


FUCK A basic Sibyl SPCC bug. Once a font gets to zero use count it is destroyed..
but DereferenceFont does not set the font to nil, so next time round an invalid
reference is made.

I changed SPCC (graphics.pas) DereferenceFont to take a Var parameter
and set the font to nil if it's destroyed. This finally fixes the font crash.

Also fiddled with the font dialog a little.


IMMENSE amount of debugging trying to find cause of crash after invoking the
font dialog a few times.
When TFontDialog.SetTheFont sets the FExampleText button Font,
the previous font is dereferenced and gets destroyed. This seems to
be wrong. It overwrites memory.
Also the FUseCount of the font seems to be zero to start off with...


V1.16.7
Rewrote contents reading to load all data into memory.
Strangely, this produces only 20% improvement on PM3 but apparently
about 50% improvement on PM4. ???

Anyway this saves about another second of loading PMREF. But I can't
see how to make it much faster without significantly changing the
way classes are created.
Certainly I can't see how to make mine as fast as original View.exe,
which loads contents in <1s!

Current profile in ms

Read header: 10
Read slot offsets: 0
Read contents: 703
Read dictionary: 133
Read index: 23
Read topic data: 836
Read images: 0 (in PM3)

V1.16.6
20% improvement in loading time by avoiding copying topic data memry
when loading it.
(PMREF 6.3s to 5.2s)

V1.16.5
Search the topic titles and the index as well.

V1.16.4
Delete THelpFileInfo objects from global search results outline
when clearing it.

V1.16.3
Sort topics for each file in global search

V1.16.2
Fixed ANOTHER huge bug in search! My 'starts' function would say that
'abc' starts with 'abcdefg' !!!

V1.16.1
Now can actually use the global search results.

V1.16.0
New global search results UI: as an outline. Top level is helpfile,
child nodes are matchiing topics. Looks quite good.
Apart from being extremely slow, it's perfectly functional ;-)
Further mods to HelpThread

Picked up fixes in Outline2
- highlight should invert text
- setup scrollbars after update


V1.15.7
Fixed a MASSIVE bug in search. Only the first occurrence of each matching
word was being found!! Can't believe no-one noticed...
- unfortunately this makes search very slow again ;-(

(well, I did, on global search testing)
Double clicking a note in the notes list goes to it.
Search and index search edit boxes are not cleared on close file.

V1.15.6
Now has full multicolumn listbox.

V1.15.5
Now global search form is a modeless dialog.

V1.15.4
Global search - now does actually do the search
- Set ItemIndex on the search type combo correctly
- Clear results list before each search
- Pass the search text in!!

Fixed mistake in getting help file title.

V1.15.3
More memory leaks:
  - Fixed freeing ttopic data! Was not multiplying by size of items (int16)!! Stupid.
  - Not freeing memory in ReadContents (not much loss though)

This seems to fix all significant memory leaks.

Now the global search completes and does not seem to use huge amounts of memory...
But it doesn't find anything! :-|

--
 Memory status: losing about 200 kB per open/close of OS2UG.
--
V1.15.2
Fixed index duplicates. It's not quite right because if there is a topic
with the same title but pointing to a different topic it will not be caught...
Saves @ 50kB of index strings

V1.15.1
Added /profile cmd line option

V1.15.0
Command line topic searching. Bit different to view. View searches the
index and displays only the first topic. I decided to do a full text search
and (of course) display all tht results.
This could be another option, I guess, but I think mine is more helpful.

V1.14.4
Memory leaks in THelpFile - apparent in searching cause the program
runs out of heap space!
[Example: OS2UG.INF: losing 6 MB per open/close]
- Fixed: not destroying help bitmaps (2MB)
- Fixed: not freeing THelpTopic data memory! (2MB)
- Fixed: when adding data to THelpTopic, not freeing old data.

V1.14.3
Now attempts to load and search helpfiles in global search.
Added a CreateSearchableOnly constructor to helpfile. Currently
all that does differently is not load bitmaps.

V1.14.2
While loading help file(s) show which file is being loaded in the
status bar.

V1.14.1
Fixed a huge bug in the navigation back and forward with
multiple windows! In fact it looks more like I just forgot
to finish it... I was not translating the parent between the
copied window and the actual.

V1.14.0
Started implementing global search
Step 1: in library, implemented procedure to search a given path
  for a given mask and return a list of files.
Step 2: Set up a thread on the globalsearch form and called the
  library function. Currently just sends all the filenames back.
  Hacked Eriks HT unit to make this simple.
  He says he has a generic callback mechanism, but I'm buggered if
   I can figure it out.



V1.13.3
Load notes before displaying first topic.

V1.13.2
Colours can be custommised

V1.13.1
option to use std OS/2 file dialog. so that
  enhancers can replace.

V1.12.22
Fix directory list box in file open
  - drawing
  - keyboard selection
Also updated default filter to only help files.

V1.12.21
Fix copy in RTView

V1.12.20
Fixed problems with link mouse over (fix in RTView mainly)
Corrected file types list box on file dialog
Tidied up options dialog again. (lost in crash)

V1.12.19
Fixed extra random data at end of topics. Was not counting
my stored data correctly.

V1.12.18
Changed link following to use posted message. Fixes at least one
bug with crashing following a link (ncftp.inf).
Seems like a good idea anyway. Make sure that we are not
in an event for a control when it is being destroyed...

V1.12.17
Fixed the display of < and >. Had to improve RTView to allow
<< and >> to be substituted.

V1.12.16
Figured out a bit more of the index format. Now correctly
skips the "roots" of a particular entry.

V1.12.15
Fix for using unsigned numbers and  going for ... to n - 1...
Notably an empty topic (no slots) would screw up and read indefinitely.
(example: warpnote.inf)
Also reset progress if file fails to load.
Partial fix for strange index entries... associated with global flag?
 I just skip them for now...

V1.12.14
Some improvements to file open dialog.
Double click file to open
Filter defaults to help files only
Tab order better
Typing a directory (absolute) in the filename changes to that
dir.

V1.12.13
Smooth scrolling option works
Index style option works

V1.12.12
Save fonts

V1.12.11
Picked up fixes & enhancements in richtextview
- focus changing on cursor left/up
- basic left/right margin.

V1.12.10
Open in full share mode (deny none) so can open files
that are being used by View. Previously was using
DENYWRITE but this is apparently not enough.

V1.12.9
Fixed searching with multiple files. Have to maintain word lists
(highlight words) per file.

V1.12.8
Huge speed up on searching. Instead of using Duplicates = dupIgnore
on the search results so far, simply mark each topic as found
and skip those that are already marked.

Also added a 'nothing found' item to search results when appropriate.

V1.12.7
Speed up index searching by keeping a seperate stringlist.
It's a lot quicker to search this than the listbox.
Ideally of course we could use the OS/2 listbox search function
but it is case sensitive!


How ironic... the toolkit docs include a 'how to use the contents' topic...
of course users have to have figured out how to use the contents to get to
this topic .... !

V1.12.6
Improved the progress bar for loading multiple files; uses
file size to proportionally allocate progress.

Fixed startup; my WM_OPENED message was being processed twice
because apparently DefaultHandler is NOT the place to handle
messages!? Instead define a message handling procedure like this:
  TMyForm = class( TForm )\
    ...
    Procedure WMMyMessage( Var Msg:TMessage ); messaeg WM_MYMESSAGE;

Curious. But it works.

Moved loading of file from command line to the WMOpened procedure
so it is loaded after window is shown and sized.

V1.12.5
Added a crude progress bar for loading files...


V1.12.4
Expanded the file searching further:
now looks in both HELP and BOOKSHELF and if the file
extension is not given, it looks for .inf and .hlp.

V1.12.3
Save non-maximised window size correctly.

V1.12.2
Fixed Problem, when maximised, clicking on link to another topic, unmaximises!
Due to Sibyl using WM_USER+1 for focus handling. So my startup resizing
was being called in many cases.

V1.12.1
Allows environment vars and looks in HELP path like View.

V1.11.12
Reenabled find/find next

V1.11.11
Implemented next/prev in contents
Reenabled select all and copy

V1.11.10
Rebuilt notes for multi-window.
Also
- RefreshWindows now re-reads the topics
- Save notes correctly works for multi-files open

V1.11.9
Rebuilt navigation back and forth for multi-window
situation. Seems to be working OK for single window
help files (nb mem useage is @ 400 bytes per page)
... and for multiwindow.

It would be nice to make it detect only the differences
in windows i.e. make the minimum changes necessary to get
back to a previous point.
But that is tricky.

V1.11.8
Speed up the dictionary loading by about 3x. A few 100ms
off time to load GPI ref.

V1.11.7

  Kick arse! Using TAString has sped up topic decoding
  (TTopic.GetText) by at least 5x!
  Now there is no noticeable delay on any topic
    (good examples of long topics are in the GPI guide:
      How to use the GPI guide
      Graphics Attributes)

Performance:
  Tried TTopic.GetText using AnsiString. It worked
  perfectly (AFAIK) but was if anything slightly slower
  than using c strings!
    Optimisation did not improve things...
    Nor did inline string functions

    NOTE!!! Optimisation causes errors in Bitmap decompression (at least)


V1.11.6
Reconstructed window handling to use child lists properly.
Think I have fixed it all!

Memory status: no known leaks with just text and one window.
Also images and links are fine (with one window).
Hm. One error: second topic in GPI guide. Something with fonts...
OK a stuff up on /tt. Using Font instead of NormalFont. Now OK.
OK, seems to be fine even with multiple windows. There may be some
odd occurrence when flicking through lots of topics rapidly (?!)

Note: A small amount of memory is used with each topic displayed
because it gets added to the page history, with a new string
being allocated in TStringList each time. This is not a leak!

V1.11.5
Memory leak fixing:
Remember to close child windows!
Still losing 50-100k per topic!

Numerous bug fixes in TRichTextView . Now a (basically) blank
topic loses 2KB.

V1.11.4
Attempting to get (non-auto) links going again.
Current scheme is: if the link is to a topic in the contents then
change topic (close all windows)
If the link is not in the contents (ie. invisible topic) then just
open the window.  Seems to work well enough for toolkit docs.

Current problem: if we click on another topic link then the
rtview will be destroyed before the OnClickLink event returns!

Updated rich text view to not call any code after calling onclick.
Losing a *lot* of memory.

V1.11.3
Now reads link sizing information as well. This means the OS/2
Desktop Guide makes a reasonable attempt at display.

Fixed the sizing of the main
display panel w.r.t. the splitbar.

V1.11.2
Implemented 'split' window handling, although for now I have approximated
the effects.
Window layout is now done properly and on resize

V1.11.1
Many frustrations later... still going!
Toolkit docs such as GPI reference are *almost* there. But still,
the primary window, that only loads other windows, seems to have a
group number > 0. Then the mini-contents window has a group of zero
and therefore loads into another new window and therefore gets the wrong
size.

Hmm... well it is using 'split' windows which is to say there ARE actually
3 windows. But the mini-contents is inside the first and *all controls are
turned off*. Why would anyone do it this way? Blurk.

V1.11.0
Multiwindow support started.

V1.10.5
Reworked MRU list so it is used in all cases,
and moves files to head of list if they have been loaded before.

V1.10.4
Significant restructure of image handling. They are now held
in compressed form (as THelpBitmap objects)
and uncompressed only for the topic as needed.
This cuts down RAM usage by a huge amount. Now only takes 3.5MB to load
LAN distance guide vs. 30MB+ before.

V1.10.3
Fixed a problem with loading uncompressed bitmaps:
uncompressed block size is compressedblocksize - 1 since the first
byte is the compression type.

V1.10.2
Fixed crashes in index loading.
Fixed back/forward navigation.
Further observations:
- could delay loading index until it actually selected
- should disable update whilst clearing outline
- need to do outline layout after endupdate(?) - is not
  setting scrollbar correctly.

V1.10.1
Updated file selection and parameter passing to accept multiple files.
It seems to work! Although I notice I have broken back button.

Also, now uses my own file dialog which allows multifile select, and sizing.

V1.10.0
Made a huge mess of things in order to support
multiple files open at the same time. Argh
All seems to be working again...

V1.9.6
Wow! Finally figured out how to set  the icon!
Have to do:
  AnIcon:= TICon.Create;
  AnIcon.LoadFromResourceName( 'AppIcon' );
  Icon:= AnIcon;

on main form...
It finds the first independent color form (?) which
should be 20x20 to avoid scaling.


V1.9.5
Load notes
Set caption when no file
Close file menu item
Disable most controls when no file

V1.9.4
Save notes to filename.nte

V1.9.3
Added ability to delete notes

V1.9.2
Added ability to edit notes.

V1.9.1
Notes enhanced. They are remembered and
redisplayed whenever the topic is. Works with
more than one note in a single topic by adjusting
for earlier notes and storing indexes into the
original text.

V1.9.0
First attempt at functioning notes - they
are inserted into the text at the cursor point.
Quite a few problems with this approach tho.

V1.8.5
Fixed search results for new contents structure
Attempted to figure out search table in the INF file
but it looks non-obvious.

V1.8.4
Finally changed contents to have a TContentsEntry class
Also, the contents in THelpFile DOES load hidden entries
since the index may refer to them.
Instead the UI contents loading excludes them
This allows Sibyl SPCC.INF to load again

V1.8.3
Fixed bug in index
  Index .objects were being given tocindex not tocobject
Fixed bug in searching:
  Match not set to false in THelpFile.SearchDictionary
Fixed problems with getting itemindex of searchtypecombobox
  (problem due to Sibyl notebooks)

V1.8.2
Properly disable coolbar buttons

V1.8.1
Removed old mainform and renamed new form back to mainform.

V1.8.0
Added Coolbar and Statusbar to UI. Fully cheesiferous!

V1.7.13
Sketched the Notes page and a global search dialog...

V1.7.12
Implemented find/find next...

BTW somewhere in the last few versions I added a incremental
search of the index. Turns out Sibyl's ComboBox does *not* wrap
a real OS/2 combo box instead it has a seperate edit and listbox.
This is good I suppose (e.g. allows setting DropDownCount?) but
they did not implement the incremental searching function. Grr

V1.7.11
Fixed some memory leaks - destroying contents TList's of slots, and the
slots themselves. But it still seems to lose a lot of memory. As per!

V1.7.10
No, I hadn't got the extended TOC entries right. I was checking
the extended flag as bit 2 (val=4) not bit 5 (val=32)
An example of an extended TOC Entry is the OS/2 user guide (os2ug.inf)

Also fixed styles 4,5,6 (.hp5,6,7) this makes the Sibyl SPCC ref look
a lot better.

V1.7.9
Fixed a crash loading os2\book\orexx.inf
This was to do with extended TOC entries. I'm not all that
sure I got it exactly right but it seems to load the contents OK...

V1.7.8
Fixed a bug loading bitmaps larger than 64k (more than one block).
Now it works but takes a huge amount of memory - for example
the 'LAN distance' manual uses 37MB!

The total bitmap data in this case is only 16MB so obviously TImageList
is not very efficient. Still, even better would be to store the
images in compressed form and only uncompress required images when
getting an article.

V1.7.7
Implemented font option, though they are not saved.

V1.7.6
Fixed margin setting - no closed brace was being added -
looks like it never was !?

V1.7.5
If there is only one top level contents node then expand it
automatically.
Select the first node after loading a file.

V1.7.4
Fixed back and forward enabling (might be different cause of
TOutline2...)
FIxed SetSelectedObject on TOUtline2 (probably in TNode.FindData ...
not setting result to nil if not found) so we are back to we were
before

V1.7.3
Now uses TOutline2. Very fast to load. Not quite complete...

----

Profile SPCC.INF
Read contents: 0
Read dictionary: 343
Read articles: 656
Read slots: 656       <<----
Read index: 23460
Load contents outline: 23710
Load index listbox: 38125   <<----
Add extra index entries: 38210 <<----
Profile stop: 53625


Further investigation shows that Sibyls TOutline takes a very
long time to insert lots of nodes. It's difficult to say if this
is due to the OS/2 container or just the Sibyl code around it
(which is quite complex).

Am tempted to use my new Outline2 control, which is much more lightweight
and is customisable.

V1.7.2
Speeded up loading of index listbox enormously by setting Duplicates to true.
if not true,then Sibyl searches the whole list before inserting any item.

V1.7.1
Don't load images more than once! - cut 4 s of spcc.inf load time.

V1.7.0
First draft search.

V1.6.1
Implemented Save As (current entry only)

V1.6.0
Implemented passing a file on command line

V1.5.3
OK fixed that. Now the official index entries are loaded as is,
then the doc titles are inserted appropriately
This also works nicely for INF files with *no* index

V1.5.2
OK there is one problem (at least with that. The indexed phrases
may include indented multiple entries e.g.
phraseX
  doc 1
  doc 2
This is lost by my previous scheme. Haven't realy solved this exactly.

V1.5.1
OK, so now the index includes all the topic headings
as well as the specifically indexed phrases

V1.5.0
Now reads/displays the index. But I think it
should be enhanced or perhaps just replaced, with
just an alphabetical list of all topics.

V1.4.0
Now displays bitmaps! Fucken aye

V1.3.6
Fixed my memory corruption. My MemCopy
was copying 4 bytes at a time instead of single bytes
So it seems that all bitmaps are now being loaded successfully.

V1.3.5
Ported LZW decompression, seems to be working fine
Memory corruption

V1.3.4
No functional change
There is now functional code to read the blocks out of the bitmap
sensibly, but the decompression does not yet work.

    The bitmap decompression code (new with V0.91) at the bottom was
   written by Peter Fitzsimmons (pfitz@ican.net), who kindly sent me
   his code upon my cry for help in WarpCast. Thanks a lot.

V1.3.3
CHanged UI to use a tabset since they take less space
and graphic buttons for a prettier look

V1.3.2
Fixed TCustomOUtline so that when making the selected item visible
(fake cursor keys) the onitemfocus is not called. Need so back/forward
is useful for links.

V1.3.1
Now has functioning back and forward

V1.3.0
Restructured the help file reading so that, text is only fully
uncompressed when asked for. On loading it resolves local dictionary
to global, then stores the global dictionary indices.
Next and previous in contents work.
Catch errors on loading file.
Select All and Copy work.

V1.2.5
Setting left margin now works (esc $02)
V1.2.4
Fixed problem - $fa code, should not
set spacing to true if in monospace

V1.2.3
Has a functioning MRU list

V1.2.2
Remembers window position.

V1.2.1
Hyperlinks now work.

V1.2.0
Now using RichTextView, so basic formatting
works

V1.1.0
Crude plain-text help system, knocked up
in a fever of coding. Processes table of contents,
text and a few escape codes

V1.0.0
Quick prototype interface
}

function GetAppVersion: string;
begin
  Result:= AppVersion;
end;

Initialization
End.
