Unit OptionsForm;

// NewView - a new OS/2 Help Viewer
// Copyright 2001 Aaron Lawrence (aaronl at consultant dot com)
// This software is released under the Gnu Public License - see readme.txt

Interface

Uses
  Classes, Forms, Graphics, Buttons, ExtCtrls, StdCtrls, Grids, Dialogs,
  TabCtrls, ColorWheel, CustomFontDialog;

Type
  TOptionsForm = Class (TForm)
    OKButton: TBitBtn;
    CancelButton: TBitBtn;
    TabbedNotebook: TTabbedNotebook;
    IndexStyleRadioGroup: TRadioGroup;
    SmoothScrollingCheckBox: TCheckBox;
    Label3: TLabel;
    Label4: TLabel;
    UseOriginalDialogsCheckBox: TCheckBox;
    Label1: TLabel;
    NormalFontPanel: TPanel;
    Label2: TLabel;
    FixedFontPanel: TPanel;
    FixedFontButton: TSpeedButton;
    NormalFontButton: TSpeedButton;
    Label5: TLabel;
    ColorItemsListBox: TListBox;
    GroupBox1: TGroupBox;
    FontDialog: TCustomFontDialog;
    OpenBackgroundImageButton: TBitBtn;
    ClearBackgroundBitmapButton: TBitBtn;
    ColorWheel: TColorWheel;
    ValueBar: TValueBar;
    BackgroundImageFilenameEdit: TEdit;
    Label6: TLabel;
    Procedure ClearBackgroundBitmapButtonOnClick (Sender: TObject);
    Procedure OpenBackgroundImageButtonOnClick (Sender: TObject);
    Procedure OptionsFormOnCreate (Sender: TObject);
    Procedure ValueBarOnChange (Sender: TObject);
    Procedure ColorItemsListBoxOnItemFocus (Sender: TObject; Index: LongInt);
    Procedure OKButtonOnClick (Sender: TObject);
    Procedure FixedFontButtonOnClick (Sender: TObject);
    Procedure NormalFontButtonOnClick (Sender: TObject);
    Procedure OptionsFormOnShow (Sender: TObject);
  Protected
    Colors: Array[ 0..9 ] of TColor;
    Procedure SetFontCaptions;
    Procedure DisplayColorItem;
  Public
    MyParent: TForm;
  End;

Var
  OptionsForm: TOptionsForm;

Implementation

uses
  SettingsUnit, SysUtils, FileDialogForm, PmWin;

function GetFontString( Font: TFont ): string;
begin
  Result:= Font.FaceName
           + ' ' + IntToStr( Font.PointSize );
  if faBold in Font.Attributes then
    Result:= Result + ' Bold';
  if faItalic in Font.Attributes then
    Result:= Result + ' Italic';
end;

Procedure TOptionsForm.ClearBackgroundBitmapButtonOnClick (Sender: TObject);
Begin
  BackgroundImageFilenameEdit.Text:= '(None)';
End;

Procedure TOptionsForm.OpenBackgroundImageButtonOnClick (Sender: TObject);
Begin
  FileDialogForm.AllowMultipleFiles:= false;
  FileDialogForm.Caption:= 'Open bitmap';
  FileDialogForm.FilterComboBox.Filter := 'Bitmaps (*.bmp)|*.bmp';
  if FileDialogForm.ShowModal = mrOK then
  begin
    BackgroundImageFilenameEdit.Text:= FileDialogForm.Filenames[ 0 ];
  end;
End;

Procedure TOptionsForm.OptionsFormOnCreate (Sender: TObject);
Begin
  TabbedNoteBook.PageIndex:= 0;
  // Select the first colour item
  ColorItemsListBox.ItemIndex:= 0;
End;

Procedure TOptionsForm.ValueBarOnChange (Sender: TObject);
Begin
  Colors[ ColorItemsListBox.ItemIndex ]:= ValueBar.SelectedColor;
End;

Procedure TOptionsForm.ColorItemsListBoxOnItemFocus (Sender: TObject;
  Index: LongInt);
begin
  DisplayColorItem;
end;

Procedure TOptionsForm.DisplayColorItem;
Var
  c: longint;
Begin
  c:= Colors[ ColorItemsListBox.ItemIndex ];
  ColorWheel.SetSelectedColor( C );
End;

Procedure TOptionsForm.OKButtonOnClick (Sender: TObject);
var
  ColorIndex: integer;
Begin
  // Save settings from controls

  Settings.NormalFont:= NormalFontPanel.Font;
  Settings.FixedFont:= FixedFontPanel.Font;

  Settings.IndexStyle:= TIndexStyle( IndexStyleRadioGroup.ItemIndex );
  Settings.SmoothScrolling:= SmoothScrollingCheckbox.Checked;
  Settings.UseOriginalDialogs:= UseOriginalDialogsCheckBox.Checked;

  Settings.BackgroundImageFilename := BackgroundImageFilenameEdit.Text;

  for ColorIndex:= 0 to High( Settings.Colors ) do
    Settings.Colors[ ColorIndex ]:= Colors[ ColorIndex ];

End;

Procedure TOptionsForm.FixedFontButtonOnClick (Sender: TObject);
Begin
  FontDialog.EditFont:= FixedFontPanel.Font;
  if FontDialog.Execute then
  begin
    FixedFontPanel.Font:= Screen.CreateCompatibleFont( FontDialog.EditFont );
    SetFontCaptions;
  end;

End;

Procedure TOptionsForm.NormalFontButtonOnClick (Sender: TObject);
Begin
  FontDialog.EditFont:= NormalFontPanel.Font;
  if FontDialog.Execute then
  begin
    NormalFontPanel.Font:= FontDialog.EditFont;
    SetFontCaptions;
  end;
End;

Procedure TOptionsForm.OptionsFormOnShow (Sender: TObject);
var
  ColorIndex: integer;
Begin
  // Load settings into controls.

  NormalFontPanel.Font:= Settings.NormalFont;
  FixedFontPanel.Font:= Settings.FixedFont;
  SetFontCaptions;

  SmoothScrollingCheckbox.Checked:= Settings.SmoothScrolling;
  IndexStyleRadioGroup.ItemIndex:= integer( Settings.IndexStyle );
  UseOriginalDialogsCheckBox.Checked:= Settings.UseOriginalDialogs;

  for ColorIndex:= 0 to High( Settings.Colors ) do
    Colors[ ColorIndex ]:= Settings.Colors[ ColorIndex ];

  DisplayColorItem;

  BackgroundImageFilenameEdit.Text := Settings.BackgroundImageFilename;

  FontDialog.Font:= Font;
End;

Procedure TOptionsForm.SetFontCaptions;
begin
  NormalFontPanel.Caption:= GetFontString( NormalFontPanel.Font );
  FixedFontPanel.Caption:= GetFontString( FixedFontPanel.Font );
end;

Initialization
  RegisterClasses ([TOptionsForm, TBitBtn,
    TLabel, TTabbedNotebook
   , TRadioGroup, TCheckBox, TPanel, TSpeedButton, TListBox, TGroupBox,
    TCustomFontDialog, TEdit, TColorWheel, TValueBar]);
End.
