Unit FileDialogForm;

// NewView - a new OS/2 Help Viewer
// Copyright 2001 Aaron Lawrence (aaronl at consultant dot com)
// This software is released under the Gnu Public License - see readme.txt

Interface

// This form is a generic, sizeable file dialog. I never
// got round to making it a seperate thing. Better would be
// to enhance the one in SPCC.

Uses
  Classes, Forms, Graphics, StdCtrls, FileCtrl, Buttons,
  CustomFileControls;

Type
  TFileDialogForm = Class (TForm)
    FilenameEdit: TEdit;
    FileNameLabel: TLabel;
    FilesLabel: TLabel;
    FileTypeLabel: TLabel;
    DrivesLabel: TLabel;
    DirectoriesLabel: TLabel;
    FileListBox: TCustomFilelistBox;
    DriveComboBox: TCustomDriveComboBox;
    FilterComboBox: TCustomFilterComboBox;
    DirectoryListBox: TCustomDirectoryListBox;
    OKButton: TBitBtn;
    CancelButton: TBitBtn;
    Procedure FileListBoxOnDblClick (Sender: TObject);
    Procedure FileDialogFormOnShow (Sender: TObject);
    Procedure FileDialogFormOnDestroy (Sender: TObject);
    Procedure FileListBoxOnItemFocus (Sender: TObject; Index: LongInt);
    Procedure OKButtonOnClick (Sender: TObject);
    Procedure FileDialogFormOnCreate (Sender: TObject);
  Public
    // Input
    AllowMultipleFiles: boolean;
    // Output
    FileNames: TStringList;
  End;

Var
  FileDialogForm: TFileDialogForm;

Implementation

uses
  ACLStringUtility, ACLFileUtility, SysUtils, Dialogs;

Procedure TFileDialogForm.FileListBoxOnDblClick (Sender: TObject);
Begin
  OKButton.Click;
End;

Procedure TFileDialogForm.FileDialogFormOnShow (Sender: TObject);
Begin
  FilenameEdit.Focus;
  FilelistBox.MultiSelect:= AllowMultipleFiles;
End;

Procedure TFileDialogForm.FileDialogFormOnDestroy (Sender: TObject);
Begin
  FileNames.Destroy;
End;

Procedure TFileDialogForm.FileListBoxOnItemFocus (Sender: TObject;
  Index: LongInt);
var
  FileName: string;
  FileIndex: longint;
Begin
  FileNames.Clear;
  for FileIndex:= 0 to FileListBox.Items.Count - 1 do
    if FileListBox.Selected[ FileIndex ] then
      FileNames.Add( FileListBox.Items[ FileIndex ] );
  FileNameEdit.Text:= ListToString( FileNames, '+' );
End;

Procedure TFileDialogForm.OKButtonOnClick (Sender: TObject);
var
  FileNameText: string;
  FileIndex: longint;
  FileName: string;
  Directory: string;
  NewDirectory: string;
Begin
  FileNameText:= trim( FileNameEdit.Text );
  if FileNameText = '' then
    exit;

  Directory:= DirectoryListBox.Directory;

  NewDirectory := ExpandPath( Directory, FileNameText );

  if DirectoryExists( NewDirectory ) then
  begin
    DirectoryListBox.Directory:= NewDirectory;
    FileNameEdit.Text := '';
    exit;
  end;

  FileNames.Clear;
  while FileNameText <> '' do
  begin
    FileName:= AddSlash( Directory ) + ExtractNextValue( FileNameText, '+' );
    if not FileExists( FileName ) then
    begin
      ShowMessage( 'File ' + Filename + ' does not exist' );
      exit;
    end;
    FileNames.Add( FileName );
  end;
  DismissDlg( mrOK );
End;

Procedure TFileDialogForm.FileDialogFormOnCreate (Sender: TObject);
Begin
  FileNameEdit.YAlign:= yaTop;
  FileNameEdit.xStretch:= xsFrame;
  FileNameLabel.YAlign:= yaTop;
  FilterComboBox.YAlign:= yaTop;
  FileTypeLabel.YAlign:= yaTop;
  DriveComboBox.YAlign:= yaTop;
  DrivesLabel.YAlign:= yaTop;
  DirectoryListBox.YStretch:= ysFrame;
  DirectoriesLabel.YAlign:= yaTop;
  FilterComboBox.xStretch:= xsFrame;
  FileListBox.xStretch:= xsFrame;
  FileListBox.yStretch:= ysFrame;
  FilesLabel.YAlign:= yaTop;
  OKButton.XAlign:= xaRight;
  CancelButton.XAlign:= xaRight;
  FileNames:= TStringList.Create;
End;

Initialization
  RegisterClasses ([TFileDialogForm, TEdit, TLabel,
    TCustomFilelistBox, TCustomDriveComboBox,
    TCustomFilterComboBox, TCustomDirectoryListBox, TBitBtn]);
End.
