/****************************************************************************
*                                                                           *
*  Author      : Dr. Thomas Brandes, GMD, I1.HR                             *
*  Date        : Nov 92                                                     *
*  Last Update : Jan 93							    *
*                                                                           *
*  Module      : xmenu                                                      *
*                                                                           *
*  Function    : *****                                                      *
*                                                                           *
*  Export :                                                                 *
*                                                                           *
*    xmenu (int argc, char ** argv);                                        *
*                                                                           *
*                                                                           *
*     topLevel :  frame    -------------------------------------------      *
*                          | logo commands                           |      *
*                          |                                         |      *
*                          |      filelabel                          |      *
*                          |                                         |      *
*                          |      message_widget                     |      *
*                          -------------------------------------------      *
*                          | vp_mytext                               |      *
*                          |                                         |      *
*                          |                                         |      *
*                          |                                         |      *
*                          -------------------------------------------      *
*                          | label_units           label_vars        |      *
*                          -------------------------------------------      *
*                          | vp_units              vp_vars           |      *
*                          |                                         |      *
*                          -------------------------------------------      *
*                                                                           *
*                                                                           *
****************************************************************************/

#include "xglobal.h"
#include "xcommands.h"
#include "xunits.h"
#include "xhelp.h"            /* show_help         */
#include "xoptions.h"         /* KeyTranslations   */

#define HIGH 0                /* HIGH = 1 for higher widget */

/****************************************************************************
*                                                                           *
*   GMD Bitmap                                                              *
*                                                                           *
****************************************************************************/

#define gmd_width 56
#define gmd_height 56
static char gmd_bits[] = {
   0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0x1f, 0xfe, 0xff, 0xff, 0xff, 0xff,
   0xff, 0x7f, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x03, 0x00, 0x00,
   0x00, 0x00, 0x00, 0xc0, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x03,
   0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00,
   0xc0, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x03, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xc0, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x03, 0x00,
   0x00, 0x00, 0x00, 0x00, 0xc0, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0,
   0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x03, 0x00, 0x00, 0x00, 0x00,
   0x00, 0xc0, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x03, 0x00, 0x00,
   0x00, 0x00, 0x00, 0xc0, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x03,
   0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00,
   0xc0, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x03, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xc0, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x03, 0x00,
   0x00, 0x00, 0x00, 0x00, 0xc0, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0,
   0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x03, 0x00, 0x00, 0x00, 0x00,
   0x00, 0xc0, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x03, 0x00, 0x00,
   0x00, 0x00, 0x00, 0xc0, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x03,
   0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00,
   0xc0, 0x03, 0x70, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x03, 0xe0, 0x80, 0x00,
   0x30, 0x80, 0xc1, 0x03, 0x80, 0x81, 0x01, 0x30, 0x00, 0xc3, 0x03, 0x00,
   0x83, 0x01, 0x30, 0x00, 0xc6, 0x03, 0x07, 0x03, 0x03, 0x30, 0x3c, 0xcc,
   0x83, 0xe3, 0x03, 0x03, 0x30, 0x7c, 0xcc, 0xc3, 0xe1, 0x03, 0x06, 0x30,
   0x4c, 0xcc, 0xc3, 0x00, 0x00, 0x06, 0x30, 0x0c, 0xcc, 0xc3, 0x00, 0x40,
   0x0c, 0x30, 0x0c, 0xcc, 0xc3, 0x00, 0x43, 0x0c, 0x32, 0x0c, 0xcc, 0xc3,
   0x00, 0xc3, 0x18, 0x32, 0x0c, 0xcc, 0xc3, 0x00, 0xc3, 0x18, 0x33, 0x0c,
   0xcc, 0xc3, 0x38, 0xc3, 0x10, 0x33, 0x0c, 0xcc, 0xc3, 0x38, 0xc3, 0x80,
   0x31, 0x0c, 0xcc, 0xc3, 0x00, 0xc3, 0x80, 0x31, 0x0c, 0xcc, 0x83, 0x01,
   0xc3, 0xc0, 0x30, 0x0c, 0xcc, 0x03, 0x00, 0xc3, 0xc0, 0x30, 0x00, 0xc6,
   0x33, 0x30, 0xc3, 0x60, 0x30, 0x00, 0xc3, 0xf3, 0xff, 0xf3, 0x70, 0x3c,
   0xff, 0xc1, 0xc3, 0xef, 0xf3, 0x30, 0x3c, 0xff, 0xc0, 0x03, 0x00, 0x00,
   0x00, 0x00, 0x00, 0xc0, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x06,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff,
   0x7f, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0x1f};

void create_pixmap ()
{
   /* set global gmdPixmap */

   gmdPixmap = XCreatePixmapFromBitmapData (
          XtDisplay (topLevel),
          RootWindowOfScreen (XtScreen (topLevel)),
          gmd_bits, gmd_width, gmd_height,
          1, 0, 1);

}

void update_pixmap ()

{
        if (DefaultDepthOfScreen (XtScreen(gmdBitmap)) == 1)
           XCopyArea (XtDisplay (gmdBitmap), gmdPixmap, XtWindow (gmdBitmap),
                   DefaultGCOfScreen (XtScreen (gmdBitmap)), 0, 0,
                   gmd_width, gmd_height, 0, 0);
         else
           XCopyPlane(XtDisplay (gmdBitmap), gmdPixmap, XtWindow (gmdBitmap),
                   DefaultGCOfScreen (XtScreen (gmdBitmap)), 0, 0,
                   gmd_width, gmd_height, 0, 0, 1);

}

/****************************************************************************
*                                                                           *
*   END of  GMD Bitmap                                                      *
*                                                                           *
****************************************************************************/

Widget frame;  /* global used */
xmenu (argc, argv)
int argc;
char **argv;
{
    XtAppContext app_context;
    Widget vp_units, vp_vars, label_units, label_vars;
    Arg args[20];
    int n;

    static XtActionsRec window_actions[] = {
    { "update_pixmap", update_pixmap },
    { "show_help", show_help},
    { "return_key", return_key},
    { "is_no_digit_or_return", is_no_digit_or_return}
    };

    /* Initialization of the global file variable */

    strcpy (selected_file, PHOME);
    strcat (selected_file, "/welcome");

    strcpy (last_message, "No Errors.");

    /* Displays the welcome message at the beginning of the session */

/****************************************************************************
*                                                                           *
*  topLevel :  frame                                                        *
*                                                                           *
****************************************************************************/

    topLevel = XtVaAppInitialize(
        &app_context,       /* Application context */
        "XAdapt",            /* Application class */
        NULL, 0,            /* command line option list */
        &argc, argv,        /* command line args */
        NULL,               /* for missing app-defaults file */
        NULL);              /* terminate varargs list */

/****************************************************************************
*                                                                           *
*  formWidget                                                               *
*                                                                           *
*  frame :  commands                                                        *
*           vp_text, vp_units, vp_vars                                      *
*                                                                           *
****************************************************************************/

        frame = XtCreateManagedWidget(
                "frame",                      /* widget name */
                formWidgetClass,              /* widget class */
                topLevel,                     /* parent widget*/
                NULL, 0);                     /* terminate varargs list */
                
/****************************************************************************
*                                                                           *
*  bitmapWidget: gmdBitmap                                                  *
*                                                                           *
****************************************************************************/

        XtAppAddActions (app_context, window_actions,
                          XtNumber (window_actions));

        n = 0;
        XtSetArg (args[n], XtNlabel, "GMD");  n++;
        XtSetArg (args[n], XtNvertDistance, 10);  n++;
        XtSetArg (args[n], XtNwidth, gmd_width); n++;
        XtSetArg (args[n], XtNheight, gmd_height); n++;
        XtSetArg (args[n], XtNborderWidth, 0);  n++;
        XtSetArg (args[n], XtNtranslations,
          XtParseTranslationTable ("<Expose>:  update_pixmap()")); n++;

        gmdBitmap = XtCreateManagedWidget ("GMD",
                    widgetClass, frame, args, n);

        make_help_available (gmdBitmap);

/****************************************************************************
*                                                                           *
*  boxWidget : commands                                                     *
*                                                                           *
****************************************************************************/

        n = 0;
        XtSetArg (args[n], XtNfromHoriz, gmdBitmap);  n++;
        XtSetArg (args[n], XtNhorizDistance, 10);  n++;
        XtSetArg (args[n], XtNwidth, MyTextWidth); n++; 
        XtSetArg (args[n], XtNborderWidth, 0); n++; 

        commands = XtCreateManagedWidget(
                "commands",                    /* widget name */
                boxWidgetClass,        /* widget class */
                frame,                     /* parent widget*/
                args, n);                  /* terminate varargs list */

        make_commands (commands);

/****************************************************************************
*                                                                           *
*  labelWidget : filelabel                                                  *
*                                                                           *
****************************************************************************/

        n = 0;
        XtSetArg (args[n], XtNvertDistance, 5);  n++;
        XtSetArg (args[n], XtNhorizDistance, 10);  n++;
        XtSetArg (args[n], XtNfromVert, commands);  n++;
        XtSetArg (args[n], XtNfromHoriz, gmdBitmap);  n++;
        XtSetArg (args[n], XtNborderWidth, 0);  n++;
        XtSetArg (args[n], XtNlabel, selected_file);  n++;

        filelabel = XtCreateManagedWidget (
                 "filelabel",
                 labelWidgetClass,
                 frame,
                 args, n);

/****************************************************************************
*                                                                           *
*  labelWidget : message_widget                                             *
*                                                                           *
****************************************************************************/

        n = 0;
        XtSetArg (args[n], XtNvertDistance, 5);  n++;
        XtSetArg (args[n], XtNfromVert, filelabel);  n++;
        XtSetArg (args[n], XtNfromHoriz, gmdBitmap);  n++;
        XtSetArg (args[n], XtNhorizDistance, 10);  n++;
        XtSetArg (args[n], XtNborderWidth, 3);  n++;
        XtSetArg (args[n], XtNlabel, last_message);  n++;

        message_widget = XtCreateManagedWidget (
                 "message",
                 labelWidgetClass,
                 frame,
                 args, n);

/****************************************************************************
*                                                                           *
*  viewportWidget : vp_mytext                                               *
*                                                                           *
****************************************************************************/

        n = 0;
        XtSetArg (args[n], XtNheight, MyTextHeight); n++; 
        XtSetArg (args[n], XtNwidth, MyTextWidth);  n++;
        XtSetArg (args[n], XtNvertDistance, 10);  n++;
        XtSetArg (args[n], XtNfromVert, message_widget);  n++;

        vp_mytext = XtCreateManagedWidget (
                    "mytext",
                    viewportWidgetClass,
                    frame,
                    args, n);  /* will be managed when filename is set */
       
        n = 0;

        XtSetArg (args[n], XtNeditType, XawtextRead);  n++;
        XtSetArg (args[n], XtNtype, XawAsciiFile);  n++;
        XtSetArg (args[n], XtNstring, selected_file);  n++;
        /* XtSetArg (args[n], XtNscrollVertical, 1);  n++;
           XtSetArg (args[n], XtNscrollHorizontal, 1);  n++; */

        mytext = XtCreateManagedWidget (
                 "editor",
                 asciiTextWidgetClass,
                 vp_mytext,
                 args, n);  /* will be managed when filename is set */

        make_help_available (mytext);

        /* units is a list widget that contains unit entries */

/****************************************************************************
*                                                                           *
*  labelWidget : label_units                                                *
*                                                                           *
****************************************************************************/

        n = 0;
        if (HIGH == 1)
          { XtSetArg (args[n], XtNvertDistance, 10);  n++;
            XtSetArg (args[n], XtNfromVert, vp_mytext);  n++;  
          }
         else
          { XtSetArg (args[n], XtNvertDistance, 10);  n++;
            XtSetArg (args[n], XtNfromVert, message_widget);  n++;
            XtSetArg (args[n], XtNhorizDistance, 10);  n++;
            XtSetArg (args[n], XtNfromHoriz, vp_mytext);  n++;
          }
        XtSetArg (args[n], XtNborderWidth, 0);  n++;
        XtSetArg (args[n], XtNlabel,
                           "Units (program, subroutine, function)");  n++;

        label_units = XtCreateManagedWidget (
                 "units",
                 labelWidgetClass,
                 frame,
                 args, n);

        make_help_available (label_units);

/****************************************************************************
*                                                                           *
*  viewportWidget : vp_units                                                *
*                                                                           *
****************************************************************************/

        n = 0;
        XtSetArg (args[n], XtNvertDistance, 10);  n++;
        XtSetArg (args[n], XtNfromVert, label_units);  n++;
        if (HIGH != 1)
         { XtSetArg (args[n], XtNhorizDistance, 10);  n++;
           XtSetArg (args[n], XtNfromHoriz, vp_mytext);  n++;
         }
        XtSetArg (args[n], XtNheight, MyUnitHeight); n++; 
        XtSetArg (args[n], XtNwidth, MyUnitWidth);  n++;  
        XtSetArg (args[n], XtNallowHoriz, TRUE);  n++;
        XtSetArg (args[n], XtNallowVert, TRUE);  n++;

        vp_units = XtCreateManagedWidget(
                "vp_units",                        /* widget name */
                viewportWidgetClass,            /* widget class */
                frame,                        /* parent widget*/
                args, n);                     /* terminate varargs list */

        init_units (vp_units);

/****************************************************************************
*                                                                           *
*  labelWidget : label_vars                                                 *
*                                                                           *
****************************************************************************/

        n = 0;
        XtSetArg (args[n], XtNvertDistance, 10);  n++;
        XtSetArg (args[n], XtNhorizDistance, 10);  n++;
        if (HIGH == 1)
          { XtSetArg (args[n], XtNfromVert, vp_mytext);  n++;
            XtSetArg (args[n], XtNfromHoriz, vp_units);  n++; }
         else
          { XtSetArg (args[n], XtNfromVert, vp_units);  n++;
            XtSetArg (args[n], XtNfromHoriz, vp_mytext);  n++; }
        XtSetArg (args[n], XtNborderWidth, 0);  n++;
        XtSetArg (args[n], XtNlabel, "Definitions in a unit");  n++;

        label_vars = XtCreateManagedWidget (
                 "definitions",
                 labelWidgetClass,
                 frame,
                 args, n);

        make_help_available (label_vars);

/****************************************************************************
*                                                                           *
*  viewportWidget : vp_vars                                                 *
*                                                                           *
****************************************************************************/

        /* vars is a list widget that contains var entries */

        n = 0;
        XtSetArg (args[n], XtNvertDistance, 10);  n++;
        XtSetArg (args[n], XtNfromVert, label_vars);  n++;
        XtSetArg (args[n], XtNhorizDistance, 10);  n++;
        if (HIGH == 1)
           { XtSetArg (args[n], XtNfromHoriz, vp_units);  n++; }
          else
           { XtSetArg (args[n], XtNfromHoriz, vp_mytext);  n++; }
        XtSetArg (args[n], XtNwidth, MyVarWidth);  n++;
        XtSetArg (args[n], XtNheight, MyVarHeight);  n++;
        XtSetArg (args[n], XtNallowHoriz, TRUE);  n++;
        XtSetArg (args[n], XtNallowVert, TRUE);  n++;

        vp_vars = XtCreateManagedWidget(
                "vp_vars",                        /* widget name */
                viewportWidgetClass,            /* widget class */
                frame,                        /* parent widget*/
                args, n);                     /* terminate varargs list */

        init_vars (vp_vars);

        create_pixmap ();

        XtRealizeWidget(topLevel);

        XtAppMainLoop(app_context);
}
