/**************************************************************************
*                                                                         *
*  Author      : Werner Meurer, GMD, I1.HR                                *
*  Date        : Jan 93                                                   *
*  Last Update :                                                          *
*                                                                         *
*  Module      : xhelp                                                    *
*                                                                         *
*  Function    : Athena Widgets for Help Handling                         *
*                                                                         *
*  Export :                                                               *
*                                                                         *
*    void make_help_available (Widget w)                                  *
*                                                                         *
*       - gets help entry for the widget based on its label               *
*                                                                         *
*    void make_help_menu_entries (Widget father)                          *
*                                                                         *
**************************************************************************/

#define DEBUG(x) 

#define MAXHELP	40          /* maximal help records */

#define MAXHELPNAMELENGTH	30     /* maximal length of a help name */

#define PIXELS	15          /* used to compute size of help widget */

#define EOL     10          /* character for end of line */

#include <string.h>

#include "xglobal.h"
#include "xfiles.h"

/*********************************************************************
*                                                                    *
*  Global Data is Array of Entries                                   *
*                                                                    *
*********************************************************************/

static char HELPFILE[165];

struct HELP{
	char	HelpName[MAXHELPNAMELENGTH];
	long	start,
		end;
	Widget	window;
};

static struct HELP help[MAXHELP+1];

static int helpcount = 0;	/* Number of entries in help */

void print_help_entries ();

/****************************************************************
*             							*
*   helpinit()							*
*   INPUT:	none						*
*   OUTPUT:	none						*
*   Initialising the Arraystruktur help with 0!			*
*   Initialising the Directory with the file help!		*
*           							*
****************************************************************/

helpinit()
{
	int i,x;
DEBUG(fprintf(stdout,"helpinit()<-\n"));
	for (i=0;i<MAXHELP;i++)
	{
	  for (x=0;x<MAXHELPNAMELENGTH;x++)
		help[i].HelpName[x] = '\0';
	  help[i].start = 0;
	  help[i].end = 0;
	  help[i].window = 0;
	}
	strcpy(HELPFILE,PHOME);
	strcpy(HELPFILE+strlen(HELPFILE),"/help");
DEBUG(fprintf(stdout,"helpinit()->\n"));
}

/****************************************************************/
/* get_help_entries()						*/
/* INPUT:	none						*/
/* OUTPUT:	none						*/
/* Loads Data in the Struktur help.				*/
/****************************************************************/

void get_help_entries ()
{
	FILE *helpfileptr = 0;
	char letter;
	char command[MAXHELPNAMELENGTH];
	int commandptr;
	long start,end;
DEBUG(fprintf(stdout,"get_help_entries()<-\n"));
	helpinit();
	helpfileptr = fopen(HELPFILE,"r");
DEBUG(fprintf(stdout,"HELPFILE = %s\nhelpfileptr = %d\n",
	HELPFILE,(unsigned long)helpfileptr));
	if (!helpfileptr)
	{
		strcpy(last_message,"HELPFILE wasn't found or no access\n");
		set_message();
		fprintf(stderr,"HELPFILE wasn't found or no access\n");
		return;
	}
	letter= getc(helpfileptr);/* 1. charakter of command */
	while (letter!= EOF)
	{
		if (letter== '.')
		/* command */
		{
			if (help[helpcount].start)
			{
				help[helpcount].end = ftell(helpfileptr) -2;
DEBUG(fprintf(stdout,"end = %d\n",help[helpcount].end));
			}
			commandptr = 0;
			letter = getc(helpfileptr);
			while ((letter != EOF) &&
				(letter != '.') && 
				(letter != EOL))
			{
				if (commandptr < MAXHELPNAMELENGTH)
				{
				   command[commandptr] = letter;
				   commandptr++;
				   command[commandptr] = '\0';
				}
				letter= getc(helpfileptr);
			}
			letter = getc(helpfileptr);
DEBUG(fprintf(stdout,":%s:\t%d\n",help[helpcount].HelpName,helpcount));
                        if (helpcount == MAXHELP)
                        {
                            fprintf(stderr,"maximal number of helpentries has benn reached (%d)\n",MAXHELP);
                            return;
                        }
			if (help[helpcount].HelpName[0] == '\0')
				strncpy(help[helpcount].HelpName,command,
					MAXHELPNAMELENGTH);
			else
				strncpy(help[helpcount+1].HelpName,command,
					MAXHELPNAMELENGTH);
DEBUG(fprintf(stdout,"command = %s\thelpcount = %d\n",
help[helpcount].HelpName,helpcount));
		}
		else
		/* help */
		{
			if ((helpcount == 0) || (help[helpcount].end))
			{
				if ((help[helpcount].start) && 
				    (help[helpcount].end))
				{
				   helpcount++;
				   help[helpcount].start = ftell(helpfileptr)-1;
				}
				if ((!help[helpcount].start) &&
				    (!help[helpcount].end))
				{
				   help[helpcount].start = ftell(helpfileptr)-1;
				}
DEBUG(fprintf(stdout,"start = %d\n",help[helpcount].start));
			}
			while ((letter!= EOF) && (letter != EOL))
			{
				letter = getc(helpfileptr);
			}
			if (letter == EOL)
			{
				letter = getc(helpfileptr);
			}
			if (letter == EOF)
			{
				help[helpcount].end = ftell(helpfileptr) -2;
DEBUG(fprintf(stdout,"end = %d\n",help[helpcount].end));
				helpcount++;
			}
		}
	}
	fclose(helpfileptr);
DEBUG(fprintf(stdout,"get_help_entries()->\n"));
}

/****************************************************************/
/* HelpSelect()							*/
/* INPUT:	w is the calling Widget				*/
/*		client_data are the calling Parameters		*/
/*		call_data 					*/
/* OUTPUT:	The called help is printed 			*/
/****************************************************************/

static void HelpSelect (w, client_data, call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
  FILE *helpfileptr;
  int nr;
  int rows = 3;
  int maxline = 0,line = 0;
  long stelle;
  char *string;
  Arg args[2];
  int x,y;

  DEBUG(fprintf (stdout, "one help entry selected\n"));
  print_help_entries();

  nr = (int) client_data;
  if (helpcount == nr)
  {
	Arg arg;
	char *label;
	string = "No help available!\n";
	rows++;
	XtSetArg(arg,XtNlabel,&label);
	XtGetValues(w,&arg,1);
  	xshowhelp(w,label,string,rows,strlen(string));
	return;
  }
  DEBUG(printf("Help entry %d for command %s selected\n",nr,help[nr].HelpName));
  helpfileptr = fopen(HELPFILE,"r");
  if (!helpfileptr)
  {
	fprintf(stderr,"No access on HELPFILE\n");
	return;
  }
  DEBUG(fprintf(stdout,"start = %d\tend = %d\n",help[nr].start,help[nr].end));
  if (fseek(helpfileptr,help[nr].start,(long) 0) != 0)
  {
	fprintf(stderr,"seek failed \n");
	return;
  }
  string = (char*) malloc(help[nr].end - help[nr].start +2);
  if (!string)
  {
	fprintf(stderr,"string not allocated\n");
	return;
  }
  for (stelle = help[nr].start;stelle <= help[nr].end;stelle++)
  {
	string[stelle-help[nr].start] = getc(helpfileptr);
	if (string[stelle-help[nr].start] == EOL)
	{
		rows++;
		if (line > maxline) maxline = line;
		line = 0;
	}
	else
	{
		line++;
	}
	DEBUG(fprintf(stdout,"%c",string[stelle-help[nr].start]));
  }
	/* only one line of characters is shown in message window */
  if (rows == 4)
  {
	string[help[nr].end - help[nr].start] = '\0';
        /* not end - start + 1 to remove EOL */
	strcpy(last_message,string);
	set_message();
  }
  else /* more lines are shown in help window */
  {
        string[help[nr].end - help[nr].start + 1] = '\0'; /* terminate string */

	DEBUG(fprintf(stdout,"HelpName = %s\n",help[nr].HelpName));

	xshowhelp(w,help[nr].HelpName,string,rows,maxline);
  }
  free(string);
  if (fclose(helpfileptr))
  {
	fprintf(stderr,"fclose failed\n");
	return;
  }
}

/****************************************************************/
/* make_help_menu_entries()					*/
/* INPUT:	fatherwidget					*/
/* OUTPUT:							*/
/* return value:	true if helpcount is greater than 0	*/
/*			false, if helpcount is 0		*/
/* Making the pulldownmenu					*/
/****************************************************************/
bool make_help_menu_entries (father)

Widget father;

{ int i;
  Widget entry, menu;
  char *item;

  get_help_entries ();

  menu = XtCreatePopupShell("menu", simpleMenuWidgetClass,
                            father, NULL, 0);

  for (i=0; ((i < helpcount) && (helpcount < MAXHELP)); i++)
    { item = help[i].HelpName;
      entry = XtCreateManagedWidget (item, smeBSBObjectClass, menu, NULL, 0);
      XtAddCallback (entry, XtNcallback, HelpSelect, (XtPointer) i);
    }

  DEBUG(fprintf (stdout, "help entries created"));
  print_help_entries();

  if (helpcount)
	return(true);
  else
	return(false);
}

void show_help_quit (w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{ Widget parent;
  int i;
  parent = XtParent (XtParent (w));
  for (i=0;i<helpcount;i++)
  {
	if (help[i].window == w)
	{
	    help[i].window = 0;
	    XtPopdown (parent);
	    XtDestroyWidget (parent);
	    return;
	}
  }
}

xshowhelp (w,name, string, rows, maxline)
Widget w;
char name[];
char *string;
int rows;
int maxline;
{  int n;
   Arg args[10];

   Widget sh_popup, sh_form, sh_quit,sh_text;

   int i;
   Widget parent = XtParent(w);
   /* Get the positions to set the position of the helpwindow. */
   /* It should be shown under the button which asks for help. */
   Position x1,x2,y;

   n = 0;
   XtSetArg(args[n],XtNx,&x1);n++;
   XtSetArg(args[n],XtNy,&y);n++;
   XtGetValues(XtParent(XtParent(parent)),args,n);
   n = 0;
   XtSetArg(args[n],XtNx,&x2);n++;
   XtGetValues(w,args,n);
   for (i=0;((i<helpcount) && (strcmp(name,help[i].HelpName) != 0)) ;i++)
	;
   if (helpcount == i)
	/* help not available */
   {
	strcpy(last_message,
		"No help available ");
	set_message();
	return;
   }
   if (help[i].window != 0)
	/* helpwindow is open */
   {
	strcpy(last_message,
		"helpwindow is open");
	set_message();
	return;
   }
   sh_popup = XtCreatePopupShell (
         name,
         transientShellWidgetClass,
         parent,
         NULL, 0);

   /* Set the position of the helpwindow */
   n = 0;
   XtSetArg(args[n],XtNx,x1+x2);n++;
   XtSetArg(args[n],XtNy,y+100);n++;
   XtSetValues(sh_popup,args,n);

/****************************************************************************
*                                                                           *
*  formWidget                                                               *
*                                                                           *
*  sh_form :  sh_quit                                                       *
*             sh_text                                                       *
*                                                                           *
****************************************************************************/

      sh_form = XtCreateManagedWidget(
                  "sh_form",                    /* widget name */
                  formWidgetClass,              /* widget class */
                  sh_popup,                     /* parent widget*/
                  NULL, 0);                     /* terminate varargs list */
                
      sh_quit = XtCreateManagedWidget(
                  "Quit",                       /* widget name */
                  commandWidgetClass,           /* widget class */
                  sh_form,                      /* parent widget*/
                  NULL, 0);                     /* terminate varargs list */

      help[i].window = sh_quit;
      
      XtAddCallback(sh_quit, XtNcallback, show_help_quit, 0);
                
      n = 0;
      XtSetArg (args[n], XtNhorizDistance, 10);  n++;
      XtSetArg (args[n], XtNfromHoriz, sh_quit);  n++;

                
      n = 0;
      if (rows > 20) rows = 20;
      XtSetArg (args[n], XtNheight,
	(int) ((float)(PIXELS*rows))); n++; 
      {
	if (maxline > 80) maxline = 80;
      XtSetArg (args[n], XtNwidth, (int)(0.5 * (float) (PIXELS*maxline))); n++;
      }
      XtSetArg (args[n], XtNvertDistance, 10);  n++;
      XtSetArg (args[n], XtNfromVert, sh_quit);  n++;
      XtSetArg (args[n], XtNtype, XawAsciiString);  n++;
      XtSetArg (args[n], XtNstring, string);  n++;
      XtSetArg (args[n], XtNeditType, XawtextRead);  n++;
      XtSetArg (args[n], XtNscrollVertical, 1);  n++;
      XtSetArg (args[n], XtNscrollHorizontal, 1);  n++; 

      sh_text = XtCreateManagedWidget (
                 "sh_text",
                 asciiTextWidgetClass,
                 sh_form,
                 args, n);  

      XtPopup (sh_popup, XtGrabNone);

}

void print_help_entries ()
{
DEBUG( int i);
DEBUG(fprintf(stdout,"There are %d help entries\n", helpcount));
DEBUG(for(i=0;i<helpcount;i++))
DEBUG(printf("HelpName %s length = %d\n",
	help[i].HelpName,strlen(help[i].HelpName)));
}

/****************************************************************
*             							*
*  show_help()							*
*             							*
*  INPUT:	w is the calling widget				*
*  		event is the event which called this procedure	*
*  OUTPUT:	none						*
*  This procedure compares the label of the calling widget with	*
*  the HelpNames. If it was equal, it calles the procedure	*
*  SelectHelp, which shows the helptext.			*
****************************************************************/

void show_help (w, event)
Widget w;
XEvent *event;
{
	char *widget_name;
	int i;

        widget_name = XtName (w);

	DEBUG(fprintf(stdout,"label = %s\tlength = %d\n",widget_name,strlen(widget_name)));
	for (i=0;
	    ((i<helpcount) && (strcmp(help[i].HelpName,widget_name) != 0));
	    i++)
	{
		;	
	}

        if (i == helpcount)
           { /* no help availble for this widget */
             sprintf (last_message, "No Help available for '%s'", widget_name);
             set_message ();
           }
         else
           {
             DEBUG(fprintf(stdout,"HelpSelect is called with %d\n",i));
             HelpSelect (w, (XtPointer) i, (XtPointer) 0);
           }
}


static String helpTranslation =
        "<Btn3Down>:    show_help()";

void make_help_available (w)

Widget w;

{ XtOverrideTranslations(w, XtParseTranslationTable(helpTranslation));
}
