# include "Reductio.h"
# include "yyReduc.w"
# include <stdio.h>
# if defined __STDC__ | defined __cplusplus
#  include <stdlib.h>
# else
   extern void exit ();
# endif
# include "Tree.h"
# include "Definiti.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 33 "Reductions.puma"


# include <stdio.h>
# include "Tree.h"
# include "Idents.h"
# include "protocol.h"

# include "StringMe.h"
# include "Definiti.h"
# include "Types.h"
# include "Transfor.h"    /* ExpToVarParam */



static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module Reductions, routine %s failed\n", yyFunction);
 exit (1);
}

bool IsReduction ARGS((tTree t));
tTree GlobalReductionStmt ARGS((tTree var, tTree vtype, tTree func));
tTree GlobalLocReductionStmt ARGS((tTree var, tTree vtype, tTree func));
tTree InitReductionStmt ARGS((tTree var, tTree vtype, tTree func));
tTree ResolveReduce ARGS((tTree t));
static tTree ResolveDoIt ARGS((tTree t, tIdent func, tTree var, tTree exp, tTree other_stmts));
static tTree MakeIntrRedCall ARGS((tIdent fname, tTree var, tTree exp));
static tTree LocationStmts ARGS((tTree params));
static int GetGlobalOp ARGS((tTree type, tIdent redfunc));

bool IsReduction
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t == NoTree) return false;
  if (t->Kind == kACF_BASIC) {
# line 57 "Reductions.puma"
  {
# line 58 "Reductions.puma"
   if (! (IsReduction (t->ACF_BASIC.BASIC_STMT))) goto yyL1;
  }
   return true;
yyL1:;

  }
  if (t->Kind == kASSIGN_STMT) {
  if (t->ASSIGN_STMT.ASSIGN_EXP->Kind == kFUNC_CALL_EXP) {
# line 61 "Reductions.puma"
  {
# line 62 "Reductions.puma"
   if (! (IsIntrFunc (t->ASSIGN_STMT.ASSIGN_EXP) == true)) goto yyL2;
  {
# line 63 "Reductions.puma"
   if (! (IntrFuncRed (t->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident) == true)) goto yyL2;
  }
  }
   return true;
yyL2:;

  }
  }
  return false;
}

tTree GlobalReductionStmt
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree vtype, register tTree func)
# else
(var, vtype, func)
 register tTree var;
 register tTree vtype;
 register tTree func;
# endif
{
  if (func->Kind == kPROC_OBJ) {
# line 85 "Reductions.puma"
 {
  int op;
  tTree t;
  {
# line 87 "Reductions.puma"

# line 88 "Reductions.puma"

# line 90 "Reductions.puma"
 op = GetGlobalOp (vtype, func->PROC_OBJ.Ident);

     if (op == -1)
        { error_protocol ("illegal reduction");
          printf ("Reductions: Generate Global Reduction Statement failed\n");
          printf ("var = "); FileUnparse (stdout, var); printf ("\n");
          printf ("vtype = "); FileUnparse (stdout, vtype); printf ("\n");
          printf ("call = "); FileUnparse (stdout, func); printf ("\n");
          t = NoTree;
        }
      else
        { t = mVAR_PARAM (mADDR (mCONST_EXP (mINT_CONSTANT (op))));
          t = mBTP_LIST (t, mBTP_EMPTY ());
          t = mBTP_LIST (mVAR_PARAM (var), t);
          t = mCALL_STMT (mPROC_OBJ (MakeDalibId ("reduction")), t);
          t = mACF_BASIC (t);
        }

  }
  {
   return t;
  }
 }

  }
 yyAbort ("GlobalReductionStmt");
}

tTree GlobalLocReductionStmt
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree vtype, register tTree func)
# else
(var, vtype, func)
 register tTree var;
 register tTree vtype;
 register tTree func;
# endif
{
  if (func->Kind == kPROC_OBJ) {
# line 127 "Reductions.puma"
 {
  int op;
  tTree t;
  {
# line 129 "Reductions.puma"

# line 130 "Reductions.puma"

# line 132 "Reductions.puma"
 op = GetGlobalOp (vtype, func->PROC_OBJ.Ident);

     if ((op < 1) || (op > 6))
        { error_protocol ("illegal loc reduction");
          printf ("GlobalLocReductionStmt failed\n");
          printf ("var = "); FileUnparse (stdout, var); printf ("\n");
          printf ("vtype = "); FileUnparse (stdout, vtype); printf ("\n");
          printf ("call = "); FileUnparse (stdout, func); printf ("\n");
          t = NoTree;
        }
      else
        { t = mVAR_PARAM (mADDR (mCONST_EXP (mINT_CONSTANT (op))));
          t = mBTP_LIST (t, mBTP_EMPTY ());
          t = mBTP_LIST (mVAR_PARAM (var), t);
          t = mCALL_STMT (mPROC_OBJ (MakeDalibId ("pos_reduction")), t);
          t = mACF_BASIC (t);
        }

  }
  {
   return t;
  }
 }

  }
 yyAbort ("GlobalLocReductionStmt");
}

tTree InitReductionStmt
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree vtype, register tTree func)
# else
(var, vtype, func)
 register tTree var;
 register tTree vtype;
 register tTree func;
# endif
{
# line 172 "Reductions.puma"

tTree t;

  if (vtype->Kind == kBOOLEAN_TYPE) {
  if (equalint (vtype->BOOLEAN_TYPE.size, 4)) {
  if (func->Kind == kPROC_OBJ) {
  if (equaltIdent (func->PROC_OBJ.Ident, MakeIdent ("ANY", 3))) {
# line 176 "Reductions.puma"
  {
# line 177 "Reductions.puma"
 t = mCONST_EXP (mBOOL_CONSTANT (0));
     t = mASSIGN_STMT (var, t);
     t = mACF_BASIC (t);

  }
   return t;

  }
  }
  }
  if (equalint (vtype->BOOLEAN_TYPE.size, 4)) {
  if (func->Kind == kPROC_OBJ) {
  if (equaltIdent (func->PROC_OBJ.Ident, MakeIdent ("ALL", 3))) {
# line 184 "Reductions.puma"
  {
# line 185 "Reductions.puma"
 t = mCONST_EXP (mBOOL_CONSTANT (1));
     t = mASSIGN_STMT (var, t);
     t = mACF_BASIC (t);

  }
   return t;

  }
  }
  }
  if (equalint (vtype->BOOLEAN_TYPE.size, 4)) {
  if (func->Kind == kPROC_OBJ) {
  if (equaltIdent (func->PROC_OBJ.Ident, MakeIdent ("PARITY", 6))) {
# line 192 "Reductions.puma"
  {
# line 193 "Reductions.puma"
 t = mCONST_EXP (mBOOL_CONSTANT (0));
     t = mASSIGN_STMT (var, t);
     t = mACF_BASIC (t);

  }
   return t;

  }
  }
  }
  }
  if (vtype->Kind == kINTEGER_TYPE) {
  if (equalint (vtype->INTEGER_TYPE.size, 4)) {
  if (func->Kind == kPROC_OBJ) {
  if (equaltIdent (func->PROC_OBJ.Ident, MakeIdent ("COUNT", 5))) {
# line 200 "Reductions.puma"
  {
# line 201 "Reductions.puma"
 t = mCONST_EXP (mINT_CONSTANT (0));
     t = mASSIGN_STMT (var, t);
     t = mACF_BASIC (t);

  }
   return t;

  }
  }
  }
  if (equalint (vtype->INTEGER_TYPE.size, 4)) {
  if (func->Kind == kPROC_OBJ) {
  if (equaltIdent (func->PROC_OBJ.Ident, MakeIdent ("SUM", 3))) {
# line 208 "Reductions.puma"
  {
# line 209 "Reductions.puma"
 t = mCONST_EXP (mINT_CONSTANT (0));
     t = mASSIGN_STMT (var, t);
     t = mACF_BASIC (t);

  }
   return t;

  }
  }
  }
  if (equalint (vtype->INTEGER_TYPE.size, 4)) {
  if (func->Kind == kPROC_OBJ) {
  if (equaltIdent (func->PROC_OBJ.Ident, MakeIdent ("PRODUCT", 7))) {
# line 216 "Reductions.puma"
  {
# line 217 "Reductions.puma"
 t = mCONST_EXP (mINT_CONSTANT (1));
     t = mASSIGN_STMT (var, t);
     t = mACF_BASIC (t);

  }
   return t;

  }
  }
  }
  if (equalint (vtype->INTEGER_TYPE.size, 4)) {
  if (func->Kind == kPROC_OBJ) {
  if (equaltIdent (func->PROC_OBJ.Ident, MakeIdent ("MAXVAL", 6))) {
# line 224 "Reductions.puma"
  {
# line 225 "Reductions.puma"
 t = mCONST_EXP (mINT_CONSTANT (-2147483647));
     t = mASSIGN_STMT (var, t);
     t = mACF_BASIC (t);

  }
   return t;

  }
  }
  }
  if (equalint (vtype->INTEGER_TYPE.size, 4)) {
  if (func->Kind == kPROC_OBJ) {
  if (equaltIdent (func->PROC_OBJ.Ident, MakeIdent ("MINVAL", 6))) {
# line 232 "Reductions.puma"
  {
# line 233 "Reductions.puma"
 t = mCONST_EXP (mINT_CONSTANT (2147483647));
     t = mASSIGN_STMT (var, t);
     t = mACF_BASIC (t);

  }
   return t;

  }
  }
  }
  if (equalint (vtype->INTEGER_TYPE.size, 4)) {
  if (func->Kind == kPROC_OBJ) {
  if (equaltIdent (func->PROC_OBJ.Ident, MakeIdent ("IALL", 4))) {
# line 240 "Reductions.puma"
  {
# line 241 "Reductions.puma"
 t = mCONST_EXP (mINT_CONSTANT (-1));
     t = mASSIGN_STMT (var, t);
     t = mACF_BASIC (t);

  }
   return t;

  }
  }
  }
  if (equalint (vtype->INTEGER_TYPE.size, 4)) {
  if (func->Kind == kPROC_OBJ) {
  if (equaltIdent (func->PROC_OBJ.Ident, MakeIdent ("IANY", 4))) {
# line 248 "Reductions.puma"
  {
# line 249 "Reductions.puma"
 t = mCONST_EXP (mINT_CONSTANT (0));
     t = mASSIGN_STMT (var, t);
     t = mACF_BASIC (t);

  }
   return t;

  }
  }
  }
  if (equalint (vtype->INTEGER_TYPE.size, 4)) {
  if (func->Kind == kPROC_OBJ) {
  if (equaltIdent (func->PROC_OBJ.Ident, MakeIdent ("IPARITY", 7))) {
# line 256 "Reductions.puma"
  {
# line 257 "Reductions.puma"
 t = mCONST_EXP (mINT_CONSTANT (0));
     t = mASSIGN_STMT (var, t);
     t = mACF_BASIC (t);

  }
   return t;

  }
  }
  }
  }
  if (vtype->Kind == kREAL_TYPE) {
  if (equalint (vtype->REAL_TYPE.size, 4)) {
  if (func->Kind == kPROC_OBJ) {
  if (equaltIdent (func->PROC_OBJ.Ident, MakeIdent ("SUM", 3))) {
# line 264 "Reductions.puma"
  {
# line 265 "Reductions.puma"
 t = mCONST_EXP (mREAL_CONSTANT (PutString("0.0",3)));
     t = mASSIGN_STMT (var, t);
     t = mACF_BASIC (t);

  }
   return t;

  }
  }
  }
  if (equalint (vtype->REAL_TYPE.size, 4)) {
  if (func->Kind == kPROC_OBJ) {
  if (equaltIdent (func->PROC_OBJ.Ident, MakeIdent ("PRODUCT", 7))) {
# line 272 "Reductions.puma"
  {
# line 273 "Reductions.puma"
 t = mCONST_EXP (mREAL_CONSTANT (PutString("1.0",3)));
     t = mASSIGN_STMT (var, t);
     t = mACF_BASIC (t);

  }
   return t;

  }
  }
  }
  if (equalint (vtype->REAL_TYPE.size, 4)) {
  if (func->Kind == kPROC_OBJ) {
  if (equaltIdent (func->PROC_OBJ.Ident, MakeIdent ("MINVAL", 6))) {
# line 280 "Reductions.puma"
  {
# line 281 "Reductions.puma"
 t = mCONST_EXP (mREAL_CONSTANT (PutString("3.4028235E+38",13)));
     t = mASSIGN_STMT (var, t);
     t = mACF_BASIC (t);

  }
   return t;

  }
  }
  }
  if (equalint (vtype->REAL_TYPE.size, 4)) {
  if (func->Kind == kPROC_OBJ) {
  if (equaltIdent (func->PROC_OBJ.Ident, MakeIdent ("MAXVAL", 6))) {
# line 288 "Reductions.puma"
  {
# line 289 "Reductions.puma"
 t = mCONST_EXP (mREAL_CONSTANT (PutString("-3.4028235E+38",14)));
     t = mASSIGN_STMT (var, t);
     t = mACF_BASIC (t);

  }
   return t;

  }
  }
  }
  if (equalint (vtype->REAL_TYPE.size, 8)) {
  if (func->Kind == kPROC_OBJ) {
  if (equaltIdent (func->PROC_OBJ.Ident, MakeIdent ("SUM", 3))) {
# line 296 "Reductions.puma"
  {
# line 297 "Reductions.puma"
 t = mCONST_EXP (mDREAL_CONSTANT (PutString("0.0d0",5)));
     t = mASSIGN_STMT (var, t);
     t = mACF_BASIC (t);

  }
   return t;

  }
  }
  }
  if (equalint (vtype->REAL_TYPE.size, 8)) {
  if (func->Kind == kPROC_OBJ) {
  if (equaltIdent (func->PROC_OBJ.Ident, MakeIdent ("PRODUCT", 7))) {
# line 304 "Reductions.puma"
  {
# line 305 "Reductions.puma"
 t = mCONST_EXP (mDREAL_CONSTANT (PutString("1.0d0",5)));
     t = mASSIGN_STMT (var, t);
     t = mACF_BASIC (t);

  }
   return t;

  }
  }
  }
  if (equalint (vtype->REAL_TYPE.size, 8)) {
  if (func->Kind == kPROC_OBJ) {
  if (equaltIdent (func->PROC_OBJ.Ident, MakeIdent ("MINVAL", 6))) {
# line 312 "Reductions.puma"
  {
# line 313 "Reductions.puma"
 t = mCONST_EXP (mDREAL_CONSTANT (PutString("1.797693134862313E+308",22)));
     t = mASSIGN_STMT (var, t);
     t = mACF_BASIC (t);

  }
   return t;

  }
  }
  }
  if (equalint (vtype->REAL_TYPE.size, 8)) {
  if (func->Kind == kPROC_OBJ) {
  if (equaltIdent (func->PROC_OBJ.Ident, MakeIdent ("MAXVAL", 6))) {
# line 320 "Reductions.puma"
  {
# line 321 "Reductions.puma"
 t = mCONST_EXP (mDREAL_CONSTANT (PutString("-1.797693134862313E+308",23)));
     t = mASSIGN_STMT (var, t);
     t = mACF_BASIC (t);

  }
   return t;

  }
  }
  }
  }
  if (vtype->Kind == kCOMPLEX_TYPE) {
  if (equalint (vtype->COMPLEX_TYPE.size, 8)) {
  if (func->Kind == kPROC_OBJ) {
  if (equaltIdent (func->PROC_OBJ.Ident, MakeIdent ("SUM", 3))) {
# line 328 "Reductions.puma"
  {
# line 329 "Reductions.puma"
 t = mCONST_EXP (mCOMPLEX_CONSTANT (PutString("0.0",3),
                                        PutString("0.0",3)));
     t = mASSIGN_STMT (var, t);
     t = mACF_BASIC (t);

  }
   return t;

  }
  }
  }
  if (equalint (vtype->COMPLEX_TYPE.size, 8)) {
  if (func->Kind == kPROC_OBJ) {
  if (equaltIdent (func->PROC_OBJ.Ident, MakeIdent ("PRODUCT", 7))) {
# line 337 "Reductions.puma"
  {
# line 338 "Reductions.puma"
 t = mCONST_EXP (mCOMPLEX_CONSTANT (PutString("1.0",3),
                                        PutString("0.0",3)));
     t = mASSIGN_STMT (var, t);
     t = mACF_BASIC (t);

  }
   return t;

  }
  }
  }
  }
# line 346 "Reductions.puma"
  {
# line 347 "Reductions.puma"
   error_protocol ("Reductions : initial reduction statement failed");
# line 348 "Reductions.puma"
   printf ("Generate Initial Reduction Statement failed\n");
# line 349 "Reductions.puma"
   printf ("var = ");
# line 349 "Reductions.puma"
   FileUnparse (stdout, var);
# line 349 "Reductions.puma"
   printf ("\n");
# line 350 "Reductions.puma"
   printf ("vtype = ");
# line 350 "Reductions.puma"
   FileUnparse (stdout, vtype);
# line 350 "Reductions.puma"
   printf ("\n");
# line 351 "Reductions.puma"
   printf ("call = ");
# line 351 "Reductions.puma"
   FileUnparse (stdout, func);
# line 351 "Reductions.puma"
   printf ("\n");
# line 352 "Reductions.puma"
   kill_in_protocol ();
  }
   return NoTree;

}

tTree ResolveReduce
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_BASIC) {
  if (t->ACF_BASIC.BASIC_STMT->Kind == kREDUCE_STMT) {
  if (t->ACF_BASIC.BASIC_STMT->REDUCE_STMT.RED_PARAMS->Kind == kBTP_LIST) {
  if (t->ACF_BASIC.BASIC_STMT->REDUCE_STMT.RED_PARAMS->BTP_LIST.Elem->Kind == kVAR_PARAM) {
  if (t->ACF_BASIC.BASIC_STMT->REDUCE_STMT.RED_PARAMS->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (t->ACF_BASIC.BASIC_STMT->REDUCE_STMT.RED_PARAMS->BTP_LIST.Next->BTP_LIST.Elem->Kind == kVAR_PARAM) {
  if (t->ACF_BASIC.BASIC_STMT->REDUCE_STMT.RED_PARAMS->BTP_LIST.Next->BTP_LIST.Elem->VAR_PARAM.V->Kind == kADDR) {
# line 378 "Reductions.puma"
   return ResolveDoIt (t, t->ACF_BASIC.BASIC_STMT->REDUCE_STMT.RED_FUNC->PROC_OBJ.Ident, t->ACF_BASIC.BASIC_STMT->REDUCE_STMT.RED_PARAMS->BTP_LIST.Elem->VAR_PARAM.V, t->ACF_BASIC.BASIC_STMT->REDUCE_STMT.RED_PARAMS->BTP_LIST.Next->BTP_LIST.Elem->VAR_PARAM.
V->ADDR.E, LocationStmts (t->ACF_BASIC.BASIC_STMT->REDUCE_STMT.RED_PARAMS->BTP_LIST.Next->BTP_LIST.Next));

  }
# line 389 "Reductions.puma"
   return ResolveDoIt (t, t->ACF_BASIC.BASIC_STMT->REDUCE_STMT.RED_FUNC->PROC_OBJ.Ident, t->ACF_BASIC.BASIC_STMT->REDUCE_STMT.RED_PARAMS->BTP_LIST.Elem->VAR_PARAM.V, mVAR_EXP (t->ACF_BASIC.BASIC_STMT->REDUCE_STMT.RED_PARAMS->BTP_LIST.Next->BTP_LIST.Elem->
VAR_PARAM.V), LocationStmts (t->ACF_BASIC.BASIC_STMT->REDUCE_STMT.RED_PARAMS->BTP_LIST.Next->BTP_LIST.Next));

  }
  }
  }
  }
  }
  }
# line 399 "Reductions.puma"
  {
# line 400 "Reductions.puma"
   printf ("ResolveReduce failed\n");
# line 401 "Reductions.puma"
   WriteTree (stdout, t);
# line 402 "Reductions.puma"
   FileUnparse (stdout, t);
# line 403 "Reductions.puma"
   kill_in_protocol ();
  }
   return NoTree;

}

static tTree ResolveDoIt
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tIdent func, register tTree var, register tTree exp, register tTree other_stmts)
# else
(t, func, var, exp, other_stmts)
 register tTree t;
 register tIdent func;
 register tTree var;
 register tTree exp;
 register tTree other_stmts;
# endif
{
# line 410 "Reductions.puma"

tTree stmt, cond;

  if (t->Kind == kACF_BASIC) {
  if (equaltIdent (func, MakeIdent ("COUNT", 5))) {
# line 414 "Reductions.puma"
  {
# line 416 "Reductions.puma"
 stmt = mCONST_EXP(mINT_CONSTANT(1));
      stmt = mOP_EXP (mOP_PLUS(), mVAR_EXP (var), stmt);
      t->ACF_BASIC.BASIC_STMT = mASSIGN_STMT (var, stmt);

      stmt = mACF_LIST (t, mACF_EMPTY());
      stmt = mACF_IF (exp, stmt, mACF_EMPTY ());

  }
   return stmt;

  }
  if (equaltIdent (func, MakeIdent ("ANY", 3))) {
# line 426 "Reductions.puma"
  {
# line 428 "Reductions.puma"
 stmt = mOP_EXP (mOP_OR(), mVAR_EXP (var), exp);
      t->ACF_BASIC.BASIC_STMT = mASSIGN_STMT (CopyTree(var), stmt);

  }
   return t;

  }
  if (equaltIdent (func, MakeIdent ("PARITY", 6))) {
# line 434 "Reductions.puma"
  {
# line 436 "Reductions.puma"
 stmt = mOP_EXP (mOP_NEQV (), mVAR_EXP (var), exp);
      t->ACF_BASIC.BASIC_STMT = mASSIGN_STMT (CopyTree(var), stmt);

  }
   return t;

  }
  if (equaltIdent (func, MakeIdent ("ALL", 3))) {
# line 442 "Reductions.puma"
  {
# line 444 "Reductions.puma"
 stmt = mOP_EXP (mOP_AND(), mVAR_EXP (var), exp);
      t->ACF_BASIC.BASIC_STMT = mASSIGN_STMT (CopyTree(var), stmt);

  }
   return t;

  }
  if (equaltIdent (func, MakeIdent ("SUM", 3))) {
# line 450 "Reductions.puma"
  {
# line 452 "Reductions.puma"
 stmt = mOP_EXP (mOP_PLUS(), mVAR_EXP (var), exp);
      t->ACF_BASIC.BASIC_STMT = mASSIGN_STMT (CopyTree(var), stmt);

  }
   return t;

  }
  if (equaltIdent (func, MakeIdent ("PRODUCT", 7))) {
# line 458 "Reductions.puma"
  {
# line 460 "Reductions.puma"
 stmt = mOP_EXP (mOP_TIMES(), mVAR_EXP (var), exp);
      t->ACF_BASIC.BASIC_STMT = mASSIGN_STMT (CopyTree(var), stmt);

  }
   return t;

  }
  if (equaltIdent (func, MakeIdent ("IALL", 4))) {
# line 466 "Reductions.puma"
  {
# line 468 "Reductions.puma"
 t->ACF_BASIC.BASIC_STMT = MakeIntrRedCall (MakeIdent ("IAND",4), var, exp);
  }
   return t;

  }
  if (equaltIdent (func, MakeIdent ("IANY", 4))) {
# line 472 "Reductions.puma"
  {
# line 474 "Reductions.puma"
 t->ACF_BASIC.BASIC_STMT = MakeIntrRedCall (MakeIdent ("IOR",3), var, exp);
  }
   return t;

  }
  if (equaltIdent (func, MakeIdent ("IPARITY", 7))) {
# line 478 "Reductions.puma"
  {
# line 480 "Reductions.puma"
 t->ACF_BASIC.BASIC_STMT = MakeIntrRedCall (MakeIdent ("IEOR",4), var, exp);
  }
   return t;

  }
  if (equaltIdent (func, MakeIdent ("MINVAL", 6))) {
# line 484 "Reductions.puma"
  {
# line 486 "Reductions.puma"
 cond = mOP_EXP (mOP_LT(), exp, mVAR_EXP (var));
      t->ACF_BASIC.BASIC_STMT = mASSIGN_STMT (CopyTree(var), CopyTree(exp));

      stmt = mACF_LIST (t, other_stmts);
      stmt = mACF_IF (cond, stmt, mACF_EMPTY ());

  }
   return stmt;

  }
  if (equaltIdent (func, MakeIdent ("MAXVAL", 6))) {
# line 495 "Reductions.puma"
  {
# line 497 "Reductions.puma"
 cond = mOP_EXP (mOP_GT(), exp, mVAR_EXP (var));
      t->ACF_BASIC.BASIC_STMT = mASSIGN_STMT (CopyTree(var), CopyTree(exp));

      stmt = mACF_LIST (t, other_stmts);
      stmt = mACF_IF (cond, stmt, mACF_EMPTY ());

  }
   return stmt;

  }
  }
# line 506 "Reductions.puma"
  {
# line 507 "Reductions.puma"
   printf ("Reductions: ResolveReduce failed\n");
# line 508 "Reductions.puma"
   FileUnparse (stdout, t);
# line 509 "Reductions.puma"
   kill_in_protocol ();
  }
   return NoTree;

}

static tTree MakeIntrRedCall
# if defined __STDC__ | defined __cplusplus
(register tIdent fname, register tTree var, register tTree exp)
# else
(fname, var, exp)
 register tIdent fname;
 register tTree var;
 register tTree exp;
# endif
{
# line 521 "Reductions.puma"
 {
  tTree p;
  tTree f;
  {
# line 523 "Reductions.puma"

# line 524 "Reductions.puma"

# line 526 "Reductions.puma"
 p = mBTP_EMPTY ();
      p = mBTP_LIST (ExpToVarParam (exp), p);
      p = mBTP_LIST (mVAR_PARAM (var), p);
      f = mPROC_OBJ (fname);
      f -> PROC_OBJ.Object = GetDeclEntry (fname, GetIntrinsicEntries ());
      f = mFUNC_CALL_EXP (f, p);
      f = mASSIGN_STMT (CopyTree (var), f);

  }
  {
   return f;
  }
 }

}

static tTree LocationStmts
# if defined __STDC__ | defined __cplusplus
(register tTree params)
# else
(params)
 register tTree params;
# endif
{
# line 549 "Reductions.puma"

tTree stmt;

  if (params->Kind == kBTP_EMPTY) {
# line 553 "Reductions.puma"
   return mACF_EMPTY ();

  }
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Elem->Kind == kVAR_PARAM) {
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Elem->Kind == kVAR_PARAM) {
  if (params->BTP_LIST.Next->BTP_LIST.Elem->VAR_PARAM.V->Kind == kADDR) {
# line 557 "Reductions.puma"
  {
# line 558 "Reductions.puma"
 stmt = mASSIGN_STMT (params->BTP_LIST.Elem->VAR_PARAM.V, params->BTP_LIST.Next->BTP_LIST.Elem->VAR_PARAM.V->ADDR.E);
      stmt = mACF_BASIC (stmt);

  }
   return mACF_LIST (stmt, LocationStmts (params->BTP_LIST.Next->BTP_LIST.Next));

  }
# line 564 "Reductions.puma"
  {
# line 565 "Reductions.puma"
 stmt = mASSIGN_STMT (params->BTP_LIST.Elem->VAR_PARAM.V, mVAR_EXP (params->BTP_LIST.Next->BTP_LIST.Elem->VAR_PARAM.V));
      stmt = mACF_BASIC (stmt);

  }
   return mACF_LIST (stmt, LocationStmts (params->BTP_LIST.Next->BTP_LIST.Next));

  }
  }
  }
  }
 yyAbort ("LocationStmts");
}

static int GetGlobalOp
# if defined __STDC__ | defined __cplusplus
(register tTree type, register tIdent redfunc)
# else
(type, redfunc)
 register tTree type;
 register tIdent redfunc;
# endif
{
  if (type->Kind == kBOOLEAN_TYPE) {
  if (equalint (type->BOOLEAN_TYPE.size, 4)) {
  if (equaltIdent (redfunc, MakeIdent ("ANY", 3))) {
# line 581 "Reductions.puma"
   return 17;

  }
  }
  if (equalint (type->BOOLEAN_TYPE.size, 4)) {
  if (equaltIdent (redfunc, MakeIdent ("ALL", 3))) {
# line 583 "Reductions.puma"
   return 16;

  }
  }
  if (equalint (type->BOOLEAN_TYPE.size, 4)) {
  if (equaltIdent (redfunc, MakeIdent ("PARITY", 6))) {
# line 585 "Reductions.puma"
   return 18;

  }
  }
  }
  if (type->Kind == kINTEGER_TYPE) {
  if (equalint (type->INTEGER_TYPE.size, 4)) {
  if (equaltIdent (redfunc, MakeIdent ("SUM", 3))) {
# line 587 "Reductions.puma"
   return 7;

  }
  }
  if (equalint (type->INTEGER_TYPE.size, 4)) {
  if (equaltIdent (redfunc, MakeIdent ("PRODUCT", 7))) {
# line 589 "Reductions.puma"
   return 10;

  }
  }
  if (equalint (type->INTEGER_TYPE.size, 4)) {
  if (equaltIdent (redfunc, MakeIdent ("MINVAL", 6))) {
# line 591 "Reductions.puma"
   return 1;

  }
  }
  if (equalint (type->INTEGER_TYPE.size, 4)) {
  if (equaltIdent (redfunc, MakeIdent ("MAXVAL", 6))) {
# line 593 "Reductions.puma"
   return 4;

  }
  }
  if (equalint (type->INTEGER_TYPE.size, 4)) {
  if (equaltIdent (redfunc, MakeIdent ("IALL", 4))) {
# line 595 "Reductions.puma"
   return 13;

  }
  }
  if (equalint (type->INTEGER_TYPE.size, 4)) {
  if (equaltIdent (redfunc, MakeIdent ("IANY", 4))) {
# line 597 "Reductions.puma"
   return 14;

  }
  }
  if (equalint (type->INTEGER_TYPE.size, 4)) {
  if (equaltIdent (redfunc, MakeIdent ("IPARITY", 7))) {
# line 599 "Reductions.puma"
   return 15;

  }
  }
  if (equalint (type->INTEGER_TYPE.size, 4)) {
  if (equaltIdent (redfunc, MakeIdent ("COUNT", 5))) {
# line 601 "Reductions.puma"
   return 7;

  }
  }
  }
  if (type->Kind == kREAL_TYPE) {
  if (equalint (type->REAL_TYPE.size, 4)) {
  if (equaltIdent (redfunc, MakeIdent ("SUM", 3))) {
# line 603 "Reductions.puma"
   return 8;

  }
  }
  if (equalint (type->REAL_TYPE.size, 4)) {
  if (equaltIdent (redfunc, MakeIdent ("PRODUCT", 7))) {
# line 605 "Reductions.puma"
   return 11;

  }
  }
  if (equalint (type->REAL_TYPE.size, 4)) {
  if (equaltIdent (redfunc, MakeIdent ("MINVAL", 6))) {
# line 607 "Reductions.puma"
   return 2;

  }
  }
  if (equalint (type->REAL_TYPE.size, 4)) {
  if (equaltIdent (redfunc, MakeIdent ("MAXVAL", 6))) {
# line 609 "Reductions.puma"
   return 5;

  }
  }
  if (equalint (type->REAL_TYPE.size, 8)) {
  if (equaltIdent (redfunc, MakeIdent ("SUM", 3))) {
# line 611 "Reductions.puma"
   return 9;

  }
  }
  if (equalint (type->REAL_TYPE.size, 8)) {
  if (equaltIdent (redfunc, MakeIdent ("PRODUCT", 7))) {
# line 613 "Reductions.puma"
   return 12;

  }
  }
  if (equalint (type->REAL_TYPE.size, 8)) {
  if (equaltIdent (redfunc, MakeIdent ("MINVAL", 6))) {
# line 615 "Reductions.puma"
   return 3;

  }
  }
  if (equalint (type->REAL_TYPE.size, 8)) {
  if (equaltIdent (redfunc, MakeIdent ("MAXVAL", 6))) {
# line 617 "Reductions.puma"
   return 6;

  }
  }
  }
  if (type->Kind == kCOMPLEX_TYPE) {
  if (equalint (type->COMPLEX_TYPE.size, 8)) {
  if (equaltIdent (redfunc, MakeIdent ("SUM", 3))) {
# line 619 "Reductions.puma"
   return 19;

  }
  }
  }
# line 621 "Reductions.puma"
  {
# line 622 "Reductions.puma"
   error_protocol ("This reduction is not handled within ADAPTOR");
# line 623 "Reductions.puma"
   tree_protocol ("type is ", type);
  }
   return - 1;

}

void BeginReductions ()
{
}

void CloseReductions ()
{
}
