/* $Id: Errors.c,v 2.6 1992/06/23 12:33:51 grosch rel $ */

# include "Errors.h"
# include "Parser.h"
# include <stdio.h>

# ifdef __cplusplus
extern "C" {
#  include "Sets.h"
}
#  include <stdlib.h>
# else
#  include "Sets.h"
#  ifdef __STDC__
#   include <stdlib.h>
#  else
    extern void exit ();
#  endif
# endif

static void WriteTokenSet
# if defined __STDC__ | defined __cplusplus
   (FILE * yyf, tSet * yys)
# else
   (yyf, yys) FILE * yyf; tSet * yys;
# endif
{
   int yyi;
   for (yyi = 0; yyi <= xxMaxToken; yyi ++)
      if (IsElement (yyi, yys)) (void) fprintf (yyf, "%s ", xxTokenName [yyi]);
}

static void WriteErrorMessage
# if defined __STDC__ | defined __cplusplus
   (short yyErrorCode, short yyErrorClass, tPosition yyPosition)
# else
   (yyErrorCode, yyErrorClass, yyPosition) short yyErrorCode, yyErrorClass; tPosition yyPosition;
# endif
{
   (void) fprintf (stderr, "%3d, %2d: ", yyPosition.Line, yyPosition.Column);

   switch (yyErrorClass) {
   case yyFatal		: (void) fprintf (stderr, "Fatal       "); break;
   case yyRestriction	: (void) fprintf (stderr, "Restriction "); break;
   case yyError		: (void) fprintf (stderr, "Error       "); break;
   case yyWarning	: (void) fprintf (stderr, "Warning     "); break;
   case yyRepair	: (void) fprintf (stderr, "Repair      "); break;
   case yyNote		: (void) fprintf (stderr, "Note        "); break;
   case yyInformation	: (void) fprintf (stderr, "Information "); break;
   default		: (void) fprintf (stderr, "Error class %d ", yyErrorClass);
   }

   switch (yyErrorCode) {
   case yyNoText	: break;
   case yySyntaxError	: (void) fprintf (stderr, "syntax error"	); break;
   case yyExpectedTokens: (void) fprintf (stderr, "expected tokens"	); break;
   case yyRestartPoint	: (void) fprintf (stderr, "restart point"	); break;
   case yyTokenInserted	: (void) fprintf (stderr, "token inserted "	); break;
   default		: (void) fprintf (stderr, "error code %d", yyErrorCode);
   }
}

static void WriteInfo
# if defined __STDC__ | defined __cplusplus
   (short yyInfoClass, char * yyInfo)
# else
   (yyInfoClass, yyInfo) short yyInfoClass; char * yyInfo;
# endif
{
   if (yyInfoClass == yyNone) return;
   (void) fprintf (stderr, ": ");
   switch (yyInfoClass) {
   case yyInteger	: (void) fprintf (stderr, "%d", * (int *)	yyInfo); break;
   case yyShort		: (void) fprintf (stderr, "%d", * (short *)	yyInfo); break;
   case yySet		: WriteSet	 (stderr, (tSet *)		yyInfo); break;
   case yyToken		: (void) fprintf (stderr, "%s", xxTokenName [* (short *) yyInfo]); break;
   case yyTokenSet	: WriteTokenSet  (stderr, (tSet *)		yyInfo); break;
   case yyString	: (void) fprintf (stderr, "%s",			yyInfo); break;
   default		: (void) fprintf (stderr, "info class: %d", yyInfoClass);
   }
}

void ErrorMessageI
# if defined __STDC__ | defined __cplusplus
   (short yyErrorCode, short yyErrorClass, tPosition yyPosition, short yyInfoClass, char * yyInfo)
# else
   (yyErrorCode, yyErrorClass, yyPosition, yyInfoClass, yyInfo)
   short	yyErrorCode, yyErrorClass;
   tPosition	yyPosition;
   short	yyInfoClass;
   char *	yyInfo;
# endif
{
   WriteErrorMessage (yyErrorCode, yyErrorClass, yyPosition);
   WriteInfo (yyInfoClass, yyInfo);
   (void) fprintf (stderr, "\n");
   if (yyErrorClass == yyFatal) exit (1);
}

void ErrorMessage
# if defined __STDC__ | defined __cplusplus
   (short yyErrorCode, short yyErrorClass, tPosition yyPosition)
# else
   (yyErrorCode, yyErrorClass, yyPosition) short yyErrorCode, yyErrorClass; tPosition yyPosition;
# endif
{
   ErrorMessageI (yyErrorCode, yyErrorClass, yyPosition, yyNone, (char *) NULL);
}
