# include "F77.h"
# include "yyAF77.w"
# include <stdio.h>
# if defined __STDC__ | defined __cplusplus
#  include <stdlib.h>
# else
   extern void exit ();
# endif
# include "Tree.h"
# include "Definiti.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 35 "AdaptF77.puma"

# include <stdio.h>
# include "Idents.h"
# include "StringMe.h"

# include "protocol.h"

# include "Types.h"
# include "Transfor.h"    /* AppendDECLS */
# include "Shapes.h"

# include "TempScal.h"  /* MakeNewLoopVar */

# include "Expressi.h"
# include "Reductio.h"

# include "IndexSha.h"  /* FindShapeExp */

# undef DEBUG

tObject loop_var_objs [10];  /* decl entries for new loop variables   */

       /***************************************
       *                                      *
       *  split_shape :     dim  = d          *
       *                                      *
       *                                      *
       *   ug1:og1:str1                       *
       *   ....                               *
       *   ugd:ogd:strd   -> move to s1       *
       *   ....                               *
       *   ugn:ogn:strn                       *
       *                                      *
       ***************************************/

void split_shape (s, s1, dim)
shape s, s1;
int dim;
{ int i, j;

  if ((dim < 1) || (dim > s->rank))
     { printf ("Illegal shape - dim in split_shape\n");
       exit (-1);
     }

  /* set up one-dimensional shape for reduction loop */

  s1->rank = 1;
  for (i = 0; i < 3; i ++)
    s1->bounds[0][i] = s->bounds[dim-1][i];
  s1->perm[0] = s->perm[dim-1];

  /* reduced shape back in s */

  for (j = 0; j < s->rank; j ++)
    if (j >= dim)
      for (i = 0; i < 3; i++)
        { s->bounds[j-1][i] = s->bounds[j][i];
          s->perm[j-1] = s->perm[j];
        }

  s->rank = s->rank - 1;

} /* split_shape */



static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module AdaptF77, routine %s failed\n", yyFunction);
 exit (1);
}

tTree F77Where ARGS((tTree t));
void F77IO ARGS((tTree t));
tTree F77Assign ARGS((tTree t));
tTree F77Reduction ARGS((tTree var, tTree exp));
static void GetFormalShape ARGS((tTree t, shape s));
static void UpdateFormalShape ARGS((tTree indexes, shape s, int n));
static tTree SetActualShape ARGS((tTree t, shape s));
static tTree SetSpreadActualShape ARGS((tTree t, shape s));
static void SetActualIndexShape ARGS((tTree ind, shape s, int n));
static tTree MakeOuterLoops ARGS((shape s, tTree body, int k));
static tTree MakeListBody ARGS((tTree t));
static tTree MakeOuterImpliedLoops ARGS((shape s, tTree body));
static tTree MakeOuterImpliedLoopsV ARGS((shape s, tTree body));

tTree F77Where
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 110 "AdaptF77.puma"

struct_shape shp;
tTree newacf;

  if (t->Kind == kACF_WHERE) {
# line 115 "AdaptF77.puma"
  {
# line 116 "AdaptF77.puma"
 GetFormalShape (t->ACF_WHERE.WHERE_EXP, &shp);

     t->ACF_WHERE.WHERE_EXP = SetActualShape (t->ACF_WHERE.WHERE_EXP, &shp);
     t->ACF_WHERE.TRUE_PART = SetActualShape (t->ACF_WHERE.TRUE_PART, &shp);
     t->ACF_WHERE.FALSE_PART = SetActualShape (t->ACF_WHERE.FALSE_PART, &shp);

     newacf = mACF_IF (t->ACF_WHERE.WHERE_EXP, t->ACF_WHERE.TRUE_PART, t->ACF_WHERE.FALSE_PART);
     newacf->ACF_NODE.Line  = t->ACF_WHERE.Line;

     newacf = MakeOuterLoops (&shp, newacf,1);

  }
   return newacf;

  }
 yyAbort ("F77Where");
}

void F77IO
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 140 "AdaptF77.puma"

struct_shape shp;
tTree new;

  if (t == NoTree) return;
  if (t->Kind == kBTP_LIST) {
  if (t->BTP_LIST.Elem->Kind == kVAR_PARAM) {
  if (t->BTP_LIST.Elem->VAR_PARAM.V->Kind == kADDR) {
  if (t->BTP_LIST.Elem->VAR_PARAM.V->ADDR.E->Kind == kDO_EXP) {
# line 145 "AdaptF77.puma"
  {
# line 147 "AdaptF77.puma"
   F77IO (t->BTP_LIST.Next);
  }
   return;

  }
# line 153 "AdaptF77.puma"
  {
# line 154 "AdaptF77.puma"
 if (TreeRank (t->BTP_LIST.Elem->VAR_PARAM.V->ADDR.E) > 0)
       {
         GetFormalShape (t->BTP_LIST.Elem->VAR_PARAM.V->ADDR.E, &shp);
         new = SetActualShape (t->BTP_LIST.Elem->VAR_PARAM.V->ADDR.E, &shp);
         new = MakeOuterImpliedLoops (&shp, new);
         t->BTP_LIST.Elem->VAR_PARAM.V->ADDR.E = new;
       }
   F77IO (t->BTP_LIST.Next);

  }
   return;

  }
  if (t->BTP_LIST.Elem->VAR_PARAM.V->Kind == kDO_VAR) {
# line 149 "AdaptF77.puma"
  {
# line 152 "AdaptF77.puma"
   F77IO (t->BTP_LIST.Next);
  }

   return;

  }
  if (t->BTP_LIST.Elem->VAR_PARAM.V->Kind == kUSED_VAR) {
# line 164 "AdaptF77.puma"
  {
# line 169 "AdaptF77.puma"
   F77IO (t->BTP_LIST.Next);
  }

   return;

  }
# line 168 "AdaptF77.puma"
  {
# line 169 "AdaptF77.puma"
 if (TreeRank (t->BTP_LIST.Elem->VAR_PARAM.V) > 0)
       {
         GetFormalShape (t->BTP_LIST.Elem->VAR_PARAM.V, &shp);
         new = SetActualShape (t->BTP_LIST.Elem->VAR_PARAM.V, &shp);
         new = MakeOuterImpliedLoopsV (&shp, new);
         t->BTP_LIST.Elem->VAR_PARAM.V = new;
       }

  }
   return;

  }
  }
  if (t->Kind == kBTP_EMPTY) {
# line 179 "AdaptF77.puma"
   return;

  }
# line 182 "AdaptF77.puma"
  {
# line 183 "AdaptF77.puma"
   printf ("Illegal Tree in IOF77\n");
# line 184 "AdaptF77.puma"
   FileUnparse (stdout, t);
# line 185 "AdaptF77.puma"
   WriteTree (stdout, t);
# line 186 "AdaptF77.puma"
   exit (- 1);
  }
   return;

;
}

tTree F77Assign
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 191 "AdaptF77.puma"

struct_shape shp;
tTree new;

  if (t->Kind == kACF_BASIC) {
  if (t->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
# line 196 "AdaptF77.puma"
  {
# line 197 "AdaptF77.puma"

     GetFormalShape (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, &shp);
# ifdef DEBUG
     printf ("Call of F77 Assign\n"); FileUnparse (stdout, t);
     printf ("Here is the Actual shape of the lhs variable\n");
     PrintCurrentShape (&shp);
     printf ("Will actualize shape in var and exp\n");
# endif
     if (shp.rank > 0)
       {
         t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR = SetActualShape (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, &shp);
         t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP = SetActualShape (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP, &shp);
         new = MakeOuterLoops (&shp, t, 1);
         new->ACF_NODE.Line = t->ACF_BASIC.Line;
       }
     else
       new = t;

  }
   return new;

  }
  }
 yyAbort ("F77Assign");
}

tTree F77Reduction
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree exp)
# else
(var, exp)
 register tTree var;
 register tTree exp;
# endif
{
# line 230 "AdaptF77.puma"

tTree stmt, params;
struct_shape shp, shp_red;
tTree red_var;

  if (exp->Kind == kFUNC_CALL_EXP) {
  if (exp->FUNC_CALL_EXP.FUNC_PARAMS->Kind == kBTP_LIST) {
  if (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem->Kind == kVAR_PARAM) {
  if (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 258 "AdaptF77.puma"
 {
  bool found;
  int idim;
  {
# line 261 "AdaptF77.puma"

# line 262 "AdaptF77.puma"

# line 264 "AdaptF77.puma"
 GetIntConstValue (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->BTP_LIST.Elem, &found, &idim);
      if (!found)
       { error_protocol ("dim parameter of reduction unknown at compile time");
         idim = 1;
       }

      GetFormalShape (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem->VAR_PARAM.V, &shp);
      exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem->VAR_PARAM.V = SetActualShape (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem->VAR_PARAM.V, &shp);
      split_shape (&shp, &shp_red, idim);

      red_var = SetActualShape (var, &shp);

      params = mBTP_EMPTY ();
      params = mBTP_LIST (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem, params);
      params = mBTP_LIST (mVAR_PARAM (red_var), params);
      stmt   = mREDUCE_STMT (exp->FUNC_CALL_EXP.FUNC_ID, params);
      stmt   = mACF_BASIC (stmt);
      stmt   = MakeOuterLoops (&shp_red, stmt, 0);
      stmt   = mACF_LIST (stmt, mACF_EMPTY());
      stmt   = mACF_LIST (InitReductionStmt (CopyTree(red_var),
                                             TreeType(var),
                                             exp->FUNC_CALL_EXP.FUNC_ID),
                          stmt);
      stmt   = MakeOuterLoops (&shp, stmt, 0);

  }
  {
   return stmt;
  }
 }

  }
  }
  if (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 298 "AdaptF77.puma"
  {
# line 300 "AdaptF77.puma"

      GetFormalShape (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem->VAR_PARAM.V, &shp);
      exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem->VAR_PARAM.V = SetActualShape (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem->VAR_PARAM.V, &shp);
      params = mBTP_EMPTY();
      params = mBTP_LIST (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem, params);
      params = mBTP_LIST (mVAR_PARAM (var), params);
      stmt   = mREDUCE_STMT (exp->FUNC_CALL_EXP.FUNC_ID, params);
      stmt   = mACF_BASIC (stmt);
      stmt   = MakeOuterLoops (&shp, stmt, 0);
      stmt   = mACF_LIST (stmt, NoTree);
      stmt   = mACF_LIST (InitReductionStmt (CopyTree(var),
                                             TreeType(var),
                                             exp->FUNC_CALL_EXP.FUNC_ID),
                          stmt);


  }
   return stmt;

  }
  }
  }
# line 319 "AdaptF77.puma"
  {
# line 320 "AdaptF77.puma"
   error_protocol ("this kind of reduction is not handled");
  }
   return mACF_DUMMY ();

  }
 yyAbort ("F77Reduction");
}

static void GetFormalShape
# if defined __STDC__ | defined __cplusplus
(register tTree t, shape s)
# else
(t, s)
 register tTree t;
 shape s;
# endif
{
# line 339 "AdaptF77.puma"

int i;

  if (t == NoTree) return;

  switch (t->Kind) {
  case kOP_EXP:
# line 343 "AdaptF77.puma"
  {
# line 344 "AdaptF77.puma"
 GetFormalShape (t->OP_EXP.OPND1, s);
     if (s->rank == 0)
        GetFormalShape (t->OP_EXP.OPND2, s);

  }
   return;

  case kOP1_EXP:
# line 349 "AdaptF77.puma"
  {
# line 350 "AdaptF77.puma"
 GetFormalShape (t->OP1_EXP.OPND, s);

  }
   return;

  case kCONST_EXP:
# line 353 "AdaptF77.puma"
  {
# line 354 "AdaptF77.puma"
 s->rank = 0;

  }
   return;

  case kADDR:
# line 357 "AdaptF77.puma"
  {
# line 358 "AdaptF77.puma"
   GetFormalShape (t->ADDR.E, s);
  }
   return;

  case kARRAY_EXP:
  if (t->ARRAY_EXP.ELEMENTS->Kind == kBTE_LIST) {
  if (t->ARRAY_EXP.ELEMENTS->BTE_LIST.Elem->Kind == kSLICE_EXP) {
  if (t->ARRAY_EXP.ELEMENTS->BTE_LIST.Next->Kind == kBTE_EMPTY) {
# line 367 "AdaptF77.puma"
  {
# line 368 "AdaptF77.puma"

     s->rank = 1;
     s->bounds[0][0] = t->ARRAY_EXP.ELEMENTS->BTE_LIST.Elem->SLICE_EXP.START;
     s->bounds[0][1] = t->ARRAY_EXP.ELEMENTS->BTE_LIST.Elem->SLICE_EXP.STOP;
     s->bounds[0][2] = t->ARRAY_EXP.ELEMENTS->BTE_LIST.Elem->SLICE_EXP.INC;
     s->perm[0] = 1;

  }
   return;

  }
  }
  }
  break;
  case kFUNC_CALL_EXP:
  if (t->FUNC_CALL_EXP.FUNC_PARAMS->Kind == kBTP_LIST) {
  if (t->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem->Kind == kVAR_PARAM) {
# line 376 "AdaptF77.puma"
  {
# line 377 "AdaptF77.puma"

     s->rank = 0;
     if (IsIntrFunc (t))
      { if (IntrFuncKind1 (t->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident))
          {
            GetFormalShape (t->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem->VAR_PARAM.V, s);
          }
      }

  }
   return;

  }
  }
# line 388 "AdaptF77.puma"
  {
# line 389 "AdaptF77.puma"

     s->rank = 0;

  }
   return;

  case kVAR_EXP:
# line 393 "AdaptF77.puma"
  {
# line 394 "AdaptF77.puma"
   GetFormalShape (t->VAR_EXP.V, s);
  }
   return;

  case kUSED_VAR:
# line 403 "AdaptF77.puma"
  {
# line 404 "AdaptF77.puma"
 if (TreeRank (t) == 0)
        s->rank = 0;
       else
        { GetCurrentShape (t, s);

          for (i=0;i<s->rank;i++)
             s->perm[i] = i+1;
        }

  }
   return;

  case kINDEXED_VAR:
  if (t->INDEXED_VAR.IND_VAR->Kind == kUSED_VAR) {
# line 414 "AdaptF77.puma"
  {
# line 415 "AdaptF77.puma"
 GetCurrentShape (t->INDEXED_VAR.IND_VAR, s);
     s->rank = 0;
     UpdateFormalShape (t->INDEXED_VAR.IND_EXPS, s, 0);

  }
   return;

  }
  break;
  }

# line 420 "AdaptF77.puma"
  {
# line 421 "AdaptF77.puma"
   printf ("GetFormalShape failed\n");
# line 422 "AdaptF77.puma"
   FileUnparse (stdout, t);
# line 423 "AdaptF77.puma"
   WriteTree (stdout, t);
# line 424 "AdaptF77.puma"
   exit (- 1);
  }
   return;

;
}

static void UpdateFormalShape
# if defined __STDC__ | defined __cplusplus
(register tTree indexes, shape s, register int n)
# else
(indexes, s, n)
 register tTree indexes;
 shape s;
 register int n;
# endif
{
# line 441 "AdaptF77.puma"

int r, m;
struct_shape h_shp;

  if (indexes == NoTree) return;
  if (indexes->Kind == kBTE_LIST) {
  if (indexes->BTE_LIST.Elem->Kind == kSLICE_EXP) {
# line 446 "AdaptF77.puma"
  {
# line 448 "AdaptF77.puma"
 m = s->rank;
     if (indexes->BTE_LIST.Elem->SLICE_EXP.START->Kind != kDUMMY_EXP)
        s->bounds[m][0] = indexes->BTE_LIST.Elem->SLICE_EXP.START;
      else
        s->bounds[m][0] = s->bounds[n][0];
     if (indexes->BTE_LIST.Elem->SLICE_EXP.STOP->Kind != kDUMMY_EXP)
        s->bounds[m][1] = indexes->BTE_LIST.Elem->SLICE_EXP.STOP;
      else
        s->bounds[m][1] = s->bounds[n][1];
     if (indexes->BTE_LIST.Elem->SLICE_EXP.INC->Kind != kDUMMY_EXP)
        s->bounds[m][2] = indexes->BTE_LIST.Elem->SLICE_EXP.INC;
      else
        s->bounds[m][2] = s->bounds[n][2];
     s->perm[m] = m + 1;
     s->rank = m + 1;

# line 464 "AdaptF77.puma"
   UpdateFormalShape (indexes->BTE_LIST.Next, s, n + 1);
  }
   return;

  }
# line 467 "AdaptF77.puma"
  {
# line 469 "AdaptF77.puma"
 r = TreeRank(indexes->BTE_LIST.Elem);
     if (r > 0)
        {
          if (r == 1)
            { GetFormalShape (indexes->BTE_LIST.Elem, &h_shp);
              if (h_shp.rank != 1)
                 error_protocol ("unknown fatal error");
              m = s->rank;
              s->bounds[m][0] = h_shp.bounds[0][0];
              s->bounds[m][1] = h_shp.bounds[0][1];
              s->bounds[m][2] = h_shp.bounds[0][2];
              s->perm[m] = m+1;
              s->rank = m+1;
            }
           else
             error_protocol ("illegal rank in indirect addressing");
         }

# line 487 "AdaptF77.puma"
   UpdateFormalShape (indexes->BTE_LIST.Next, s, n + 1);
  }
   return;

  }
  if (indexes->Kind == kBTE_EMPTY) {
# line 490 "AdaptF77.puma"
   return;

  }
# line 493 "AdaptF77.puma"
  {
# line 494 "AdaptF77.puma"
   printf ("Illegal Tree in UpdateFormalShape\n");
# line 495 "AdaptF77.puma"
   WriteTree (stdout, indexes);
# line 496 "AdaptF77.puma"
   exit (- 1);
  }
   return;

;
}

static tTree SetActualShape
# if defined __STDC__ | defined __cplusplus
(register tTree t, shape s)
# else
(t, s)
 register tTree t;
 shape s;
# endif
{
# line 512 "AdaptF77.puma"

tTree newexp;


  switch (t->Kind) {
  case kACF_LIST:
# line 516 "AdaptF77.puma"
  {
# line 517 "AdaptF77.puma"
 t->ACF_LIST.Elem = SetActualShape (t->ACF_LIST.Elem, s);
     t->ACF_LIST.Next = SetActualShape (t->ACF_LIST.Next, s);
  }
   return t;

  case kACF_EMPTY:
# line 522 "AdaptF77.puma"
   return t;

  case kACF_BASIC:
# line 526 "AdaptF77.puma"
  {
# line 527 "AdaptF77.puma"
 t->ACF_BASIC.BASIC_STMT = SetActualShape (t->ACF_BASIC.BASIC_STMT, s);
  }
   return t;

  case kASSIGN_STMT:
# line 531 "AdaptF77.puma"
  {
# line 532 "AdaptF77.puma"
 t->ASSIGN_STMT.ASSIGN_VAR = SetActualShape (t->ASSIGN_STMT.ASSIGN_VAR, s);
     t->ASSIGN_STMT.ASSIGN_EXP = SetActualShape (t->ASSIGN_STMT.ASSIGN_EXP, s);
  }
   return t;

  case kOP_EXP:
# line 537 "AdaptF77.puma"
  {
# line 538 "AdaptF77.puma"
 t->OP_EXP.OPND1 = SetActualShape (t->OP_EXP.OPND1, s);
     t->OP_EXP.OPND2 = SetActualShape (t->OP_EXP.OPND2, s);
  }
   return t;

  case kOP1_EXP:
# line 543 "AdaptF77.puma"
  {
# line 544 "AdaptF77.puma"
 t->OP1_EXP.OPND = SetActualShape (t->OP1_EXP.OPND, s);
  }
   return t;

  case kCONST_EXP:
# line 548 "AdaptF77.puma"
   return t;

  case kARRAY_EXP:
  if (t->ARRAY_EXP.ELEMENTS->Kind == kBTE_LIST) {
  if (t->ARRAY_EXP.ELEMENTS->BTE_LIST.Elem->Kind == kSLICE_EXP) {
  if (t->ARRAY_EXP.ELEMENTS->BTE_LIST.Next->Kind == kBTE_EMPTY) {
# line 552 "AdaptF77.puma"
  {
# line 553 "AdaptF77.puma"
 if (s->rank != 1)
        { printf ("Illegal formal shape for current array expression\n");
          WriteTree (stdout, t);
          exit(-1);
        }
     newexp = mVAR_EXP (MakeNewLoopVar (s->perm[0]));

     newexp = FindShapeExp (t->ARRAY_EXP.ELEMENTS->BTE_LIST.Elem, s->bounds[0][0], s->bounds[0][1],
                               s->bounds[0][2], newexp );

  }
   return newexp;

  }
  }
  }
  break;
  case kFUNC_CALL_EXP:
# line 566 "AdaptF77.puma"
  {
# line 567 "AdaptF77.puma"

     newexp = t;
     if (IsIntrFunc (t))
      { if (IntrFuncKind1 (t->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident) ||
            IntrFuncKindn (t->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident) ||
            IntrFuncKind2 (t->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident) )
          {
            t->FUNC_CALL_EXP.FUNC_PARAMS = SetActualShape (t->FUNC_CALL_EXP.FUNC_PARAMS, s);
          }
         else if (t->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident == MakeIdent ("SPREAD", 6))
          newexp = SetSpreadActualShape (t->FUNC_CALL_EXP.FUNC_PARAMS, s);
         else
          error_protocol ("Illegal Intrinsic function for SetActualShape");
      }
     else
      error_protocol ("Illegal function call in SetActualShape");

  }
   return newexp;

  case kBTP_LIST:
# line 585 "AdaptF77.puma"
  {
# line 586 "AdaptF77.puma"
 t->BTP_LIST.Elem = SetActualShape (t->BTP_LIST.Elem, s);
     t->BTP_LIST.Next = SetActualShape (t->BTP_LIST.Next, s);

  }
   return t;

  case kBTP_EMPTY:
# line 592 "AdaptF77.puma"
   return t;

  case kVAR_PARAM:
# line 596 "AdaptF77.puma"
  {
# line 597 "AdaptF77.puma"
 t->VAR_PARAM.V = SetActualShape (t->VAR_PARAM.V, s);
  }
   return t;

  case kADDR:
# line 601 "AdaptF77.puma"
  {
# line 602 "AdaptF77.puma"
 t->ADDR.E = SetActualShape (t->ADDR.E, s);
  }
   return t;

  case kVAR_EXP:
# line 606 "AdaptF77.puma"
  {
# line 607 "AdaptF77.puma"
 t->VAR_EXP.V = SetActualShape (t->VAR_EXP.V, s);
  }
   return t;

  case kUSED_VAR:
# line 611 "AdaptF77.puma"
  {
# line 612 "AdaptF77.puma"
 if (TreeRank (t) > 0)
       {
         newexp = MakeFullShape (t);
         newexp = SetActualShape (newexp, s);
       }
     else
         newexp = t;

  }
   return newexp;

  case kLOOP_VAR:
# line 623 "AdaptF77.puma"
   return t;

  case kINDEXED_VAR:
# line 627 "AdaptF77.puma"
  {
# line 628 "AdaptF77.puma"
 newexp = MakeFullShape (t);
     SetActualIndexShape (t->INDEXED_VAR.IND_EXPS, s, 0);
  }
   return t;

  }

# line 633 "AdaptF77.puma"
  {
# line 634 "AdaptF77.puma"
   printf ("SetActualShape failed\n");
# line 635 "AdaptF77.puma"
   FileUnparse (stdout, t);
# line 636 "AdaptF77.puma"
   WriteTree (stdout, t);
# line 637 "AdaptF77.puma"
   exit (- 1);
  }
   return NoTree;

}

static tTree SetSpreadActualShape
# if defined __STDC__ | defined __cplusplus
(register tTree t, shape s)
# else
(t, s)
 register tTree t;
 shape s;
# endif
{
# line 643 "AdaptF77.puma"

int i, k, dimval;
bool found;
tTree newexp;
struct_shape h_shp;

  if (t->Kind == kBTP_LIST) {
  if (t->BTP_LIST.Elem->Kind == kVAR_PARAM) {
  if (t->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (t->BTP_LIST.Next->BTP_LIST.Elem->Kind == kVAR_PARAM) {
  if (t->BTP_LIST.Next->BTP_LIST.Elem->VAR_PARAM.V->Kind == kADDR) {
  if (t->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (t->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 650 "AdaptF77.puma"
  {
# line 654 "AdaptF77.puma"

    if (t->BTP_LIST.Elem->VAR_PARAM.V->Kind == kADDR)
         newexp = t->BTP_LIST.Elem->VAR_PARAM.V->ADDR.E;
      else
         newexp = mVAR_EXP (t->BTP_LIST.Elem->VAR_PARAM.V);
    GetIntConstValue (t->BTP_LIST.Next->BTP_LIST.Elem->VAR_PARAM.V->ADDR.E, &found, &dimval);
    if (!found)
       error_protocol ("DIM in SPREAD only at run-time");
     else if ((dimval <= 0) || (dimval > s->rank))
       error_protocol ("DIM in SPREAD out of range");
     else
       {
         h_shp.rank = s->rank-1;
         for (i=0;i<s->rank;i++)
           if (i != dimval-1)
               { k = i;
                 if (i>=dimval) k = i-1;
                 h_shp.bounds[k][0] = s->bounds[i][0];
                 h_shp.bounds[k][1] = s->bounds[i][1];
                 h_shp.bounds[k][2] = s->bounds[i][2];
                 h_shp.perm[k] = s->perm[i];
               }
         newexp = SetActualShape (newexp, &h_shp);
       }

  }
   return newexp;

  }
  }
  }
  }
  }
  }
  }
# line 683 "AdaptF77.puma"
  {
# line 684 "AdaptF77.puma"
   error_protocol ("illegal SPREAD for SetSpreadActualShape");
  }
   return t;

}

static void SetActualIndexShape
# if defined __STDC__ | defined __cplusplus
(register tTree ind, shape s, register int n)
# else
(ind, s, n)
 register tTree ind;
 shape s;
 register int n;
# endif
{
# line 690 "AdaptF77.puma"

int rank;
struct_shape h_shp;

  if (ind == NoTree) return;
  if (ind->Kind == kBTE_LIST) {
  if (ind->BTE_LIST.Elem->Kind == kSLICE_EXP) {
# line 695 "AdaptF77.puma"
 {
  tTree nexp;
  {
# line 697 "AdaptF77.puma"

# line 699 "AdaptF77.puma"
 nexp = mVAR_EXP (MakeNewLoopVar (s->perm[n]));

     ind->BTE_LIST.Elem = FindShapeExp (ind->BTE_LIST.Elem, s->bounds[n][0], s->bounds[n][1],
                               s->bounds[n][2], nexp);

     SetActualIndexShape (ind, s, n+1);

  }
   return;
 }

  }
# line 708 "AdaptF77.puma"
  {
# line 709 "AdaptF77.puma"
 rank = TreeRank (ind->BTE_LIST.Elem);
    if (rank > 0)
       {
         if (rank != 1)
           error_protocol ("wrong indirect addressing in SetActualIndexShape");
          else
           {
             h_shp.rank = 1;
             h_shp.bounds[0][0] = s->bounds[n][0];
             h_shp.bounds[0][1] = s->bounds[n][1];
             h_shp.bounds[0][2] = s->bounds[n][2];
             h_shp.perm [0]     = s->perm[n];
             ind->BTE_LIST.Elem = SetActualShape (ind->BTE_LIST.Elem, &h_shp);
           }
         SetActualIndexShape (ind->BTE_LIST.Next, s, n+1);
       }
     else
       SetActualIndexShape (ind->BTE_LIST.Next, s, n);

  }
   return;

  }
  if (ind->Kind == kBTE_EMPTY) {
# line 730 "AdaptF77.puma"
   return;

  }
# line 733 "AdaptF77.puma"
  {
# line 734 "AdaptF77.puma"
   printf ("SetActualIndexShape failed\n");
# line 735 "AdaptF77.puma"
   exit (- 1);
  }
   return;

;
}

static tTree MakeOuterLoops
# if defined __STDC__ | defined __cplusplus
(shape s, register tTree body, register int k)
# else
(s, body, k)
 shape s;
 register tTree body;
 register int k;
# endif
{
# line 750 "AdaptF77.puma"

tTree new, var, range;
int i;

# line 761 "AdaptF77.puma"
  {
# line 762 "AdaptF77.puma"
 new = body;
    for (i=0; i<s->rank; i++)
      {
        if (s->bounds[i][0] != s->bounds[i][1])
          {
            new = MakeListBody (new);
            var = MakeNewLoopVar (s->perm[i]);

            if (s->bounds[i][2] != NoTree)
                range = s->bounds[i][2];
              else
                range = mDUMMY_EXP();

            range = mSLICE_EXP (s->bounds[i][0],
                                s->bounds[i][1], range);
            new = mACF_DOLOCAL (var, range, new);
            if (k!=0) new->Kind = kACF_FORALL;
          }
      }

  }
   return new;

}

static tTree MakeListBody
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_LIST) {
# line 787 "AdaptF77.puma"
   return t;

  }
  if (t->Kind == kACF_EMPTY) {
# line 791 "AdaptF77.puma"
   return t;

  }
  if (Tree_IsType (t, kACF_NODE)) {
# line 795 "AdaptF77.puma"
   return mACF_LIST (t, mACF_EMPTY ());

  }
 yyAbort ("MakeListBody");
}

static tTree MakeOuterImpliedLoops
# if defined __STDC__ | defined __cplusplus
(shape s, register tTree body)
# else
(s, body)
 shape s;
 register tTree body;
# endif
{
# line 807 "AdaptF77.puma"

tTree new, var, range;
int i;

# line 812 "AdaptF77.puma"
  {
# line 813 "AdaptF77.puma"
 new = body;
    for (i=0; i<s->rank; i++)
      {
        if (s->bounds[i][0] != s->bounds[i][1])
          {
            new = mBTE_LIST (new, mBTE_EMPTY());
            var = MakeNewLoopVar (i+1);

            if (s->bounds[i][2] != NoTree)
                range = s->bounds[i][2];
              else
                range = mDUMMY_EXP();

            range = mSLICE_EXP (s->bounds[i][0],
                                s->bounds[i][1], range);
            new = mDO_EXP (var, range, new);
          }
      }

  }
   return new;

}

static tTree MakeOuterImpliedLoopsV
# if defined __STDC__ | defined __cplusplus
(shape s, register tTree body)
# else
(s, body)
 shape s;
 register tTree body;
# endif
{
# line 843 "AdaptF77.puma"

tTree new, var, range;
int i;

# line 848 "AdaptF77.puma"
  {
# line 849 "AdaptF77.puma"
 new = body;
    for (i=0; i<s->rank; i++)
      {
        if (s->bounds[i][0] != s->bounds[i][1])
          {
            new = mBTV_LIST (new, mBTV_EMPTY());
            var = MakeNewLoopVar (i+1);

            if (s->bounds[i][2] != NoTree)
                range = s->bounds[i][2];
              else
                range = mDUMMY_EXP();

            range = mSLICE_EXP (s->bounds[i][0],
                                s->bounds[i][1], range);
            new = mDO_VAR (var, range, new);
          }
      }

  }
   return new;

}

void BeginAdaptF77 ()
{
}

void CloseAdaptF77 ()
{
}
