      PROGRAM LAPLACE
      REAL F(:,:), DF(:,:), HF(:,:[1:1])
      INTEGER MAXX, MAXY
      REAL FMAX
      INTEGER ITER
c 
c     read in sizes 
c
      PRINT *,'MAXX = (z.B. 64) '
      READ *,MAXX
      PRINT *,'MAXY = (z.B. 64) '
      READ *,MAXY
      ALLOCATE (F(MAXX,MAXY), DF(MAXX,MAXY))
      ALLOCATE (HF(MAXX,MAXY))
C
!HPF$ INDEPENDENT, LOCAL_ACCESS
      do j = 1, maxy
!HPF$    INDEPENDENT, LOCAL_ACCESS
         do i = 1, maxx 
           if (j == maxy) then
              F(i,j) = 1.0
           else if (j == 1) then
              F(i,j) = 2.0
           else if ((i==1) .or. (i==maxx)) then
              F(i,j) = 2.0
           else
              F(i,j) = 0.0
           end if
         end do
      end do

      ITER = 0
      FMAX = 1
      DF = 0
      DO WHILE (FMAX .gt. 0.001)
         ITER = ITER + 1
c        print *, 'iter = ', iter
c        do i = 1, maxx
c           do j = 1, maxy
c              print *, 'f(',i,',',j,') = ',f(i,j)
c           end do
c        end do
         hf = f          ! communicate with overlap
c        do i = 1, maxx
c           do j = 1, maxy
c              print *, 'hf(',i,',',j,') = ', hf(i,j)
c           end do
c        end do
         forall (j=2:maxy-1,i=2:maxx-1)
             df(i,j) = (hf(i,j-1) + hf(i,j+1) + 
     $                  hf(i-1,j) + hf(i+1,j) ) * 0.25  - hf(i,j)
         end forall
!HPF$    INDEPENDENT, LOCAL_ACCESS
         do j = 2, maxy-1
!HPF$      INDEPENDENT, LOCAL_ACCESS
           do i = 2, maxx-1 
             f(i,j) = f(i,j) + df(i,j)
           end do
         end do
         DF = ABS(DF)
         FMAX = MAXVAL (DF)
         PRINT *,'Iteration ',ITER,'  Max = ',FMAX
      END DO
      PRINT *, ITER, ' Iterationen benoetigt'
      deallocate (hf, df, f)
      END 
 
