/**************************************************************************
*                                                                         *
*  Author      : Dr. Thomas Brandes, GMD, I1.HR                           *
*  Copyright   : GMD St. Augustin, Germany                                *
*  Date        : Aug 92                                                   *
*  Last Update : Aug 92                                                   *
*                                                                         *
*  This Module is part of the DALIB                                       *
*                                                                         *
*  Module      : hostnode1.c                                              *
*                                                                         *
*  Function    : Moving full arrays between host and nodes                *
*                                                                         *
*  Export :  FORTRAN Interface                                            *
*                                                                         *
**************************************************************************/

#undef DEBUG

#include "system.h"

     /*********************************************************
     *                                                        *
     *  HOSTARRAY = NODEARRAY (x1:y1)                         *
     *                                                        *
     *********************************************************/

void dalib_host_node1__ (a, size, N1, x1, y1)
unsigned char *a;
int *size;
int *N1, *x1, *y1;

{   int pid_low, pid_up, send_pid;
    int my_pid;
    unsigned char *a_ptr;

    int send_size;
    int low, up;

    my_pid = pcb.i;

#ifdef DEBUG
    printf ("Process %d calls host_node1 %d : %d\n", my_pid, *x1, *y1);
#endif

    /* pid_low : pid_up =  processors that own elements of this range */

    if (my_pid == 0)

      { /* HOST recvs the data */
        pid_low = dalib_where (*N1, *x1);
        pid_up  = dalib_where (*N1, *y1);

        a_ptr = a;

        for (send_pid = pid_low; send_pid <= pid_up; send_pid ++)

          { /* get range , size */

            dalib_local_extensions (send_pid, *N1, &low, &up);
            if (low < *x1) low = *x1;
            if (up  > *y1) up  = *y1;

            /* host gets a(low:up) from processor i */
            
            send_size = (up - low + 1) * *size;
            areceive (0, send_pid, a_ptr, send_size);
            a_ptr += send_size;
          }
      }

     else
      { /* look for data to send */

        dalib_local_slice__ (N1, x1, y1, &low, &up);
        if (low <= up)
          {  dalib_setup_section1 (*size, *N1, low, up);
             dalib_send_section1 (0, a);
          }
      }
} /* dalib_host_node1 */

     /*********************************************************
     *                                                        *
     *  NODEARRAY (x1:y1) = HOSTARRAY                         *
     *                                                        *
     *********************************************************/

void dalib_node_host1__ (a, size, N1, x1, y1)
unsigned char *a;
int *size;
int *N1, *x1, *y1;

{   int pid_low, pid_up, send_pid;
    int my_pid;
    unsigned char *a_ptr;

    int send_size;
    int low, up;

    my_pid = pcb.i;

#ifdef DEBUG
    printf ("Process %d calls node_host1 %d : %d\n", my_pid, *x1, *y1);
#endif

    /* pid_low : pid_up =  processors that own elements of this range */

    if (my_pid == 0)

      { /* HOST sends the data */
        pid_low = dalib_where (*N1, *x1);
        pid_up  = dalib_where (*N1, *y1);

        a_ptr = a;

        for (send_pid = pid_low; send_pid <= pid_up; send_pid++)

          { /* get range */

            dalib_local_extensions (send_pid, *N1, &low, &up);
            if (low < *x1) low = *x1;
            if (up  > *y1) up  = *y1;

            /* host sends a(low:up) to processor send_pid */
            
            send_size = (up - low + 1) * *size;
            asend (0, send_pid, a_ptr, send_size);
            a_ptr += send_size;
          }
      }

     else

      { /* look for data to recv */

        dalib_local_slice__ (N1, x1, y1, &low, &up);
        if (low <= up)
          {  dalib_setup_section1 (*size, *N1, low, up);
             dalib_recv_section1 (0, a);
          }
      }
} /* dalib_node_host1 */

     /*********************************************************
     *                                                        *
     *  HOSTARRAY = NODEARRAY (x1:y1,x2:y2)                   *
     *                                                        *
     *********************************************************/

void dalib_host_node2__ (a, size, N1, x1, y1, N2, x2, y2)
unsigned char *a;
int *size;
int *N1, *x1, *y1, *N2, *x2, *y2;

{   int pid_low, pid_up, send_pid;
    int my_pid;
    unsigned char *a_ptr;

    int send_size;
    int low, up;

    my_pid = pcb.i;

#ifdef DEBUG
    printf ("Process %d calls host_node2 %d : %d, %d : %d\n", 
             my_pid, *x1, *y1, *x2, *y2);
#endif

    /* pid_low : pid_up =  processors that own elements of this range */

    if (my_pid == 0)

      { /* HOST recvs the data */
        pid_low = dalib_where (*N2, *x2);
        pid_up  = dalib_where (*N2, *y2);

        a_ptr = a;

        for (send_pid = pid_low; send_pid <= pid_up; send_pid ++)

          { /* get range , size */

            dalib_local_extensions (send_pid, *N2, &low, &up);
            if (low < *x2) low = *x2;
            if (up  > *y2) up  = *y2;

            /* host gets a(low:up) from processor i */
            
            send_size = (up - low + 1) * (*y1 - *x1 + 1) * *size;
            areceive (0, send_pid, a_ptr, send_size);
            a_ptr += send_size;
          }
      }

     else
      { /* look for data to send */

        dalib_local_slice__ (N2, x2, y2, &low, &up);
        if (low <= up)
          {  dalib_setup_section2 (*size, *N1, *x1, *y1, *N2, low, up);
             dalib_send_section2 (0, a);
          }
      }
} /* dalib_host_node2 */

     /*********************************************************
     *                                                        *
     *  NODEARRAY (x1:y1,x2:y2) = HOSTARRAY                   *
     *                                                        *
     *********************************************************/

void dalib_node_host2__ (a, size, N1, x1, y1, N2, x2, y2)
unsigned char *a;
int *size;
int *N1, *x1, *y1, *N2, *x2, *y2;

{   int pid_low, pid_up, send_pid;
    int my_pid;
    unsigned char *a_ptr;

    int send_size;
    int low, up;

    my_pid = pcb.i;

#ifdef DEBUG
    printf ("Process %d calls node_host2 %d : %d, %d : %d\n", 
             my_pid, *x1, *y1, *x2, *y2);
#endif

    /* pid_low : pid_up =  processors that own elements of this range */

    if (my_pid == 0)

      { /* HOST sends the data */
        pid_low = dalib_where (*N2, *x2);
        pid_up  = dalib_where (*N2, *y2);

        a_ptr = a;

        for (send_pid = pid_low; send_pid <= pid_up; send_pid++)

          { /* get range */

            dalib_local_extensions (send_pid, *N2, &low, &up);
            if (low < *x2) low = *x2;
            if (up  > *y2) up  = *y2;

            /* host sends a(low:up) to processor send_pid */
            
            send_size = (up - low + 1) * (*y1 - *x1 + 1) * *size;
            asend (0, send_pid, a_ptr, send_size);
            a_ptr += send_size;
          }
      }

     else

      { /* look for data to recv */

        dalib_local_slice__ (N2, x2, y2, &low, &up);
        if (low <= up)
          {  dalib_setup_section2 (*size, *N1, *x1, *y1, *N2, low, up);
             dalib_recv_section2 (0, a);
          }
      }
} /* dalib_node_host2 */

     /*********************************************************
     *                                                        *
     *  HOSTARRAY = NODEARRAY (x1:y1,x2:y2,x3:y3)             *
     *                                                        *
     *********************************************************/

void dalib_host_node3__ (a, size, N1, x1, y1, N2, x2, y2, N3, x3, y3)
unsigned char *a;
int *size;
int *N1, *x1, *y1, *N2, *x2, *y2, *N3, *x3, *y3;

{   int pid_low, pid_up, send_pid;
    int my_pid;
    unsigned char *a_ptr;

    int send_size;
    int low, up;

    my_pid = pcb.i;

#ifdef DEBUG
    printf ("Process %d calls host_node3 %d : %d, %d : %d, %d : %d\n", 
             my_pid, *x1, *y1, *x2, *y2, *x3, *y3);
#endif

    /* pid_low : pid_up =  processors that own elements of this range */

    if (my_pid == 0)

      { /* HOST recvs the data */
        pid_low = dalib_where (*N3, *x3);
        pid_up  = dalib_where (*N3, *y3);

        a_ptr = a;

        for (send_pid = pid_low; send_pid <= pid_up; send_pid ++)

          { /* get range , size */

            dalib_local_extensions (send_pid, *N3, &low, &up);
            if (low < *x3) low = *x3;
            if (up  > *y3) up  = *y3;

            /* host gets a(low:up) from processor i */
            
            send_size = (up - low + 1) * (*y1 - *x1 + 1) * 
                        (*y2 - *x2 + 1) * *size;
            areceive (0, send_pid, a_ptr, send_size);
            a_ptr += send_size;
          }
      }

     else
      { /* look for data to send */

        dalib_local_slice__ (N3, x3, y3, &low, &up);
        if (low <= up)
          {  dalib_setup_section3 (*size, *N1, *x1, *y1, *N2, *x2, *y2,
                                          *N3, low, up);
             dalib_send_section3 (0, a);
          }
      }
} /* dalib_host_node3 */

     /*********************************************************
     *                                                        *
     *  NODEARRAY (x1:y1,x2:y2,x3:y3) = HOSTARRAY             *
     *                                                        *
     *********************************************************/

void dalib_node_host3__ (a, size, N1, x1, y1, N2, x2, y2, N3, x3, y3)
unsigned char *a;
int *size;
int *N1, *x1, *y1, *N2, *x2, *y2, *N3, *x3, *y3;

{   int pid_low, pid_up, send_pid;
    int my_pid;
    unsigned char *a_ptr;

    int send_size;
    int low, up;

    my_pid = pcb.i;

#ifdef DEBUG
    printf ("Process %d calls node_host3 %d : %d, %d : %d, %d : %d\n", 
             my_pid, *x1, *y1, *x2, *y2, *x3, *y3);
#endif

    /* pid_low : pid_up =  processors that own elements of this range */

    if (my_pid == 0)

      { /* HOST sends the data */
        pid_low = dalib_where (*N3, *x3);
        pid_up  = dalib_where (*N3, *y3);

        a_ptr = a;

        for (send_pid = pid_low; send_pid <= pid_up; send_pid++)

          { /* get range */

            dalib_local_extensions (send_pid, *N3, &low, &up);
            if (low < *x3) low = *x3;
            if (up  > *y3) up  = *y3;

            /* host sends a(low:up) to processor send_pid */
            
            send_size = (up - low + 1)  * (*y1 - *x1 + 1) * 
                        (*y2 - *x2 + 1) * *size;
            asend (0, send_pid, a_ptr, send_size);
            a_ptr += send_size;
          }
      }

     else

      { /* look for data to recv */

        dalib_local_slice__ (N3, x3, y3, &low, &up);
        if (low <= up)
          {  dalib_setup_section3 (*size, *N1, *x1, *y1, *N2, *x2, *y2,
                                          *N3, low, up);
             dalib_recv_section3 (0, a);
          }
      }
} /* dalib_node_host3 */

     /*********************************************************
     *                                                        *
     *  HOSTARRAY = NODEARRAY (x1:y1,x2:y2,x3:y3,x4:y4)       *
     *                                                        *
     *********************************************************/

void dalib_host_node4__ (a, size, N1, x1, y1, N2, x2, y2, N3, x3, y3, N4, x4, y4)
unsigned char *a;
int *size;
int *N1, *x1, *y1, *N2, *x2, *y2, *N3, *x3, *y3, *N4, *x4, *y4;

{   int pid_low, pid_up, send_pid;
    int my_pid;
    unsigned char *a_ptr;

    int send_size;
    int low, up;

    my_pid = pcb.i;

#ifdef DEBUG
    printf ("Process %d calls host_node4 %d : %d, %d : %d, %d : %d, %d : %d\n", 
             my_pid, *x1, *y1, *x2, *y2, *x3, *y3, *x4, *y4);
#endif

    /* pid_low : pid_up =  processors that own elements of this range */

    if (my_pid == 0)

      { /* HOST recvs the data */
        pid_low = dalib_where (*N4, *x4);
        pid_up  = dalib_where (*N4, *y4);

        a_ptr = a;

        for (send_pid = pid_low; send_pid <= pid_up; send_pid ++)

          { /* get range , size */

            dalib_local_extensions (send_pid, *N4, &low, &up);
            if (low < *x4) low = *x4;
            if (up  > *y4) up  = *y4;

            /* host gets a(low:up) from processor i */
            
            send_size = (up - low + 1) * (*y1 - *x1 + 1) * 
                        (*y2 - *x2 + 1) * (*y3 - *x3 + 1) * *size;
            areceive (0, send_pid, a_ptr, send_size);
            a_ptr += send_size;
          }
      }

     else
      { /* look for data to send */

        dalib_local_slice__ (N4, x4, y4, &low, &up);
        if (low <= up)
          {  dalib_setup_section4 (*size, *N1, *x1, *y1, *N2, *x2, *y2,
                                          *N3, *x3, *y3, *N4, low, up);
             dalib_send_section4 (0, a);
          }
      }
} /* dalib_host_node4 */

     /*********************************************************
     *                                                        *
     *  NODEARRAY (x1:y1,x2:y2,x3:y3,x4:y4) = HOSTARRAY       *
     *                                                        *
     *********************************************************/

void dalib_node_host4__ (a, size, N1, x1, y1, N2, x2, y2, N3, x3, y3, N4, x4, y4)
unsigned char *a;
int *size;
int *N1, *x1, *y1, *N2, *x2, *y2, *N3, *x3, *y3, *N4, *x4, *y4;

{   int pid_low, pid_up, send_pid;
    int my_pid;
    unsigned char *a_ptr;

    int send_size;
    int low, up;

    my_pid = pcb.i;

#ifdef DEBUG
    printf ("Process %d calls node_host4 %d : %d, %d : %d, %d : %d, %d : %d\n", 
             my_pid, *x1, *y1, *x2, *y2, *x3, *y3, *x4, *y4);
#endif

    /* pid_low : pid_up =  processors that own elements of this range */

    if (my_pid == 0)

      { /* HOST sends the data */
        pid_low = dalib_where (*N4, *x4);
        pid_up  = dalib_where (*N4, *y4);

        a_ptr = a;

        for (send_pid = pid_low; send_pid <= pid_up; send_pid++)

          { /* get range */

            dalib_local_extensions (send_pid, *N4, &low, &up);
            if (low < *x4) low = *x4;
            if (up  > *y4) up  = *y4;

            /* host sends a(low:up) to processor send_pid */
            
            send_size = (up - low + 1)  * (*y1 - *x1 + 1) * 
                        (*y2 - *x2 + 1) * (*y3 - *x3 + 1) * *size;
            asend (0, send_pid, a_ptr, send_size);
            a_ptr += send_size;
          }
      }

     else

      { /* look for data to recv */

        dalib_local_slice__ (N4, x4, y4, &low, &up);
        if (low <= up)
          {  dalib_setup_section4 (*size, *N1, *x1, *y1, *N2, *x2, *y2,
                                          *N3, *x3, *y3, *N4, low, up);
             dalib_recv_section4 (0, a);
          }
      }
} /* dalib_node_host4 */
