/* migrate.cmd

   Account Manager - Migrate utility
   ---------------------------------
   Simple REXX script to migrate data from version 0.10

   This script makes an ascii file to use with import option of Account Manager

   INPUT.: no input is required
   OUTPUT: "migrate.txt" (ascii file)

*/
call rxfuncadd 'IniLoadFuncs', 'REXXINI', 'IniLoadFuncs'
call IniLoadFuncs
'@del migrate.txt > NUL 2>&1'

sep=";"
file_name="migrate.txt"
head='"Account Name";"User ID";"Password";"Account Type";"URL";"First Name";"Last Name";"Address";"Zip Code";"City";"State";"E-Mail"'

call lineout file_name, head


/* count the sections */
call IniEnumSections Section, "account.db"	

do i = 1 to Section.0
	handle=IniOpen(section.i, "account.db")
	say "Elaborating..... "section.i
	_url=IniGet(URL,handle)
	_userid=IniGet(USERID, handle)
	_passwd=IniGet(PASSWORD, handle)
	_fname=IniGet(FNAME, handle)
	_lname=IniGet(LNAME, handle)
	_address=IniGet(ADDRESS, handle)
	_zip=IniGet(ZIP,handle)
	_city=IniGet(CITY, handle)
	_state=IniGet(STATE, handle)
	_email=IniGet(EMAIL, handle)
	_category=IniGet(TYPE, handle)
	call lineout file_name, d2c(34)||section.i||d2c(34)||sep||d2c(34)||_userid||d2c(34)||sep||d2c(34)||_passwd||d2c(34)||sep||d2c(34)||_category||d2c(34)||sep||d2c(34)||_url||d2c(34)||sep||d2c(34)||_fname||d2c(34)||sep||d2c(34)||_lname||d2c(34)||sep||d2c(34)||_address||d2c(34)||sep||d2c(34)||_zip||d2c(34)||sep||d2c(34)||_city||d2c(34)||sep||d2c(34)||_state||d2c(34)||sep||d2c(34)||_email||d2c(34)

end /* do */
call lineout file_name
say ''
say "Done!"
say ''
say "Please, check the file migrate.txt!"
