/**************************************************************************
*                                                                         *
*  Author      : Dr. Thomas Brandes, GMD, I1.HR                           *
*  Copyright   : GMD St. Augustin, Germany                                *
*  Date        : Aug 92                                                   *
*  Last Update : Sep 92                                                   *
*                                                                         *
*  This Module is part of the DALIB                                       *
*                                                                         *
*  Module      : memcopy.c                                                *
*                                                                         *
*  Function    : Copying of data in local memory                          *
*                                                                         *
*  Export :                                                               *
*                                                                         *
*      void dalib_memcpy (target, source, size)                           *
*      void dalib_rmemcpy (target, source, size)                          *
*                                                                         *
*      unsigned char *dest, *source;  int size;                           *
*                                                                         *
**************************************************************************/

void dalib_memcpy1 (dest, source, size)
unsigned char *dest, *source;
int size;
{ int i;
  for (i=0;i<size;i++)
     dest[i] = source[i];
}

    /*****************************************************
    *                                                    *
    *    Faster copy if data size is multiple of 4       *
    *                                                    *
    *****************************************************/

void dalib_memcpy4 (dest, source, size)
int *dest, *source;
int size;
{ int i;
  for (i=0;i<size;i++)
     dest[i] = source[i];
}

    /*****************************************************
    *                                                    *
    *    Faster copy if data size is multiple of 8       *
    *                                                    *
    *****************************************************/

void dalib_memcpy8 (dest, source, size)
double *dest, *source;
int size;
{ int i;
  for (i=0;i<size;i++)
     dest[i] = source[i];
}

void dalib_memcpy (target, source, size)
unsigned char *target;
unsigned char *source;
int size;

{ int hlength;
  int pattern;

  pattern = (size | (int) source | (int) target);

  if ((pattern & 7) == 0)
     { /* could be double or complex */
       hlength = size / 8;
       dalib_memcpy8 (target, source, hlength);
     }
   else if ((pattern & 3) == 0)
     { /* could be real or int */
       hlength = size / 4;
       dalib_memcpy4 (target, source, hlength);
     }
    else
       dalib_memcpy1 (target, source, size);

}

void dalib_rmemcpy1 (dest, source, size)
unsigned char *dest, *source;
int size;
{ int i;
  for (i=size-1;i>=0;i--)
     dest[i] = source[i];
}

    /*****************************************************
    *                                                    *
    *    Faster copy if data size is multiple of 4       *
    *                                                    *
    *****************************************************/

void dalib_rmemcpy4 (dest, source, size)
int *dest, *source;
int size;
{ int i;
  for (i=size-1;i>=0;i--)
     dest[i] = source[i];
}

    /*****************************************************
    *                                                    *
    *    Faster copy if data size is multiple of 8       *
    *                                                    *
    *****************************************************/

void dalib_rmemcpy8 (dest, source, size)
double *dest, *source;
int size;
{ int i;
  for (i=size-1;i>=0;i--)
     dest[i] = source[i];
}

    /*****************************************************
    *                                                    *
    *    Reverse memory copy: must be called if          *
    *                                                    *
    *       source < target <= source+size               *
    *                                                    *
    *            --------------------------------        *
    *            |   target data                |        *
    *            --------------------------------        *
    *        --------------------------------            *
    *        |   source data                |            *
    *        --------------------------------            *
    *                                                    *
    *    for (i=0;i<size;i++) target[i] = source[i]      *
    *      would destroy source data !!!                 *
    *                                                    *
    *****************************************************/

void dalib_rmemcpy (target, source, size)
unsigned char *target;
unsigned char *source;
int size;

{ int hlength;
  int pattern;

  pattern = (size | (int) source | (int) target);

  if ((pattern & 7) == 0)
     { /* could be double or complex */
       hlength = size / 8;
       dalib_rmemcpy8 (target, source, hlength);
     }
   else if ((pattern & 3) == 0)
     { /* could be real or int */
       hlength = size / 4;
       dalib_rmemcpy4 (target, source, hlength);
     }
    else
       dalib_rmemcpy1 (target, source, size);

}

    /*****************************************************
    *                                                    *
    *    Indirect addressing of local memory for         *
    *    different data sizes (1, 4, 8)                  *
    *                                                    *
    *****************************************************/

void dalib_memget4 (target, source, index, n)
int *target, *source;
int *index, n;

{ int i;
  for (i=0; i<n; i++)
     target[i] = source[index[i]];
}

void dalib_memgetm4 (target, source, index, n)
int *target, *source;
int *index, n;

{ int i;
  for (i=0; i<n; i++)
   if (index[i] >= 0)
     target[i] = source[index[i]];
}

void dalib_memget8 (target, source, index, n)
double *target, *source;
int *index, n;

{ int i;
  for (i=0; i<n; i++)
     target[i] = source[index[i]];
}

void dalib_memgetm8 (target, source, index, n)
double *target, *source;
int *index, n;

{ int i;
  for (i=0; i<n; i++)
   if (index[i] >= 0)
     target[i] = source[index[i]];
}

