/*******************************************************************
*                                                                  *
*  MODULE : barrier.c                                              *
*                                                                  *
*  Function: Realization of Barrier Synchronization for Nodes      *
*                                                                  *
*******************************************************************/
#include "system.h"

/*******************************************************************
*                                                                  *
*  process_barrier: synchronization for all nodes                  *
*                                                                  *
*     - call only by node processes, not host                      *
*                                                                  *
*******************************************************************/

void process_barrier ()

/* Synchronization of all node processes */

/*   Communication Patterns

     0    1    2    3    4    5    6    7    8    9   10  
            <-        <-        <-        <-        <-
            <-------            <--------         
            <-----------------
            <-------------------------------------
            ------------------------------------->
            -----------------> 
            ------->            -------->
            ->        ->        ->        ->        <-
*/

{ int steph, distance;
  int i, n;
  unsigned char *dummy_data;
 
  i = pcb.i ;

  n = pcb.p ;

  if (i==0)   /* host does not synchronize */
    { 
      return;
    }

  /* barrier corresponds a reduction without function, and data
     of length = 0                                              */
  
  distance = 1;
  while (distance < n)    /* log n (base 2) loop */
    { steph = 2*distance;
      if ( ((i-1) % steph) == 0)
         { /* if i+distance exists get a result and combine */
           if ( (i+distance) <= n)
             areceive (i,i+distance,dummy_data,0);
         }
      if ( ((i-1) % steph) == distance)
         asend (i,i-distance,dummy_data,0);
      distance = steph;
    }

  /* send values back to all processors */

  while (distance > 1)
    { steph = distance;
      distance = distance / 2;
      if ( ((i-1) % steph) == 0)
         { /* if i+distance exists send the new result */
           if ( (i+distance) <= n)
             asend (i,i+distance,dummy_data,0);
         }
      if ( ((i-1) % steph) == distance)
         areceive (i,i-distance,dummy_data,0);
    }
}

