/*

  module : plugininterface.hpp

  descr  :  This file define the public interface to be used , if you want to develop
            a PlugIn for CUSeeMe/2.

  log    :
           12/10/1997 - Added inifile support
*/

#ifdef __cplusplus
extern "C"
{
#endif

// list of possible commands

#define PLUGIN_CMD_QUERYINFORMATION          1       // mandatory
#define PLUGIN_CMD_INITIALIZE                2    // mandatory
#define PLUGIN_CMD_TERMINATE                 3    // mandatory
#define PLUGIN_CMD_GET_FRAME                 4    // mandatory
#define PLUGIN_CMD_SETUP                     5    // mandatory
#define PLUGIN_CMD_ABOUT                     6    // optional


#define PLUGIN_NO_ERROR                      NO_ERROR
#define PLUGIN_INVALID_PARAMETER             ERROR_INVALID_PARAMETER

/*
  When user changes critical information in the setup dialog fx going from B&W to Color the
  setup command must return PLUGIN_MUST_RELOAD. CUSeeme/2 will then unload the plugin from memory
  and then load it again. The plugin should save its state in a INI file. The handle to a valid
  INI file is available to a plugin on the Setup and Initialize commands.

*/

#define PLUGIN_MUST_RELOAD                   (-1)

APIRET APIENTRY PlugInCommand(ULONG ulCmd,PVOID pvIN,ULONG ulIn,PVOID pvOut,ULONG ulOut);

typedef APIRET (APIENTRY _PlugInCommand)(ULONG ulCmd,PVOID pvIN,ULONG ulIn,PVOID pvOut,ULONG ulOut);
typedef _PlugInCommand * PPlugInCommand;

// input
typedef struct
{
  ULONG cbFix;
  HMODULE hmodule;
  HWND hwnd;                             // handle of client window
  ULONG ulFlags;
  HINI hini;      // handle of Initialization file
} PLUGIN_GENEREL,*PPLUGIN_GENEREL;

#define FLAG_GRAY                        0
#define FLAG_COLOR                       1


// output
typedef struct
{
  ULONG cbFix;
  ULONG ulVersion;
  ULONG ulFlags;                         // can be either FLAG_GRAY or FLAG_COLOR
  HPOINTER hIcon;                        // use NULLHANDLE for default icon
  char  title[64];
  FOURCC fourcc;                         // buffer format eq FOURCC_RGB3 , FOURCC_BGR3,FOURCC_GREY
} PLUGIN_QUERYINFORMATION,*PPLUGIN_QUERYINFORMATION;

// input
typedef struct
{
  ULONG cbFix;
  ULONG ulflags;                         // should be 0 for now
  ULONG cx;    // size of image eg 160x120
  ULONG cy;
  ULONG bpp;      // color depth
  HINI hini;      // handle of Initialization file
} PLUGIN_INITIALIZE,*PPLUGIN_INITIALIZE;

// input
typedef struct
{
  ULONG cbFix;
  ULONG ulflags;                         // should be 0 for now
  PVOID pBuffer;
  ULONG ulLen;
  HPS   hps;
} PLUGIN_GETFRAME,*PPLUGIN_GETFRAME;

// input
typedef struct
{
  ULONG cbFix;
  ULONG ulflags;                         // should be 0 for now

} PLUGIN_TERMINATE,*PPLUGIN_TERMINATE;

#ifdef __cplusplus
}
#endif

