function Aib = qtrsvmat(qib)
# function Aib = qtrsvmat(qib)
# construct 3x3  transformation matrix from quatern qib
# Aib is equivalent to rotation of th radians about axis vv, where
#    [vv,th] = quatern(qib)

if(!is_vec(qib) | length(qib) != 4)
  error(sprintf("qtrsvmat: q(%d,%d) must be a quatern",rows(qib),columns(qib)))
elseif(max(abs(imag(qib))) != 0)
  qib
  error("qtrsvmat: input values must be real.");
endif

Aib = [ (2.*(qib(1)^2 + qib(4)^2) -1.), ...
	  (2.*(qib(1)*qib(2)-qib(3)*qib(4))), ...
	  (2.*(qib(1)*qib(3)+qib(2)*qib(4))); ...
	(2.*(qib(1)*qib(2)+qib(3)*qib(4))), ...
	  (2.*(qib(2)*qib(2)+qib(4)*qib(4))-1.), ...
	  (2.*(qib(2)*qib(3)-qib(1)*qib(4))); ...
	(2.*(qib(1)*qib(3)-qib(2)*qib(4))), ...
	  (2.*(qib(2)*qib(3)+qib(1)*qib(4))), ...
	  (2.*(qib(3)*qib(3)+qib(4)*qib(4))-1.)];
endfunction

