/*  rexx-program generating a HyperMake folder and
    program objects with *.HMP file association,
    pointing to HMAKE.EXE and E.EXE
    Author: Martin Vieregg, Germany, Jan 1997  */

Call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
Call SysLoadFuncs

CurrentDir = directory()

say "German language (press Y or N) "
pull YesNo
if  ((YesNo = "Y") | (YesNo = "y") | (YesNo = "J") | (YesNo = "j") ) then 
  German = TRUE
else
  German = FALSE

rc = SysOpenObject("<MVhmakeFolder>", ICON, TRUE)

if (rc = 1) then DO
  if (German = TRUE) then DO
    say "Der Programmordner HyperMake ist schon vorhanden.";
    say "Sollen die HyperMake Objekte gelscht werden ? (drcken Sie J oder N) "
  END
  else DO
    say "The HyperMake program folder already exists.";
    say "Do you want to delete all these WPS Objects ? (press Y or N) "
  END
  pull Contin
  if  ((Contin = "N") | (Contin = "n")) then EXIT

  Call Destroy "<MVhmake_comp>"
  Call Destroy "<MVhmake_edit>"
  Call Destroy "<MVhmakeAssocFolder>"
  Call Destroy "<MVhmakeDirShadow>"
  Call Destroy "<MVhmakeButtonLib>"
  Call Destroy "<MVhmake_DocuHelp>"
  Call Destroy "<MVhmake_DocuHTML>"
  Call Destroy "<MVhmakeFolder>"

  exit
END


if (German = TRUE) then DO

  say "Bevor Sie mit diesem Programm fortfahren, mssen Sie die HyperMake"
  say "Verzeichnisse und Dateien selbst in das Verzeichnis Ihrer Wahl kopieren."
  say "Weitermachen ? (drcken Sie J oder N) "
  pull Contin
  if  ((Contin = "N") | (Contin = "n")) then EXIT

  say "Es wird ein HyperMake Ordner auf der Arbeitsoberflche erzeugt..."

  Call SysCreateObject "WPFolder", "HyperMake", "<WP_DESKTOP>",,
	"OBJECTID=<MVhmakeFolder>;ICONFILE="CurrentDir"\HMP.ICO;"

  Call SysCreateObject "WPFolder", "HMP Zuordnungen", "<MVhmakeFolder>",,
	"OBJECTID=<MVhmakeAssocFolder>;"
      Call SysCreateObject "WPProgram", "kompiliere Projekt", "<MVhmakeAssocFolder>",,
  	    "OBJECTID=<MVhmake_comp>;EXENAME="CurrentDir"\HMAKE.EXE;ICONFILE="CurrentDir"\HMP.ICO;ASSOCFILTER=*.HMP,,;"
      Call SysCreateObject "WPProgram", "editiere Projektdatei", "<MVhmakeAssocFolder>",,
	    "OBJECTID=<MVhmake_edit>;EXENAME=E.EXE;ASSOCFILTER=*.HMP,,;"

  Call SysCreateObject "WPProgram", "Button Bibliothek", "<MVhmakeFolder>",,
	"OBJECTID=<MVhmakeButtonLib>;EXENAME=NETSCAPE.EXE;PARAMETERS="CurrentDir"\Buttons\Content.htm;STARTUPDIR="CurrentDir"\Buttons;"

  Call SysCreateObject "WPProgram", "Doku als HTML", "<MVhmakeFolder>",,
	"OBJECTID=<MVhmake_DocuHTML>;EXENAME=NETSCAPE.EXE;PARAMETERS="CurrentDir"\German\Doku\Index.html;STARTUPDIR="CurrentDir"\German\Doku;"

  Call SysCreateObject "WPProgram", "Doku als INF", "<MVhmakeFolder>",,
	"OBJECTID=<MVhmake_DocuHelp>;EXENAME=VIEW.EXE;PARAMETERS="CurrentDir"\German\Doku.inf;"
  
  Call SysCreateObject "WPShadow", "ShadowOfHyperMake", "<MVhmakeFolder>",,
	"OBJECTID=<MVhmakeDirShadow>;SHADOWID="CurrentDir";"


  say "Es wurde erfolgreich ein HyperMake Ordner mit einigen Objekten erstellt."
  say "Sie knnen den Ordner irgendwo in einen anderen Ordner Ihrer"
  say "Arbeitsoberflche verschieben."
  say "Zum Deinstallieren dieser Objekte starten Sie dieses Programm erneut."
  say "Die zwei Referenzen zur Dokumentation gehen noch ins Leere, solange"
  say "die Dokumentation noch nicht erstellt worden ist."
  say "Lesen Sie hierfr bitte GERMAN\MACHDOKU.HLP"

END
ELSE DO

  say "Before running this installation program, you have to copy the HyperMake"
  say "directories and files to the location of your choice by yourself."
  say "Continue ? (press Y or N) "
  pull Contin
  if  ((Contin = "N") | (Contin = "n")) then EXIT

  say "creation of a HyperMake folder on the desktop..."


  Call SysCreateObject "WPFolder", "HyperMake", "<WP_DESKTOP>",,
	"OBJECTID=<MVhmakeFolder>;ICONFILE="CurrentDir"\HMP.ICO;"

  Call SysCreateObject "WPFolder", "HMP Associations", "<MVhmakeFolder>",,
	"OBJECTID=<MVhmakeAssocFolder>;"
      Call SysCreateObject "WPProgram", "compile project", "<MVhmakeAssocFolder>",,
  	    "OBJECTID=<MVhmake_comp>;EXENAME="CurrentDir"\HMAKE.EXE;ICONFILE="CurrentDir"\HMP.ICO;ASSOCFILTER=*.HMP,,;"
      Call SysCreateObject "WPProgram", "edit project file", "<MVhmakeAssocFolder>",,
	    "OBJECTID=<MVhmake_edit>;EXENAME=E.EXE;ASSOCFILTER=*.HMP,,;"

  Call SysCreateObject "WPProgram", "Button Library", "<MVhmakeFolder>",,
	"OBJECTID=<MVhmakeButtonLib>;EXENAME=NETSCAPE.EXE;PARAMETERS="CurrentDir"\Buttons\Content.htm;STARTUPDIR="CurrentDir"\Buttons;"

  Call SysCreateObject "WPProgram", "Docu in HTML", "<MVhmakeFolder>",,
	"OBJECTID=<MVhmake_DocuHTML>;EXENAME=NETSCAPE.EXE;PARAMETERS="CurrentDir"\English\Docu\Index.html;STARTUPDIR="CurrentDir"\English\Docu;"

  Call SysCreateObject "WPProgram", "Docu in INF", "<MVhmakeFolder>",,
	"OBJECTID=<MVhmake_DocuHelp>;EXENAME=VIEW.EXE;PARAMETERS="CurrentDir"\English\Docu.inf;"
  
  Call SysCreateObject "WPShadow", "ShadowOfHyperMake", "<MVhmakeFolder>",,
	"OBJECTID=<MVhmakeDirShadow>;SHADOWID="CurrentDir";"


  say "Successful creation of a HyperMake folder on your desktop"
  say "containing some objects."
  say "You can drop the folder somewhere into a folder of your desktop."
  say "To deinstal these objects run this program again."
  say "The shortcuts to the documentation are not working yet because you"
  say "need to create the docu first. Please read ENGLISH\MAKEDOCU.HLP" 

END

"copy kbdvio32.dll c:\os2\dll"
"@pause"


exit


Destroy:
if SysDestroyObject(ARG(1)) then DO
  if (German = TRUE) then DO
    say "lschen von "ARG(1)" OK"
  END
  else DO
    say "deleting "ARG(1)" OK"
  END

END
else DO
  if (German = TRUE) then DO
    say "lschen von "ARG(1)" fehlgeschlagen"
  END
  else DO
    say "deleting "ARG(1)" failed"
  END
END
return