/***************************************************************************
 *  TEST-CGI.CMD - a REXX script to test CGI interface
 *
 *  An sre-http adaptation of work by:   Frankie Fan <kfan@netcom.com>  7/11/94
 *
 **************************************************************************/

Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs

Parse Arg Argv


env = "OS2ENVIRONMENT"
vtab = ""
lead = "<LI>"
Argc = Words(Argv)

Say "Content-type: text/html"
Say


Say "<H1>CGI/1.0 test script report:</H1>"  || vtab

method = value("REQUEST_METHOD",,env)

Say "<UL>"

Say lead || "argc = " Argc || vtab
Say lead || "argv = " Argv || vtab
Say lead || "SERVER_SOFTWARE = " value("SERVER_SOFTWARE",,env) || vtab
Say lead || "SERVER_NAME = " value("SERVER_NAME",,env) || vtab
Say lead || "GATEWAY_INTERFACE = " value("GATEWAY_INTERFACE",,env) || vtab 
Say lead || "SERVER_PROTOCOL = " value("SERVER_PROTOCOL",,env) || vtab 
Say lead || "SERVER_PORT = " value("SERVER_PORT",,env) || vtab
Say lead || "REQUEST_METHOD = " method || vtab 
Say lead || "HTTP_USER_AGENT = " value("HTTP_USER_AGENT",,env) || vtab 
Say lead || "HTTP_ACCEPT = " value("HTTP_ACCEPT",,env) || vtab 
Say lead || "HTTP_REFERER = " value("HTTP_REFERER",,env) || vtab 
Say lead || "PATH_INFO = " value("PATH_INFO",,env) || vtab 
Say lead || "PATH_TRANSLATED = " value("PATH_TRANSLATED",,env) || vtab 
Say lead || "SCRIPT_NAME = " value("SCRIPT_NAME",,env) || vtab 
Say lead || "QUERY_STRING = " value("QUERY_STRING",,env) || vtab 
Say lead || "REMOTE_HOST = " value("REMOTE_HOST",,env) || vtab 
Say lead || "REMOTE_ADDR = " value("REMOTE_ADDR",,env) || vtab 
Say lead || "REMOTE_USER = " value("REMOTE_USER",,env) || vtab 
Say lead || "AUTH_TYPE = " value("AUTH_TYPE",,env) || vtab 
Say lead || "CONTENT_TYPE = " value("CONTENT_TYPE",,env) || vtab
len = value("CONTENT_LENGTH",,env)
Say lead || "CONTENT_LENGTH = " || len || vtab   

/* sre-http add-ons */
say lead ||"CALLER_THREAD = " value("CALLER_THREAD",,env) || ' <em>(SRE-Http add-on </em>)'||vtab
say lead ||"SERVER_PID = " value("SERVER_PID",,env) || ' <em>(SRE-Http add-on </em>)'||vtab

Say lead || "DOCUMENT_ROOT = " value("DOCUMENT_ROOT",,env) || ' <em>(SRE-Http add-on </em>)'||vtab

say lead ||"SCRIPT_DIR = " value("SCRIPT_DIR",,env) || ' <em>(SRE-Http add-on </em>)'|| vtab
say lead ||"SERVER_ROOT = " value("SERVER_ROOT",,env) || ' <em>(SRE-Http add-on </em>)'|| vtab

say lead ||"SREF_PRIVSET = " value("SREF_PRIVSET",,env) || ' <em>(SRE-Http add-on </em>)'|| vtab

if (method == "GET") Then Do
   query_string = value("QUERY_STRING",,env)
end

If (method == "POST") & (len \= "") Then Do
  /* use POST method to pass parameters */

  post_string = charin(,,len) /* read only the number specified 
                                 in CONTENT_LENGTH */

  Say vtab 
  Say lead || "Standard Input = " || post_string || vtab
  query_string = post_string
End

   NF = ParseQueryString( query_string)
   Say "<UL>"
   do i = 1 to NFields
      Say lead || Parms.Tag.i ' = ' Parms.XVal.i || vtab
   end
   Say "</UL>"

Say "</UL>"
say " "
say " <br>Note: current process and thread are: " dospid()' 'dostid()
say
return


	/* Do not modify below this line --  Important parsing code... */
ParseQueryString: procedure expose Parms. NFields
  Parse arg P
  i = 1
  do while ((P \= '') & (i < 10))
     Parse var P Parms.Text.i '&' rest
     Parse var Parms.Text.i Parms.Tag.i '=' Parms.KeyVal.i
     Parms.Tag.i = translate( Parms.Tag.i)
     Parms.XVal.i=DecodeKeyVal( Parms.KeyVal.i)
     P = rest
     i = i + 1
  end
  NFields = i - 1
  return NFields

/************************************************/
/* procedure from TEST-CGI.CMD, modified by daniel hellerstein 12/97,
from code by  Frankie Fan <kfan@netcom.com>  7/11/94 */
DecodeKeyVal: procedure
  parse arg Code
  Text=''
  Code=translate(Code, ' ', '+')
  rest='%'
  do while (rest\='')
     Parse var Code T '%' rest
     Text=Text || T
     if (rest\='' ) then
      do
        ch = left( rest,2)
        if verify(ch,'01234567890ABCDEF')=0 then
           c=X2C(ch)
        else
           c=ch
        Text=Text || c
        Code=substr( rest, 3)
      end
  end
  return Text




