/* 29 June 1999

This is a sample user-specific "server side" content
negotiation procedure. It closely emulates SRE-http's default 
algorithim, with a few cookie checks thrown in.

The arguments that sre-http sends here are:
   sel -- the request selector, after possible "aliasing" within
          SRE-http
  file -- the fully qualified file name that sel maps to
          (varilist is pulled from file)
    n  -- number of entries in the variant list
  varilist -- the variant list
 

Although you can work directly with varilist (see NEGOTIAT.DOC for
the details), we recommend using the SREF_NEGOTIATE_EXTRACT
and SREF_NEGOTIATE_SEARCH procedures instead -- see NEGOTIAT.DOC
for the details on these procedures. Also, note the use of the
reqfield and SREF_GET_COOKIE procedures.



********************************************************/

negot:          

parse arg sel,file,n,varilist

say " For variant list in selector: "sel 
say '      (' file
say " # alternatives: " n

say "Step 1: look for accept: header matches (weighted) "
acc=reqfield('accept')
ind1=sref_negotiate_search(acc,'type',varilist,2)
say "After accept, matching variants are: " ind1
if ind1=0 then return ind1
if words(ind1)=1 then return ind1' Accept'


say "Step 2: look for accept-language: header matches (weighted) "
acc=reqfield('accept-language')
if acc<>'' then do
  ind2=sref_negotiate_search(acc,'language',varilist,2,ind1)
  say "After accept-language, matching variants are: " ind2
  if ind2=0 then return ind2
  if words(ind2)=1 then return ind2' Accept Accept-language'
end
else do
   ind2=ind1
end /* do */

say "Step 2.2: look for a language cookie "
acc=sref_get_cookie('language')
if acc<>'' then do
  ind2a=sref_negotiate_search(acc,'language',varilist,2,ind2)
  say "After cookie: language, matching variants are: " ind2a
  if words(ind2a)=1 & ind2a<>0  then return ind2a' Accept Accept-language Cookie'
  ind2=ind2a
end


say "Step 3: look for accept-encoding: header matches (weighted) "
acc=reqfield('accept-encoding')
if acc<>'' then do
  ind3=sref_negotiate_search(acc,'encoding',varilist,2,ind2)
  say "After accept-encoding, matching variants are: " ind3
  if ind3=0 then return ind3
  if words(ind3)=1 then return ind3' Accept Accept-language Accept-Encoding Cookie'
end
else do
   ind3=ind2
end


say "Step 4: look for accept-charset: header matches (weighted) "
acc=reqfield('accept-charset')
if acc<>''  then do
   ind4=sref_negotiate_search(acc,'charset',varilist,2,ind3)
   say "After accept-charset, matching variants are: " ind4
   if ind4=0 then return ind4
   if words(ind4)=1 then 
      return ind4' Accept Accept-language Accept-Encoding Accept-Charset Cookie'
end
else do
   ind4=ind3
end /* do */

say "Step 5: use remaining variant with smallest length from:"ind4
alist=sref_negotiate_extract('length',ind4,varilist)
usemm=1
if alist<>'' then do
  aw0=111111111111
  do mm=1 to words(ind4)
     parse var alist aw '0d0a'x alist
     aw=strip(aw)
     if aw='' then iterate  /* none defined */
     if aw<aw0 then do
        usemm=mm
        aw0=aw
     end /* do */
  end
end /* do */
useit=word(ind4,usemm)
return useit' Accept Accept-language Accept-Encoding Accept-Charset Cookie'




return 0




