/* Create a BROWSERS.IDX file from a .CFG file obtained from
http://website-1.openmarket.com:80/browsertest/prob/bt-maker.cgi?DataFile
or ... if called as an srehttp addon, will query/list
capabilities of current browser (using sref_browser_info)


 */

/*---   Load REXX libraries ----- */
/* Load up advanced REXX functions */
foo=rxfuncquery('sysloadfuncs')
if foo=1 then do
  call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
  call SysLoadFuncs
end
foo=rxfuncquery('rexxlibregister')
if foo=1 then do
 call rxfuncadd 'rexxlibregister','rexxlib', 'rexxlibregister'
 call rexxlibregister
end
if rxfuncquery('sref_fileread')<>0 then do
  ik=rxfuncadd('sref_fileread','rexxlib','LIB_FILEREAD')
  if ik<>0 then call pmprintf(' SRE-http Monitor: Warning: unable to register SREF_FILEREAD')
end

parse arg  ddir, tempfile, reqstrg,list,verb ,uri,user, ,
          basedir ,workdir,privset,enmadd,transaction,verbose, ,
         servername,host_nickname,homedir,aparam,semqueue


if verb<>'' then signal doaddon

/* if here, treat as a stand alone */
say " This utility will create a BROWSERS.IDX file from information"
say " obtained from http:\\website-1.openmarket.com/browsertest"
say
say " In particular, it reads a CFG style file (of browser capabilities)"
say " generated by this /browsertest URL "
say
hoy1: nop
say " Please enter name of the CFG file "
parse pull cfgfile
dd=stream(cfgfile,'c','query exists')
if dd=""  then do
     say " could not find: " cfgfile
     signal hoy1
end
oo=sref_fileread(dd,lins,,'E')
if lins.0=0 then do
     say " error with cfg file "
    signal hoy1
end  /* Do */

/* look for # BROWSER.CFG */
gotit=0
do mm=1 to lins.0
    a1=strip(lins.mm)
    if abbrev(a1,'#')=0 then iterate
    parse upper var a1 . '#' a2 . ; a2=strip(a2)
    if a2='BROWSER.CFG' then do
        gotit=1
        leave
    end   
end
if gotit=0 then do
    say " This does not appear to be a BROWSER.CFG file."
    call charout," Are you sure it is (Yes/NO): "
    pull yesno
    say
    if abbrev(yesno,'Y')=0 then do
          say " let's try again ... "
          signal hoy1
    end
end

/* typical entry:
Browser {Mozilla/2.0 (compatible; PCN-The PointCast Network 2.0/win32/ *} \
        -browser {PointCast} \
        -cache {WA} \
        -cookies {YES} \
        -date {97/08/01} \
        -maxlinklen {8192} \
        -redirectlimit {8192} \
        -security {NONE} \
        -tables {YES}
*/

varlist='USER_AGENT SIMPLEKEY'
idid=0  ;mm=0
BLIST.!AGENT_LIST=' '
do until mm=lins.0
    mm=mm+1
    if lins.mm="" then iterate
    alin=strip(lins.mm)
    if abbrev(alin,'#')=1 then iterate

/* search for a BROWSER  entry; concatenate lines till next browser entry
   or till end of file; then parse into fields */

    parse upper var alin avar . ; avar=strip(avar)
    if avar<>'BROWSER' then iterate   /* some kind of orphan line */

/* got a BROWSER LINE -- start entry (concatenate all lines ending with a \ */
    idid=idid+1         /* nth browser found */

    parse var alin  . '{' aval '}' .
    anent=''
    say " Entry for: " aval
     blist.idid.!USER_AGENT=aval
     blist.idid.!SIMPLEKEY=strip(upper(space(translate(aval,' ','*-~'),0)))
     blist.!agent_list=blist.!agent_list' 'blist.idid.!SIMPLEKEY

    do forever
        mm=mm+1
        alin=strip(lins.mm)
        anent=strip(anent' 'alin,'t','\')
        if right(alin,1)='\' then iterate

 /* otherwise, this is last line of entry; so parse it */
        do until anent=""
           parse var anent avar '{' aval '}' anent 
           avar=strip(avar); aval=strip(aval)
           avar=upper(strip(avar,'l','-'))
           tt='!'avar
           blist.idid.tt=aval
           if wordpos(avar,varlist)=0 then varlist=varlist' 'avar
        end /* do */
        leave           /* get next browser entry */
   end /* do forever */
end     /* do mm=lins.0 */
blist.0=idid
say " Found " idid " browsers "
say " with variables: "varlist

say
call charout, ' Enter output (BROWSERS.IDX) stem-file name: '
pull outfile
foo=cvwrite(outfile,blist)
say " stem-file status: " foo

exit


doaddon:               /* JUMP HERE WHEN CALLED AS AN ADDON */

foo=reqfield('USER-AGENT')
call lineout tempfile,'<HTML><HEAD><TITLE>Browser Features</title></head><body>'
call lineout tempfile,'<h1>Browser Features </h1>'
call lineout tempfile,' Your browser'' user-agent is: <b>'foo '</b><p>'
call lineout tempfile,' Our data indicate it has the following capabilities:<ul> '

/*
user_agent = User-agent of browser                      
browser = Vendor of the Browser                         
cookies =Cookie capable? YES or NO.                     
security = Type of security. NO, SHTTP, or SSL.         
tables = Understands tables (YES NO)                    
date = The date this table entry was entered or most rec
        modified. YY/MM/DD                              
redirectlimit = Maximum length of redirection string.   
               Integer between 255 and 8000             
maxlinklen = Maximum characters in url                  
               Integer between 255 and 8000             */

call lineout tempfile,'<li> Vendor: <b>'||sref_browser_info('browser')||' </b>'
call lineout tempfile,'<li> User-agent: <b>'||sref_browser_info('user_agent')||' </b>'
call lineout tempfile,'<li> Cookies capable: <b>'||sref_browser_info('cookies')||' </b>'
call lineout tempfile,'<li> Security: <b>'||sref_browser_info('security')||' </b>'
call lineout tempfile,'<li> ReDirectLimit: <b>'||sref_browser_info('redirectlimit')||' </b>'
call lineout tempfile,' <li> MaxCharInURL: <b>'||sref_browser_info('maxlinklen')||' </b>'

call lineout tempfile,'</ul></body></html>'
call lineout tempfile
'FILE erase type text/html name 'tempfile
return '200 '||extract('bytessent')


