
/*
 * $Id: whois.c,v 1.18 2002/08/22 12:29:15 hno Exp $
 *
 * DEBUG: section 75    WHOIS protocol
 * AUTHOR: Duane Wessels, Kostas Anagnostakis
 */
#include "squidDeclaration.h"

#include "squid.h"

#define WHOIS_PORT 43

typedef struct {
    StoreEntry *entry;
    request_t *request;
    FwdState *fwd;
} WhoisState;

static PF whoisClose;
static PF whoisTimeout;
static PF whoisReadReply;

/* PUBLIC */

CBDATA_TYPE(WhoisState);

void
whoisStart(FwdState * fwd)
{
    WhoisState *p;
    int fd = fwd->server_fd;
    char *buf;
    size_t l;
    CBDATA_INIT_TYPE(WhoisState);
    p = cbdataAlloc(WhoisState);
    p->request = fwd->request;
    p->entry = fwd->entry;
    p->fwd = fwd;
    storeLockObject(p->entry);
    comm_add_close_handler(fd, whoisClose, p);
    l = strLen(p->request->urlpath) + 3;
    buf = (char *) xmalloc(l);
    snprintf(buf, l, "%s\r\n", strBuf(p->request->urlpath) + 1);
    comm_write(fd, buf, strlen(buf), NULL, p, xfree);
    commSetSelect(fd, COMM_SELECT_READ, whoisReadReply, p, 0);
    commSetTimeout(fd, Config.Timeout.read, whoisTimeout, p);
}

/* PRIVATE */

static void
whoisTimeout(int fd, void *data)
{
    WhoisState *p = (WhoisState *) data;
    debug(75, 1) ("whoisTimeout: %s\n", storeUrl(p->entry));
    whoisClose(fd, p);
}

static void
whoisReadReply(int fd, void *data)
{
    WhoisState *p = (WhoisState *)data;
    StoreEntry *entry = p->entry;
    char *buf = (char *) memAllocate(MEM_4K_BUF);
    MemObject *mem = entry->mem_obj;
    int len;
    statCounter.syscalls.sock.reads++;
    len = squid_fd_table.fd_table[fd].read(buf, 4095);
    buf[len] = '\0';
    debug(75, 3) ("whoisReadReply: FD %d read %d bytes\n", fd, len);
    debug(75, 5) ("{%s}\n", buf);
    if (len > 0) {
       if (0 == mem->inmem_hi)
           mem->reply->sline.status = HTTP_OK;
       //fd_bytes(fd, len, FD_READ);
       kb_incr(&statCounter.server.all.kbytes_in, len);
       kb_incr(&statCounter.server.http.kbytes_in, len);
       storeAppend(entry, buf, len);
       commSetSelect(fd, COMM_SELECT_READ, whoisReadReply, p, Config.Timeout.read);
    } else if (len < 0) {
       debug(50, 2) ("whoisReadReply: FD %d: read failure: %s.\n",
           fd, xstrerror_type(squid_fd_table.fd_table[fd].type));
       if (ignoreErrno(errno,squid_fd_table.fd_table[fd].type)) {
           commSetSelect(fd, COMM_SELECT_READ, whoisReadReply, p, Config.Timeout.read);
       } else if (mem->inmem_hi == 0) {
           ErrorState *err;
           err = errorCon(ERR_READ_ERROR, HTTP_INTERNAL_SERVER_ERROR);
           err->xerrno = errno;
           fwdFail(p->fwd, err);
           comm_close(fd);
       } else {
           comm_close(fd);
       }
    } else {
	storeTimestampsSet(entry);
	storeBufferFlush(entry);
	if ( !EBIT_TEST(entry->flags, RELEASE_REQUEST ) )
	    storeSetPublicKey(entry);
       fwdComplete(p->fwd);
       debug(75, 3) ("whoisReadReply: Done: %s\n", storeUrl(entry));
       comm_close(fd);
    }
    memFree(buf, MEM_4K_BUF);
}

static void
whoisClose(int fd, void *data)
{
    WhoisState *p = (WhoisState *)data;
    debug(75, 3) ("whoisClose: FD %d\n", fd);
    storeUnlockObject(p->entry);
    cbdataFree(p,WhoisState);

}
