/* $Id: structsConfig.h,v 0.1 2004/3/09 0:0:0 hno Exp $ */

#ifndef SQUID_STRUCTSCONFIG_H
#define SQUID_STRUCTSCONFIG_H

/*********************************************/
    struct _authConfig {
       authScheme *schemes;
       int n_allocated;
       int n_configured;
    };

    struct _cacheSwap {
       SwapDir *swapDirs;
       int n_allocated;
       int n_configured;
    };


//struct _SquidConfig {
class SquidConfig
{
public:
    struct {
       size_t maxSize;
       int highWaterMark;
       int lowWaterMark;
    } Swap;
    size_t memMaxSize;
    struct {
       char *relayHost;
       u_short relayPort;
       _peer *peer;
    } Wais;
    struct {
       size_t min;
       int pct;
       size_t max;
    } quickAbort;
    RemovalPolicySettings *replPolicy;
    RemovalPolicySettings *memPolicy;
    time_t negativeTtl;
    time_t negativeDnsTtl;
    time_t positiveDnsTtl;
    time_t shutdownLifetime;
    struct {
       time_t read;
       time_t lifetime;
       time_t forward;
       time_t connect;
       time_t peer_connect;
       time_t request;
       time_t persistent_request;
       time_t pconn;
       time_t siteSelect;
       time_t deadPeer;
       int icp_query;          /* msec */
       int icp_query_max;      /* msec */
       int mcast_icp_query;    /* msec */
#if USE_IDENT
       time_t ident;
#endif
#if !USE_DNSSERVERS
       time_t idns_retransmit;
       time_t idns_query;
#endif
    } Timeout;
    size_t maxRequestHeaderSize;
    size_t maxRequestBodySize;
    size_t maxReplyHeaderSize;
    dlink_list ReplyBodySize;
    struct {
       u_short icp;
#if USE_HTCP
       u_short htcp;
#endif
#if SQUID_SNMP
       u_short snmp;
#endif
    } Port;
    struct {
       sockaddr_in_list *http;
#if USE_SSL
       https_port_list *https;
#endif
    } Sockaddr;
#if SQUID_SNMP
    struct {
       char *configFile;
       char *agentInfo;
    } Snmp;
#endif
#if USE_WCCP
    struct {
       struct in_addr router;
       struct in_addr incoming;
       struct in_addr outgoing;
       int version;
    } Wccp;
#endif
    char *as_whois_server;
    struct {
       char *log;
       char *access;
       char *store;
       char *swap;
#if USE_USERAGENT_LOG
       char *useragent;
#endif
#if USE_REFERER_LOG
       char *referer;
#endif
#if WIP_FWD_LOG
       char *forward;
#endif
       int rotateNumber;
    } Log;
    char *adminEmail;
    char *effectiveUser;
    char *effectiveGroup;
    struct {
#if USE_DNSSERVERS
       char *dnsserver;
#endif
       wordlist *redirect;
#if USE_ICMP
       char *pinger;
#endif
#if USE_UNLINKD
       char *unlinkd;
#endif
       char *diskd;
    } Program;
#if USE_DNSSERVERS
    int dnsChildren;
#endif
    int redirectChildren;
    time_t authenticateGCInterval;
    time_t authenticateTTL;
    time_t authenticateIpTTL;
    struct {
       int single_host;
       char *host;
       u_short port;
    } Accel;
    char *appendDomain;
    size_t appendDomainLen;
    char *debugOptions;
    char *pidFilename;
    char *mimeTablePathname;
    char *etcHostsPath;
    char *visibleHostname;
    char *uniqueHostname;
    wordlist *hostnameAliases;
    char *errHtmlText;
    struct {
       char *host;
       char *file;
       time_t period;
       u_short port;
    } Announce;
    struct {
       struct in_addr udp_incoming;
       struct in_addr udp_outgoing;
#if SQUID_SNMP
       struct in_addr snmp_incoming;
       struct in_addr snmp_outgoing;
#endif
       struct in_addr client_netmask;
    } Addrs;
    size_t tcpRcvBufsz;
    size_t udpMaxHitObjsz;
    wordlist *hierarchy_stoplist;
    wordlist *mcast_group_list;
    wordlist *dns_testname_list;
    wordlist *dns_nameservers;
    peer *peers;
    int npeers;
    struct {
       int size;
       int low;
       int high;
    } ipcache;
    struct {
       int size;
    } fqdncache;
    int minDirectHops;
    int minDirectRtt;
    cachemgr_passwd *passwd_list;
    struct {
       int objectsPerBucket;
       size_t avgObjectSize;
       size_t maxObjectSize;
       size_t minObjectSize;
       size_t maxInMemObjSize;
    } Store;
    struct {
       int high;
       int low;
       time_t period;
    } Netdb;

    struct {
       int log_udp;
#if USE_DNSSERVERS
       int res_defnames;
#endif
       int anonymizer;
       int client_db;
       int query_icmp;
       int icp_hit_stale;
       int buffered_logs;
#if ALLOW_SOURCE_PING
       int source_ping;
#endif
       int common_log;
       int log_mime_hdrs;
       int log_fqdn;
       int announce;
       int accel_with_proxy;
       int mem_pools;
       int test_reachability;
       int half_closed_clients;
#if HTTP_VIOLATIONS
       int reload_into_ims;
#endif
       int offline;
       int redir_rewrites_host;
       int prefer_direct;
       int nonhierarchical_direct;
       int strip_query_terms;
       int redirector_bypass;
       int ignore_unknown_nameservers;
       int client_pconns;
       int server_pconns;
#if USE_CACHE_DIGESTS
       int digest_generation;
#endif
       int log_ip_on_direct;
       int ie_refresh;
       int vary_ignore_expire;
       int pipeline_prefetch;
       int request_entities;
       int detect_broken_server_pconns;
	int balance_on_multiple_ip;
	int relaxed_header_parser;
	
	int accel_uses_host_header;
	int accel_no_pmtu_disc;
	
//	int check_hostnames; /* 2.6 */
//	int via;             /* 2.6 */
//	int emailErrData;    /* 2.6 */

/*== EK VAC bonus ==*/
       int UseANSI_stdout; /* main stdout is ANSI console */
       int UseBeepAtFatalError;
/*== endof EK VAC bonus ==*/
    } onoff;

/*== EK VAC bonus ==*/
/* number of working squid  runtime copy ( commanline option -n) */
       int SquidNum;      
/*== endof EK VAC bonus ==*/

    acl *aclList;
    struct {
       acl_access *http;
       acl_access *icp;
       acl_access *miss;
       acl_access *NeverDirect;
       acl_access *AlwaysDirect;
       acl_access *ASlists;
       acl_access *noCache;
#if SQUID_SNMP
       acl_access *snmp;
#endif
       acl_access *brokenPosts;
#if USE_IDENT
       acl_access *identLookup;
#endif
       acl_access *redirector;
       acl_access *reply;
       acl_address *outgoing_address;
       acl_tos *outgoing_tos;
    } accessList;
    acl_deny_info_list *denyInfoList;
/*== EK VAC bonus - Florian DECKERT ==*/
    acl_deny_info_list *blockInfoList;
    time_t blockingTTL;
/*== endof EK VAC bonus ==*/

    struct _authConfig  authConfig;

    struct {
       size_t list_width;
       int list_wrap;
       char *anon_user;
       int passive;
       int sanitycheck;
       int telnet;
    } Ftp;
    refresh_t *Refresh;
    struct _cacheSwap  cacheSwap;

    struct {
       char *directory;
	int use_short_names;
    } icons;
    char *errorDirectory;
    struct {
       int maxtries;
    } retry;
    struct {
       size_t limit;
    } MemPools;
#if DELAY_POOLS
    delayConfig Delay;
#endif
    struct {
       int icp_average;
       int dns_average;
       int http_average;
       int icp_min_poll;
       int dns_min_poll;
       int http_min_poll;
    } comm_incoming;
    int max_open_disk_fds;
    int uri_whitespace;
    size_t rangeOffsetLimit;
#if MULTICAST_MISS_STREAM
    struct {
       struct in_addr addr;
       int ttl;
       unsigned short port;
       char *encode_key;
    } mcast_miss;
#endif
    header_mangler header_access[HDR_ENUM_END];
    char *coredump_dir;
    char *chroot_dir;
#if USE_CACHE_DIGESTS
    struct {
       int bits_per_entry;
       time_t rebuild_period;
       time_t rewrite_period;
       size_t swapout_chunk_size;
       int rebuild_chunk_percentage;
    } digest;
#endif
#if USE_SSL
    struct {
       int unclean_shutdown;
    } SSL;
#endif
    wordlist *ext_methods;
    struct {
       int high_rptm;
       int high_pf;
       size_t high_memory;
    } warnings;
    char *store_dir_select_algorithm;
//    int sleep_after_fork;      /* microseconds */
    external_acl *externalAclHelperList;
};



#endif /*  SQUID_STRUCTSCONFIG_H */
