/*
 * $Id: safe_inet_addr.c,v 1.12 2001/02/07 18:56:51 hno Exp $
 */

#include "squid.h"

int
safe_inet_addr(const char *buf, struct in_addr *addr)
{
    static char addrbuf[32];
    int a1 = 0, a2 = 0, a3 = 0, a4 = 0;
    struct in_addr A;
    char x;
#if defined(_SQUID_HPUX_)
    /*
     * MIYOSHI Tsutomu <mijosxi@ike.tottori-u.ac.jp> says scanning 'buf'
     * causes a bus error on hppa1.1-hp-hpux9.07, so we
     * have a broad hack for all HP systems.
     */
    static char buftmp[32];
    snprintf(buftmp, 32, "%s", buf);
    if (sscanf(buftmp, "%d.%d.%d.%d%c", &a1, &a2, &a3, &a4, &x) != 4)
#else
    if (sscanf(buf, "%d.%d.%d.%d%c", &a1, &a2, &a3, &a4, &x) != 4)
#endif
	return 0;
    if (a1 < 0 || a1 > 255)
	return 0;
    if (a2 < 0 || a2 > 255)
	return 0;
    if (a3 < 0 || a3 > 255)
	return 0;
    if (a4 < 0 || a4 > 255)
	return 0;
    snprintf(addrbuf, 32, "%d.%d.%d.%d", a1, a2, a3, a4);
    A.s_addr = inet_addr(addrbuf);
    if (addr)
	addr->s_addr = A.s_addr;
    return 1;
}
