/*
 * $Id: util.h,v 1.63 2002/04/06 08:49:24 adrian Exp $
 *
 * AUTHOR: Harvest Derived
 *
 * SQUID Web Proxy Cache          http://www.squid-cache.org/
 * ----------------------------------------------------------
 *
 *  Squid is the result of efforts by numerous individuals from
 *  the Internet community; see the CONTRIBUTORS file for full
 *  details.   Many organizations have provided support for Squid's
 *  development; see the SPONSORS file for full details.  Squid is
 *  Copyrighted (C) 2001 by the Regents of the University of
 *  California; see the COPYRIGHT file for full details.  Squid
 *  incorporates software developed and/or copyrighted by other
 *  sources; see the CREDITS file for full details.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *  
 */

#ifndef SQUID_UTIL_H
#define SQUID_UTIL_H


#ifdef _SQUID_OS2_
#include <sys/types.h>
/* #ifndef TCPV40HDRS */
  #ifdef _SQUID_OS2VAC_
    #include <types.h>
  #endif
/* #endif */

#endif

#include "config.h"


#include <stdio.h>
#include <time.h>
#if HAVE_TIME_H
#include <time.h>
#endif
#if HAVE_SYS_TIME_H
	#include <sys/time.h>
#endif

#if !defined(SQUIDHOSTNAMELEN)

#if HAVE_SYS_PARAM_H
	#include <sys/param.h>
#endif

#ifndef _SQUID_NETDB_H_		/* need protection on NEXTSTEP */
#define _SQUID_NETDB_H_
#include <netdb.h>
#endif

#if !defined(MAXHOSTNAMELEN) || (MAXHOSTNAMELEN < 128)
#define SQUIDHOSTNAMELEN 128
#else
#define SQUIDHOSTNAMELEN MAXHOSTNAMELEN
#endif
#endif

#if defined(_SQUID_FREEBSD_)
#define _etext etext
#endif

extern const char *getfullhostname(void);
extern const char *mkhttpdlogtime(const time_t *);
extern const char *mkrfc1123(time_t);
extern char *uudecode(const char *);
extern char *xstrdup(const char *);
extern char *xstrndup(const char *, size_t);

#ifndef  _SQUID_OS2VAC_
extern const char *xstrerror(void);
extern const char *xbstrerror(int);
#define xstrerror_type(type) xstrerror()
#else
  const char * xstrerror_type(int type);
  const char * xbstrerror(int ierr);
  const char * xstdio_strerror(void);
  const char * xstrerror_i(int ierr);
  const char * xstrerror_a(void);

#endif

extern int tvSubMsec(struct timeval t1, struct timeval t2);
extern int tvSubUsec(struct timeval t1, struct timeval t2);
extern double tvSubDsec(struct timeval, struct timeval);
extern char *xstrncpy(char *s, const char *s1, size_t sz);
extern size_t xcountws(const char *str);
extern time_t parse_rfc1123(const char *str);
extern void *xcalloc(size_t n, size_t sz);
extern void *xmalloc(size_t sz);
extern void *xrealloc(void *s, size_t sz);
extern void Tolower(char *s);
extern void xfree(void *s);
extern void xxfree(const void *s_const);

/* rfc1738.c */
extern char *rfc1738_escape(const char *s);
extern char *rfc1738_escape_unescaped(const char *s);
extern char *rfc1738_escape_part(const char *s);
extern void rfc1738_unescape(char *s);

/* html.c */
extern char *html_quote(const char *s);

#if XMALLOC_STATISTICS
extern void malloc_statistics(void (*)(int, int, int, void *), void *);
#endif

#if XMALLOC_TRACE
#define xmalloc(size) (xmalloc_func="xmalloc",xmalloc_line=__LINE__,xmalloc_file=__FILE__,xmalloc(size))
#define xfree(ptr) (xmalloc_func="xfree",xmalloc_line=__LINE__,xmalloc_file=__FILE__,xfree(ptr))
#define xxfree(ptr) (xmalloc_func="xxfree",xmalloc_line=__LINE__,xmalloc_file=__FILE__,xxfree(ptr))
#define xrealloc(ptr,size) (xmalloc_func="xrealloc",xmalloc_line=__LINE__,xmalloc_file=__FILE__,xrealloc(ptr,size))
#define xcalloc(n,size) (xmalloc_func="xcalloc",xmalloc_line=__LINE__,xmalloc_file=__FILE__,xcalloc(n,size))
#define xstrdup(ptr) (xmalloc_func="xstrdup",xmalloc_line=__LINE__,xmalloc_file=__FILE__,xstrdup(ptr))
extern int xmalloc_line;
extern char *xmalloc_file;
extern char *xmalloc_func;
extern int xmalloc_trace;
extern size_t xmalloc_total;
extern void xmalloc_find_leaks(void);
#endif

typedef struct in_addr SIA;
extern int safe_inet_addr(const char *, SIA *);
extern time_t parse_iso3307_time(const char *buf);
extern char *base64_decode(const char *coded);
extern const char *base64_encode(const char *decoded);
extern const char *base64_encode_bin(const char *data, int len);

extern double xpercent(double part, double whole);
extern int xpercentInt(double part, double whole);
extern double xdiv(double nom, double denom);

extern const char *xitoa(int num);

#if !HAVE_DRAND48
double drand48(void);
#endif

typedef struct {
    size_t count;
    size_t bytes;
    size_t gb;
} gb_t;

/* gb_type operations */
#define gb_flush_limit (0x3FFFFFFF)
#define gb_inc(gb, delta) { if ((gb)->bytes > gb_flush_limit || delta > gb_flush_limit) gb_flush(gb); (gb)->bytes += delta; (gb)->count++; }
#define gb_incb(gb, delta) { if ((gb)->bytes > gb_flush_limit || delta > gb_flush_limit) gb_flush(gb); (gb)->bytes += delta; }
#define gb_incc(gb, delta) { if ((gb)->bytes > gb_flush_limit || delta > gb_flush_limit) gb_flush(gb); (gb)->count+= delta; }
extern double gb_to_double(const gb_t *);
extern const char *double_to_str(char *buf, int buf_size, double value);
extern const char *gb_to_str(const gb_t *);
extern void gb_flush(gb_t *);  /* internal, do not use this */

/*
 * Returns the amount of known allocated memory
 */
int statMemoryAccounted(void);

#ifdef _SQUID_OS2_EMX_
#include <io.h>		/* truncate() declared here */

#endif	/*_SQUID_OS2_EMX_*/

#endif /* SQUID_UTIL_H */
