/*
 * $Id: squid_types.h,v 1.5 2002/08/09 10:57:42 robertc Exp $
 * * * * * * * * Declaration of intents * * * * * * *
 *
 * Here are defined several known-width types, obtained via autoconf
 * from system locations or various attempts. This is just a convenience
 * header to include which takes care of proper preprocessor stuff
 */

#ifndef SQUID_TYPES_H
#define SQUID_TYPES_H

#include "autoconf.h"

/* This should be in synch with what we have in acinclude.m4 */

#if HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif
#if STDC_HEADERS
#include <stdlib.h>
#include <stddef.h>
#endif
#if HAVE_INTTYPES_H
#include <inttypes.h>
#endif
#if HAVE_SYS_BITYPES_H
#include <sys/bitypes.h>
#endif


#ifndef TCPV40HDRS
  #ifdef _SQUID_OS2VAC_
    #include <types.h>
  #endif
#else

#ifdef TCPV40HDRS

typedef signed char                int8_t;
typedef unsigned char            u_int8_t;
typedef short                     int16_t;
typedef unsigned short          u_int16_t;
typedef int                       int32_t;
typedef unsigned int            u_int32_t;

typedef int32_t         pid_t;          /* process id */

#endif // TCPV40HDRS


#endif

#endif /* SQUID_TYPES_H */
