/*
 * $Id: rfc1035.h,v 1.5.6.1 2003/12/18 03:13:36 squidadm Exp $
 *
 * AUTHOR: Duane Wessels
 */
#include "squidDeclaration.h"

#ifndef SQUID_RFC1035_H
#define SQUID_RFC1035_H

#include "config.h"
#if HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif
#if HAVE_NETINET_IN_H
#include <netinet/in.h>
#endif
#if HAVE_ARPA_INET_H
#include <arpa/inet.h>
#endif

/* rfc1035 - DNS */
#define RFC1035_MAXHOSTNAMESZ 250
typedef struct _rfc1035_rr rfc1035_rr;
struct _rfc1035_rr {
    char name[RFC1035_MAXHOSTNAMESZ];
    unsigned short type;
    unsigned short _class;
    unsigned int ttl;
    unsigned short rdlength;
    char *rdata;
};
extern unsigned short rfc1035BuildAQuery(const char *hostname,
    char *buf,
    size_t * szp);
extern unsigned short rfc1035BuildPTRQuery(const struct in_addr,
    char *buf,
    size_t * szp);
extern unsigned short rfc1035RetryQuery(char *);
extern int rfc1035AnswersUnpack(const char *buf,
    size_t sz,
    rfc1035_rr ** records,
    unsigned short *id);
extern void rfc1035RRDestroy(rfc1035_rr * rr, int n);
extern int rfc1035_errno;
extern const char *rfc1035_error_message;

#define RFC1035_TYPE_A 1
#define RFC1035_TYPE_PTR 12
#define RFC1035_CLASS_IN 1

#endif /* SQUID_RFC1035_H */
