/* UNIX_OS2.H */
#ifndef __UNIX_OS2__
#define __UNIX_OS2__

/*   undef for TCP5 and upper */
//#define TCPV40HDRS   

#ifdef TCPV40HDRS

#ifdef HAVE_SYS_PARAM_H
       #undef HAVE_SYS_PARAM_H
#endif
#ifdef HAVE_UNISTD_H
       #undef HAVE_UNISTD_H
#endif
#ifdef HAVE_ARPA_INET_H
       #undef HAVE_ARPA_INET_H
#endif

       #define HAVE_SYS_PARAM_H        0
       #define HAVE_UNISTD_H           0
       #define HAVE_ARPA_INET_H        0
#else
//       #define HAVE_SYS_PARAM_H        1
//       #define HAVE_UNISTD_H           1
//       #define HAVE_ARPA_INET_H        1

#endif


#define USE_SELECT 1
#define __const__



/* Deafault defines */
#define DEFAULT_PREFIX         // = $(prefix)
#define DEFAULT_CONFIG_FILE     "etc/squid.conf"   //= $(sysconfdir)/squid.conf
#define DEFAULT_MIME_TABLE      "etc/mime.conf"    //= $(sysconfdir)/mime.conf
#define DEFAULT_DNSSERVER       "" //= $(libexecdir)/$(DNSSERVER_EXE)
#define DEFAULT_CACHE_LOG       "logs/cache.log"  //= $(localstatedir)/logs/cache.log
#define DEFAULT_ACCESS_LOG      "logs/access.log" // = $(localstatedir)/logs/access.log
#define DEFAULT_STORE_LOG       "logs/store.log"  //= $(localstatedir)/logs/store.log
#define DEFAULT_PID_FILE        "logs/squid.pid"  // = $(localstatedir)/logs/squid.pid
#define DEFAULT_SWAP_DIR        "/cache"     //= $(localstatedir)/cache
#define DEFAULT_PINGER         "" // PINGER_EXE = $(libexecdir)/$(PINGER_EXE)
#define DEFAULT_UNLINKD        ""//UNLINKD_EXE= $(libexecdir)/$(UNLINKD_EXE)
#define DEFAULT_DISKD          ""//DISKD_EXE= $(libexecdir)/$(DISKD_EXE)
#define DEFAULT_ICON_DIR       "/icons"   //= $(sysconfdir)/icons
#define DEFAULT_ERROR_DIR      "/errors"  //= $(sysconfdir)/errors
#define DEFAULT_MIB_PATH       "/mib.txt" //= $(sysconfdir)/mib.txt


#if !defined (F_OK)
#define F_OK 0
#define X_OK 1
#define W_OK 2
#define R_OK 4
#endif

#define O_NDELAY 0

/* for signal's fuck'ing +30 to EMX's defines */
#define SIGHUP    31 /* (1 in EMX) Hangup */
//#define SIGINT    2 /* Interrupt (Ctrl-C) =6 in TOOLKIT - OS/2 SIGINTR signal  */
#define SIGQUIT   33 /* (3 in EMX)Q uit */
// #define SIGILL    4 /* Illegal instruction, =1 in TOOLKIT */

#define SIGTRAP   35 /* (5 in EMX) Single step (debugging) */
//#define SIGABRT   6 /* abort ()  =5 in TOOLKIT*/
#define SIGEMT    37 /* (7 in EMX) EMT instruction */
//#define SIGFPE    8 /* Floating point  =3 in TOOLKIT */

#define SIGKILL   39 /* (9 in EMX) Kill process */
#define SIGBUS    40 /* (10 in EMX) Bus error */
//#define SIGSEGV  11 /* Segmentation fault  =2 in TOOLKIT */

#define SIGSYS   42 /* (12 in EMX) Invalid argument to system call */
#define SIGPIPE  43 /* (13 in EMX) Broken pipe */
//#define SIGALRM  44 /* (14 in EMX) Alarm */
//#define SIGTERM  15 /* Termination, process killed   =2 in TOOLKIT */
//#define SIGUSR1  16 /* User-defined signal #1  =7 in TOOLKIT*/
//#define SIGUSR2  17 /* User-defined signal #2  =8 in TOOLKIT*/
#define SIGCHLD  48 /* (18 in EMX)  Death of a child process */
//#define SIGBREAK 21 /* Break (Ctrl-Break)  =10 in TOOLKIT*/
#define SIGWINCH 58 /* (28 in EMX) Window size change (not implemented) */


#if !defined (_UID_T)
  #define _UID_T
  typedef int uid_t;
#endif

#if !defined (_GID_T)
  #define _GID_T
  typedef int gid_t;
#endif


uid_t getuid(void);
uid_t geteuid(void);
int getegid (void);             /* gid_t getegid (void); */

struct group
{
  char *gr_name;
  gid_t gr_gid;
  char **gr_mem;
};

struct group *getgrgid (gid_t gid);
struct group *getgrnam (__const__ char * grname);


int setuid(gid_t uid);
int setgid(gid_t uid);
int waitpid (int pid, int *stat_loc, int options);

#define ENFILE  SOCEMFILE  /* The maximum number of sockets are currently in use./Too many open files*/
#define ESRCH   SOCESRCH   /* No such process                      */


#if POKA

/* EMX-like error codes, +100 to EMX'defines */

#define EPERM           101   /* Operation not permitted              */
#define ESRCH           103   /* No such process                      */
#define EIO             105   /* I/O error                            */
#define ENXIO           106   /* No such device or address            */
#define EFAULT          114   /* Bad address                          */
#define ENOLCK          115  /* No locks available                   */
#define EBUSY           116  /* Resource busy                        */
#define ENODEV          119  /* No such device                       */
#define ENOTDIR         120  /* Not a directory                      */
#define EISDIR          121  /* Is a directory                       */
#define ENFILE          123  /* Too many open files in system        */
#define ENOTTY          125  /* Inappropriate ioctl                  */

#define EDEADLK         126  /* Resource deadlock avoided            */
#define EFBIG           127  /* File too large                       */

#define ESPIPE          129  /* Invalid seek                         */
#define EROFS           130  /* Read-only file system                */
#define EMLINK          131  /* Too many links                       */
#define EPIPE           132  /* Broken pipe                          */
//#define ENOTEMPTY       135  /* Directory not empty                  */

//#define EINPROGRESS     136  /* Operation now in progress            */
#define ENOSYS          137  /* Function not implemented             */
//#define ENAMETOOLONG    138  /* File name too long                   */
//#define EDESTADDRREQ    139  /* Destination address required         */
//#define EMSGSIZE        140  /* Message too long                     */
//#define EPROTOTYPE      141  /* Protocol wrong type for socket       */
//#define ENOPROTOOPT     142  /* Option not supported by protocol     */
//#define EPROTONOSUPPORT 143  /* Protocol not supported               */
//#define ESOCKTNOSUPPORT 144  /* Socket type not supported            */
//#define EOPNOTSUPP      145  /* Operation not supported on socket    */
//#define EPFNOSUPPORT    146  /* Protocol family not supported        */
//#define EAFNOSUPPORT    147  /* Address family not supported by protocol family */
//#define EADDRINUSE      148  /* Address already in use               */
//#define EADDRNOTAVAIL   149  /* Can't assigned requested address     */
//#define ENETDOWN        150  /* Network is down                      */
//#define ENETUNREACH     151  /* Network is unreachable               */
//#define ENETRESET       152  /* Network dropped connection on reset  */
//#define ECONNABORTED    153  /* Software caused connection abort     */
//#define ECONNRESET      154  /* Connection reset by peer             */
//#define ENOBUFS         155  /* No buffer space available            */
//#define EISCONN         156  /* Socket is already connected          */
//#define ENOTCONN        157  /* Socket is not connected              */
//#define ESHUTDOWN       158  /* Can't send after socket shutdown     */
//#define ETOOMANYREFS    159  /* Too many references: can't splice    */
//#define ETIMEDOUT       160  /* Connection timed out                 */
//#define ECONNREFUSED    161  /* Connection refused                   */
//#define ELOOP           162  /* Too many levels of symbolic links    */
//#define ENOTSOCK        163  /* Socket operation on non-socket       */
//#define EHOSTDOWN       164  /* Host is down                         */
//#define EHOSTUNREACH    165  /* No route to host                     */
//#define EALREADY        166  /* Operation already in progress        */

//#define EWOULDBLOCK     EAGAIN

#endif //POKA

#if !defined (_STATFS)
#define _STATFS
struct statfs
{
  short f_fstyp;
  long f_bsize;
  long f_frsize;
  long f_blocks;
  long f_bfree;
  long f_files;
  long f_ffree;
  char f_fname[6];
  char f_fpack[6];
};
#endif

int statfs (const char *path, struct statfs *stat);


struct passwd
{
  char *pw_name;
  char *pw_passwd;
  uid_t pw_uid;
  gid_t pw_gid;
  char *pw_age;
  char *pw_comment;
  char *pw_gecos;
  char *pw_dir;
  char *pw_shell;
};



struct passwd *getpwnam (__const__ char *);

/*********************/
/* file& directories */
/*********************/

#if !defined (S_IFMT)
#define S_IFMT   0170000  /* Mask for file type */
#define S_IFIFO  0010000  /* Pipe */
/* #define S_IFCHR  0020000   Character device */
/* #define S_IFDIR  0040000   Directory */
/* #define S_IFREG  0100000   Regular file */
#define S_IFSOCK 0140000  /* Socket */

/* S_ISBLK */
#define S_ISCHR(mode)  (((mode) & S_IFMT) == S_IFCHR)
#define S_ISDIR(mode)  (((mode) & S_IFMT) == S_IFDIR)
#define S_ISREG(mode)  (((mode) & S_IFMT) == S_IFREG)
#define S_ISFIFO(mode) (((mode) & S_IFMT) == S_IFIFO)
#define S_ISSOCK(mode) (((mode) & S_IFMT) == S_IFSOCK)
#endif

int getpagesize (void);

/*  ANSI Console color's */

#define FATAL_COLOR        "[1;31;40m"
#define WARNING_COLOR      "[1;33;40m"
#define IGNORING_COLOR     "[1;35;40m"
#define NORMAL_COLOR       "[0;37;40m"
#define DISABLE_COLOR      "[2;37;40m"

#endif
//__UNIX_OS2__

