/*
 * $Id: fd.c,v 1.7.12.1 2003/12/15 03:13:47 squidadm Exp $
 *
 * DEBUG: section 51    Filedescriptor Functions
 * AUTHOR: Duane Wessels
 */
#define NAFIG 0
#include "squidDeclaration.h"

#include "squid.h"

int default_read_method(int, char *, int);
int default_write_method(int, const char *, int);

const char *fdTypeStr[] =
{
    "None",
    "Log",
    "File",
    "Socket",
    "Pipe",
    "uPipeR",
    "uPipeW",
    "Unknown"
};

/* see enums.h :
enum {
    FD_NONE,
    FD_LOG,
    FD_FILE,
    FD_SOCKET,
    FD_PIPE,
    FD_PIPE_READ,
    FD_PIPE_WRITE,
    FD_UNKNOWN
};
*/

#if NAFIG
static void fdUpdateBiggest(int fd, int);

static void
fdUpdateBiggest(int fd, int opening)
{
    if (fd < Biggest_FD)
       return;
    assert(fd < Squid_MaxFD);
    if (fd > Biggest_FD) {
       /*
        * assert that we are not closing a FD bigger than
        * our known biggest FD
        */
       assert(opening);
       Biggest_FD = fd;
       return;
    }
    /* if we are here, then fd == Biggest_FD */
    /*
     * assert that we are closing the biggest FD; we can't be
     * re-opening it
     */
    assert(!opening);
    while (!fd_table[Biggest_FD].flags.open)
       Biggest_FD--;
}
/*
void
fd_close(int fd)
{
    squid_fde *F = &squid_fd_table.fd_table[fd];
   squid_fd_table.check(fd, 45);
    if (F->type == FD_FILE) {
       assert(F->read_handler == NULL);
       assert(F->write_handler == NULL);
    }
    debug(51, 3) ("fd_close FD %d %s\n", fd, F->desc);
    commSetSelect(fd, COMM_SELECT_READ|COMM_SELECT_WRITE, NULL, NULL, 0);
    F->flags.open = 0;
    fdUpdateBiggest(fd, 0);
    Number_FD--;
    memset(F, '\0', sizeof(squid_fde));
    F->timeout = 0;
}
*/

int
default_read_method(int fd, char *buf, int len)
{
    return (read(fd, buf, len));
}

int
default_write_method(int fd, const char *buf, int len)
{
    return (write(fd, buf, len));
}
int
socket_read_method(int fd, char *buf, int len)
{
    return (recv(fd, buf, len, 0 /* MSG_DONTWAIT ? */));
}

int
socket_write_method(int fd, const char *buf, int len)
{
    return (send(fd, (char *)buf, len,0 /* MSG_DONTWAIT ? */));
}

void
fd_open(int fd, unsigned int type, const char *desc)
{
    squid_fde *F;
    assert(fd >= 0);
    F = &fd_table[fd];
    if (F->flags.open) {
       debug(51, 1) ("WARNING: Closing open FD %4d, (Type %i)\n", fd,F->type);
       fd_close(fd);
    }
    assert(!F->flags.open);
    debug(51, 3) ("fd_open FD %d %s\n", fd, desc);
    F->type = type;
    F->flags.open = 1;
#ifdef _SQUID_OS2VAC_
/* EK ᤥ switch(type)  write_method/read_method */
/*  switch(type)
    {  case  FD_SOCKET:
        F->read_method = &socket_read_method;
        F->write_method = &socket_write_method;
         break;
       default:
        F->read_method = &default_read_method;
        F->write_method = &default_write_method;
    }
*/
#else
    F->read_method = &default_read_method;
    F->write_method = &default_write_method;
#endif
    fdUpdateBiggest(fd, 1);
    if (desc)
       xstrncpy(F->desc, desc, FD_DESC_SZ);
    Number_FD++;
}

#endif //NAFIG

void
fd_note(int fd, const char *s)
{
    squid_fde *F = &squid_fd_table.fd_table[fd];
   squid_fd_table.check(fd, 46);
    xstrncpy(F->desc, s, FD_DESC_SZ);
}
#if NAFIG
void
fd_bytes(int fd, int len, unsigned int type)
{
    squid_fde *F = &fd_table[fd];
    if (len < 0)
       return;
    assert(type == FD_READ || type == FD_WRITE);
    if (type == FD_READ)
       F->bytes_read += len;
    else
       F->bytes_written += len;
}

#endif

void
fdFreeMemory(void)
{
    safe_free(squid_fd_table.fd_table);
}

void
fdDumpOpen(void)
{
    int i;
    squid_fde *F;
    for (i = 0; i < Squid_MaxFD; i++) {
       F = &squid_fd_table.fd_table[i];
       if (!F->flags.open)
           continue;
       if (i == fileno(debug_log))
           continue;
       debug(51, 1) ("Open FD %-10s %4d %s\n",
           F->bytes_read && F->bytes_written ? "READ/WRITE" :
           F->bytes_read ? "READING" :
           F->bytes_written ? "WRITING" : null_string,
           i, F->desc);
    }
}
#if NAFIG

int
fdNFree(void)
{
    return Squid_MaxFD - Number_FD - Opening_FD;
}
#endif


int
fdUsageHigh(void)
{
    int nrfree = squid_fd_table.NFree();
    if (nrfree < (RESERVED_FD << 1))
	return 1;
    if (nrfree < (Number_FD >> 2))
	return 1;
    return 0;
}

/* Called when we runs out of file descriptors */
void
fdAdjustReserved(void)
{
    int new_res;
    int x;
    static time_t last = 0;
    /*
     * don't update too frequently
     */
    if (last + 5 > squid_curtime)
       return;
    /*
     * Calculate a new reserve, based on current usage and a small extra
     */
    new_res = Squid_MaxFD - Number_FD + XMIN(25, Squid_MaxFD / 16);
    if (new_res <= RESERVED_FD)
       return;
    x = Squid_MaxFD - 20 - XMIN(25, Squid_MaxFD / 16);
    if (new_res > x) {
       /* perhaps this should be fatal()? -DW */
       debug(51, 0) ("WARNING: This machine has a serious shortage of filedescriptors.\n");
       new_res = x;
    }
    debug(51, 0) ("Reserved FD adjusted from %d to %d due to failures\n",
       RESERVED_FD, new_res);
    RESERVED_FD = new_res;
}
