/* debug_spy.hpp */

int InitDebugSpy(int mode);
void _Optlink CloseDebugSpy(void);
//BSD select
//int DebugSelect(int nfds,  fd_set *readfds,  fd_set *writefds,  fd_set *exceptfds,  struct timeval *timeout);
//OS2 select
int DebugSelect(int *s, int noreads, int nowrites, int noexepts, long timeout);

int DebugGetsockname( int s, struct sockaddr *name, int *namelen);
int DebugGettimeofday( struct timeval * timev, struct timezone *timez);
int DebugGethostname (char * name, int namelen);
struct hostent * DebugGethostbyname(const char * name);
struct hostent * DebugGethostbyaddr(const char * addr, int len, int type);
int  DebugSock_errno( void );
char *  DebugInet_ntoa(struct in_addr in);
unsigned long  DebugInet_addr(const char * cp);
struct servent * DebugGetservbyname(const char * name, const char * proto);
int  DebugRecv(int s, char * buf, int len, int flags);
int  DebugRecvfrom(int s, char * buf, int len, int flags,
                struct sockaddr *from, int * fromlen);
int  DebugBind(int s, const struct sockaddr *addr, int namelen);
int  DebugSend(int s, const char * buf, int len, int flags);
int  DebugIoctl(int s, int cmd, char* data, int len);
int  DebugIoctl(int s, int cmd, char* data);
int  DebugAccept(int s, struct sockaddr *addr, int *addrlen);
int  DebugSocket(int af, int type, int protocol);
int  DebugSoclose( int socket);

int DebugSendto (int  s, const char * buf, int len, int flags,
                       const struct sockaddr *to, int tolen);

int DebugSetsockopt (int  s, int level, int optname,
                           const char * optval, int optlen);

int DebugGetsockopt(int s, int level, int optname,
                           char * optval, int *optlen);
int  DebugListen(int s, int backlog);
int  DebugConnect(int s, const struct sockaddr *name, int namelen);

#ifndef NOT_REDEFINE

#define getsockname    DebugGetsockname
//#define select                 DebugSelect
#define gettimeofday   DebugGettimeofday
#define gethostname    DebugGethostname
#define gethostbyname  DebugGethostbyname
#define gethostbyaddr  DebugGethostbyaddr
#define sock_errno     DebugSock_errno
#define inet_ntoa      DebugInet_ntoa
#define inet_addr      DebugInet_addr
#define getservbyname  DebugGetservbyname
#define recv           DebugRecv
#define recvfrom       DebugRecvfrom
#define bind          DebugBind
#define send          DebugSend
#define ioctl          DebugIoctl
#define accept         DebugAccept
#define socket         DebugSocket
#define soclose        DebugSoclose
#define sendto         DebugSendto
#define setsockopt     DebugSetsockopt
#define getsockopt     DebugGetsockopt
#define listen         DebugListen
#define connect        DebugConnect

#define bswap(x)   (((unsigned)x<<8)|((unsigned)x>>8))
#define lswap(x)   ((x<<24)|(x>>24)|((x&0xff00)<<8)|((x&0xff0000)>>8))

#endif //NOT_REDEFINE

