#include <stdio.h>
#include <signal.h>
#include <syslog.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/param.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <time.h>
#include <ctype.h>
#include <fcntl.h>


#ifndef __LSOS2AUTH_H
#define __LSOS2AUTH_H

/* Path to configuration file */
#define CONFIGFILE   "\\lsos2auth.conf"

#define MAXDOMAINS  16
#define LSHOSTLEN 	65
#define NAMELEN     50          /* Maximum username length */

#ifndef MAXPATHLEN
#define MAXPATHLEN  260
#endif

typedef struct
{
    char *path;
    char **names;
    int Alloc;
    int Inuse;
    time_t LMT;
}
usersfile;

int Read_usersfile(const char *path, usersfile * uf);
int Check_userlist(usersfile * uf, char *User);
void Check_forfilechange(usersfile * uf);

void Checktimer(void);
void Check_forallowchange(void);
void Check_forchange(int);
int Check_ifuserallowed(char *ConnectingUser);
int Check_user(char *);
int OpenConfigFile(void);
int QueryDomains(char *, char *);
int Read_allowusers(void);
int Read_denyusers(void);

#endif  /*__LSOS2AUTH_H*/

