/*
 * LSOS2 - IBM LAN Server domain squid authenticator module
 * Version 0.1 by Sergey I. Yevtushenko
 *
 * Based on
 * MSNT - Microsoft Windows NT domain squid authenticator module
 * Version 2.0 by Stellar-X Pty Ltd, Antonino Iannella
 * Sun Sep  2 14:39:53 CST 2001
 *
 * Modified to act as a Squid authenticator module.
 * Removed all Pike stuff.
 * Returns OK for a successful authentication, or ERR upon error.
 *
 * Uses code from -
 * Andrew Tridgell 1997
 * Richard Sharpe 1996
 * Bill Welliver 1999
 * Duane Wessels 2000 (wessels@squid-cache.org)
 *
 * Released under GNU Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "lsos2auth.h"

extern char version[];
char msntauth_version[] = "lsauth v0.1.0 (C) 6 Oct 2002 Sergey I. Yevtushenko.";

/* Main program for simple authentication.
 * Reads the denied user file. Sets alarm timer.
 * Scans and checks for Squid input, and attempts to validate the user.
 */

#define TT  fprintf(stderr, "%s %d\n", __FILE__, __LINE__);

int main(int argc, char **argv)
{
	char username[256];
	char password[256];
    char wstr[256];
    int flags = LOG_PID;

    if(argc == 2 && argv[1][0] == '-' && argv[1][1] == 'd')
        flags |= LOG_PERROR;

    openlog("lsos2_auth", flags, LOG_USER);
    setbuf(stdout, NULL);

	/* Read configuration file. Abort wildly if error. */

    if (OpenConfigFile())
		return 1;

	/*
	 * Read denied and allowed user files.
	 * If they fails, there is a serious problem.
	 * Check syslog messages. Deny all users while in this state.
     * The lsos2auth process should then be killed.
	 */
    if ((Read_denyusers() == 1) || (Read_allowusers() == 1))
    {
        for(;;)
        {
            memset(wstr, '\0', sizeof(wstr));
            fgets(wstr, 255, stdin);
            puts("ERR");
        }
    }
	/*
     * Make Check_forchange() the handle for HUP signals.
	 * Don't use alarms any more. I don't think it was very
	 * portable between systems.
     * XXX this should be sigaction()
	 */
    //signal(SIGHUP, Check_forchange);

    for(;;)
    {
        int err = 0;

        /* Read whole line from standard input. Terminate on break. */
        memset(wstr, '\0', sizeof(wstr));

        if(fgets(wstr, 255, stdin) == NULL)
            break;

        do
        {
	        int n;
            char* src = wstr;
            char* dst;

            if(!strchr(wstr, '\n'))
            {
                err = 1;
                break;
            }

            username[0] = '\0';
            password[0] = '\0';

            dst = username;

            while(*src && *src != ' ' && *src != '\t')
                *dst++ = *src++;

            *dst = 0;

            while(*src && (*src == ' ' || *src == '\t'))
                src++;

            /* don't allow empty password */

            if(!*src)
            {
                err = 1;
                break;
            }

            dst = password;

            while(*src && *src != ' ' && *src != '\t')
                *dst++ = *src++;

            *dst = 0;

            Checktimer();           /* Check if the user lists have changed */

            if(Check_user(username))
            {
                err = 1;
                break;
            }

            if(QueryDomains(username, password))
            {
                err = 1;
                break;
            }
        }
        while(0);

        puts(err ? "ERR":"OK");
    }

    return 0;
}

