/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xsl;

import com.caucho.util.CharBuffer;
import com.caucho.util.IntArray;
import com.caucho.xsl.XslWriter;
import java.util.ArrayList;

public class XslNumberFormat {
    private String head;
    private String tail;
    private String[] separators;
    private int[] formats;
    private int[] zeroSize;
    private String format;
    private String lang;
    private boolean isAlphabetic;
    private String groupSeparator;
    private int groupSize;

    public String getFormat() {
        return this.format;
    }

    public String getLang() {
        return this.lang;
    }

    public boolean isAlphabetic() {
        return this.isAlphabetic;
    }

    public String getGroupSeparator() {
        return this.groupSeparator;
    }

    public int getGroupSize() {
        return this.groupSize;
    }

    void format(XslWriter xslWriter, IntArray intArray) {
        CharBuffer charBuffer = new CharBuffer();
        charBuffer.append(this.head);
        int n = intArray.size() - 1;
        while (n >= 0) {
            int n2 = intArray.size() - n - 1;
            if (n2 >= this.formats.length) {
                n2 = this.formats.length - 1;
            }
            char c = (char)this.formats[n2];
            int n3 = this.zeroSize[n2];
            int n4 = intArray.get(n);
            switch (c) {
                case 'i': {
                    this.romanize(charBuffer, "mdclxvi", n4);
                    break;
                }
                case 'I': {
                    this.romanize(charBuffer, "MDCLXVI", n4);
                    break;
                }
                case 'a': {
                    this.formatAlpha(charBuffer, 'a', n4);
                    break;
                }
                case 'A': {
                    this.formatAlpha(charBuffer, 'A', n4);
                    break;
                }
                default: {
                    this.formatDecimal(charBuffer, c, n3, n4);
                    break;
                }
            }
            if (n > 0) {
                charBuffer.append(this.separators[n2]);
            }
            --n;
        }
        charBuffer.append(this.tail);
        xslWriter.print(charBuffer.toString());
    }

    /*
     * Unable to fully structure code
     */
    private void romanize(CharBuffer var1_1, String var2_2, int var3_3) {
        if (var3_3 <= 0) {
            throw new RuntimeException();
        }
        if (var3_3 <= 5000) ** GOTO lbl10
        var1_1.append(var3_3);
        return;
lbl-1000:
        // 1 sources

        {
            var1_1.append(var2_2.charAt(0));
            var3_3 -= 1000;
lbl10:
            // 2 sources

            ** while (var3_3 > 1000)
        }
lbl11:
        // 1 sources

        this.romanize(var1_1, var2_2.charAt(0), var2_2.charAt(1), var2_2.charAt(2), var3_3 / 100);
        this.romanize(var1_1, var2_2.charAt(2), var2_2.charAt(3), var2_2.charAt(4), (var3_3 %= 100) / 10);
        this.romanize(var1_1, var2_2.charAt(4), var2_2.charAt(5), var2_2.charAt(6), var3_3 %= 10);
    }

    private void romanize(CharBuffer charBuffer, char c, char c2, char c3, int n) {
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                charBuffer.append(c3);
                break;
            }
            case 2: {
                charBuffer.append(c3);
                charBuffer.append(c3);
                break;
            }
            case 3: {
                charBuffer.append(c3);
                charBuffer.append(c3);
                charBuffer.append(c3);
                break;
            }
            case 4: {
                charBuffer.append(c3);
                charBuffer.append(c2);
                break;
            }
            case 5: {
                charBuffer.append(c2);
                break;
            }
            case 6: {
                charBuffer.append(c2);
                charBuffer.append(c3);
                break;
            }
            case 7: {
                charBuffer.append(c2);
                charBuffer.append(c3);
                charBuffer.append(c3);
                break;
            }
            case 8: {
                charBuffer.append(c2);
                charBuffer.append(c3);
                charBuffer.append(c3);
                charBuffer.append(c3);
                break;
            }
            case 9: {
                charBuffer.append(c3);
                charBuffer.append(c);
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    private void formatAlpha(CharBuffer charBuffer, char c, int n) {
        if (n <= 0) {
            throw new RuntimeException();
        }
        int n2 = charBuffer.length();
        while (n > 0) {
            charBuffer.insert(n2, (char)(c + --n % 26));
            n /= 26;
        }
    }

    private void formatDecimal(CharBuffer charBuffer, int n, int n2, int n3) {
        int n4 = 0;
        int n5 = charBuffer.length();
        while (n3 > 0) {
            if (n4 > 0 && n4 % this.groupSize == 0) {
                charBuffer.insert(n5, this.groupSeparator);
            }
            charBuffer.insert(n5, (char)(n + n3 % 10));
            n3 /= 10;
            ++n4;
        }
        while (charBuffer.length() - n5 < n2) {
            charBuffer.insert(n5, (char)n);
        }
    }

    public XslNumberFormat(String string, String string2, boolean bl, String string3, int n) {
        this.format = string;
        this.lang = string2;
        this.isAlphabetic = bl;
        if (n <= 0) {
            n = 3;
            string3 = "";
        }
        if (string3 == null) {
            string3 = "";
        }
        this.groupSeparator = string3;
        this.groupSize = n;
        if (string == null) {
            string = "1";
        }
        int n2 = string.length();
        ArrayList<String> arrayList = new ArrayList<String>();
        IntArray intArray = new IntArray();
        IntArray intArray2 = new IntArray();
        CharBuffer charBuffer = new CharBuffer();
        int n3 = 0;
        while (n3 < string.length()) {
            char c;
            charBuffer.clear();
            while (n3 < string.length()) {
                c = string.charAt(n3);
                if (Character.isLetterOrDigit(c)) break;
                charBuffer.append(c);
                ++n3;
            }
            if (this.head == null) {
                this.head = charBuffer.toString();
            } else if (n3 >= string.length()) {
                this.tail = charBuffer.toString();
            } else {
                arrayList.add(charBuffer.toString());
            }
            if (n3 >= string.length()) break;
            int n4 = 1;
            int n5 = 48;
            while (n3 < string.length()) {
                c = string.charAt(n3);
                if (!Character.isLetterOrDigit(c)) break;
                if (!Character.isDigit(c)) {
                    n5 = n5 != 48 || n4 != 1 ? 0 : (int)c;
                } else if (Character.digit(c, 10) == 0 && n4 >= 0) {
                    ++n4;
                } else {
                    n5 = Character.digit(c, 10) == 1 ? c - '\u0001' : 0;
                }
                ++n3;
            }
            if (n5 == 0) {
                n5 = 48;
            }
            intArray.add(n4);
            intArray2.add(n5);
        }
        if (intArray2.size() == 0) {
            this.tail = this.head;
            this.head = "";
            intArray2.add(48);
            intArray.add(0);
        }
        if (arrayList.size() == 0) {
            arrayList.add(".");
        }
        if (arrayList.size() < intArray2.size()) {
            arrayList.add((String)arrayList.get(arrayList.size() - 1));
        }
        this.separators = arrayList.toArray(new String[arrayList.size()]);
        this.zeroSize = intArray.toArray();
        this.formats = intArray2.toArray();
        if (this.head == null) {
            this.head = "";
        }
        if (this.tail == null) {
            this.tail = "";
        }
    }
}

