/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xsl;

import com.caucho.es.ESParseException;
import com.caucho.es.Resin;
import com.caucho.es.Script;
import com.caucho.java.JavaCompileException;
import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import com.caucho.xml.CauchoElement;
import com.caucho.xml.CauchoNode;
import com.caucho.xpath.Expr;
import com.caucho.xpath.NamespaceContext;
import com.caucho.xpath.Pattern;
import com.caucho.xsl.Generator;
import com.caucho.xsl.JavaScriptStylesheet;
import com.caucho.xsl.Sort;
import com.caucho.xsl.StylesheetImpl;
import com.caucho.xsl.Template;
import com.caucho.xsl.XslNumberFormat;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

class JavaScriptGenerator
extends Generator {
    private static WriteStream dbg = LogStream.open("/caucho.com/xsl/js");
    static int count;
    WriteStream s;
    ArrayList patterns;
    ArrayList keys;
    ArrayList values;
    ArrayList tmpKeys;
    ArrayList tmpValues;
    ArrayList callKeys;
    ArrayList callValues;
    ArrayList scopeList;
    ArrayList exprs;
    ArrayList fragments;
    ArrayList sorts;
    ArrayList namespaces;
    ArrayList formats;
    private int flagCount;
    Path srcPath;
    Path path;
    Path[] scriptPath;
    String className;
    JavaScriptStylesheet xslScript;

    private static String getClassName(Path path) {
        String string = path == null ? "xsl_temp" : path.getPath();
        String string2 = string;
        int n = string2.lastIndexOf(47);
        if (n >= 0) {
            string2 = string2.substring(n + 1);
        }
        if ((n = string2.indexOf(46)) >= 0) {
            string2 = string2.substring(0, n);
        }
        CharBuffer charBuffer = new CharBuffer();
        if (string2.length() == 0 || Character.isJavaIdentifierStart(string2.charAt(0))) {
            charBuffer.append("_");
        }
        int n2 = 0;
        while (n2 < string2.length()) {
            char c = string2.charAt(n2);
            if (Character.isJavaIdentifierStart(c)) {
                charBuffer.append(c);
            } else {
                charBuffer.append("_");
            }
            ++n2;
        }
        charBuffer.append("_");
        charBuffer.append(count++);
        return charBuffer.toString();
    }

    protected void printTemplate(Element element, String string, String string2, String string3, double d) throws Exception {
        this.print("function ");
        this.print(this.createTemplatePattern(element, string, string2, string3, d));
        this.println("(out, inputNode, env) {");
        this.println("var node = inputNode;");
        if (this.isRawText) {
            this.println("var oldEscaping = out.disableEscaping(true);");
        } else {
            this.println("var oldEscaping = out.disableEscaping(false);");
        }
        this.generateChildren(element);
        if (!this.isCacheable) {
            this.println("out.setNotCacheable();");
        }
        this.popDepth();
        this.println("out.disableEscaping(oldEscaping);");
        if (!this.isCacheable) {
            this.println("out.setNotCacheable();");
        }
        this.println("}");
    }

    String createTemplatePattern(Element element, String string, String string2, String string3, double d) throws Exception {
        String string4 = string != null && !string.equals("") ? this.getName(string) : this.getName(string2);
        String string5 = "template_" + string4;
        if (!string2.equals("")) {
            this.addPattern(this.parseMatch(string2), string3, d, string5, 0);
        }
        if (string != null && !string.equals("")) {
            this.xslScript.addMacro(string, string3, d, string5);
        }
        return string5;
    }

    protected void printCopyOf(String string, Element element) throws Exception {
        Expr expr = this.parseExpr(string);
        this.println("copyOf(out, node, env, " + this.exprs.size() + ");");
        this.exprs.add(expr);
    }

    protected void startDisableEscaping() throws IOException {
        if (!this.isRawText) {
            this.println("out.disableEscaping(true);");
        }
    }

    protected void endDisableEscaping() throws IOException {
        if (!this.isRawText) {
            this.println("out.disableEscaping(false);");
        }
    }

    protected void writeText(String string) throws Exception {
        if (string != null && string.length() > 0) {
            this.printLocation(this.filename, this.line);
            this.print("out.write(\"");
            int n = 0;
            while (n < string.length()) {
                char c = string.charAt(n);
                switch (c) {
                    case '\n': {
                        this.print("\\n");
                        break;
                    }
                    case '\r': {
                        this.print("\\r");
                        break;
                    }
                    case '\"': {
                        this.print("\\\"");
                        break;
                    }
                    case '\\': {
                        this.print("\\\\");
                        break;
                    }
                    default: {
                        this.print(c);
                    }
                }
                ++n;
            }
            this.println("\");");
        }
    }

    protected void printLocation(String string, int n) throws Exception {
        if (string != null && !this.isSpecial) {
            this.println("out.setLocation(\"" + string + "\", " + n + ");");
        }
    }

    protected void printElement(Node node) throws Exception {
        String string = node.getNodeName();
        if (string.equals("jsp:decl") || string.equals("jsp:declaration")) {
            this.println("if (out.isFlagFirst(" + this.flagCount++ + ")) {");
            this.pushDepth();
        }
        CauchoElement cauchoElement = (CauchoElement)node;
        String string2 = cauchoElement.getPrefixName();
        String string3 = cauchoElement.getLocalName();
        String string4 = cauchoElement.getNamespace();
        String[] stringArray = (String[])this.namespaceAliases.get(string4);
        if (stringArray != null) {
            string2 = stringArray[0];
            string4 = stringArray[1];
        }
        if (this.excludedNamespaces.get(string4) != null) {
            string4 = null;
        }
        this.print("out.pushElement(");
        this.print(string2 == null ? "null" : "\"" + string2 + "\"");
        this.print(string3 == null ? ", null" : ", \"" + string3 + "\"");
        this.print(string4 == null ? ", null" : ", \"" + string4 + "\"");
        this.println(");");
        NamedNodeMap namedNodeMap = node.getAttributes();
        int n = 0;
        while (n < namedNodeMap.getLength()) {
            String string5;
            Object object;
            Object object2;
            Attr attr = (Attr)namedNodeMap.item(n);
            if (attr.getNodeName().equals("xsl:use-attribute-sets")) {
                object2 = (HashMap)this.attributeSets.get(attr.getNodeValue());
                if (object2 != null) {
                    object = ((HashMap)object2).keySet().iterator();
                    while (object.hasNext()) {
                        string5 = (String)object.next();
                        String string6 = (String)((HashMap)object2).get(string5);
                        this.print("out.pushAttribute(");
                        this.generateString(string5, 43, cauchoElement);
                        this.println(");");
                        this.print("out.write(");
                        this.generateString(string6, 44, cauchoElement);
                        this.print(");");
                        this.println("out.popAttribute();");
                    }
                }
            } else {
                object2 = (CauchoNode)((Object)attr);
                string2 = object2.getPrefixName();
                string3 = object2.getLocalName();
                string4 = object2.getNamespace();
                object = attr.getNodeName();
                string5 = attr.getNodeValue();
                stringArray = (String[])this.namespaceAliases.get(string4);
                if (stringArray != null) {
                    string2 = stringArray[0];
                    string4 = stringArray[1];
                }
                if (this.excludedNamespaces.get(string4) != null) {
                    string4 = null;
                }
                this.print("out.pushAttribute(");
                this.print(string2 == null ? "null" : "\"" + string2 + "\"");
                this.print(string3 == null ? ", null" : ", \"" + string3 + "\"");
                this.print(string4 == null ? ", null" : ", \"" + string4 + "\"");
                this.println(");");
                this.print("out.write(");
                this.generateString(string5, 44, cauchoElement);
                this.println(");");
                this.println("out.popAttribute();");
            }
            ++n;
        }
        this.generateChildren(node);
        this.println("out.popElement();");
        if (string.equals("jsp:decl") || string.equals("jsp:declaration")) {
            this.popDepth();
            this.println("}");
        }
    }

    protected void pushCall() {
        this.tmpKeys.add(this.keys);
        this.tmpValues.add(this.values);
        this.keys = new ArrayList();
        this.values = new ArrayList();
    }

    protected void printParam(String string, String string2, Element element) throws Exception {
        this.keys.add(string.intern());
        throw new RuntimeException();
    }

    protected void printParam(String string, Object object) {
        this.keys.add(string.intern());
        if (object instanceof Expr) {
            this.values.add(object);
        } else {
            this.values.add(new Integer(this.fragments.size()));
            this.fragments.add(object);
        }
    }

    protected void printCallTemplate(String string, String string2) throws Exception {
        this.print("callTemplate(out, node, env, \"");
        this.print(string);
        if (!string2.equals("")) {
            this.print("\", \"");
            this.print(string2);
            this.print("\", ");
        } else {
            this.print("\", ");
        }
        this.print(this.addCallArgs(this.keys, this.values));
        this.println(");");
    }

    protected void printApplyTemplates(Pattern pattern, String string, Sort[] sortArray) throws Exception {
        this.print("applyTemplates(out, node, env, ");
        this.print(this.createSelectPattern(pattern));
        if (!string.equals("")) {
            this.print(", \"");
            this.print(string);
            this.print("\"");
        } else {
            this.print(", null");
        }
        this.print(", " + this.addCallArgs(this.keys, this.values));
        if (sortArray != null) {
            this.print(", ");
            this.print(this.sorts.size());
            this.sorts.add(sortArray);
        }
        this.println(");");
    }

    protected void printApplyImports(String string, int n, int n2) throws Exception {
        this.print("applyImports(out, node, env ");
        if (!string.equals("")) {
            this.print(", \"");
            this.print(string);
            this.print("\"");
        } else {
            this.print(", null");
        }
        this.print(", " + n + ", " + (n2 - 1) + ", ");
        this.println(this.addCallArgs(this.keys, this.values) + ");");
    }

    int addCallArgs(ArrayList arrayList, ArrayList arrayList2) throws Exception {
        if (arrayList.size() == 0) {
            return -1;
        }
        this.callKeys.add(arrayList);
        this.callValues.add(arrayList2);
        return this.callKeys.size() - 1;
    }

    protected void popCall() {
        this.keys = (ArrayList)this.tmpKeys.remove(this.tmpKeys.size() - 1);
        this.values = (ArrayList)this.tmpValues.remove(this.tmpValues.size() - 1);
    }

    protected void printParamVariable(String string, Expr expr) throws Exception {
        this.print("setParamVariable(out, node, env, \"");
        this.print(string);
        this.print("\", ");
        this.print("evalExpr(node, env, " + this.exprs.size() + ")");
        this.exprs.add(expr);
        this.println(");");
    }

    protected void printParamVariable(String string, Element element) throws Exception {
        this.print("setParamVariable(out, node, env, \"");
        this.print(string);
        this.print("\", ");
        if (element.getFirstChild() == null) {
            this.print("\"\"");
        } else {
            this.print("_xsl_fragment_" + this.fragments.size() + "(out, node, env)");
            this.fragments.add(element);
        }
        this.println(");");
    }

    protected void printVariable(String string, Object object) throws Exception {
        this.print("setVariable(out, node, env, \"");
        this.print(string);
        this.print("\", ");
        this.printVariableValue(object);
        this.println(");");
    }

    protected void printVariableValue(Object object) throws Exception {
        if (object instanceof Expr) {
            this.print("evalExpr(node, env, " + this.exprs.size() + ")");
            this.exprs.add(object);
        } else if (object instanceof Node) {
            this.print("_xsl_fragment_" + this.fragments.size() + "(out, node, env)");
            this.fragments.add(object);
        } else {
            throw new RuntimeException();
        }
    }

    protected void printPopScope(int n) throws Exception {
        this.print("popScope(env, " + n + ");");
    }

    protected void printSelectValue(String string, Element element) throws Exception {
        this.printStringExpr(string, element);
    }

    protected void printForEach(Element element, String string) throws Exception {
        this.pushLoop();
        this.println("var " + this.getElement() + " = node;");
        this.print("for (var node in ");
        this.printSelectNodes(string, "node", element);
        this.println(") {");
        Pattern pattern = this.nodeListContext;
        this.nodeListContext = this.parseMatch(string);
        this.generateChildren(element);
        this.nodeListContext = pattern;
        this.println("}");
        this.println("node = " + this.getElement() + ";");
        this.popLoop();
    }

    protected void printForEach(Element element, String string, Sort[] sortArray) throws Exception {
        this.pushLoop();
        this.println("var " + this.getElement() + " = node;");
        this.print("for (var node in ");
        this.print("_xsl_sort(node, env, " + this.patterns.size() + ", ");
        this.println(this.sorts.size() + ")) {");
        this.patterns.add(this.parseSelect(string));
        this.sorts.add(sortArray);
        this.pushDepth();
        Pattern pattern = this.nodeListContext;
        this.nodeListContext = this.parseMatch(string);
        this.generateChildren(element);
        this.nodeListContext = pattern;
        this.popDepth();
        this.println("}");
        this.println("node = " + this.getElement() + ";");
        this.popLoop();
    }

    protected void printIf(Element element, Expr expr) throws Exception {
        this.print("if (");
        this.printExprTest(expr, "node");
        this.println(") {");
        this.pushDepth();
        this.generateChildren(element);
        this.popDepth();
        this.println("}");
    }

    protected void printChoose(Element element, Expr expr, boolean bl) throws Exception {
        if (!bl) {
            this.print("else if (");
        } else {
            this.print("if (");
        }
        this.printExprTest(expr, "node");
        this.println(") {");
        this.pushDepth();
        this.generateChildren(element);
        this.popDepth();
        this.println("}");
    }

    protected void printOtherwise(Element element, boolean bl) throws Exception {
        if (!bl) {
            this.print("else");
        }
        this.println("{");
        this.pushDepth();
        this.generateChildren(element);
        this.popDepth();
        this.println("}");
    }

    void printNumber(Expr expr, XslNumberFormat xslNumberFormat) throws Exception {
        this.print("exprNumberJs(out, node, env, ");
        this.print(this.createExpr(expr));
        this.print(", ");
        this.print(this.formats.size());
        this.formats.add(xslNumberFormat);
        this.println(");");
    }

    void printNumber(String string, Pattern pattern, Pattern pattern2, XslNumberFormat xslNumberFormat) throws Exception {
        if (string.equals("single")) {
            this.print("singleNumberJs(out, ");
        } else if (string.equals("multiple")) {
            this.print("multiNumberJs(out, ");
        } else if (string.equals("any")) {
            this.print("anyNumberJs(out, ");
        } else {
            throw this.error("xsl:number cannot understand level=`" + string + "'");
        }
        this.print("node, env, ");
        this.printPattern(pattern);
        this.print(", ");
        this.printPattern(pattern2);
        this.print(", ");
        this.print(this.formats.size());
        this.formats.add(xslNumberFormat);
        this.println(");");
    }

    protected void printCopy(Element element) throws Exception {
        this.print("out.pushCopy(node);");
        this.printUseAttributeSet(element);
        this.generateChildren(element);
        this.println("out.popCopy();");
    }

    protected void printCopyElement(Element element) throws Exception {
        this.print("out.pushElementCopy(node);");
        this.printUseAttributeSet(element);
        this.generateChildren(element);
        this.println("out.popElement();");
    }

    protected void printElement(Element element, String string) throws Exception {
        this.print("pushElement(out, ");
        this.generateString(string, 43, element);
        this.print(", " + this.namespaces.size());
        this.namespaces.add(this.namespace);
        this.println(");");
        this.printUseAttributeSet(element);
        this.generateChildren(element);
        this.println("out.popElement();");
    }

    protected void printElement(Element element, String string, String string2) throws Exception {
        this.print("out.pushElementNs(");
        this.generateString(string, 43, element);
        this.print(", ");
        this.generateString(string2, 43, element);
        this.println(");");
        this.printUseAttributeSet(element);
        this.generateChildren(element);
        this.println("out.popElement();");
    }

    private void printUseAttributeSet(Element element) throws Exception {
        Attr attr = ((CauchoElement)element).getFirstAttribute();
        while (attr != null) {
            HashMap hashMap;
            if (attr.getNodeName().equals("xsl:use-attribute-sets") && (hashMap = (HashMap)this.attributeSets.get(attr.getNodeValue())) != null) {
                Iterator iterator = hashMap.keySet().iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    String string2 = (String)hashMap.get(string);
                    this.print("pushAttribute(out, ");
                    this.generateString(string, 43, element);
                    this.print(", " + this.namespaces.size());
                    this.namespaces.add(this.namespace);
                    this.println(");");
                    this.print("out.write(");
                    this.generateString(string2, 44, element);
                    this.println(");");
                    this.println("out.popAttribute();");
                }
            }
            attr = (Attr)attr.getNextSibling();
        }
    }

    protected void printAttribute(Element element, String string) throws Exception {
        this.print("pushAttribute(out, ");
        this.generateString(string, 43, element);
        this.print(", " + this.namespaces.size());
        this.namespaces.add(this.namespace);
        this.println(");");
        this.generateChildren(element);
        this.println("out.popAttribute();");
    }

    protected void printAttribute(Element element, String string, String string2) throws Exception {
        this.print("out.pushAttributeNs(");
        this.generateString(string, 43, element);
        this.print(", ");
        this.generateString(string2, 43, element);
        this.println(");");
        this.printUseAttributeSet(element);
        this.generateChildren(element);
        this.println("out.popAttribute();");
    }

    protected void printPi(Element element) throws Exception {
        String string = element.getAttribute("name");
        if (string.equals("")) {
            throw this.error("xsl:pi expected `name' attribute.");
        }
        this.print("out.pushPi(");
        this.generateString(string, 43, element);
        this.println(");");
        this.generateChildren(element);
        this.println("out.popPi();");
    }

    protected void printComment(Element element) throws Exception {
        this.println("out.pushComment();");
        this.generateChildren(element);
        this.println("out.popComment();");
    }

    protected void printError(String string) throws Exception {
        this.println("if (true) throw caucho.xsl.XslParseException.create(\"" + string + "\");");
    }

    protected void printMessage(Element element) throws Exception {
        this.println("out.pushFragment();");
        this.generateChildren(element);
        String string = element.getAttribute("terminate");
        if (string.equals("yes")) {
            this.println("if (true) throw new java.io.IOException(out.popFragment().getTextValue());");
        } else {
            this.println("File('stderr:').writeln(out.popFragment().getTextValue());");
        }
    }

    protected void printExpression(Element element) throws Exception {
        String string = ((CauchoNode)((Object)element)).getTextValue();
        this.print("out.write(");
        this.print(string);
        this.println(");");
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            if (string.charAt(n2) == '\n') {
                ++n;
            }
            ++n2;
        }
        this.destLine += n;
        this.line += n;
    }

    protected void printScriptlet(Element element) throws Exception {
        String string = ((CauchoNode)((Object)element)).getTextValue();
        this.println(string);
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            if (string.charAt(n2) == '\n') {
                ++n;
            }
            ++n2;
        }
        this.destLine += n;
        this.line += n;
    }

    protected void printDeclaration(Element element) throws Exception {
        String string = ((CauchoNode)((Object)element)).getTextValue();
        this.println(string);
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            if (string.charAt(n2) == '\n') {
                ++n;
            }
            ++n2;
        }
        this.destLine += n;
        this.line += n;
    }

    protected void printCacheDepends(String string) throws Exception {
        this.println("out.addCacheDepend(out.pwd.lookup(\"" + string + "\"));");
    }

    void print(char c) throws IOException {
        this.s.print(c);
    }

    void println(char c) throws IOException {
        this.s.println(c);
        ++this.destLine;
    }

    void print(String string) throws IOException {
        this.s.print(string);
    }

    void print(int n) throws IOException {
        this.s.print(String.valueOf(n));
    }

    void println(String string) throws IOException {
        this.s.println(string);
        ++this.destLine;
    }

    String getElement() {
        return "node" + this.loopDepth;
    }

    void pushLoop() {
        ++this.loopDepth;
    }

    void popLoop() {
        --this.loopDepth;
    }

    String getJtp() {
        return "out";
    }

    void pushJtp() throws IOException {
        this.print("out.pushJtp(null);");
    }

    void popJtp() throws IOException {
        this.print("out.popJtp();");
    }

    void printPattern(Pattern pattern) throws Exception {
        if (pattern == null) {
            this.print("-1");
        } else {
            this.print(this.patterns.size());
            this.patterns.add(pattern);
        }
    }

    private int createNodeSet(String string, Element element) throws Exception {
        Pattern pattern = this.parseSelect(string);
        this.patterns.add(pattern);
        return this.patterns.size() - 1;
    }

    int createSelectPattern(Pattern pattern) throws Exception {
        this.patterns.add(pattern);
        return this.patterns.size() - 1;
    }

    int createExpr(Expr expr) throws Exception {
        this.exprs.add(expr);
        return this.exprs.size() - 1;
    }

    String getName(String string) {
        CharBuffer charBuffer = new CharBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case '(': 
                case ')': {
                    break;
                }
                case '.': 
                case ':': 
                case '|': {
                    charBuffer.append('_');
                    break;
                }
                default: {
                    if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') && (c < '0' || c > '9')) break;
                    charBuffer.append(c);
                }
            }
            ++n;
        }
        string = charBuffer.toString();
        if (this.names.get(string) == null) {
            this.names.put(string, string);
            return string;
        }
        n = 0;
        while (true) {
            String string2;
            if (this.names.get(string2 = string + n) == null) {
                this.names.put(string2, string2);
                return string2;
            }
            ++n;
        }
    }

    void printSelectNodes(String string, String string2, Element element) throws Exception {
        this.print("select(");
        this.print(string2);
        this.print(", env, ");
        this.print(this.createNodeSet(string, element));
        this.print(")");
    }

    void printExprTest(Expr expr, String string) throws Exception {
        this.print("test(");
        this.print(string);
        this.print(", env, ");
        this.print(this.exprs.size());
        this.exprs.add(expr);
        this.print(")");
    }

    void generateString(String string, int n, Element element) throws Exception {
        CharBuffer charBuffer = new CharBuffer();
        int n2 = 0;
        boolean bl = true;
        int n3 = string.length();
        while (n2 < n3) {
            char c = string.charAt(n2);
            if (c == '\n') {
                charBuffer.append("\\n");
            } else if (c == '\'') {
                charBuffer.append("\\'");
            } else if (c == '{' && n2 + 1 < n3) {
                if (string.charAt(n2 + 1) == '{') {
                    charBuffer.append('{');
                    ++n2;
                } else {
                    if (!bl) {
                        this.print((char)n);
                    }
                    if (charBuffer.length() > 0) {
                        this.print("'");
                        this.print(charBuffer.toString());
                        this.print("'");
                        this.print((char)n);
                    }
                    charBuffer.clear();
                    ++n2;
                    while (n2 < n3 && string.charAt(n2) != '}') {
                        charBuffer.append(string.charAt(n2));
                        ++n2;
                    }
                    this.stringExpr(charBuffer.toString(), element);
                    charBuffer.clear();
                    bl = false;
                }
            } else if (c == '}' && n2 + 1 < n3) {
                if (string.charAt(n2 + 1) == '}') {
                    charBuffer.append('}');
                    ++n2;
                } else {
                    charBuffer.append('}');
                }
            } else {
                charBuffer.append(c);
            }
            ++n2;
        }
        if (charBuffer.length() > 0) {
            if (!bl) {
                this.print((char)n);
            }
            this.print("'");
            this.print(charBuffer.toString());
            this.print("'");
        } else if (bl && n == 43) {
            this.print("''");
        }
    }

    void printStringExpr(String string, Element element) throws Exception {
        this.print("printExpr(out, node, env, ");
        Expr expr = this.parseExpr(string);
        this.print(this.exprs.size());
        this.exprs.add(expr);
        this.println(");");
    }

    void stringExpr(String string, Element element) throws Exception {
        this.print("stringExpr(node, env, ");
        Expr expr = this.parseExpr(string);
        this.print(this.exprs.size());
        this.exprs.add(expr);
        this.print(")");
    }

    void pushDepth() {
    }

    void popDepth() {
    }

    protected StylesheetImpl completeGenerate(ArrayList arrayList) throws Exception {
        this.printInit(arrayList);
        int n = 0;
        while (n < this.fragments.size()) {
            this.println("function _xsl_fragment_" + n + "(out, inputNode, env) {");
            this.pushDepth();
            this.println("var node = inputNode;");
            this.println("out.pushFragment();");
            this.generateChildren((Node)this.fragments.get(n));
            this.popDepth();
            this.println("return out.popFragment();");
            this.println("}");
            ++n;
        }
        this.s.close();
        ReadStream readStream = this.path.openRead();
        readStream.setPath(this.srcPath);
        Script script = null;
        try {
            script = Resin.parse(readStream, this.scriptPath);
        }
        catch (ESParseException eSParseException) {
            String string = this.lineMap.convertError(eSParseException.getFilename(), eSParseException.getLine(), eSParseException.getColumn(), eSParseException.getText());
            throw new JavaCompileException(string);
        }
        readStream.close();
        this.xslScript.setScript(script);
        this.xslScript.text = this.text.getBuffer();
        this.xslScript.templates = this.rewriteTemplates(this.templates);
        this.xslScript._xsl_exprs = this.exprs.toArray(new Expr[this.exprs.size()]);
        this.xslScript._xsl_sorts = (Sort[][])this.sorts.toArray((T[])new Sort[this.sorts.size()][]);
        this.xslScript._xsl_ns = this.namespaces.toArray(new NamespaceContext[this.namespaces.size()]);
        this.xslScript._xsl_formats = this.formats.toArray(new XslNumberFormat[this.formats.size()]);
        this.fillInit(this.xslScript);
        return this.xslScript;
    }

    private HashMap rewriteTemplates(HashMap hashMap) {
        HashMap<String, Template[]> hashMap2 = new HashMap<String, Template[]>();
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            ArrayList arrayList = (ArrayList)hashMap.get(string);
            Template[] templateArray = new Template[arrayList.size()];
            arrayList.toArray(templateArray);
            hashMap2.put(string, templateArray);
        }
        return hashMap2;
    }

    private void fillInit(StylesheetImpl stylesheetImpl) {
        Object object;
        stylesheetImpl.setSpaces(this.preserve, this.strip);
        stylesheetImpl.setOutputAttributes(this.outputAttributes);
        stylesheetImpl.addFunction("key", this.keyFun);
        stylesheetImpl.addFunction("format-number", this.formatNumberFun);
        int n = 0;
        while (n < this.depends.size()) {
            object = (Path)this.depends.get(n);
            stylesheetImpl.addDepend((Path)object);
            ++n;
        }
        n = 0;
        while (n < this.cacheDepends.size()) {
            object = (String)this.cacheDepends.get(n);
            stylesheetImpl.addCacheDepend((String)object);
            ++n;
        }
        stylesheetImpl.errorPage = this.errorPage;
        stylesheetImpl.lineMap = this.lineMap;
        String string = null;
        if (this.outputAttributes != null) {
            string = (String)this.outputAttributes.get("disable-output-escaping");
        }
        if (string != null && !string.equals("no") && !string.equals("false")) {
            stylesheetImpl.defaultDisableEscaping = true;
        }
    }

    protected void printInit(ArrayList arrayList) throws Exception {
        this.println("function _xsl_init(out, node, env)");
        this.println("{");
        this.pushDepth();
        int n = 0;
        while (n < arrayList.size()) {
            String string;
            String string2;
            CauchoElement cauchoElement = (CauchoElement)arrayList.get(n);
            if (cauchoElement.getLocalName() == "variable") {
                string2 = cauchoElement.getAttribute("name");
                string = cauchoElement.getAttribute("select");
                this.print("env.setGlobal(\"" + string2 + "\", ");
                if (!string.equals("")) {
                    this.printVariableValue(this.parseExpr(string));
                } else {
                    this.printVariableValue(cauchoElement);
                }
                this.println(");");
            } else if (cauchoElement.getLocalName() == "param") {
                string2 = cauchoElement.getAttribute("name");
                string = cauchoElement.getAttribute("select");
                this.print("env.setGlobal(\"" + string2 + "\", ");
                if (!string.equals("")) {
                    this.printVariableValue(this.parseExpr(string));
                } else {
                    this.printVariableValue(cauchoElement);
                }
                this.println(");");
            } else {
                throw new RuntimeException();
            }
            ++n;
        }
        this.popDepth();
        this.println("}");
    }

    JavaScriptGenerator(Path path, Path[] pathArray, Path[] pathArray2, ClassLoader classLoader, String string) throws IOException {
        super(path, pathArray, classLoader);
        this.srcPath = path;
        this.className = string;
        this.init(string.replace('.', '/') + ".js");
        Path path2 = CauchoSystem.getWorkPath();
        String string2 = string.replace('.', '/') + ".js";
        this.path = path2.lookup(string2);
        this.path.getParent().mkdirs();
        this.s = this.path.openWrite();
        this.s.setPath(this.context);
        this.xslScript = new JavaScriptStylesheet();
        this.scriptPath = pathArray2;
        this.patterns = this.xslScript.patterns;
        this.callKeys = this.xslScript.callKeys;
        this.callValues = this.xslScript.callValues;
        this.scopeList = this.xslScript.scopeList;
        this.exprs = this.xslScript.values;
        this.fragments = new ArrayList();
        this.tmpKeys = new ArrayList();
        this.tmpValues = new ArrayList();
        this.sorts = new ArrayList();
        this.namespaces = new ArrayList();
        this.formats = new ArrayList();
    }
}

