/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath;

import com.caucho.util.FreeList;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.WriteStream;
import com.caucho.xpath.Env;
import com.caucho.xpath.Expr;
import com.caucho.xpath.FromContext;
import com.caucho.xpath.NamespaceContext;
import com.caucho.xpath.Pattern;
import com.caucho.xpath.XPathParseException;
import com.caucho.xpath.XPathParser;
import java.util.Iterator;
import org.w3c.dom.Node;

public class XPath {
    static WriteStream dbg = LogStream.open("/caucho.com/xpath");
    private static FreeList freeList = new FreeList(32);

    public static Node find(String string, Node node) throws XPathParseException {
        Pattern pattern = XPath.parseSelect(string);
        return (Node)pattern.select(node).next();
    }

    public static Iterator select(String string, Node node) throws XPathParseException {
        Pattern pattern = XPath.parseSelect(string);
        return pattern.select(node);
    }

    public static Pattern parseSelect(String string, NamespaceContext namespaceContext) throws XPathParseException {
        XPathParser xPathParser = new XPathParser(string, namespaceContext);
        Pattern pattern = xPathParser.parseSelect();
        if (dbg.canWrite()) {
            dbg.log("select: " + pattern);
        }
        return pattern;
    }

    public static Pattern parseSelect(String string) throws XPathParseException {
        return XPath.parseSelect(string, null);
    }

    public static Pattern parseMatch(String string, NamespaceContext namespaceContext) throws XPathParseException {
        XPathParser xPathParser = new XPathParser(string, namespaceContext);
        Pattern pattern = xPathParser.parseMatch();
        if (dbg.canWrite()) {
            dbg.log("match: " + pattern);
        }
        return pattern;
    }

    public static Pattern parseMatch(String string) throws XPathParseException {
        XPathParser xPathParser = new XPathParser(string, null);
        Pattern pattern = xPathParser.parseMatch();
        if (dbg.canWrite()) {
            dbg.log("match: " + pattern);
        }
        return pattern;
    }

    public static String evalString(String string, Node node) throws XPathParseException {
        Expr expr = XPath.parseExpr(string);
        return expr.evalString(node);
    }

    public static double evalNumber(String string, Node node) throws XPathParseException {
        Expr expr = XPath.parseExpr(string);
        return expr.evalNumber(node);
    }

    public static Object evalObject(String string, Node node) throws XPathParseException {
        Expr expr = XPath.parseExpr(string);
        return expr.evalObject(node);
    }

    public static Expr parseExpr(String string, NamespaceContext namespaceContext, Pattern pattern) throws XPathParseException {
        XPathParser xPathParser = new XPathParser(string, namespaceContext);
        Expr expr = xPathParser.parseExpr(new FromContext(), pattern);
        if (expr != null) {
            expr.setListContext(pattern);
        }
        if (dbg.canWrite()) {
            dbg.log("expr: " + expr);
        }
        return expr;
    }

    public static Expr parseExpr(String string, NamespaceContext namespaceContext) throws XPathParseException {
        XPathParser xPathParser = new XPathParser(string, namespaceContext);
        Expr expr = xPathParser.parseExpr();
        if (dbg.canWrite()) {
            dbg.log("expr: " + expr);
        }
        return expr;
    }

    public static Expr parseExpr(String string) throws XPathParseException {
        XPathParser xPathParser = new XPathParser(string, null);
        Expr expr = xPathParser.parseExpr();
        if (dbg.canWrite()) {
            dbg.log("expr: " + expr);
        }
        return expr;
    }

    public static Env createEnv() {
        Env env = (Env)freeList.allocate();
        if (env == null) {
            env = new Env();
        }
        env.init();
        return env;
    }

    public static Env createEnv(Env env) {
        Env env2 = (Env)freeList.allocate();
        if (env2 == null) {
            env2 = new Env();
        }
        env2.init(env);
        return env2;
    }

    public static void freeEnv(Env env) {
        freeList.free(env);
    }

    private XPath() {
    }
}

