/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath;

import com.caucho.xpath.Env;
import com.caucho.xpath.FromSelf;
import com.caucho.xpath.Pattern;
import org.w3c.dom.Node;

class NodeTypePattern
extends Pattern {
    static final int NODE = -2;
    static final int ANY = -1;
    private int nodeType;

    public double getPriority() {
        return -0.5;
    }

    boolean match(Node node, Env env, Node node2) {
        if (node == null) {
            return false;
        }
        if (this.nodeType != -1 && (this.nodeType == -2 ? node.getNodeType() == 2 : node.getNodeType() != this.nodeType)) {
            return false;
        }
        return this.parent.match(node, env, node2);
    }

    boolean allowAttr() {
        return this.parent.allowAttr();
    }

    boolean allowNamespace() {
        return this.parent.allowNamespace();
    }

    public String toString() {
        switch (this.nodeType) {
            case -1: {
                if (this.parent instanceof FromSelf) {
                    return this.parent.getPrefix() + ".";
                }
                return this.parent.toString() + "node()";
            }
            case -2: {
                return this.parent.toString() + "node()";
            }
            case 7: {
                return this.parent.toString() + "pi()";
            }
            case 2: {
                return this.parent.toString() + "*";
            }
            case 1: {
                return this.parent.toString() + "*";
            }
            case 8: {
                return this.parent.toString() + "comment()";
            }
            case 3: {
                return this.parent.toString() + "text()";
            }
            case 5: {
                return this.parent.toString() + "er()";
            }
        }
        return super.toString();
    }

    NodeTypePattern(Pattern pattern, int n) {
        super(pattern);
        this.nodeType = n;
        if (pattern == null) {
            throw new RuntimeException();
        }
    }
}

