/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath;

import com.caucho.xpath.Env;
import com.caucho.xpath.FromAny;
import com.caucho.xpath.FromChildren;
import com.caucho.xpath.FromContext;
import com.caucho.xpath.Pattern;
import org.w3c.dom.Node;

class NodePattern
extends Pattern {
    private String tag;
    private int nodeType;

    public double getPriority() {
        if (this.parent == null || this.parent instanceof FromChildren && (this.parent.parent instanceof FromAny || this.parent.parent instanceof FromContext)) {
            return 0.0;
        }
        return 0.5;
    }

    public String getNodeName() {
        return this.tag;
    }

    boolean match(Node node, Env env, Node node2) {
        if (node == null) {
            return false;
        }
        if (node.getNodeType() != this.nodeType) {
            return false;
        }
        if (!node.getNodeName().equals(this.tag)) {
            return false;
        }
        return this.parent.match(node, env, node2);
    }

    boolean allowAttr() {
        return this.parent.allowAttr();
    }

    boolean allowNamespace() {
        return this.parent.allowNamespace();
    }

    public String toString() {
        switch (this.nodeType) {
            case 7: {
                return this.parent + "pi(" + this.tag + ")";
            }
            case 2: {
                return this.parent + this.tag;
            }
            case 1: {
                return this.parent + this.tag;
            }
        }
        return super.toString();
    }

    NodePattern(Pattern pattern, String string, int n) {
        super(pattern);
        this.tag = string.intern();
        this.nodeType = n;
        if (pattern == null) {
            throw new RuntimeException();
        }
    }
}

