/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath;

import com.caucho.xpath.Axis;
import com.caucho.xpath.Env;
import com.caucho.xpath.NamespaceNode;
import com.caucho.xpath.Pattern;
import org.w3c.dom.Node;

class FromNamespace
extends Axis {
    boolean match(Node node, Env env, Node node2) {
        if (node == null) {
            return false;
        }
        if (!(node instanceof NamespaceNode)) {
            return false;
        }
        return this.parent.match(node.getParentNode(), env, node2);
    }

    boolean allowChildren(Node node, Env env, Node node2) {
        return this.parent.allowChildren(node, env, node2);
    }

    boolean allowNamespace() {
        return true;
    }

    int position(Node node, Env env, Node node2, Pattern pattern) {
        int n = 1;
        node = node.getPreviousSibling();
        while (node != null) {
            if (pattern.match(node, env, node2)) {
                ++n;
            }
            node = node.getPreviousSibling();
        }
        return n;
    }

    int count(Node node, Env env, Node node2, Pattern pattern) {
        int n = this.position(node, env, node2, pattern);
        node = node.getNextSibling();
        while (node != null) {
            if (pattern.match(node, env, node2)) {
                ++n;
            }
            node = node.getNextSibling();
        }
        return n;
    }

    public String toString() {
        return this.getPrefix() + "namespace::";
    }

    FromNamespace(Pattern pattern) {
        super(pattern);
        if (pattern == null) {
            throw new RuntimeException();
        }
    }
}

