/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath;

import com.caucho.xpath.Axis;
import com.caucho.xpath.Env;
import com.caucho.xpath.Pattern;
import org.w3c.dom.Node;

class FromChildren
extends Axis {
    boolean allowChildren(Node node, Env env, Node node2) {
        if (node == null || node.getParentNode() == null) {
            return true;
        }
        if (!this.parent.allowChildren(node.getParentNode(), env, node2)) {
            return false;
        }
        if (this.parent.allowChildren(node, env, node2)) {
            return true;
        }
        return this.parent.match(node, env, node2);
    }

    boolean match(Node node, Env env, Node node2) {
        if (node == null) {
            return false;
        }
        return this.parent.match(node.getParentNode(), env, node2);
    }

    int position(Node node, Env env, Node node2, Pattern pattern) {
        int n = 1;
        node = node.getPreviousSibling();
        while (node != null) {
            if (pattern.match(node, env, node2)) {
                ++n;
            }
            node = node.getPreviousSibling();
        }
        return n;
    }

    int count(Node node, Env env, Node node2, Pattern pattern) {
        int n = 0;
        node = node.getParentNode().getFirstChild();
        while (node != null) {
            if (pattern.match(node, env, node2)) {
                ++n;
            }
            node = node.getNextSibling();
        }
        return n;
    }

    public String toString() {
        return this.getPrefix() + "child::";
    }

    FromChildren(Pattern pattern) {
        super(pattern);
        if (pattern == null) {
            throw new RuntimeException();
        }
    }
}

