/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath;

import com.caucho.util.NullIterator;
import com.caucho.xml.CauchoNode;
import com.caucho.xml.XmlChar;
import com.caucho.xpath.Env;
import com.caucho.xpath.FromExpr;
import com.caucho.xpath.NodeSetExpr;
import com.caucho.xpath.Pattern;
import com.caucho.xpath.XPath;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.w3c.dom.Node;

public abstract class Expr {
    static final int CONST = 0;
    static final int NODE_SET = 1;
    static final int ID = 2;
    static final int OR = 3;
    static final int AND = 4;
    static final int EQ = 5;
    static final int BOOLEAN_EQ = 6;
    static final int NUMBER_EQ = 7;
    static final int STRING_EQ = 8;
    static final int NEQ = 9;
    static final int BOOLEAN_NEQ = 10;
    static final int NUMBER_NEQ = 11;
    static final int STRING_NEQ = 12;
    static final int LT = 13;
    static final int LE = 14;
    static final int GT = 15;
    static final int GE = 16;
    static final int NEG = 17;
    static final int ADD = 18;
    static final int SUB = 19;
    static final int MUL = 20;
    static final int DIV = 21;
    static final int QUO = 22;
    static final int MOD = 23;
    static final int TRUE = 24;
    static final int FALSE = 25;
    static final int NOT = 26;
    static final int BOOLEAN = 27;
    static final int LANG = 28;
    static final int NUMBER = 29;
    static final int SUM = 30;
    static final int FLOOR = 31;
    static final int CEILING = 32;
    static final int ROUND = 33;
    static final int POSITION = 34;
    static final int COUNT = 35;
    static final int LAST = 36;
    static final int STRING = 37;
    static final int CONCAT = 38;
    static final int STARTS_WITH = 39;
    static final int CONTAINS = 40;
    static final int SUBSTRING = 41;
    static final int SUBSTRING_BEFORE = 42;
    static final int SUBSTRING_AFTER = 43;
    static final int STRING_LENGTH = 44;
    static final int NORMALIZE = 45;
    static final int TRANSLATE = 46;
    static final int FORMAT_NUMBER = 47;
    static final int LOCAL_PART = 48;
    static final int NAMESPACE = 49;
    static final int QNAME = 50;
    static final int GENERATE_ID = 51;
    static final int FUNCTION_AVAILABLE = 52;
    static final int SYSTEM_PROPERTY = 53;
    static final int IF = 54;
    static final int LAST_FUN = 55;
    private Pattern listContext;

    public void setListContext(Pattern pattern) {
        this.listContext = pattern;
    }

    public Pattern getListContext() {
        return this.listContext;
    }

    public double evalNumber(Node node) {
        Env env = XPath.createEnv();
        env.setCurrent(node);
        double d = this.evalNumber(env, node, node);
        XPath.freeEnv(env);
        return d;
    }

    public double evalNumber(Node node, Env env) {
        env.setCurrent(node);
        return this.evalNumber(env, node, node);
    }

    public boolean evalBoolean(Node node) {
        Env env = XPath.createEnv();
        env.setCurrent(node);
        boolean bl = this.evalBoolean(null, node, node);
        XPath.freeEnv(env);
        return bl;
    }

    public boolean evalBoolean(Node node, Env env) {
        env.setCurrent(node);
        return this.evalBoolean(env, node, node);
    }

    public String evalString(Node node) {
        Env env = XPath.createEnv();
        env.setCurrent(node);
        String string = this.evalString(env, node, node);
        XPath.freeEnv(env);
        return string;
    }

    public String evalString(Node node, Env env) {
        env.setCurrent(node);
        return this.evalString(env, node, node);
    }

    public Object evalObject(Node node) {
        Env env = XPath.createEnv();
        env.setCurrent(node);
        Object object = this.evalObject(null, node, node);
        XPath.freeEnv(env);
        return object;
    }

    public Object evalObject(Node node, Env env) {
        env.setCurrent(node);
        return this.evalObject(env, node, node);
    }

    public Iterator evalNodeSet(Node node) {
        Env env = XPath.createEnv();
        env.setCurrent(node);
        Iterator iterator = this.evalNodeSet(null, node, node);
        XPath.freeEnv(env);
        return iterator;
    }

    public Iterator evalNodeSet(Node node, Env env) {
        env.setCurrent(node);
        return this.evalNodeSet(env, node, node);
    }

    public boolean isNumber() {
        return false;
    }

    public boolean isBoolean() {
        return false;
    }

    public boolean isString() {
        return false;
    }

    public boolean isNodeSet() {
        return false;
    }

    abstract double evalNumber(Env var1, Node var2, Node var3);

    abstract boolean evalBoolean(Env var1, Node var2, Node var3);

    abstract String evalString(Env var1, Node var2, Node var3);

    abstract Object evalObject(Env var1, Node var2, Node var3);

    Iterator evalNodeSet(Env env, Node node, Node node2) {
        Object object = this.evalObject(env, node, node2);
        if (object instanceof ArrayList) {
            return ((AbstractList)((ArrayList)object)).iterator();
        }
        if (object instanceof Node) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(object);
            return ((AbstractList)arrayList).iterator();
        }
        if (object instanceof Iterator) {
            return (Iterator)object;
        }
        return NullIterator.create();
    }

    public static boolean toBoolean(Object object) {
        if (object instanceof ArrayList) {
            ArrayList arrayList = (ArrayList)object;
            return arrayList.size() > 0;
        }
        if (object instanceof Iterator) {
            return ((Iterator)object).hasNext();
        }
        if (object instanceof Node) {
            object = ((CauchoNode)object).getTextValue();
        }
        if (object == null) {
            return false;
        }
        if (object instanceof Double) {
            Double d = (Double)object;
            return d != 0.0;
        }
        if (object instanceof Boolean) {
            Boolean bl = (Boolean)object;
            return bl;
        }
        if (object instanceof String) {
            String string = (String)object;
            return string != null && string.length() > 0;
        }
        return true;
    }

    public static double toDouble(Object object) {
        Serializable serializable;
        if (object instanceof ArrayList) {
            serializable = (ArrayList)object;
            object = ((ArrayList)serializable).size() > 0 ? ((ArrayList)serializable).get(0) : null;
        } else if (object instanceof Iterator) {
            object = ((Iterator)object).next();
        }
        if (object instanceof Node) {
            object = ((CauchoNode)object).getTextValue();
        }
        if (object == null) {
            return 0.0;
        }
        if (object instanceof Double) {
            serializable = (Double)object;
            return (Double)serializable;
        }
        if (object instanceof Boolean) {
            serializable = (Boolean)object;
            return ((Boolean)serializable).booleanValue() ? 1 : 0;
        }
        if (object instanceof String) {
            return Expr.stringToNumber((String)object);
        }
        return 0.0;
    }

    public static String toString(Object object) {
        if (object instanceof ArrayList) {
            ArrayList arrayList = (ArrayList)object;
            object = arrayList.size() > 0 ? arrayList.get(0) : null;
        } else if (object instanceof Iterator) {
            object = ((Iterator)object).next();
        }
        if (object instanceof Node) {
            object = ((CauchoNode)object).getTextValue();
        } else if (object instanceof Double) {
            double d = (Double)object;
            if ((double)((int)d) == d) {
                return String.valueOf((int)d);
            }
            return String.valueOf(d);
        }
        if (object == null) {
            return "";
        }
        return object.toString();
    }

    public static Node toNode(Object object) {
        if (object instanceof ArrayList) {
            ArrayList arrayList = (ArrayList)object;
            object = arrayList.size() > 0 ? arrayList.get(0) : null;
        } else if (object instanceof Iterator) {
            object = ((Iterator)object).next();
        }
        if (object instanceof Node) {
            return (Node)object;
        }
        return null;
    }

    static double stringToNumber(String string) {
        int n = 0;
        int n2 = string.length();
        boolean bl = false;
        while (n < n2 && XmlChar.isWhitespace(string.charAt(n))) {
            ++n;
        }
        if (n >= n2) {
            return 0.0;
        }
        char c = string.charAt(n);
        int n3 = 1;
        if (c == '-') {
            n3 = -1;
            ++n;
            while (n < n2 && XmlChar.isWhitespace(string.charAt(n))) {
                ++n;
            }
        }
        double d = 0.0;
        double d2 = 1.0;
        while (n < n2 && (c = string.charAt(n)) >= '0' && c <= '9') {
            d = 10.0 * d + (double)c - 48.0;
            bl = true;
            ++n;
        }
        if (c == '.') {
            ++n;
            while (n < n2 && (c = string.charAt(n)) >= '0' && c <= '9') {
                d = 10.0 * d + (double)c - 48.0;
                bl = true;
                d2 = 10.0 * d2;
                ++n;
            }
        }
        while (n < n2 && XmlChar.isWhitespace(string.charAt(n))) {
            ++n;
        }
        if (n < n2 || !bl) {
            return Double.NaN;
        }
        return (double)n3 * d / d2;
    }

    Pattern toNodeList() {
        if (this instanceof NodeSetExpr) {
            return ((NodeSetExpr)this).getPattern();
        }
        return new FromExpr(null, this);
    }

    Expr() {
    }
}

