/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml;

import com.caucho.util.CharBuffer;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.Pwd;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.VfsStream;
import com.caucho.vfs.WriteStream;
import com.caucho.xml.Entities;
import com.caucho.xml.HtmlEntities;
import com.caucho.xml.HtmlPolicy;
import com.caucho.xml.Policy;
import com.caucho.xml.QComment;
import com.caucho.xml.QContentParticle;
import com.caucho.xml.QDocument;
import com.caucho.xml.QDocumentType;
import com.caucho.xml.QElement;
import com.caucho.xml.QElementDef;
import com.caucho.xml.QEntity;
import com.caucho.xml.QEntityReference;
import com.caucho.xml.QName;
import com.caucho.xml.QNode;
import com.caucho.xml.QNotation;
import com.caucho.xml.QProcessingInstruction;
import com.caucho.xml.QText;
import com.caucho.xml.XmlChar;
import com.caucho.xml.XmlEntities;
import com.caucho.xml.XmlParseException;
import com.caucho.xml.XmlPolicy;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Locale;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.AttributeList;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlParser
implements Parser,
Locator {
    static Hashtable attrTypes = new Hashtable();
    static Entities xmlEntities;
    WriteStream dbg = LogStream.open("/caucho.com/xml/parser");
    Policy policy;
    boolean expandReferences = true;
    boolean optionalTags = true;
    boolean skipWhitespace;
    boolean skipComments;
    boolean strictComments;
    boolean strictAttributes;
    boolean entitiesAsText = false;
    boolean expandEntities = true;
    boolean strictCharacters;
    boolean strictXml;
    boolean singleTopElement;
    boolean normalizeWhitespace = false;
    boolean forgiving;
    boolean switchToXml = true;
    boolean isSax = false;
    DocumentHandler documentHandler;
    EntityResolver entityResolver;
    DTDHandler dtdHandler;
    ErrorHandler errorHandler;
    QAttributeList attributeList;
    Locale locale;
    QDocumentType dtd;
    QDocument owner;
    CharBuffer text;
    CharBuffer eltName;
    CharBuffer cb;
    String textFilename;
    int textLine;
    CharBuffer buf = new CharBuffer();
    CharBuffer macro = new CharBuffer();
    int macroIndex = 0;
    int macroLength = 0;
    char[] macroBuffer;
    String filename;
    int line = 1;
    ReadStream is;
    String systemId;
    String publicId;
    Node activeNode;
    Node topNamespaceNode;
    boolean isTagStart;
    Entities entities;

    public void setEntitiesAsText(boolean bl) {
        this.entitiesAsText = bl;
    }

    public void setExpandEntities(boolean bl) {
        this.expandEntities = bl;
        this.policy.expandEntities = bl;
    }

    public void setAutodetectXml(boolean bl) {
        this.switchToXml = bl;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.isSax = true;
        this.entityResolver = entityResolver;
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
        this.isSax = true;
        this.dtdHandler = dTDHandler;
    }

    public void setDocumentHandler(DocumentHandler documentHandler) {
        this.isSax = true;
        this.documentHandler = documentHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.isSax = true;
        this.errorHandler = errorHandler;
    }

    public void setLocale(Locale locale) {
        this.isSax = true;
        this.locale = locale;
    }

    public Document getDocument() {
        return this.owner;
    }

    public void parse(InputSource inputSource) throws IOException {
        ReadStream readStream;
        String string = null;
        if (inputSource.getByteStream() != null) {
            readStream = Vfs.openRead(inputSource.getByteStream());
            string = inputSource.getEncoding();
        } else if (inputSource.getCharacterStream() != null) {
            readStream = Vfs.openRead(inputSource.getCharacterStream());
        } else if (inputSource.getSystemId() != null) {
            readStream = Vfs.lookupNative(inputSource.getSystemId()).openRead();
            string = inputSource.getEncoding();
        } else {
            throw new FileNotFoundException("invalid InputSource");
        }
        if (string != null) {
            readStream.setEncoding(string);
        }
        try {
            try {
                this.parseInt(readStream);
            }
            catch (SAXException sAXException) {
                throw new IOException(sAXException.toString());
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            readStream.close();
            throw throwable;
        }
        readStream.close();
    }

    public void parse(String string) throws IOException, SAXException {
        Path path = Pwd.lookupNative(string);
        ReadStream readStream = path.openRead();
        try {
            this.parseInt(readStream);
        }
        finally {
            Object var5_4 = null;
            readStream.close();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Document parse(Path path) throws IOException {
        Document document;
        ReadStream readStream = path.openRead();
        try {
            try {
                document = this.parseInt(readStream);
                Object var4_4 = null;
            }
            catch (SAXException sAXException) {
                throw new IOException(sAXException.toString());
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            readStream.close();
            throw throwable;
        }
        readStream.close();
        return document;
    }

    public Document parse(InputStream inputStream) throws IOException {
        try {
            return this.parseInt(VfsStream.openRead(inputStream));
        }
        catch (SAXException sAXException) {
            throw new IOException(sAXException.toString());
        }
    }

    public Document parse(ReadStream readStream) throws IOException {
        try {
            return this.parseInt(readStream);
        }
        catch (SAXException sAXException) {
            throw new IOException(sAXException.toString());
        }
    }

    public synchronized Document parseInt(ReadStream readStream) throws IOException, SAXException {
        this.is = readStream;
        this.filename = readStream.getUserPath();
        if (this.filename == null) {
            this.filename = "stream";
        }
        if (this.documentHandler != null) {
            this.documentHandler.setDocumentLocator(this);
            this.documentHandler.startDocument();
        }
        QDocument qDocument = new QDocument();
        qDocument.setLocation(this.getFilename(), this.getLine(), this.getColumn());
        this.owner = qDocument;
        this.activeNode = qDocument;
        this.policy.setDocument(qDocument);
        this.policy.setStream(readStream);
        int n = this.read();
        if (n == 254) {
            n = this.read();
            if (n == 255) {
                qDocument.setAttribute("encoding", "UTF-16");
                readStream.setEncoding("utf-16");
                n = this.read();
            } else {
                this.unread(n);
            }
        } else if (n == 0) {
            n = this.read();
            qDocument.setAttribute("encoding", "UTF-16");
            readStream.setEncoding("utf-16");
        }
        n = this.skipWhitespace(n);
        this.parseNode(qDocument, n, false);
        if (this.documentHandler != null) {
            this.documentHandler.endDocument();
        }
        return qDocument;
    }

    private void parseNode(QNode qNode, int n, boolean bl) throws IOException, SAXException {
        boolean bl2 = qNode instanceof QDocument;
        this.text.clear();
        this.textFilename = this.getFilename();
        this.textLine = this.getLine();
        while (true) {
            if (this.text.length() == 0) {
                this.textFilename = this.getFilename();
                this.textLine = this.getLine();
            }
            switch (n) {
                case -1: {
                    if (this.text.length() != 0) {
                        this.appendText(this.text);
                    }
                    this.text.clear();
                    this.closeTag("");
                    return;
                }
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    if (!this.normalizeWhitespace) {
                        this.text.append((char)n);
                    } else if (this.text.length() == 0) {
                        if (!this.isTagStart) {
                            this.text.append(' ');
                        }
                    } else if (this.text.getLastChar() != ' ') {
                        this.text.append(' ');
                    }
                    n = this.read();
                    break;
                }
                default: {
                    this.text.append((char)n);
                    n = this.read();
                    break;
                }
                case 47: {
                    if (!bl) {
                        this.text.append((char)n);
                        n = this.read();
                        break;
                    }
                    n = this.read();
                    if (n == 62 || n == -1) {
                        this.appendText(this.text);
                        this.activeNode = this.activeNode.getParentNode();
                        return;
                    }
                    this.text.append('/');
                    break;
                }
                case 38: {
                    if (this.entitiesAsText) {
                        this.text.append((char)n);
                        n = this.read();
                        break;
                    }
                    n = this.parseEntityReference(qNode);
                    break;
                }
                case 60: {
                    boolean bl3 = false;
                    n = this.read();
                    if (n == 47 && !bl) {
                        if (this.normalizeWhitespace && this.text.length() > 0 && this.text.getLastChar() == ' ') {
                            this.text.setLength(this.text.length() - 1);
                        }
                        this.appendText(this.text);
                        n = this.parseName(this.text, this.read());
                        if (n != 62) {
                            throw this.error("expected `>' at " + this.badChar(n));
                        }
                        this.closeTag(this.policy.getName(this.activeNode, this.text).getName());
                        this.text.clear();
                        n = this.read();
                        break;
                    }
                    if (n == 33) {
                        n = this.read();
                        if (n == 91) {
                            this.parseCdata(qNode);
                            n = this.read();
                            break;
                        }
                        if (n == 45) {
                            this.parseComment(qNode);
                            this.text.clear();
                            n = this.read();
                            break;
                        }
                        if (XmlChar.isNameStart(n)) {
                            this.appendText(this.text);
                            n = this.parseName(this.text, n);
                            String string = this.text.toString();
                            if (string.equals("DOCTYPE")) {
                                this.parseDoctype(qNode, n);
                                n = this.read();
                                break;
                            }
                            if (this.forgiving && string.equalsIgnoreCase("doctype")) {
                                this.parseDoctype(qNode, n);
                                n = this.read();
                                break;
                            }
                            throw this.error("expected declaration at `" + string + "'");
                        }
                        if (this.forgiving) {
                            this.text.append("<!");
                            break;
                        }
                        throw this.error("expected declaration at " + this.badChar(n));
                    }
                    if (n == 63) {
                        this.parsePI(qNode);
                        this.text.clear();
                        n = this.read();
                        break;
                    }
                    if (XmlChar.isNameStart(n)) {
                        this.appendText(this.text);
                        this.parseElement(qNode, n);
                        this.text.clear();
                        n = this.read();
                        break;
                    }
                    if (!this.strictXml) {
                        this.text.append('<');
                        break;
                    }
                    throw this.error("expected tag after `<' at " + this.badChar(n));
                }
            }
        }
    }

    private void parseElement(QNode qNode, int n) throws IOException, SAXException {
        this.eltName.clear();
        n = this.parseName(this.eltName, n);
        QElement qElement = new QElement();
        qElement.owner = qNode.owner;
        qElement.setLocation(this.getFilename(), this.getLine(), this.getColumn());
        n = this.skipWhitespace(n);
        n = this.parseAttributes(qElement, n);
        QName qName = this.policy.getName(this.activeNode, this.eltName);
        qElement.setName(qName);
        QElementDef qElementDef = this.dtd.getElement(qName.getName());
        if (qElementDef != null) {
            qElementDef.fillDefaults(qElement);
        }
        if (n == 47) {
            n = this.read();
            if (n == 62) {
                this.addElement(qElement, true);
            } else {
                this.addElement(qElement, false);
                this.parseNode(qElement, n, true);
            }
        } else if (n == 62) {
            this.addElement(qElement, false);
            QElementDef qElementDef2 = this.dtd.getElement(qElement.getNodeName());
        } else {
            throw this.error("expected `>' at " + this.badChar(n) + " in element `" + qName.getName() + "'");
        }
    }

    private int parseAttributes(Node node, int n) throws IOException, SAXException {
        QElement qElement = null;
        QDocument qDocument = null;
        if (node instanceof QElement) {
            qElement = (QElement)node;
        } else {
            qDocument = (QDocument)node;
        }
        n = this.skipWhitespace(n);
        if (this.isSax) {
            this.attributeList.clear();
        }
        while (n != -1 && XmlChar.isNameStart(n)) {
            Object object;
            n = this.parseName(this.text, n);
            if (this.text.startsWith("xmlns:") || this.text.matches("xmlns")) {
                object = this.text.length() > 5 ? this.text.substring(6) : "";
                this.text.clear();
                n = this.skipWhitespace(n);
                if (n != 61) {
                    throw this.error("xmlns: needs value at " + this.badChar(n));
                }
                n = this.skipWhitespace(this.read());
                n = this.parseValue(this.text, n, true);
                n = this.skipWhitespace(n);
                this.topNamespaceNode = qElement;
                this.policy.setNamespace((String)object, this.text.toString());
                if (qElement != null && object == "") {
                    qElement.setAttribute("xmlns", this.text.toString());
                } else if (qElement != null) {
                    qElement.setAttribute("xmlns:" + (String)object, this.text.toString());
                }
                this.text.clear();
                continue;
            }
            object = this.policy.getAttributeName(this.activeNode, this.text);
            this.text.clear();
            n = this.skipWhitespace(n);
            String string = null;
            if (n == 61) {
                n = this.skipWhitespace(this.read());
                n = this.parseValue(this.text, n, true);
                n = this.skipWhitespace(n);
                string = this.text.toString();
            } else {
                if (this.strictAttributes) {
                    throw this.error("empty attributes are not allowed: " + ((QName)object).getName() + " " + this.badChar(n));
                }
                string = ((QName)object).getName();
            }
            if (this.isSax) {
                this.attributeList.add(((QName)object).getName(), string);
                continue;
            }
            if (qElement != null) {
                qElement.setAttribute((QName)object, string);
                continue;
            }
            qDocument.setAttribute(((QName)object).getName(), string);
        }
        return n;
    }

    private void closeTag(String string) throws IOException, SAXException {
        block5: while (this.activeNode != null) {
            switch (this.policy.elementCloseAction(this, this.activeNode, string)) {
                case 5: {
                    Node node;
                    if (this.activeNode == this.topNamespaceNode) {
                        this.policy.clearNamespaceCache();
                    }
                    if (this.documentHandler != null) {
                        this.documentHandler.endElement(this.activeNode.getNodeName());
                        node = this.activeNode;
                        this.activeNode = this.activeNode.getParentNode();
                        if (this.activeNode != null) {
                            this.activeNode.removeChild(node);
                        }
                    } else {
                        this.activeNode = this.activeNode.getParentNode();
                    }
                    return;
                }
                case 6: {
                    Node node;
                    if (this.activeNode == this.topNamespaceNode) {
                        this.policy.clearNamespaceCache();
                    }
                    if (this.documentHandler != null) {
                        this.documentHandler.endElement(this.activeNode.getNodeName());
                        node = this.activeNode;
                        this.activeNode = this.activeNode.getParentNode();
                        if (this.activeNode == null) continue block5;
                        this.activeNode.removeChild(node);
                        break;
                    }
                    this.activeNode = this.activeNode.getParentNode();
                    break;
                }
                case 1: {
                    return;
                }
                default: {
                    throw new RuntimeException();
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private int parseNameToken(CharBuffer var1_1, int var2_2) throws IOException, SAXException {
        var1_1.clear();
        if (XmlChar.isNameChar(var2_2)) ** GOTO lbl7
        throw this.error("expected name part at " + this.badChar(var2_2));
lbl-1000:
        // 1 sources

        {
            var1_1.append((char)var2_2);
            var2_2 = this.read();
lbl7:
            // 2 sources

            ** while (XmlChar.isNameChar((int)var2_2))
        }
lbl8:
        // 1 sources

        return var2_2;
    }

    private int skipWhitespace(int n) throws IOException, SAXException {
        while (n <= 32 && (n == 32 || n == 9 || n == 10 || n == 13)) {
            n = this.read();
        }
        return n;
    }

    private boolean hasWhitespaceOnly(CharBuffer charBuffer) {
        int n = 0;
        while (n < charBuffer.length()) {
            if (!this.isWhitespace(charBuffer.charAt(n)) || !this.skipWhitespace) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private void addElement(Element element, boolean bl) throws IOException, SAXException {
        while (this.activeNode != null) {
            int n = this.policy.openAction(this, this.activeNode, element);
            switch (n) {
                case 1: {
                    return;
                }
                case 2: {
                    QDocument qDocument;
                    this.activeNode.appendChild(element);
                    if (this.activeNode.getNodeType() == 9 && (qDocument = (QDocument)this.activeNode).getDocumentElement() == null) {
                        qDocument.setDocumentElement((QElement)element);
                    }
                    if (!bl) {
                        this.activeNode = element;
                        this.isTagStart = true;
                    } else if (element == this.topNamespaceNode) {
                        this.policy.clearNamespaceCache();
                    }
                    if (this.documentHandler != null) {
                        this.documentHandler.startElement(element.getNodeName(), this.attributeList);
                        if (bl) {
                            this.documentHandler.endElement(element.getNodeName());
                        }
                    }
                    return;
                }
                case 3: {
                    if (this.documentHandler != null) {
                        this.documentHandler.startElement(element.getNodeName(), null);
                        this.documentHandler.endElement(element.getNodeName());
                    }
                    if (element == this.topNamespaceNode) {
                        this.policy.clearNamespaceCache();
                    }
                    this.activeNode.appendChild(element);
                    return;
                }
                case 4: {
                    QElement qElement = (QElement)this.owner.createElement(this.policy.getOpt());
                    qElement.setLocation(this.getFilename(), this.getLine(), this.getColumn());
                    this.addElement(qElement, false);
                    this.addElement(element, bl);
                    return;
                }
                case 5: {
                    if (this.activeNode == this.topNamespaceNode) {
                        this.policy.clearNamespaceCache();
                    }
                    if (this.documentHandler != null) {
                        this.documentHandler.endElement(this.activeNode.getNodeName());
                        Node node = this.activeNode;
                        this.activeNode = this.activeNode.getParentNode();
                        this.activeNode.removeChild(node);
                        break;
                    }
                    this.activeNode = this.activeNode.getParentNode();
                    break;
                }
                default: {
                    throw this.error("cannot add `" + element.getNodeName() + "'" + n);
                }
            }
        }
    }

    private void addChild(Node node) throws IOException, SAXException {
        while (this.activeNode != null) {
            int n = this.policy.openAction(this, this.activeNode, node);
            switch (n) {
                case 1: {
                    return;
                }
                case 2: {
                    this.isTagStart = true;
                }
                case 3: {
                    if (this.documentHandler != null) {
                        if (node.getNodeType() == 3) {
                            String string = node.getNodeValue();
                            this.documentHandler.characters(string.toCharArray(), 0, string.length());
                        }
                    } else {
                        this.activeNode.appendChild(node);
                    }
                    if (node == this.topNamespaceNode) {
                        this.policy.clearNamespaceCache();
                    }
                    return;
                }
                case 4: {
                    QElement qElement = (QElement)this.owner.createElement(this.policy.getOpt());
                    qElement.setLocation(this.getFilename(), this.getLine(), this.getColumn());
                    this.addElement(qElement, false);
                    this.addChild(node);
                    return;
                }
                case 5: {
                    if (this.activeNode == this.topNamespaceNode) {
                        this.policy.clearNamespaceCache();
                    }
                    if (this.documentHandler != null) {
                        this.documentHandler.endElement(this.activeNode.getNodeName());
                        Node node2 = this.activeNode;
                        this.activeNode = this.activeNode.getParentNode();
                        node2.removeChild(this.activeNode);
                        break;
                    }
                    this.activeNode = this.activeNode.getParentNode();
                    break;
                }
                default: {
                    throw this.error("cannot add `" + node.getNodeName() + "'" + n);
                }
            }
        }
    }

    private void appendText(String string) {
        if (this.text.length() == 0) {
            this.textFilename = this.getFilename();
            this.textLine = this.getLine();
        }
        this.text.append(string);
    }

    private void appendText(CharBuffer charBuffer) throws IOException, SAXException {
        if (charBuffer.length() > 0) {
            char c = charBuffer.charAt(0);
            QText qText = (QText)this.owner.createTextNode(charBuffer.toString());
            charBuffer.clear();
            if (c == '\n') {
                qText.setLocation(this.textFilename, this.textLine - 1, 0);
            } else {
                qText.setLocation(this.textFilename, this.textLine, 0);
            }
            this.addChild(qText);
        }
    }

    private int parseEntityReference(QNode qNode) throws IOException, SAXException {
        int n = this.read();
        if (n == 35) {
            this.text.append((char)this.parseCharacterReference());
            return this.read();
        }
        if (XmlChar.isNameStart(n)) {
            if ((n = this.parseName(this.buf, n)) != 59 && this.strictXml) {
                throw this.error("expected `;' at " + this.badChar(n));
            }
            if (n != 59) {
                this.text.append('&');
                this.text.append(this.buf.toString());
                return this.read();
            }
            this.addEntityReference(qNode, this.buf.toString());
            return this.read();
        }
        if (this.strictXml) {
            throw this.error("expected name at " + this.badChar(n));
        }
        this.text.append('&');
        return n;
    }

    private int parseCharacterReference() throws IOException, SAXException {
        int n = this.read();
        int n2 = 10;
        if (n == 120) {
            n2 = 16;
            n = this.read();
        }
        int n3 = 0;
        while (n != 59) {
            if (n >= 48 && n <= 57) {
                n3 = n2 * n3 + n - 48;
            } else if (n2 == 16 && n >= 97 && n <= 102) {
                n3 = n2 * n3 + n - 97 + 10;
            } else if (n2 == 16 && n >= 65 && n <= 70) {
                n3 = n2 * n3 + n - 65 + 10;
            } else {
                throw this.error("malformed entity ref : " + this.badChar(n));
            }
            n = this.read();
        }
        if (n3 > 65535) {
            throw this.error("malformed entity ref : " + n3);
        }
        if (this.strictCharacters && !this.isChar(n3)) {
            throw this.error("illegal character ref : " + this.badChar(n3));
        }
        return n3;
    }

    private void addEntityReference(QNode qNode, String string) throws IOException, SAXException {
        int n = this.entities.getEntity(string);
        if (n >= 0 && n <= 65535) {
            this.text.append((char)n);
            return;
        }
        QEntity qEntity = this.dtd.getEntity(string);
        if (qEntity == null && !this.dtd.isExternal()) {
            if (this.strictXml) {
                throw this.error("expected defined entity at `&" + string + ";'");
            }
            this.appendText(this.text);
            QEntityReference qEntityReference = new QEntityReference(string);
            qEntityReference.owner = qNode.owner;
            qEntityReference.setLocation(this.getFilename(), this.getLine(), this.getColumn());
            this.addChild(qEntityReference);
        } else if (qEntity != null && qEntity.value != null && this.expandEntities) {
            if (qEntity.isSpecial) {
                this.text.append(qEntity.value);
            } else {
                this.setMacro(qEntity.value);
            }
        } else {
            this.appendText(this.text);
            QEntityReference qEntityReference = new QEntityReference(string);
            qEntityReference.setLocation(this.getFilename(), this.getLine(), this.getColumn());
            qEntityReference.owner = qNode.owner;
            this.addChild(qEntityReference);
        }
    }

    private void addPEReference(CharBuffer charBuffer, String string) throws IOException, SAXException {
        QEntity qEntity = this.dtd.getParameterEntity(string);
        if (qEntity == null && !this.dtd.isExternal()) {
            throw this.error("expected defined entity at `%" + string + ";'");
        }
        if (qEntity != null && qEntity.value != null) {
            this.setMacro(qEntity.value);
        } else {
            charBuffer.append("%");
            charBuffer.append(string);
            charBuffer.append(";");
        }
    }

    private boolean isValueChar(int n) throws IOException, SAXException {
        return !this.isWhitespace(n) && n != 47 && n != 62;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int parseValue(CharBuffer charBuffer, int n, boolean bl) throws IOException, SAXException {
        int n2;
        int n3 = n;
        charBuffer.clear();
        if (n3 == 39 || n3 == 34) {
            n = this.read();
        } else {
            if (this.strictAttributes) {
                throw this.error("attributes must be quoted at " + this.badChar(n3));
            }
            n3 = 0;
        }
        while (n != -1 && (n3 != 0 && n != n3 || n3 == 0 && !this.isWhitespace(n) && n != 62)) {
            block18: {
                block19: {
                    block21: {
                        block20: {
                            if (n == 47 && n3 == 0) {
                                n = this.read();
                                if (!this.isWhitespace(n) && n != 62) {
                                    charBuffer.append('/');
                                    charBuffer.append((char)n);
                                    break block18;
                                } else {
                                    this.unread(n);
                                    return 47;
                                }
                            }
                            if (n != 38 || this.entitiesAsText) break block19;
                            n = this.read();
                            if (n != 35) break block20;
                            charBuffer.append((char)this.parseCharacterReference());
                            break block18;
                        }
                        if (bl) break block21;
                        charBuffer.append('&');
                        charBuffer.append((char)n);
                        break block18;
                    }
                    if (XmlChar.isNameStart(n)) {
                        n = this.parseName(this.buf, n);
                        String string = this.buf.toString();
                        if (n != 59 && this.strictXml) {
                            throw this.error("expected `;' at " + this.badChar(n));
                        }
                        if (n != 59) {
                            charBuffer.append('&');
                            charBuffer.append(string);
                            continue;
                        }
                        int n4 = this.entities.getEntity(string);
                        if (n4 >= 0 && n4 <= 65535) {
                            n = this.read();
                            charBuffer.append((char)n4);
                            continue;
                        }
                        QEntity qEntity = this.dtd.getEntity(string);
                        if (qEntity != null && qEntity.value != null) {
                            charBuffer.append(qEntity.value);
                            break block18;
                        } else {
                            if (this.strictXml) {
                                throw this.error("expected local reference at `&" + string + ";'");
                            }
                            charBuffer.append('&');
                            charBuffer.append(string);
                            charBuffer.append(';');
                        }
                    }
                    break block18;
                }
                if (n == 37 && !bl) {
                    n = this.parseName(this.buf, this.read());
                    if (n != 59) {
                        throw this.error("expected `;' at " + this.badChar(n));
                    }
                    this.addPEReference(charBuffer, this.buf.toString());
                } else {
                    charBuffer.append((char)n);
                }
            }
            n = this.read();
        }
        if (n3 == 0) {
            n2 = n;
            return n2;
        }
        n2 = this.read();
        return n2;
    }

    private void parsePcdata(QNode qNode) throws IOException, SAXException {
        String string = "</" + qNode.getNodeName() + ">";
        this.text.clear();
        int n = this.read();
        if (n == 10) {
            n = this.read();
        }
        while (n != -1) {
            this.text.append((char)n);
            if (this.text.endsWith(string)) {
                this.text.setLength(this.text.length() - string.length());
                if (this.text.length() > 1 && this.text.charAt(this.text.length() - 1) == '\n') {
                    this.text.setLength(this.text.length() - 1);
                }
                this.appendText(this.text);
                return;
            }
            n = this.read();
        }
        throw this.error("bad pcdata");
    }

    private void parsePI(QNode qNode) throws IOException, SAXException {
        this.appendText(this.text);
        int n = this.read();
        if (!XmlChar.isNameStart(n)) {
            throw this.error("Expected name after '<?' at " + this.badChar(n));
        }
        n = this.parseName(this.text, n);
        String string = this.text.toString();
        if (string.equals("xml")) {
            if (this.switchToXml && qNode instanceof Document && qNode.getFirstChild() == null && !(this.policy instanceof XmlPolicy)) {
                this.policy = new XmlPolicy();
            }
            if ((n = this.parseAttributes(qNode, n)) != 63) {
                throw this.error("expected `?' at " + this.badChar(n));
            }
            if (this.read() != 62) {
                throw this.error("expected `>' at " + this.badChar(n));
            }
            String string2 = ((QDocument)qNode).getEncoding();
            if (string2 != null) {
                this.is.setEncoding(string2);
            } else if (this.is.getEncoding().equals("ISO-8859-1")) {
                this.is.setEncoding("utf-8");
            }
        } else {
            this.text.clear();
            n = this.skipWhitespace(n);
            while (n != -1) {
                if (n == 63) {
                    n = this.read();
                    if (n == 62) break;
                    this.text.append('?');
                    continue;
                }
                this.text.append((char)n);
                n = this.read();
            }
            if (this.documentHandler != null) {
                this.documentHandler.processingInstruction(string, this.text.toString());
            } else {
                QProcessingInstruction qProcessingInstruction = new QProcessingInstruction(string, this.text.toString());
                qProcessingInstruction.setLocation(this.getFilename(), this.getLine(), this.getColumn());
                qProcessingInstruction.owner = qNode.owner;
                this.addChild(qProcessingInstruction);
            }
        }
    }

    private void parseComment(QNode qNode) throws IOException, SAXException {
        this.appendText(this.text);
        int n = this.read();
        if (n != 45) {
            throw this.error("expected comment at " + this.badChar(n));
        }
        n = this.read();
        this.text.clear();
        block0: while (n != -1) {
            if (n == 45) {
                n = this.read();
                while (n == 45) {
                    n = this.read();
                    if (n == 62) break block0;
                    if (this.strictComments) {
                        throw this.error("XML does not allow `--' in comments");
                    }
                    if (n == 45) {
                        this.text.append('-');
                        continue;
                    }
                    this.text.append('-');
                    this.text.append('-');
                    continue block0;
                }
                continue;
            }
            this.text.append((char)n);
            n = this.read();
        }
        if (!this.skipComments && !this.isSax) {
            QComment qComment = new QComment(this.text.toString());
            qComment.owner = qNode.owner;
            qComment.setLocation(this.getFilename(), this.getLine(), this.getColumn());
            this.addChild(qComment);
        }
        this.text.clear();
    }

    private void parseCdata(QNode qNode) throws IOException, SAXException {
        int n;
        if (this.forgiving) {
            n = this.read();
            if (n != 67) {
                this.appendText("<![" + (char)n);
                return;
            }
            n = this.read();
            if (n != 68) {
                this.appendText("<![C" + (char)n);
                return;
            }
            n = this.read();
            if (n != 65) {
                this.appendText("<![CD" + (char)n);
                return;
            }
            n = this.read();
            if (n != 84) {
                this.appendText("<![CDA" + (char)n);
                return;
            }
            n = this.read();
            if (n != 65) {
                this.appendText("<![CDAT" + (char)n);
                return;
            }
            n = this.read();
            if (n != 91) {
                this.appendText("<![CDATA" + (char)n);
                return;
            }
        }
        if ((n = this.read()) != 67 || (n = this.read()) != 68 || (n = this.read()) != 65 || (n = this.read()) != 84 || (n = this.read()) != 65 || (n = this.read()) != 91) {
            throw this.error("expected `<![CDATA[' at " + this.badChar(n));
        }
        n = this.read();
        block0: while (n != -1) {
            if (n == 93) {
                n = this.read();
                while (n == 93) {
                    n = this.read();
                    if (n == 62) break block0;
                    if (n == 93) {
                        this.text.append(']');
                        continue;
                    }
                    this.text.append(']');
                    break;
                }
                this.text.append(']');
                continue;
            }
            if (this.strictCharacters && !this.isChar(n)) {
                throw this.error("expected character in cdata at " + this.badChar(n));
            }
            this.text.append((char)n);
            n = this.read();
        }
    }

    private int parseContentParticle(QContentParticle qContentParticle, boolean bl) throws IOException, SAXException {
        boolean bl2 = false;
        qContentParticle.separator = 0;
        qContentParticle.repeat = 0;
        int n = this.skipWhitespace(this.read());
        while (n != -1) {
            Object object;
            if (n == 40) {
                object = new QContentParticle();
                qContentParticle.addChild(object);
                n = this.parseContentParticle((QContentParticle)object, false);
            } else if (XmlChar.isNameStart(n)) {
                n = this.parseName(this.text, n);
                qContentParticle.addChild(this.text.toString());
            } else if (n == 35) {
                n = this.parseName(this.text, this.read());
                object = this.text.toString();
                if (this.strictXml && qContentParticle.children.size() != 0) {
                    throw this.error("`#" + (String)object + "' must occur first.");
                }
                if (this.strictXml && !bl) {
                    throw this.error("`#" + (String)object + "' may only occur at top level.");
                }
                if (!((String)object).equals("PCDATA")) {
                    throw this.error("illegal content particle at `#" + (String)object + "'");
                }
                qContentParticle.addChild("#PCDATA");
                bl2 = true;
            } else {
                throw this.error("expected content particle at " + this.badChar(n));
            }
            n = this.skipWhitespace(n);
            if (n == 41) break;
            if (qContentParticle.separator == 0) {
                if (n == 124) {
                    qContentParticle.separator = n;
                } else {
                    if (bl2 && this.strictXml) {
                        throw this.error("#PCDATA must be separated by `|' at " + this.badChar(n));
                    }
                    if (n == 44) {
                        qContentParticle.separator = n;
                    } else if (!this.strictXml && n == 38) {
                        qContentParticle.separator = n;
                    } else {
                        throw this.error("expected separator at " + this.badChar(n));
                    }
                }
                n = this.read();
            } else {
                if (n != qContentParticle.separator) {
                    throw this.error("expected `" + (char)qContentParticle.separator + "' at " + this.badChar(n));
                }
                n = this.read();
            }
            n = this.skipWhitespace(n);
        }
        n = this.skipWhitespace(this.read());
        if (this.strictXml && bl2 && (n == 43 || n == 63)) {
            throw this.error("pcdata clause can not have " + this.badChar(n));
        }
        if (n == 42 || n == 43 || n == 63) {
            qContentParticle.repeat = n;
            return this.read();
        }
        return n;
    }

    private int parseContentSpec(QElementDef qElementDef, int n) throws IOException, SAXException {
        if (XmlChar.isNameStart(n)) {
            n = this.parseName(this.text, n);
            String string = this.text.toString();
            if (string.equals("EMPTY")) {
                qElementDef.content = "EMPTY";
                return n;
            }
            if (string.equals("ANY")) {
                qElementDef.content = "ANY";
                return n;
            }
            throw this.error("expected EMPTY or ANY at `" + string + "'");
        }
        if (n != 40) {
            throw this.error("expected `(' at " + this.badChar(n));
        }
        QContentParticle qContentParticle = new QContentParticle();
        qElementDef.content = qContentParticle;
        return this.parseContentParticle(qContentParticle, true);
    }

    private void parseElementDecl(QDocumentType qDocumentType) throws IOException, SAXException {
        int n = this.skipWhitespace(this.read());
        n = this.parseName(this.text, n);
        String string = this.text.toString();
        n = this.skipWhitespace(n);
        QElementDef qElementDef = this.dtd.addElement(string);
        qElementDef.setLocation(this.getFilename(), this.getLine(), this.getColumn());
        boolean bl = true;
        boolean bl2 = true;
        if (this.optionalTags && (n == 79 || n == 45)) {
            bl = n == 45;
            if ((n = this.skipWhitespace(n)) == 48) {
                bl2 = false;
            } else if (n == 45) {
                bl2 = true;
            } else {
                throw this.error("unknown shorttag");
            }
        }
        n = this.parseContentSpec(qElementDef, n);
        if ((n = this.skipWhitespace(n)) != 62) {
            throw this.error("`<!ELEMENT' must close with `>' at " + this.badChar(n));
        }
    }

    private String toAttrDefault(CharBuffer charBuffer) {
        int n = 0;
        while (n < charBuffer.length()) {
            char c = charBuffer.charAt(n);
            if (c == '\"') {
                charBuffer.delete(n, n + 1);
                charBuffer.insert(n, "&#34;");
                --n;
            } else if (c == '\'') {
                charBuffer.delete(n, n + 1);
                charBuffer.insert(n, "&#39;");
                --n;
            }
            ++n;
        }
        return charBuffer.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseAttlistDecl(QDocumentType qDocumentType) throws IOException, SAXException {
        int n = this.skipWhitespace(this.read());
        n = this.parseName(this.text, n);
        String string = this.text.toString();
        n = this.skipWhitespace(n);
        QElementDef qElementDef = this.dtd.addElement(string);
        n = this.skipWhitespace(n);
        while (XmlChar.isNameStart(n)) {
            n = this.parseName(this.text, n);
            String string2 = this.text.toString();
            String string3 = null;
            ArrayList<String> arrayList = null;
            if ((n = this.skipWhitespace(n)) == 40) {
                string3 = "#ENUM";
                arrayList = new ArrayList<String>();
                do {
                    n = this.skipWhitespace(this.read());
                    n = this.parseNameToken(this.text, n);
                    arrayList.add(this.text.toString());
                } while ((n = this.skipWhitespace(n)) == 124);
                if (n != 41) {
                    throw this.error("expected `)' at " + this.badChar(n));
                }
                n = this.read();
            } else {
                n = this.parseName(this.text, n);
                string3 = this.text.toString();
                if (string3.equals("NOTATION")) {
                    arrayList = new ArrayList();
                    if ((n = this.skipWhitespace(n)) != 40) {
                        throw this.error("expected `(' at " + this.badChar(n));
                    }
                    do {
                        n = this.skipWhitespace(this.read());
                        n = this.parseName(this.text, n);
                        arrayList.add(this.text.toString());
                    } while ((n = this.skipWhitespace(n)) == 124);
                    if (n != 41) {
                        throw this.error("expected `)' at " + this.badChar(n));
                    }
                    n = this.read();
                } else if (attrTypes.get(string3) == null) {
                    throw this.error("expected attribute type at `" + string3 + "'");
                }
            }
            n = this.skipWhitespace(n);
            String string4 = null;
            String string5 = null;
            if (n == 35) {
                n = this.parseName(this.text, this.read());
                string4 = "#" + this.text.toString();
                if (!string4.equals("#IMPLIED") && !string4.equals("#REQUIRED")) {
                    if (!string4.equals("#FIXED")) throw this.error("expected attribute default at `" + string4 + "'");
                    n = this.skipWhitespace(n);
                    n = this.parseValue(this.text, n, false);
                    string5 = this.text.toString();
                }
            } else {
                n = this.parseValue(this.text, n, false);
                string5 = this.text.toString();
            }
            qElementDef.addAttribute(string2, string3, arrayList, string4, string5);
            if (string3 == null || string3.equals("ID")) {
                // empty if block
            }
            qDocumentType.setElementId(string, string2);
            n = this.skipWhitespace(n);
        }
        if (n == 62) return;
        throw this.error("expected `>' at " + this.badChar(n));
    }

    private void parseNotationDecl(QDocumentType qDocumentType) throws IOException, SAXException {
        QNotation qNotation;
        int n = this.skipWhitespace(this.read());
        n = this.parseName(this.text, n);
        String string = this.text.toString();
        n = this.skipWhitespace(n);
        n = this.parseName(this.text, n);
        String string2 = this.text.toString();
        n = this.skipWhitespace(n);
        n = this.parseValue(this.text, n, false);
        String string3 = this.text.toString();
        n = this.skipWhitespace(n);
        if (string2.equals("PUBLIC")) {
            String string4 = null;
            if (n == 34 || n == 39) {
                n = this.parseValue(this.text, n, false);
                n = this.skipWhitespace(n);
                string4 = this.text.toString();
            }
            qNotation = new QNotation(string, string3, string4);
            qNotation.setLocation(this.getFilename(), this.getLine(), this.getColumn());
        } else if (string2.equals("SYSTEM")) {
            qNotation = new QNotation(string, null, string3);
            qNotation.setLocation(this.getFilename(), this.getLine(), this.getColumn());
        } else {
            throw this.error("expected PUBLIC or SYSTEM at `" + string2 + "'");
        }
        qDocumentType.addNotation(qNotation);
        qDocumentType.appendChild(qNotation);
        if (n != 62) {
            throw this.error("expected `>' at " + this.badChar(n));
        }
    }

    private int parseExternalID(int n) throws IOException, SAXException {
        n = this.parseName(this.text, n);
        String string = this.text.toString();
        n = this.skipWhitespace(n);
        this.systemId = null;
        this.publicId = null;
        if (string.equals("PUBLIC") || this.forgiving && string.equalsIgnoreCase("public")) {
            n = this.parseValue(this.text, n, false);
            this.publicId = this.text.toString();
            n = this.skipWhitespace(n);
            n = this.parseValue(this.text, n, false);
            n = this.skipWhitespace(n);
            this.systemId = this.text.toString();
        } else if (string.equals("SYSTEM") || this.forgiving && string.equalsIgnoreCase("system")) {
            n = this.parseValue(this.text, n, false);
            this.systemId = this.text.toString();
        } else {
            throw this.error("expected PUBLIC or SYSTEM at `" + string + "'");
        }
        return n;
    }

    private void parseEntityDecl(QDocumentType qDocumentType) throws IOException, SAXException {
        QEntity qEntity;
        boolean bl;
        int n = this.skipWhitespace(this.read());
        boolean bl2 = bl = n == 37;
        if (bl) {
            n = this.skipWhitespace(this.read());
        }
        n = this.parseName(this.text, n);
        String string = this.text.toString();
        if ((n = this.skipWhitespace(n)) == 34 || n == 39) {
            n = this.parseValue(this.text, n, false);
            qEntity = new QEntity(string, this.text.toString(), null, null);
            qEntity.setLocation(this.getFilename(), this.getLine(), this.getColumn());
        } else {
            n = this.parseExternalID(n);
            String string2 = this.publicId;
            String string3 = this.systemId;
            qEntity = new QEntity(string, null, string2, string3);
            qEntity.setLocation(this.getFilename(), this.getLine(), this.getColumn());
            n = this.skipWhitespace(n);
            if (!bl && XmlChar.isNameStart(n)) {
                n = this.parseName(this.text, n);
                String string4 = this.text.toString();
                if (string4.equals("NDATA")) {
                    String string5;
                    n = this.skipWhitespace(n);
                    n = this.parseName(this.text, n);
                    qEntity.ndata = string5 = this.text.toString();
                } else {
                    throw this.error("expected `NDATA' at `" + string4 + "'");
                }
            }
        }
        qEntity.isPe = bl;
        if (bl) {
            qDocumentType.addParameterEntity(qEntity);
        } else {
            qDocumentType.addEntity(qEntity);
        }
        qDocumentType.appendChild(qEntity);
        n = this.skipWhitespace(n);
        if (n != 62) {
            throw this.error("expected `>' at " + this.badChar(n));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int parseDoctypeDecl(QDocumentType qDocumentType) throws IOException, SAXException {
        int n = 0;
        n = this.skipWhitespace(this.read());
        while (n != -1 && n != 93) {
            if (n == 60) {
                n = this.read();
                if (n == 33) {
                    n = this.read();
                    if (XmlChar.isNameStart(n)) {
                        n = this.parseName(this.text, n);
                        String string = this.text.toString();
                        if (string.equals("ELEMENT")) {
                            this.parseElementDecl(qDocumentType);
                        } else if (string.equals("ATTLIST")) {
                            this.parseAttlistDecl(qDocumentType);
                        } else if (string.equals("NOTATION")) {
                            this.parseNotationDecl(qDocumentType);
                        } else {
                            if (!string.equals("ENTITY")) throw this.error("unknown declaration `" + string + "'");
                            this.parseEntityDecl(qDocumentType);
                        }
                    } else if (n == 45) {
                        this.parseComment(qDocumentType);
                    }
                } else {
                    if (n != 63) throw this.error("expected markup at " + this.badChar(n));
                    this.parsePI(qDocumentType);
                }
            } else {
                if (n != 37) throw this.error("expected '<' at " + this.badChar(n));
                n = this.parseName(this.buf, this.read());
                if (n != 59) {
                    throw this.error("expected `;' at " + this.badChar(n));
                }
                this.addPEReference(this.text, this.buf.toString());
            }
            this.text.clear();
            n = this.skipWhitespace(this.read());
        }
        this.text.clear();
        return this.read();
    }

    private void parseDoctype(QNode qNode, int n) throws IOException, SAXException {
        if (!(qNode instanceof QDocument)) {
            throw this.error("<!DOCTYPE must be at top level ");
        }
        n = this.skipWhitespace(n);
        n = this.parseName(this.text, n);
        String string = this.text.toString();
        this.text.clear();
        n = this.skipWhitespace(n);
        this.dtd.name = string;
        ((QDocument)qNode).dtd = this.dtd;
        if (XmlChar.isNameStart(n)) {
            n = this.parseExternalID(n);
            this.dtd.publicId = this.publicId;
            this.dtd.systemId = this.systemId;
        }
        if (n == 91) {
            n = this.parseDoctypeDecl(this.dtd);
        }
        this.text.clear();
        if (n != 62) {
            throw this.error("bad <!DOCTYPE at " + this.badChar(n));
        }
    }

    private boolean isWhitespace(int n) {
        return n <= 32 && (n == 32 || n == 9 || n == 10 || n == 13);
    }

    private int parseName(CharBuffer charBuffer, int n) throws IOException, SAXException {
        charBuffer.clear();
        if (!XmlChar.isNameStart(n)) {
            throw this.error("expected name start at " + this.badChar(n));
        }
        charBuffer.append((char)n);
        n = this.read();
        while (XmlChar.isNameChar(n)) {
            charBuffer.append((char)n);
            n = this.read();
        }
        return n;
    }

    private boolean isChar(int n) {
        return n >= 32 && n <= 55295 || n == 9 || n == 10 || n == 13 || n >= 57344 && n <= 65520;
    }

    private String hex(int n) {
        CharBuffer charBuffer = CharBuffer.allocate();
        int n2 = 3;
        while (n2 >= 0) {
            int n3 = n >> 4 * n2 & 0xF;
            if (n3 < 10) {
                charBuffer.append((char)(n3 + 48));
            } else {
                charBuffer.append((char)(n3 - 10 + 97));
            }
            --n2;
        }
        return charBuffer.close();
    }

    private String getFilename() {
        return this.filename;
    }

    private int getLine() {
        return this.line;
    }

    private int getColumn() {
        return 0;
    }

    public String getPublicId() {
        return this.getFilename();
    }

    public String getSystemId() {
        return this.getFilename();
    }

    public int getLineNumber() {
        return this.getLine();
    }

    public int getColumnNumber() {
        return this.getColumn();
    }

    private int read() throws IOException {
        if (this.macroIndex < this.macroLength) {
            char c = this.macroBuffer[this.macroIndex++];
            if (this.macroIndex >= this.macroLength) {
                this.macroIndex = 0;
                this.macroLength = 0;
                this.macro.clear();
            }
            return c;
        }
        int n = this.is.readChar();
        if (n == 13) {
            n = this.is.readChar();
            if (n != 10) {
                if (n != -1) {
                    this.unread(n);
                }
                n = 10;
            }
            ++this.line;
        } else if (n == 10) {
            ++this.line;
        }
        return n;
    }

    private void unread(int n) {
        this.macro.insert(this.macroIndex, (char)n);
        this.macroLength = this.macro.length();
        this.macroBuffer = this.macro.getBuffer();
    }

    private void setMacro(String string) throws IOException, SAXException {
        this.macro.insert(this.macroIndex, string);
        this.macroLength = this.macro.length();
        this.macroBuffer = this.macro.getBuffer();
    }

    private void setMacroAttr(String string) throws IOException, SAXException {
        if (this.macroIndex < 0) {
            this.macroIndex = 0;
            this.macro.clear();
        }
        int n = this.macroIndex;
        int n2 = 0;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            if (c == '\'') {
                this.macro.insert(n++, "&#39;");
            } else if (c == '\"') {
                this.macro.insert(n++, "&#34;");
            } else {
                this.macro.insert(n++, c);
            }
            ++n2;
        }
    }

    IOException error(String string) {
        if (this.isSax && this.errorHandler != null) {
            SAXParseException sAXParseException = new SAXParseException(string, this);
            try {
                this.errorHandler.fatalError(sAXParseException);
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
        }
        return new XmlParseException(this.filename + ":" + this.line + ": " + string);
    }

    private String badChar(int n) {
        if (n < 0) {
            return "end of file";
        }
        if (n == 10 || n == 13) {
            return "end of line";
        }
        if (n >= 32 && n <= 127) {
            return "`" + (char)n + "'";
        }
        return "`" + (char)n + "' (\\u" + this.hex(n) + ")";
    }

    private void printDebugNode(WriteStream writeStream, Node node, int n) throws IOException {
        if (node == null) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            writeStream.print(' ');
            ++n2;
        }
        if (node.getFirstChild() != null) {
            writeStream.println("<" + node.getNodeName() + ">");
            Node node2 = node.getFirstChild();
            while (node2 != null) {
                this.printDebugNode(writeStream, node2, n + 2);
                node2 = node2.getNextSibling();
            }
            int n3 = 0;
            while (n3 < n) {
                writeStream.print(' ');
                ++n3;
            }
            writeStream.println("</" + node.getNodeName() + ">");
        } else {
            writeStream.println("<" + node.getNodeName() + "/>");
        }
    }

    public XmlParser() {
        this(new XmlPolicy(), null);
        this.policy.strictComments = true;
        this.policy.strictAttributes = true;
        this.policy.strictCharacters = true;
        this.policy.strictXml = true;
        this.policy.singleTopElement = true;
        this.policy.optionalTags = false;
    }

    XmlParser(Policy policy, QDocumentType qDocumentType) {
        this.policy = policy;
        if (qDocumentType == null) {
            qDocumentType = new QDocumentType(null);
        }
        this.dtd = qDocumentType;
        this.text = new CharBuffer();
        this.eltName = new CharBuffer();
        this.attributeList = new QAttributeList();
        this.entities = xmlEntities;
        if (policy instanceof HtmlPolicy) {
            this.entities = HtmlEntities.create(4.0);
        }
    }

    static {
        attrTypes.put("CDATA", "CDATA");
        attrTypes.put("ID", "ID");
        attrTypes.put("IDREF", "IDREF");
        attrTypes.put("IDREFS", "IDREFS");
        attrTypes.put("ENTITY", "ENTITY");
        attrTypes.put("ENTITIES", "ENTITIES");
        attrTypes.put("NMTOKEN", "NMTOKEN");
        attrTypes.put("NMTOKENS", "NMTOKENS");
        xmlEntities = new XmlEntities();
    }

    static class QAttributeList
    implements AttributeList {
        ArrayList names = new ArrayList();
        ArrayList values = new ArrayList();

        public int getLength() {
            return this.names.size();
        }

        public String getName(int n) {
            return (String)this.names.get(n);
        }

        public String getValue(int n) {
            return (String)this.values.get(n);
        }

        public String getValue(String string) {
            int n = 0;
            while (n < this.names.size()) {
                if (string.equals(this.names.get(n))) {
                    return (String)this.values.get(n);
                }
                ++n;
            }
            return null;
        }

        public String getType(int n) {
            return "CDATA";
        }

        public String getType(String string) {
            return "CDATA";
        }

        void clear() {
            this.names.clear();
            this.values.clear();
        }

        void add(String string, String string2) {
            this.names.add(string);
            this.values.add(string2);
        }

        QAttributeList() {
        }
    }
}

