/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml;

import com.caucho.util.CharBuffer;
import com.caucho.xml.CauchoElement;
import com.caucho.xml.QAbstractNode;
import com.caucho.xml.QAttributedNode;
import com.caucho.xml.QDeepNodeList;
import com.caucho.xml.QName;
import com.caucho.xml.QNodePredicate;
import com.caucho.xml.XmlPrinter;
import java.io.IOException;
import java.util.HashMap;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

class QElement
extends QAttributedNode
implements CauchoElement {
    private QName name;

    void setName(QName qName) {
        this.name = qName;
    }

    public String getNodeName() {
        return this.name.getName();
    }

    public String getTagName() {
        return this.name.getName();
    }

    public String getLocalName() {
        return this.name.getLocalName();
    }

    public String getPrefixName() {
        return this.name.getPrefix();
    }

    public String getCanonicalName() {
        return this.name.getCanonicalName();
    }

    public String getNamespace() {
        return this.name.getNamespace();
    }

    public String getNamespace(String string) {
        if (string == null) {
            return this.getNamespace("", "xmlns");
        }
        return this.getNamespace(string, "xmlns:" + string);
    }

    private String getNamespace(String string, String string2) {
        Attr attr = this.getAttributeNode(string2);
        if (attr != null) {
            return attr.getNodeValue();
        }
        if (this.parent instanceof QElement) {
            return ((QElement)this.parent).getNamespace(string, string2);
        }
        return null;
    }

    public short getNodeType() {
        return 1;
    }

    public NodeList getElementsByTagName(String string) {
        return new QDeepNodeList(this, this, new TagPredicate(string));
    }

    public void normalize() {
        Node node = this.firstChild;
        while (node != null) {
            Node node2;
            if (node.getNodeType() == 3 && node.getNextSibling() != null && node.getNextSibling().getNodeType() == 3) {
                node2 = (Text)node;
                Text text = (Text)node.getNextSibling();
                node2.appendData(text.getData());
                this.removeChild(text);
                continue;
            }
            if (node.getNodeType() == 1) {
                node2 = (Element)node;
                node2.normalize();
                node = node.getNextSibling();
                continue;
            }
            node = node.getNextSibling();
        }
    }

    public Node cloneNode(boolean bl) {
        QElement qElement = new QElement(this.name);
        qElement.owner = this.owner;
        qElement.filename = this.filename;
        qElement.line = this.line;
        Node node = this.firstAttribute;
        while (node != null) {
            qElement.setAttribute(node.getNodeName(), ((QAbstractNode)node).getNodeValue());
            node = ((QAbstractNode)node).next;
        }
        if (!bl) {
            return qElement;
        }
        node = this.getFirstChild();
        while (node != null) {
            qElement.appendChild(node.cloneNode(true));
            node = node.getNextSibling();
        }
        return qElement;
    }

    public boolean hasContent() {
        return true;
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public boolean equals(Node node, boolean bl) {
        return this == node;
    }

    public String getTextValue() {
        CharBuffer charBuffer = CharBuffer.allocate();
        QAbstractNode qAbstractNode = this.firstChild;
        while (qAbstractNode != null) {
            charBuffer.append(qAbstractNode.getTextValue());
            qAbstractNode = qAbstractNode.next;
        }
        return charBuffer.close();
    }

    void print(XmlPrinter xmlPrinter) throws IOException {
        xmlPrinter.printElement(this);
    }

    QElement() {
    }

    QElement(QName qName) {
        this.name = qName;
    }

    QElement(QName qName, HashMap hashMap) {
        this.name = qName;
    }

    static class TagPredicate
    implements QNodePredicate {
        String name;

        public boolean isMatch(QAbstractNode qAbstractNode) {
            return qAbstractNode.getNodeName().equals(this.name);
        }

        TagPredicate(String string) {
            this.name = string;
        }
    }
}

